/*#include <stdio.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

#include "uuxtract.h"
#include "fastecho.fmt"

extern char 	PauseFEPath[60];
extern FILE *MSGBaseFile;
extern int ReadParams();

extern unsigned char 	CFGStr[100],CFGValue[150],CFGValue2[100],
		        FindOtherString[200];
*/

int CreateTempAreasFileFastecho(char FastechoPath[60], char PathToHudson[60])
{
  SHORTINT  Fasta, Ar;
  FILE *FastechoCFG, *NewAreasBBS;
  CONFIG Config;
  char TypeMail[10];
  int NoNetmail=1;
  Area AreaRec;
  unsigned short CntAreas;
  Fasta = open(FastechoPath,O_RDONLY| O_BINARY|O_DENYWRITE);
  if (Fasta==-1)
  {
    Event("FASTECHO.CFG access denied\r\n\r\n");
    AddLog("FASTECHO.CFG access denied\r\n");
    return(7);
  }
  FastechoCFG=fdopen(Fasta,"rb");
  if (!FastechoCFG) return(9);
  Ar = remove("~~areas~.$$$");
  if (Ar==-1 && errno==EACCES)
  {
    fclose(FastechoCFG);
    Event("Temp areas file is locked (maybe by another UUXTRACT)\r\n\r\n");
    AddLog("Temp areas file access denied");
    AddLog("Possible running another UUXTRACT version\r\n");
    return(7);
  }
  NewAreasBBS=fopen("~~areas~.$$$","w+b");
  if (!NewAreasBBS) return(9);
  fread(&Config,sizeof(Config),1,FastechoCFG);
  fseek(FastechoCFG,sizeof(Config) + Config.offset + Config.NodeCnt * Config.NodeRecSize, SEEK_SET);
  CntAreas = Config.AreaCnt;
  while (CntAreas--)
  {
    fread(&AreaRec,Config.AreaRecSize,1,FastechoCFG);
    if (AreaRec.flags.storage < PASSTHRU)
    {
       if (AreaRec.flags.atype==AREA_ECHOMAIL) strcpy(TypeMail,"ECHOMAIL");
       if (AreaRec.flags.atype==AREA_NETMAIL)  {strcpy(TypeMail,"NETMAIL");if (stricmp(AreaRec.name,"NETMAIL")==0) NoNetmail=0;}
       if (AreaRec.flags.atype==AREA_LOCAL || AreaRec.flags.atype==AREA_BADMAILBOARD ||
           AreaRec.flags.atype==AREA_DUPEBOARD)  strcpy(TypeMail,"ECHOMAIL");

       if (AreaRec.flags.storage == QBBS_ECHO) fprintf(NewAreasBBS,"%-3d  %s %s\r\n",AreaRec.board,AreaRec.name,TypeMail);
       if (AreaRec.flags.storage == FIDO_ECHO) fprintf(NewAreasBBS,"%-30s %s %s\r\n",AreaRec.path,AreaRec.name,TypeMail);
       if (AreaRec.flags.storage ==SQUISH_ECHO)fprintf(NewAreasBBS,"$%-30s %s %s\r\n",AreaRec.path,AreaRec.name,TypeMail);
       if (AreaRec.flags.storage == JAM_ECHO ) fprintf(NewAreasBBS,"!%s %s %s\r\n",AreaRec.path,AreaRec.name,TypeMail);
    }
  }
  strcpy(PathToHudson,Config.MsgBase);
  strcpy(PauseFEPath,Config.SemaphorePath);
  LastSlesh(PauseFEPath,1);
  strcat(PauseFEPath,"febusy.0");
  if (NoNetmail && *Config.NetMPath) fprintf(NewAreasBBS,"%-30s NETMAIL NETMAIL\r\n",Config.NetMPath);
  fclose(NewAreasBBS);
  fclose(FastechoCFG);
  return(0);
}

int CreateTempAreasFileSquish(char *SquishCFG)
{
  int Ar, EndSquishCfg, k, Passthrough;
  FILE *NewAreasBBS;

  MSGBaseFile = fopen(SquishCFG,"rb");
  if (!MSGBaseFile)
  {
    Event("SQUISH.CFG access denied\r\n\r\n");
    AddLog("SQUISH.CFG access denied\r\n");
    return(1);
  }
  Ar = remove("~~areas~.$$$");
  if (Ar==-1 && errno==EACCES)
  {
    fclose(MSGBaseFile);
    Event("Temp areas file is locked (maybe by another UUXTRACT)\r\n\r\n");
    AddLog("Temp areas file access denied");
    AddLog("Possible running another UUXTRACT version\r\n");
    return(1);
  }
  NewAreasBBS=fopen("~~areas~.$$$","w+b");
  if (!NewAreasBBS) return(9);
  EndSquishCfg=1;
  while (EndSquishCfg)
  {
     EndSquishCfg=ReadParams();
     if (CFGStr[0]>64)
     {
       if (!stricmp(CFGStr,"NETAREA")) fprintf(NewAreasBBS,"%-30s %s NETMAIL\r\n",CFGValue2,CFGValue);
       if (!stricmp(CFGStr,"ECHOAREA") || !stricmp(CFGStr,"LOCALAREA"))
       {
          k=0; Passthrough=0;
          do
          {
            while (FindOtherString[k]!='-' && FindOtherString[k]) k++;
            if (k>0 && (k+2)<strlen(FindOtherString))
            {
              if (FindOtherString[k]=='-' && FindOtherString[k+1]=='0' && FindOtherString[k-1]==' ' && FindOtherString[k+2]==' ') Passthrough=1;
            }
            if (FindOtherString[k]) k++;
          } while (!Passthrough && FindOtherString[k]);
	  if (!Passthrough) fprintf(NewAreasBBS,"$%-30s %s ECHOMAIL\r\n",CFGValue2,CFGValue);
       }
     }
  }
  fclose(MSGBaseFile);
  fclose(NewAreasBBS);
  return(0);
}
