#include<stdio.h>
#include<conio.h>
#include<stdlib.h>
#include<string.h>
#include<dir.h>
#include<io.h>
#include<fcntl.h>
#include<ctype.h>
#include<dos.h>
#include<errno.h>
#include<sys/stat.h>

#include "uuxtract.h"

#include "hudson.fmt"             //  Hudson
#include "jam.fmt"                //  JAM
#include "fido_msg.fmt"           //  Fido/Msg
#include "squish.fmt"             //  Squish 

extern long FindCrc32(char *);
extern void LineToNetAddress(NetAddress &, char *LineA);
extern long DTToUnixDate(struct date dat, struct time tim);
extern long SqHashName(char *);

extern post postINFO;
extern SHORTINT RegisteredVersion;
extern SHORTINT postMSGNumber;
extern char FindingWordWithSpaces[200];
extern unsigned char FindingWord[200], LogString[100];
extern unsigned long lastmsgid;

unsigned long gen_msgid()
{
 unsigned long msgi=0;
 struct date curdate;
 struct time curtime;
 getdate(&curdate);
 gettime(&curtime);
 curdate.da_year%=3;
 curtime.ti_hund%=15;
 msgi|=(unsigned long)curdate.da_year<<30;
 msgi|=(unsigned long)curdate.da_mon<<26;
 msgi|=(unsigned long)curdate.da_day<<21;
 msgi|=(unsigned long)curtime.ti_hour<<16;
 msgi|=(unsigned long)curtime.ti_min<<10;
 msgi|=(unsigned long)curtime.ti_sec<<4;
 msgi|=(unsigned long)curtime.ti_hund & 0xf;
 return msgi;
}

unsigned long msgid()
{
  if (!lastmsgid) lastmsgid = gen_msgid(); else lastmsgid+=0x25;
  return (lastmsgid);
}



int HudsonPost(int postHudNum, char *postHPath, char *PID1, long Attr)
{
    FILE *MSGHDRFile, *MSGIDXFile, *MSGINFOFile, *EchoMail, *postFile, *MSGTOIDXFile, *MSGbaseFile;
    char path[80], str[514], netmailData[100], buf[800];
    MSGHDR MsgHeader;
    MSGIDX MsgIndex;
    MSGINFO MsgInformation;
    long MsgTxtSize, TPos=0;
    int ShareFile, block, q;
    struct time t;
    struct date d;
    NetAddress AdFrom, AdTo;

    const int                              //MsgHdr.MsgAttr
//    maDeleted =       1,                 //Message is deleted
      maUnmovedNet =    2,                 //Unexported Netmail message
      maNetMail =       4,                 //Message is netmail message
      maPriv =          8,                 //Message is private
//    maRcvd =         16,                 //Message is received
      maUnmovedEcho =  32,                 //Unexported Echomail message
      maLocal =        64,                 //"Locally" entered message

					   //MsgHdr.NetAttr
      naKillSent =      1,                 //Delete after exporting
//    naSent =          2,                 //Msg has been sent
//    naFAttach =       4,                 //Msg has file attached
      naCrash =         8,                 //Msg is crash
      naReqRcpt =      16,                 //Msg requests receipt
      naReqAudit =     32;                 //Msg requests audit
//    naRetRcpt =      64,                 //Msg is a return receipt
//    naFileReq =     128;                 //Msg is a file request



    ShareFile = open(postINFO.postFILE, O_RDWR|O_TEXT|O_DENYWRITE);
    if (ShareFile==-1)
    {
       return (2);
    }
    postFile=fdopen(ShareFile,"rt");

    sprintf(path,"%smsginfo.bbs",postHPath);
    ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
    if (ShareFile==-1)
    {
       fclose(postFile);
       return(1);
    }
    MSGINFOFile=fdopen(ShareFile,"r+b");
    fread(&MsgInformation,sizeof(MsgInformation),1,MSGINFOFile);

    sprintf(path,"%smsghdr.bbs",postHPath);
    ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
    if (ShareFile==-1)
    {
      fclose(postFile);
      fclose(MSGINFOFile);
      return(1);
    }
    MSGHDRFile=fdopen(ShareFile,"r+b");
    fseek(MSGHDRFile,0L,SEEK_SET);

    sprintf(path,"%smsgidx.bbs",postHPath);
    ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
    if (ShareFile==-1)
    {
      fclose(postFile);
      fclose(MSGINFOFile);
      fclose(MSGHDRFile);
      return(1);
    }
    MSGIDXFile=fdopen(ShareFile,"r+b");

    if (stricmp(postINFO.postEchoType,"NETMAIL")==0) sprintf(path,"%snetmail.bbs",postHPath);
    if (stricmp(postINFO.postEchoType,"ECHOMAIL")==0) sprintf(path,"%sechomail.bbs",postHPath);
   if ((stricmp(postINFO.postEchoType,"NETMAIL")==0) || (stricmp(postINFO.postEchoType,"ECHOMAIL")==0))
   {
    ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
    if (ShareFile==-1)
    {
      if (errno==EACCES)
      {
	fclose(MSGINFOFile);
	fclose(MSGHDRFile);
	fclose(MSGIDXFile);
	fclose(postFile);
	return(1);
      }
      if (errno==ENOENT)
      {
	ShareFile = open(path, O_CREAT|O_RDWR|O_BINARY, S_IREAD|S_IWRITE);
      }
    }
    EchoMail=fdopen(ShareFile,"r+b");
   }

    sprintf(path,"%smsgtxt.bbs",postHPath);
    ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
    if (ShareFile==-1)
    {
      fclose(postFile);
      fclose(MSGINFOFile);
      fclose(MSGHDRFile);
      fclose(MSGIDXFile);
      fclose(EchoMail);
      return(1);
    }
    MsgTxtSize=filelength(ShareFile);
    MSGbaseFile=fdopen(ShareFile,"r+b");

    sprintf(path,"%smsgtoidx.bbs",postHPath);
    ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
    if (ShareFile==-1)
    {
      fclose(postFile);
      fclose(MSGINFOFile);
      fclose(MSGHDRFile);
      fclose(MSGIDXFile);
      fclose(EchoMail);
      fclose(MSGbaseFile);
      return(1);
    }
    MSGTOIDXFile=fdopen(ShareFile,"r+b");


    gettime(&t); getdate(&d);
    LineToNetAddress(AdFrom,postINFO.postFADDR);
    LineToNetAddress(AdTo,postINFO.postTADDR);

    MsgInformation.HighMsg++;
    MsgInformation.TotalMsgs++;
    MsgInformation.TotalOnBoard[postHudNum-1]++;

    MsgIndex.MsgNum=MsgInformation.HighMsg;
    MsgIndex.Board=postHudNum;

    MsgHeader.MsgNum=MsgInformation.HighMsg;
    MsgHeader.PrevReply=0;
    MsgHeader.NextReply=0;
    MsgHeader.TimesRead=0;
    MsgHeader.StartBlock=MsgTxtSize/256;
    MsgHeader.DestNet=0;
    MsgHeader.DestNode=0;
    MsgHeader.DestZone=0;
    MsgHeader.OrigNet=AdFrom.Net;
    MsgHeader.OrigNode=AdFrom.Node;
    MsgHeader.OrigZone=AdFrom.Zone;
    MsgHeader.Cost=0;
    MsgHeader.NetAttr=0;
    MsgHeader.MsgAttr=maPriv*((Attr & 1)==1)+maLocal*((Attr & 4)==4)+maUnmovedEcho;
    if (stricmp(postINFO.postEchoType,"NETMAIL")==0)
		    {
		       MsgHeader.MsgAttr=MsgHeader.MsgAttr+maUnmovedNet+maNetMail-maUnmovedEcho;
		       MsgHeader.NetAttr=((Attr & 16)==16)*naReqRcpt+((Attr & 32)==32)*naReqAudit;
		    }
    MsgHeader.NetAttr=MsgHeader.NetAttr+naCrash*((Attr & 64)==64)+naKillSent*((Attr & 2)==2);
    MsgHeader.Board=postHudNum;

    sprintf(MsgHeader.PostTime,"%02d:%02d",t.ti_hour,t.ti_min);
    for(q=0;q<73;q++)
    {
      if (q<36) {MsgHeader.WhoTo[q]='\0';MsgHeader.WhoFrom[q]='\0';}
      MsgHeader.Subject[q]='\0';
    }
    if (d.da_year>=2000) d.da_year-=100;
    sprintf(MsgHeader.PostDate,"%02d-%02d-%02d",d.da_mon,d.da_day,d.da_year-1900);
    sprintf(MsgHeader.WhoTo,"%c%s",strlen(postINFO.postTO),postINFO.postTO);
    sprintf(MsgHeader.WhoFrom,"%c%s",strlen(postINFO.postFROM),postINFO.postFROM);
    sprintf(MsgHeader.Subject,"%c%s",strlen(postINFO.postSUBJ),postINFO.postSUBJ);

    fseek(MSGTOIDXFile,0,SEEK_END);
    fwrite(&MsgHeader.WhoTo,sizeof(MsgHeader.WhoTo),1,MSGTOIDXFile);
    fseek(MSGINFOFile,0,SEEK_SET);
    fwrite(&MsgInformation,sizeof(MsgInformation),1,MSGINFOFile);
    fseek(MSGIDXFile,0,SEEK_END);
    fwrite(&MsgIndex,sizeof(MsgIndex),1,MSGIDXFile);
   if ((stricmp(postINFO.postEchoType,"NETMAIL")==0) || (stricmp(postINFO.postEchoType,"ECHOMAIL")==0))
   {
    fseek(EchoMail,0,SEEK_END);
    MsgInformation.HighMsg--;
    fwrite(&MsgInformation.HighMsg,sizeof(MsgInformation.HighMsg),1,EchoMail);
   }
    fseek(MSGbaseFile,0,SEEK_END);
    for(q=0;q<100;q++)netmailData[q]='\0';
    if (stricmp(postINFO.postEchoType,"NETMAIL")==0)
    {
      strcpy(str,"");
      if (!(AdFrom.Zone==AdTo.Zone && AdFrom.Net==AdTo.Net && AdFrom.Node==AdTo.Node))
	sprintf(str,"INTL %d:%d/%d %d:%d/%d\r\0",AdTo.Zone,AdTo.Net,AdTo.Node,AdFrom.Zone,AdFrom.Net,AdFrom.Node);
	strcpy(netmailData,str);
	strcpy(str,"");
      if (AdTo.Point>0)	sprintf(str,"TOPT %d\r\0",AdTo.Point);
	strcat(netmailData,str);
	strcpy(str,"");
      if (AdFrom.Point>0)  sprintf(str,"FMPT %d\r\0",AdFrom.Point);
	strcat(netmailData,str);
      if (Attr>127)
      {
	strcpy(str,"FLAGS ");
	if ((Attr & 8)==8 && ((Attr & 64)!=64)) strcat(str,"HLD");
	if (Attr>=136) strcat(str," ");
	if ((Attr & 128)==128) strcat(str,"IMM");
	if (Attr>=384) strcat(str," ");
	if ((Attr & 256)==256) strcat(str,"DIR");
	strcat(str,"\r");
	strcat(netmailData,str);
      }
    }
    block=0;
    memset(str,0,511);
    sprintf(str,"%sMSGID: %s %08lx\r%s",netmailData,postINFO.postFADDR,msgid(),PID1);
    fread(&str[strlen(str)],255-strlen(str),1,postFile);
    while(strlen(str)==255)
      {
	for (q=0;q<strlen(str);q++) str[q]=str[q]=='\n'?'\r':str[q];
	sprintf(buf,"%c%s\0",char(255),str);
	fwrite(buf,strlen(buf),1,MSGbaseFile);
	block++;
	for(q=0;q<256;q++) str[q]='\0';
	fread(&str,255,1,postFile);
      }
      strcat(str,"\r--- ");
      strcat(str,postINFO.postTEARLINE);
      strcat(str,"\r * Origin: ");
      strcat(str,postINFO.postORIGIN);
      strcat(str," (");
      strcat(str,postINFO.postFADDR);
      strcat(str,")\r");
      for (q=0;q<strlen(str);q++) str[q]=str[q]=='\n'?'\r':str[q];
      if (strlen(str)<256) sprintf(buf,"%c%s",strlen(str)<255?(strlen(str)+1):255,str);
      else
      {
	 sprintf(buf,"%c%s",char(255),str); buf[256]='\0';
	 sprintf(&buf[256],"%c%s\0",strlen(&str[255])+1,&str[255]);
      }
	TPos=strlen(buf);
	q=TPos;
	TPos=((TPos+255)/256)*256;
	for (;q<=TPos;q++) buf[q]='\0';
        fwrite(buf,TPos,1,MSGbaseFile);
    fseek(MSGHDRFile,0,SEEK_END);
    MsgHeader.NumBlocks=block+(TPos/256);
    fwrite(&MsgHeader,sizeof(MsgHeader),1,MSGHDRFile);
    fclose(MSGINFOFile);
    fclose(MSGHDRFile);
    fclose(MSGIDXFile);
    fclose(MSGTOIDXFile);
    fclose(EchoMail);
    fclose(MSGbaseFile);
    fclose(postFile);
    return(0);
}


int JamPost(char *postJPath,char *postMSGBase,char *PID1, long attr)
{
  FILE *JAMHeader, *JAMIndex, *EchoMail, *postFILE, *MSGbaseFile;
  JamHdrType JAMHdr;
  JamMsgHdrType JAMMsgHdr;
  JamIdxType JAMIdx;
  char JAMStr[250], JAMFileName[70];
  int handle,q;
  long MSGID, CurNumber, JAMPid, JAMLength;
  struct time t;
  struct date d;
  long
    Jam_Local =        0x00000001,
//  Jam_InTransit =    0x00000002,
    Jam_Priv =         0x00000004,
//  Jam_Rcvd =         0x00000008,
//  Jam_Sent =         0x00000010,
    Jam_KillSent =     0x00000020,
//  Jam_AchvSent =     0x00000040,
    Jam_Hold =         0x00000080,
    Jam_Crash =        0x00000100,
    Jam_Imm =          0x00000200,
    Jam_Direct =       0x00000400,
//  Jam_Gate =         0x00000800,
//  Jam_Freq =         0x00001000,
//  Jam_FAttch =       0x00002000,
//  Jam_TruncFile =    0x00004000,
//  Jam_KillFile =     0x00008000,
    Jam_RcptReq =      0x00010000,
//  Jam_ConfmReq =     0x00020000,
//  Jam_Orphan =       0x00040000,
//  Jam_Encrypt =      0x00080000,
//  Jam_Compress =     0x00100000,
//  Jam_Escaped =      0x00200000,
//  Jam_FPU =          0x00400000,
//  Jam_TypeLocal =    0x00800000,
    Jam_TypeEcho =     0x01000000,
    Jam_TypeNet =      0x02000000;
//  Jam_NoDisp =       0x20000000,
//  Jam_Locked =       0x40000000,
//  Jam_Deleted =      0x80000000;

  handle = open(postINFO.postFILE, O_RDWR|O_TEXT|O_DENYWRITE);
  if (handle==-1)
  {
    return(2);
  }
  postFILE=fdopen(handle,"rt");

  sprintf(JAMFileName,"%s.JDX",postJPath);
  handle=open(JAMFileName, O_RDWR | O_BINARY  | O_DENYWRITE);
  if (handle==-1)
  {
    fclose(postFILE);
    return(1);
  }
  CurNumber=1+(filelength(handle)/8);
  JAMIndex=fdopen(handle,"r+b");

  sprintf(JAMFileName,"%s.JHR",postJPath);
  handle = open(JAMFileName, O_RDWR|O_BINARY|O_DENYWRITE);
  if (handle==-1)
  {
    fclose(postFILE);
    fclose(JAMIndex);
    return(1);
  }

  JAMIdx.MsgToCrc=FindCrc32(postINFO.postTO);
  JAMIdx.HdrLoc=filelength(handle);

  JAMHeader=fdopen(handle,"r+b");

  sprintf(JAMFileName,"%s.JDT",postJPath);
  handle = open(JAMFileName, O_RDWR|O_BINARY|O_DENYWRITE);
  if (handle==-1)
  {
    fclose(postFILE);
    fclose(JAMIndex);
    fclose(JAMHeader);
    return(1);
  }
  JAMMsgHdr.TextOfs=filelength(handle);
  MSGbaseFile=fdopen(handle,"r+b");

  sprintf(JAMFileName,"%sechomail.jam",postMSGBase);
  handle = open(JAMFileName, O_RDWR|O_BINARY|O_DENYWRITE);
  if (handle==-1)
  {
    if (errno==EACCES)
    {
      fclose(postFILE);
      fclose(JAMIndex);
      fclose(JAMHeader);
      fclose(MSGbaseFile);
      return(1);
    }
    if (errno==ENOENT)
    {
      handle = open(JAMFileName, O_CREAT|O_RDWR|O_BINARY, S_IREAD|S_IWRITE);
      if (handle==-1) return(1);
    }
  }
  EchoMail=fdopen(handle,"r+b");


  fread(&JAMHdr,sizeof(JAMHdr),1,JAMHeader);

  strcpy(JAMHdr.Signature,"JAM");JAMHdr.Signature[3]='\0';
  JAMHdr.ModCounter+=2;
  JAMHdr.ActiveMsgs++;
  MSGID = msgid();
  strcpy(JAMMsgHdr.Signature,"JAM");JAMMsgHdr.Signature[3]='\0';
  JAMMsgHdr.Rev=1;
  JAMMsgHdr.Resvd=0;
  JAMMsgHdr.TimesRead=0;
  sprintf(JAMStr,"%s %08lx",postINFO.postFADDR,MSGID);
  JAMMsgHdr.MsgIdCrc=FindCrc32(JAMStr);
  JAMMsgHdr.ReplyCrc=0xFFFFFFFF;
  JAMMsgHdr.ReplyTo=0;
  JAMMsgHdr.ReplyFirst=0;
  JAMMsgHdr.ReplyNext=0;
  getdate(&d); gettime(&t);
  JAMMsgHdr.DateWritten=DTToUnixDate(d,t);
  JAMMsgHdr.DateRcvd=0;
  JAMMsgHdr.DateArrived=0;
  JAMMsgHdr.MsgNum=CurNumber;
  JAMMsgHdr.Attr1=(((attr & 1)==1)*Jam_Priv) |
		  (((attr & 2)==2)*Jam_KillSent) |
		  (((attr & 4)==4)*Jam_Local) |
		  (((attr & 8)==8)*Jam_Hold)*((attr & 64)!=64) |
//		  (((attr & 32)==32)*
		  (((attr & 64)==64)*Jam_Crash) |
		  (((attr & 128)==128)*Jam_Imm) |
		  (((attr & 256)==256)*Jam_Direct);
  if (stricmp(postINFO.postEchoType,"NETMAIL")==0) JAMMsgHdr.Attr1|=(Jam_TypeNet|(((attr & 16)==16)*Jam_RcptReq)); else JAMMsgHdr.Attr1|=(Jam_TypeEcho|(((attr & 16)==16)*Jam_RcptReq));
  JAMMsgHdr.Attr2=0;
  JAMMsgHdr.PwdCrc=0xFFFFFFFF;
  JAMMsgHdr.Cost=0;

  JAMMsgHdr.SubFieldLen=strlen(postINFO.postFROM)+strlen(postINFO.postFADDR)*2+strlen(PID1)+8*4+9/*MSGID*/-7/*PID*/;
  JAMMsgHdr.SubFieldLen+=(strlen(postINFO.postTO)>0)?(8+strlen(postINFO.postTO)):0;
  JAMMsgHdr.SubFieldLen+=(strlen(postINFO.postTADDR)>0)?(8+strlen(postINFO.postTADDR)):0;
  JAMMsgHdr.SubFieldLen+=(strlen(postINFO.postSUBJ)>0)?(8+strlen(postINFO.postSUBJ)):0;

  JAMMsgHdr.TextLen=0;
  fseek(MSGbaseFile,0,SEEK_END);

  do
  {
     for(q=0;q<sizeof(JAMStr);q++) JAMStr[q]='\0';
     fread(JAMStr,sizeof(JAMStr)-1,1,postFILE);
     for (q=0;q<strlen(JAMStr);q++) JAMStr[q]=JAMStr[q]=='\n'?'\r':JAMStr[q];
     if (strlen(JAMStr)>0) fwrite(JAMStr,strlen(JAMStr),1,MSGbaseFile);
     JAMMsgHdr.TextLen+=strlen(JAMStr);
  } while (strlen(JAMStr)==sizeof(JAMStr)-1);

  strcpy(JAMStr,"\r--- ");
  strcat(JAMStr,postINFO.postTEARLINE);
  strcat(JAMStr,"\r * Origin: ");
  strcat(JAMStr,postINFO.postORIGIN);
  strcat(JAMStr," (");
  strcat(JAMStr,postINFO.postFADDR);
  strcat(JAMStr,")\r\0");
  fwrite(JAMStr,strlen(JAMStr),1,MSGbaseFile);
  JAMMsgHdr.TextLen+=strlen(JAMStr);

//  strcpy(JAMMsgHdr.Signature,"JAM"); // ⮡  稫
  fseek(JAMIndex,0,SEEK_END); fwrite(&JAMIdx,sizeof(JAMIdx),1,JAMIndex);
  fseek(JAMHeader,0,SEEK_SET);
  fwrite(&JAMHdr,sizeof(JAMHdr),1,JAMHeader);
  fseek(JAMHeader,0,SEEK_END); fwrite(&JAMMsgHdr,sizeof(JAMMsgHdr),1,JAMHeader);

  JAMPid=2; JAMLength=strlen(postINFO.postFROM);
  fwrite(&JAMPid,sizeof(JAMPid),1,JAMHeader);
  fwrite(&JAMLength,sizeof(JAMLength),1,JAMHeader);
  fwrite(postINFO.postFROM,JAMLength,1,JAMHeader);

  JAMPid=0; JAMLength=strlen(postINFO.postFADDR);
  fwrite(&JAMPid,sizeof(JAMPid),1,JAMHeader);
  fwrite(&JAMLength,sizeof(JAMLength),1,JAMHeader);
  fwrite(postINFO.postFADDR,JAMLength,1,JAMHeader);

  JAMPid=3; JAMLength=strlen(postINFO.postTO);
  fwrite(&JAMPid,sizeof(JAMPid),1,JAMHeader);
  fwrite(&JAMLength,sizeof(JAMLength),1,JAMHeader);
  fwrite(postINFO.postTO,JAMLength,1,JAMHeader);

  JAMPid=1; JAMLength=strlen(postINFO.postTADDR);
  if (JAMLength)
  {
    fwrite(&JAMPid,sizeof(JAMPid),1,JAMHeader);
    fwrite(&JAMLength,sizeof(JAMLength),1,JAMHeader);
    fwrite(postINFO.postTADDR,JAMLength,1,JAMHeader);
  }

  JAMPid=6; JAMLength=strlen(postINFO.postSUBJ);
  if (JAMLength)
  {
    fwrite(&JAMPid,sizeof(JAMPid),1,JAMHeader);
    fwrite(&JAMLength,sizeof(JAMLength),1,JAMHeader);
    fwrite(postINFO.postSUBJ,JAMLength,1,JAMHeader);
  }

  JAMPid=4; JAMLength=strlen(postINFO.postFADDR)+9;
  fwrite(&JAMPid,sizeof(JAMPid),1,JAMHeader);
  fwrite(&JAMLength,sizeof(JAMLength),1,JAMHeader);
  fwrite(postINFO.postFADDR,strlen(postINFO.postFADDR),1,JAMHeader);
  fprintf(JAMHeader," %08lx",MSGID);

  JAMPid=7; JAMLength=strlen(PID1)-7;
  fwrite(&JAMPid,sizeof(JAMPid),1,JAMHeader);
  fwrite(&JAMLength,sizeof(JAMLength),1,JAMHeader);
  fwrite(&PID1[6],JAMLength,1,JAMHeader);

  fseek(EchoMail,0,SEEK_END);
  fprintf(EchoMail,"%s %ld\r\n",postJPath,CurNumber);

  fclose(MSGbaseFile);
  fclose(EchoMail);
  fclose(JAMHeader);
  fclose(JAMIndex);
  fclose(postFILE);
	 return(0);
}

int FidoMsgPost(char *postMPath,char *PID1, long Attr)
{
  int q, MSGnumber, handle;
  FILE *MSGbaseFile;
  SHORTWORD ReadB;
  FidoMsg FidoMsgHeader;
  NetAddress AdFrom, AdTo;
  struct date dt;
  struct time tm;
  char str[300],netmailData[100];
  struct ffblk MSGLetters;
  FILE *postFILE;
  handle=open(postINFO.postFILE,O_RDONLY|O_TEXT|O_DENYWRITE);
  if(handle==-1)
  {
	 return(2);
  }
  postFILE=fdopen(handle,"rt");

  strcpy(str,postMPath);
  LastSlesh(str,1);
  strcat(str,"*.msg");
  if (!postMSGNumber)
  {
    q=findfirst(str,&MSGLetters,0);
    while (!q)
    {
      sscanf(MSGLetters.ff_name,"%d.msg",&MSGnumber);
      if (MSGnumber>postMSGNumber) postMSGNumber=MSGnumber;
      q=findnext(&MSGLetters);
    }
  }
  do
  {
    postMSGNumber++;
    sprintf(str,"%s%d.msg",postMPath,postMSGNumber);
    q=access(str,0);
  } while (!q && postMSGNumber<20000);

  MSGbaseFile=fopen(str,"wb");

  LineToNetAddress(AdFrom,postINFO.postFADDR);
  LineToNetAddress(AdTo,postINFO.postTADDR);

  memset(FidoMsgHeader.FromUserName,0,sizeof(FidoMsgHeader.FromUserName));
  memset(FidoMsgHeader.ToUserName,0,sizeof(FidoMsgHeader.ToUserName));
  memset(FidoMsgHeader.Subject,0,sizeof(FidoMsgHeader.Subject));
  memset(FidoMsgHeader.DateTime,0,sizeof(FidoMsgHeader.DateTime));
  memset(FidoMsgHeader.fill,0,sizeof(FidoMsgHeader.fill));

  getdate(&dt); gettime(&tm);

  strncpy(FidoMsgHeader.FromUserName,postINFO.postFROM,35);
  strncpy(FidoMsgHeader.ToUserName,postINFO.postTO,35);
  strncpy(FidoMsgHeader.Subject,postINFO.postSUBJ,72);
  if (dt.da_year>2000) dt.da_year-=100;
  sprintf(FidoMsgHeader.DateTime,"%02d %s %02d  %02d:%02d:%02d\0",dt.da_day,Month[dt.da_mon-1],dt.da_year-1900,
							(int)tm.ti_hour, (int)tm.ti_min, (int)tm.ti_sec);
  FidoMsgHeader.timesRead=0;
  FidoMsgHeader.destNode=AdTo.Node;
  FidoMsgHeader.origNode=AdFrom.Node;
  FidoMsgHeader.cost=0;
  FidoMsgHeader.origNet=AdFrom.Net;
  FidoMsgHeader.destNet=AdTo.Net;
  FidoMsgHeader.replyTo=0;
  FidoMsgHeader.Attribute=((Attr & 1)==1) |
			  (((Attr & 2)==2) << 7) |
			  (((Attr & 4)==4) << 8) |
			  (((Attr & 8)==8)*((Attr & 64)!=64) << 9) |
			  (((Attr & 16)==16) << 12);
  if (stricmp(postINFO.postEchoType,"NETMAIL")==0)
  FidoMsgHeader.Attribute|=(((Attr & 32)==32) << 14) |
			   (((Attr & 64)==64) << 1);
  FidoMsgHeader.nextReply=0;

    for(q=0;q<100;q++)netmailData[q]='\0';
    if (stricmp(postINFO.postEchoType,"NETMAIL")==0)
    {
      strcpy(str,"");
      if (!(AdFrom.Zone==AdTo.Zone && AdFrom.Net==AdTo.Net && AdFrom.Node==AdTo.Node))
	sprintf(str,"INTL %d:%d/%d %d:%d/%d\r\0",AdTo.Zone,AdTo.Net,AdTo.Node,AdFrom.Zone,AdFrom.Net,AdFrom.Node);
	strcpy(netmailData,str);
	strcpy(str,"");
      if (AdTo.Point>0)	sprintf(str,"TOPT %d\r\0",AdTo.Point);
	strcat(netmailData,str);
	strcpy(str,"");
      if (AdFrom.Point>0)  sprintf(str,"FMPT %d\r\0",AdFrom.Point);
	strcat(netmailData,str);
      if (Attr>127)
      {
	strcpy(str,"FLAGS ");
	if ((Attr & 128)==128) strcat(str,"IMM");
	if (Attr>=384) strcat(str," ");
	if ((Attr & 256)==256) strcat(str,"DIR");
	strcat(str,"\r");
	strcat(netmailData,str);
      }

    }

  memset(str,0,300);

  sprintf(str,"%sMSGID: %s %08lx\r%s\0",netmailData,postINFO.postFADDR,msgid(),PID1);

  fwrite(&FidoMsgHeader,sizeof(FidoMsgHeader),1,MSGbaseFile);
  fwrite(str,strlen(str),1,MSGbaseFile);


  do
  {
    for(q=0;q<sizeof(str);q++) str[q]='\0';
    fread(&str,sizeof(str)-1,1,postFILE);
    for(q=0;q<strlen(str);q++) str[q]=str[q]=='\n'?'\r':str[q];
    if (strlen(str)>0) fwrite(str,strlen(str),1,MSGbaseFile);
  } while (strlen(str)==sizeof(str)-1);
  strcpy(str,"\r--- ");
  strcat(str,postINFO.postTEARLINE);
  strcat(str,"\r * Origin: ");
  strcat(str,postINFO.postORIGIN);
  strcat(str," (");
  strcat(str,postINFO.postFADDR);
  strcat(str,")\r\0\0");
  fwrite(str,strlen(str)+1,1,MSGbaseFile);

  fclose(MSGbaseFile);
  fclose(postFILE);
  return(0);
}

long SquishTimeWritten()
{
  struct date dt;
  struct time tm;
  long TimeWritten;

/*  struct ftime
  {
    unsigned ft_tsec  : 5;  // Two seconds
    unsigned ft_min   : 6;  /* Minutes
    unsigned ft_hour  : 5;  /* Hours
    unsigned ft_day   : 5;  /* Days
    unsigned ft_month : 4;  /* Months
    unsigned ft_year  : 7;  /* Year - 1980
  };*/
  getdate(&dt); gettime(&tm);
  TimeWritten  = (long)(dt.da_year - 1980) << 25;
  TimeWritten += (long)dt.da_mon << 21;
  TimeWritten += (long)dt.da_day << 16;
  TimeWritten += (long)tm.ti_hour << 11;
  TimeWritten += (long)tm.ti_min << 5;
  TimeWritten += (long)tm.ti_sec >> 1;

  TimeWritten = (TimeWritten >> 16) | ((TimeWritten & 0xffff) << 16);

  return (TimeWritten);
}

int SquishPost(char *postSPath, char *PID1, long Attr)
{
   FILE *SquishIFile, *postFILE, *MSGbaseFile;
   char SquishFileName[60], str[300];
   SqBaseType SquishBase;
   SqFrameHdrType SquishHdr, NearHdr;
   SqMsgHdrType SquishMsgHdr;
   SqIdxType SquishIndex;
   int q,handle;
   NetAddress AdFrom, AdTo;
   struct time t;
   struct date d;
   long record,// TmpDate,
	SqMsgPriv =   0x00001,
	SqMsgCrash =  0x00002,
//	SqMsgRcvd =   0x00004,
//	SqMsgSent =   0x00008,
//	SqMsgFile =   0x00010,
//	SqMsgFwd =    0x00020,
//	SqMsgOrphan = 0x00040,
	SqMsgKill =   0x00080,
	SqMsgLocal =  0x00100,
	SqMsgHold =   0x00200,
//	SqMsgXX2 =    0x00400,
//	SqMsgFreq =   0x00800,
	SqMsgRrq =    0x01000,
//	SqMsgCpt =    0x02000,
	SqMsgArq =    0x04000;
//	SqMsgUrg =    0x08000,
//	SqMsgScanned= 0x10000;


   if((handle=open(postINFO.postFILE,O_RDONLY|O_TEXT|O_DENYWRITE))==-1)
   {
     return(2);
   }

   postFILE=fdopen(handle,"rt");

   sprintf(SquishFileName,"%s.sqd",postSPath);
   handle=open(SquishFileName, O_RDWR | O_BINARY  | O_DENYWRITE);
   if (handle==-1)
   {
     fclose(postFILE);
     return(1);
   }
   MSGbaseFile=fdopen(handle,"r+b");
   fread(&SquishBase,sizeof(SquishBase),1,MSGbaseFile);

   sprintf(SquishFileName,"%s.sqi",postSPath);
   handle=open(SquishFileName, O_RDWR | O_BINARY  | O_DENYWRITE);
   if (handle==-1)
   {
     fclose(postFILE);
     fclose(MSGbaseFile);
     return(1);
   }
   SquishIFile=fdopen(handle,"r+b");

   if(SquishBase.LastFrame)
   {
   // ࠡ⪠ ।饣 ३
   fseek(MSGbaseFile,SquishBase.LastFrame,SEEK_SET);
   fread(&NearHdr,sizeof(NearHdr),1,MSGbaseFile);
   NearHdr.NextFrame=SquishBase.EndFrame;
   fseek(MSGbaseFile,SquishBase.LastFrame,SEEK_SET);
   fwrite(&NearHdr,sizeof(NearHdr),1,MSGbaseFile);
   }

   // 室 
   SquishIndex.Ofs=SquishBase.EndFrame;
   SquishIndex.UMsgId=SquishBase.Uid;
   SquishIndex.Hash=SqHashName(postINFO.postTO);

   SquishBase.HighWater=SquishIndex.UMsgId;

   SquishHdr.Id=SqHdrId;
   SquishBase.Uid++;
   SquishHdr.NextFrame=0;
   SquishHdr.PrevFrame=SquishBase.LastFrame;
   SquishHdr.FrameType=SqFrameMsg;
   SquishHdr.ControlLength=0;
   SquishHdr.Rsvd=0;

   // ६ 祭
   SquishHdr.FrameLength=0;
   SquishHdr.MsgLength=0;

   SquishBase.NumMsg++;
   SquishBase.HighMsg=SquishBase.NumMsg;
   if (SquishBase.BeginFrame==0) SquishBase.BeginFrame=SquishIndex.Ofs;
   SquishBase.LastFrame=SquishIndex.Ofs;

   SquishMsgHdr.Attr=0xA0000 |
		     ((Attr & 1)==1)*SqMsgPriv |
//		     ((Attr & 2)==2)*SqMsgKill |
		     ((Attr & 4)==4)*SqMsgLocal |
		     ((Attr & 8)==8)*((Attr & 64)!=64)*(SqMsgHold) |
		     ((Attr & 64)==64)*SqMsgCrash;
   if (stricmp(postINFO.postEchoType,"NETMAIL")==0) SquishMsgHdr.Attr|=((((Attr & 16)==16)*SqMsgRrq) | (((Attr & 32)==32)*SqMsgArq));

   memset(SquishMsgHdr.MsgFrom,0,sizeof(SquishMsgHdr.MsgFrom));
   memset(SquishMsgHdr.MsgTo,0,sizeof(SquishMsgHdr.MsgTo));
   memset(SquishMsgHdr.Subj,0,sizeof(SquishMsgHdr.Subj));

   strcpy(SquishMsgHdr.MsgFrom,postINFO.postFROM);
   strcpy(SquishMsgHdr.MsgTo,postINFO.postTO);
   strcpy(SquishMsgHdr.Subj,postINFO.postSUBJ);
   LineToNetAddress(AdFrom,postINFO.postFADDR);
   LineToNetAddress(AdTo,postINFO.postTADDR);
   SquishMsgHdr.Orig=AdFrom;
   SquishMsgHdr.Dest=AdTo;

   getdate(&d); gettime(&t);
//   TmpDate = DTToUnixDate(d,t);
//   TmpDate=SquishTimeWritten();
   SquishMsgHdr.DateWritten=SquishTimeWritten();
   SquishMsgHdr.DateArrived=0;
   SquishMsgHdr.UtcOffset=0;
   SquishMsgHdr.ReplyTo=0;
   for (q=0;q<9;q++) SquishMsgHdr.Replies[q]=0;
   SquishMsgHdr.UMsgID=SquishIndex.UMsgId;
   sprintf(SquishMsgHdr.AzDate,"%02d %s %02d  %02d:%02d:%02d\x0",d.da_day,Month[d.da_mon-1],d.da_year-1900,
							(int)t.ti_hour, (int)t.ti_min, (int)t.ti_sec);

   fseek(SquishIFile,0,SEEK_END);
   fwrite(&SquishIndex,sizeof(SquishIndex),1,SquishIFile);
   fseek(MSGbaseFile,SquishIndex.Ofs,SEEK_SET);
   fwrite(&SquishHdr,sizeof(SquishHdr),1,MSGbaseFile);
   fwrite(&SquishMsgHdr,sizeof(SquishMsgHdr),1,MSGbaseFile);

   for(q=0;q<300;q++)str[q]='\0';
   memset(str,0,300);
   sprintf(str,"MSGID: %s %08lx%s\0",postINFO.postFADDR,msgid(),PID1);
   str[strlen(str)-1]='\0';
   if (stricmp(postINFO.postEchoType,"NETMAIL")==0 && Attr>127)
   {
     strcat(str,"FLAGS: ");
     if ((Attr & 128)==128) strcat(str,"IMM");
     if (Attr>=384) strcat(str," ");
     if ((Attr & 256)==256) strcat(str,"DIR");
     strcat(str,"\0");
   }
   fwrite(str,strlen(str)+1,1,MSGbaseFile);
   record=strlen(str)+1;
   SquishHdr.ControlLength=record;
   do
   {
     for(q=0;q<sizeof(str);q++) str[q]='\0';
     fread(&str,sizeof(str)-1,1,postFILE);
     for(q=0;q<strlen(str);q++) str[q]=str[q]=='\n'?'\r':str[q];
     if (strlen(str)>0) fwrite(str,strlen(str),1,MSGbaseFile);
     record+=strlen(str);
   } while (strlen(str)==sizeof(str)-1);
   strcpy(str,"\r--- ");
   strcat(str,postINFO.postTEARLINE);
   strcat(str,"\r * Origin: ");
   strcat(str,postINFO.postORIGIN);
   strcat(str," (");
   strcat(str,postINFO.postFADDR);
   strcat(str,")\r\0\0");
   fwrite(str,strlen(str)+1,1,MSGbaseFile);
   record+=(strlen(str)+1);

   fgetpos(MSGbaseFile,&SquishBase.EndFrame);
   SquishHdr.MsgLength=record+sizeof(SquishMsgHdr);
   SquishHdr.FrameLength=record+sizeof(SquishMsgHdr);
   fseek(MSGbaseFile,SquishIndex.Ofs,SEEK_SET);
   fwrite(&SquishHdr,sizeof(SquishHdr),1,MSGbaseFile);
   fseek(MSGbaseFile,0,SEEK_SET);
   fwrite(&SquishBase,sizeof(SquishBase),1,MSGbaseFile);

   fclose(SquishIFile);
   fclose(MSGbaseFile);
   fclose(postFILE);
   return(0);
}



int Post(char *postHUDSONpath, char *NameSysop, long Attribute=0x0006)
{
  int hand, k, BoardNumber, Disabled, PostResult;
  char postAreaStr[130],c;
  FILE *postAreas;
  char /*postFidoMsgBasePath[60],*/ postBoardName[60], postBoardPath[60];
  char PID[80];

  LastSlesh(postHUDSONpath,1);
  if (!postINFO.postTEARLINE[0])
  {
    strcpy(postINFO.postTEARLINE,"Posted by UUXTRACT ");
    strcat(postINFO.postTEARLINE,VERSION); strcat(postINFO.postTEARLINE," for "); strcat(postINFO.postTEARLINE,OPSYS);
    if (!RegisteredVersion) strcat(postINFO.postTEARLINE," UNREGISTERED");
  }

  sprintf(PID,"PID: UUXTRACT %s",VERSION);
  if (!RegisteredVersion) strcat(PID," UNREGISTERED"); else
  {
    strcat(PID," (Registered to ");
    strcat(PID,NameSysop);
    strcat(PID,")");
  }
  strcat(PID,"\r\0");
  PostResult=0;
  hand = open ("~~areas~.$$$",O_RDONLY|O_BINARY|O_DENYWRITE);
  if (hand==-1)
  {
    return(1);
  }

  postAreas = fdopen(hand,"rb");
  if (postAreas==NULL)
  {
     return(1);
  }

  do
  {
  k=0; postAreaStr[0]='\0';
  do
  {
    fread(&c,1,1,postAreas);
    if (!(k==0 && c=='\n') && k<125)
    {
      postAreaStr[k]=c;
      postAreaStr[++k]='\0';
    }
  } while (c!=13 && !feof(postAreas));
  FindWord(postAreaStr,1);
  BoardNumber=atoi(FindingWord);
//  strcpy(postFidoMsgBasePath,FindingWordWithSpaces);
  FindWord(postAreaStr,2); strcpy(postBoardName,FindingWord);
  FindWord(postAreaStr,3);
  if (!stricmp(FindingWord,"NETMAIL")) strcpy(postINFO.postEchoType,"NETMAIL");
  if (!stricmp(FindingWord,"ECHOMAIL")/* || stricmp(postINFO.postEchoType,"NETMAIL")*/)
  				       strcpy(postINFO.postEchoType,"ECHOMAIL");
  if (!stricmp(postBoardName,"NETMAIL")) strcpy(postINFO.postEchoType,"NETMAIL");
  Disabled=0;
  if (BoardNumber>0)      /*   Hudson  */
  {
       if (stricmp(postINFO.postAREA,postBoardName)==0)
       {
	      PostResult=HudsonPost(BoardNumber,postHUDSONpath,PID,Attribute);
	      Disabled=1;
       }
  }
  else
  if (postAreaStr[0]=='!')    /*   JAM  */
  {
      postAreaStr[0]=' ';
      FindWord(postAreaStr,1);
      strcpy(postBoardPath,FindingWord);
      FindWord(postAreaStr,2);
      strcpy(postBoardName,FindingWord);
      if (stricmp(postINFO.postAREA,postBoardName)==0)
      {
	PostResult=JamPost(postBoardPath,postHUDSONpath,PID,Attribute);
	Disabled=1;
      }
  }
  else
  if (postAreaStr[0]=='$')    /*   Squish  */
  {
    postAreaStr[0]=' ';
    FindWord(postAreaStr,1);
    strcpy(postBoardPath,FindingWord);
    FindWord(postAreaStr,2);
    strcpy(postBoardName,FindingWord);
    if (stricmp(postINFO.postAREA,postBoardName)==0)
    {
      PostResult=SquishPost(postBoardPath,PID,Attribute);
      Disabled=1;
    }
  }
  else
  if (postAreaStr[0]!=';')
  {                       /*   Fido/MSG  */
    FindWord(postAreaStr,1);
    strcpy(postBoardPath,FindingWord);
    if (strlen(postBoardPath)>3)
    {
      FindWord(postAreaStr,2);
      strcpy(postBoardName,FindingWord);
      LastSlesh(postBoardPath,1);
      if (stricmp(postINFO.postAREA,postBoardName)==0)
      {
        PostResult=FidoMsgPost(postBoardPath,PID,Attribute);
        Disabled=1;
      }
    }
  }
  } while (!feof(postAreas) && !Disabled);
  fclose(postAreas);
  if (PostResult==1)
  {
    sprintf(LogString,"Error accessing to %s",postINFO.postAREA);
    AddLog(LogString);
    Event(LogString);
    Event("If you make post next time runned UUXTRACT would send your messages");
    color(7,0);
    printf("\n\nThere are reason of this error:");
    Event("Message base was not found (Check \"Hudson\" variable)");
    Event("Message base may be locked by another program\n");
  }
  else
  if (PostResult==2)
  {
    sprintf(LogString,"Object for post not found (%s)",postINFO.postFILE);
    AddLog(LogString);
    Event(LogString);
  }
  if (!Disabled) {sprintf(LogString,"Error: %s area not found",postINFO.postAREA);Event(LogString);AddLog(LogString);}
  return(PostResult);
}

