// Message base processing


void ProgressBar(double &pbProgress, double pbProgressStep, unsigned long pbCL, int &pboLast)
{
    int   oPercent, oProgress;

    oProgress = ((float)pbCL+1e-6)/pbProgressStep;
    color(14,1);
    while (pboLast<(41+((oProgress-1)/2)))
    {
      gotoxy(pboLast,wherey());
      cprintf("");
      pboLast++;
    }
    pboLast = 41+((oProgress-1)/2);
    if (oProgress>42) return;
    gotoxy(pboLast,wherey()); cprintf("%c",oProgress%2?'':'');
    do
    {
      pbProgress-=pbProgressStep;
    } while (pbProgress>=pbProgressStep);
    pbProgress+=1e-9;
}

void PercentBar( double &pbPercent, double pbPercentStep, unsigned long pbCL)
{
  int oPercent;
  oPercent = ((float)pbCL+1e-6)/pbPercentStep;
  color(7,0);
  if (oPercent>100) return;
  gotoxy(66,wherey()); cprintf("[%3d%%]",oPercent);
  do
  {
    pbPercent-=pbPercentStep;
  }while (pbPercent>=pbPercentStep);
  pbPercent+=1e-9;
}

void ZeroMsgData(MsgDataBase &MsgData1)
{
  MsgData1.FullFileName[0]='\0';
  MsgData1.From[0]='\0';
  MsgData1.To[0]='\0';
  MsgData1.Subj[0]='\0';
  MsgData1.AddrFrom[0]='\0';
  MsgData1.AddrTo[0]='\0';
  MsgData1.DateTime[0]='\0';
  MsgData1.UUECoder[0]='\0';
  MsgData1.MSGID[0]='\0';
}

int HudsonProcessing(char *BName, int BNum, char *HPath, char *Outpath)
{
    FILE *MSGHDRFile, *MSGIDXFile, *MSGINFOFile;
    unsigned char path[80], j, mon[3];
    SHORTWORD PredMsg, NewHighMsg, lowmsg, NewLowMsg;
    MSGHDR MsgHeader;
    MSGIDX MsgIndex;
    MSGINFO MsgInformation;
    SHORTWORD LastReadRecord;
    int CurrentLetter=0, TotalInBoard,EchoNumber, ShareFile, SeekToLastRead=0, j1;
    long StB, LetterLen1;
    fpos_t curpos,cp;
    char d1;//, check_more;
    double PercentLetterStep, ProgressStep, Percent, Progress;
    int oLastProgress = 41;


    MsgDataBase MsgData = {"\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0"};
#ifdef __WIN32__
	 DWORD cNumRead, i;
	 INPUT_RECORD irInBuf[128];
#endif
    MakeMSGFile=NOMSG;
       if (VisibleOutput)
       {
         textcolor(7);   cprintf("\r\n      Searching in ");
         textcolor(GREEN);   cprintf("%s",BName);clreol();
       }

       if (PauseTime) CheckFastEchoBusyFlag();

       strcpy(path,HPath);
       strcat(path,"msginfo.bbs");
       ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
       if (ShareFile==-1)
       {
	 AccessDenied(path);
	 return(0);
       }
       MSGINFOFile=fdopen(ShareFile,"r+b");
       fread(&MsgInformation,sizeof(MsgInformation),1,MSGINFOFile);
       TotalInBoard = MsgInformation.TotalOnBoard[BNum-1];
       if (TotalInBoard<=0)
       {
	  fclose(MSGINFOFile);
	  gotoxy(1,wherey()-1);
	  return(0);
       }
       strcpy(path,HPath);
       strcat(path,"msghdr.bbs");
       ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
       if (ShareFile==-1)
       {
	 fclose(MSGINFOFile);
	 AccessDenied(path);
	 return(0);
       }
       MSGHDRFile=fdopen(ShareFile,"r+b");
       fseek(MSGHDRFile,0L,SEEK_SET);
       strcpy(path,HPath);
       strcat(path,"msgidx.bbs");
       ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
       if (ShareFile==-1)
       {
	 fclose(MSGINFOFile);
	 fclose(MSGHDRFile);
	 AccessDenied(path);
	 return(0);
       }
       MSGIDXFile=fdopen(ShareFile,"r+b");
       LastReadRecord=0;
       if (UseLastread)
       {
	 sprintf(path,"%slastread.uux",HPath);
	 ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
	 if (ShareFile!=-1)
	 {

           lseek(ShareFile,sizeof(LastReadRecord)*(BNum-1),SEEK_SET);
	   read(ShareFile,&LastReadRecord,sizeof(LastReadRecord));
	   close(ShareFile);
	   SeekToLastRead=1;
	 }
         else
         {
           MSGBaseFile /* lastread */ = fopen(path, "w+b");
	   if (MSGBaseFile)
           {
             LastReadRecord = 0;
             for(j1=0;j1<200;j1++) fwrite(&LastReadRecord,sizeof(LastReadRecord),1,MSGBaseFile);
             fclose(MSGBaseFile);
           }
         }
       }
	   strcpy(path,HPath);
	   strcat(path,"msgtxt.bbs");
	   ShareFile = open(path, O_RDWR|O_BINARY|O_DENYWRITE);
	   if (ShareFile==-1)
	   {
	      fclose(MSGINFOFile);
	      fclose(MSGHDRFile);
	      fclose(MSGIDXFile);
	      AccessDenied(path);
	      return(0);
	    }
	   MSGBaseFile=fdopen(ShareFile,"r+b");
       if (VisibleOutput)
       {
         gotoxy(41,wherey());
         color(15,1);
         cprintf("                     ");
         PercentLetterStep = TotalInBoard/100.0;
         ProgressStep = TotalInBoard/42.0;
         Percent = Progress = 0;

	 // 뢮 ଠ樨  ⢥ ᥬ  
         color(7,0); gotoxy(72,wherey()); cprintf("%5d", TotalInBoard);
       }
       if (debug)
       {
         sprintf(LogString,"Total letters: %5d",TotalInBoard);
	 DebugLog(LogString);
         smart_debug=2;
       }
       PredMsg=MsgInformation.LowMsg; NewHighMsg=0; NewLowMsg=0;

       do
       {
	 fread(&MsgIndex,sizeof(MsgIndex),1,MSGIDXFile);
	 if (UseLastread && SeekToLastRead)
	 {
	  if (MsgIndex.Board==BNum && MsgIndex.MsgNum!=-1 && !feof(MSGIDXFile))
	  {
	   if (MsgIndex.MsgNum>LastReadRecord) SeekToLastRead=0;
	   else {CurrentLetter++;Progress++;Percent++;}
	  }
	 }
	 if (MsgIndex.Board==BNum && !feof(MSGIDXFile) && MsgIndex.MsgNum!=-1 && !SeekToLastRead)
	 {
           LastReadRecord=MsgIndex.MsgNum;
           ZeroMsgData(MsgData);

	   fgetpos(MSGIDXFile,&curpos);
	   fseek(MSGHDRFile,sizeof(MsgHeader)*((curpos/3)-1),SEEK_SET);
	   fread(&MsgHeader,sizeof(MsgHeader),1,MSGHDRFile);

	   strncpy(MsgData.From,&MsgHeader.WhoFrom[1],72);MsgData.From[MsgHeader.WhoFrom[0]]='\0';
	   strncpy(MsgData.To,&MsgHeader.WhoTo[1],35);MsgData.To[MsgHeader.WhoTo[0]]='\0';
	   strncpy(MsgData.Subj,&MsgHeader.Subject[1],35);MsgData.Subj[MsgHeader.Subject[0]]='\0';
	   mon[0]=MsgHeader.PostDate[1];  mon[1]=MsgHeader.PostDate[2]; mon[2]='\0';
	   MsgHeader.PostTime[6]='\0';
	   sprintf(MsgData.DateTime,"%c%c %s %2d%c%c  %s:00\0",
				    MsgHeader.PostDate[4], MsgHeader.PostDate[5],
				    Month[atoi(mon)-1], (MsgHeader.PostDate[7]<'8')?20:19,
				    MsgHeader.PostDate[7], MsgHeader.PostDate[8],
				    &MsgHeader.PostTime[1]);
	   CurrentLetter++;

	   StB=MsgHeader.StartBlock;
	   LetterLen1=(long)MsgHeader.NumBlocks << 8;
           if (debug)
           {
              sprintf(LogString,"Letter #%d,  size: %ld",CurrentLetter, LetterLen1);
              DebugLog(LogString);
           }
	   if (ScanMessage(LetterLen1,(long)StB*256,Outpath,MsgData,BName,1) || DeleteEchoNow)
	   {
	    if (DeleteMessages)
	    {
	      MsgHeader.MsgAttr=1;
	      fseek(MSGHDRFile,sizeof(MsgHeader)*((curpos/3)-1),SEEK_SET);
	      fwrite(&MsgHeader,sizeof(MsgHeader),1,MSGHDRFile);
	      MsgIndex.MsgNum=0xFFFF;
	      fseek(MSGIDXFile,(curpos-sizeof(MsgIndex)),SEEK_SET);
	      fwrite(&MsgIndex,sizeof(MsgIndex),1,MSGIDXFile);
	      fseek(MSGIDXFile,curpos,SEEK_SET);
	      MsgInformation.TotalMsgs--;
	      MsgInformation.TotalOnBoard[BNum-1]--;
	      if (MsgInformation.LowMsg==MsgHeader.MsgNum) NewLowMsg=1;
	      if (MsgInformation.HighMsg==MsgHeader.MsgNum) NewHighMsg=1;
	      fseek(MSGINFOFile,0L,SEEK_SET);
	      fwrite(&MsgInformation,sizeof(MsgInformation),1,MSGINFOFile);
	    }
	   }
           if (VisibleOutput)
           {
             Progress++;
             if (Progress>=ProgressStep) ProgressBar(Progress,ProgressStep,CurrentLetter,oLastProgress);
             Percent++;
             if (Percent>=PercentLetterStep) PercentBar(Percent,PercentLetterStep,CurrentLetter);
           }

#ifdef __WIN32__
		  PeekConsoleInput(
					 hStdin,      /* input buffer handle    */
					 irInBuf,     /* buffer to read into    */
					 128,         /* size of read buffer    */
					 &cNumRead);  /* number of records read */

		  if (cNumRead)
		  {
 		    ReadConsoleInput(hStdin,irInBuf,128,&cNumRead);

		    for (i = 0; i < cNumRead; i++)
			 if (irInBuf[i].EventType==KEY_EVENT)
          {
             //KeyProcessing(irInBuf[i].Event.KeyEvent);
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==27 ||
                 irInBuf[i].Event.KeyEvent.wVirtualKeyCode==67) BreakFlag=1;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==9) BreakFlag=2;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==32) BreakFlag=3;
          }
	  }
#else
	  if (kbhit())
	  {
	    BreakC=getch();
	    if (BreakC==27) BreakFlag=1;
	    if (BreakC==9)  BreakFlag=2;
	    if (BreakC==32) BreakFlag=3;
	  }
#endif
         }
	 if (MsgHeader.MsgNum>PredMsg && MsgHeader.MsgNum<MsgInformation.HighMsg) PredMsg=MsgHeader.MsgNum;
	 if (MsgHeader.MsgNum<lowmsg && MsgHeader.MsgNum>MsgInformation.LowMsg) lowmsg=MsgHeader.MsgNum;
       } while(!feof(MSGIDXFile) && !BreakFlag);
       if (NewHighMsg || NewLowMsg)
       {
	      if (NewHighMsg) MsgInformation.HighMsg=PredMsg;
	      if (NewLowMsg)  MsgInformation.LowMsg=lowmsg;
	      fseek(MSGINFOFile,0L,SEEK_SET);
	      fwrite(&MsgInformation,sizeof(MsgInformation),1,MSGINFOFile);
       }
       fclose(MSGBaseFile);
       fclose(MSGHDRFile);
       fclose(MSGIDXFile);
       fclose(MSGINFOFile);

//       if (UseLastread)
//       {
  	   sprintf(path,"%slastread.uux",HPath);
           MSGBaseFile /* lastread */ = fopen(path, "r+b");
	   if (MSGBaseFile)
           {
             fseek (MSGBaseFile, sizeof(LastReadRecord) * (BNum - 1), SEEK_SET);
             fwrite(&LastReadRecord,sizeof(LastReadRecord),1,MSGBaseFile);
             fclose(MSGBaseFile);
           }
//       }

       color(7,0); gotoxy(41,wherey());
       if (!BreakFlag)
       {
         if (VisibleOutput)
         {
           cprintf("                               ");
	   gotoxy(5,wherey());
	   color(LIGHTGREEN,0);
	   cprintf("");
         }
       }
       else
       {
	 color(15,0);
	 if (VisibleOutput) cprintf("            Skipped            ");
	 if (BreakFlag)
	 {
	   if (BreakFlag==3) BreakFlag=0;
	   sprintf(LogString,"Scanning of %s was skipped from %d of %d messages",BName,CurrentLetter,TotalInBoard);
	   AddLog(LogString);
           DebugLog(LogString);
	 }
       }
  smart_debug=0;
  return (0);
}


int JamProcessing(char *BName, char *JAMpath, char *OutUUEpath1)
{
  FILE *JAMHeader, /*JAMText,*/ *JAMIndex;
  JamHdrType JAMHdr;
  JamMsgHdrType JAMMsgHdr;
  JamIdxType JAMIdx;
  SHORTWORD JAMLastRead;
  char JAMFileName[60], JAMStr[250];
  long JAMPid,JAMStrLength,  JAMStrIn;
  int handle, CurrentMessage, MaxMessage, s, SeekToLastRead;
  long IDXSize;
  struct date dt;
  struct time tm;
  MsgDataBase MsgData = {"\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0"};
    double PercentLetterStep, ProgressStep, Percent, Progress;
    int    oLastProgress=41;
    char d1;

#ifdef __WIN32__
	 DWORD cNumRead, i;
	 INPUT_RECORD irInBuf[128];
#endif

  MakeMSGFile=NOMSG;

  CurrentMessage=1; SeekToLastRead=0;
  if (VisibleOutput)
  {
    textcolor(7);
    cprintf("\r\n      Searching in ");
    textcolor(GREEN);
    cprintf("%s",BName);clreol();
  }

  if (PauseTime) CheckFastEchoBusyFlag();

  strcpy(JAMFileName,JAMpath);  strcat(JAMFileName,".JDX");
  handle=open(JAMFileName, O_RDWR | O_BINARY  | O_DENYWRITE);
  if (handle==-1)
  {
    AccessDenied(JAMFileName);
    return(0);
  }

  IDXSize=filelength(handle);
  if (IDXSize==0)
  {
    close(handle);
    gotoxy(1,wherey()-1);
    return(0);
  }

  if (VisibleOutput)
  {
    gotoxy(41,wherey()); color(15,1); cprintf("                     ");
  }
  MaxMessage=IDXSize/8;

       PercentLetterStep = MaxMessage/100.0;
       ProgressStep = MaxMessage/42.0;
       Percent = Progress = 0;

	// 뢮 ଠ樨  ⢥ ᥬ  
       if (VisibleOutput)
       {
         color(7,0); gotoxy(72,wherey()); cprintf("%5d", MaxMessage);
       }


  JAMIndex=fdopen(handle,"r+b");

  strcpy(JAMFileName,JAMpath);  strcat(JAMFileName,".JHR");
  handle = open(JAMFileName, O_RDWR|O_BINARY|O_DENYWRITE);
  if (handle==-1)
  {
    fclose(JAMIndex);
    AccessDenied(JAMFileName);
    return(0);
  }
  JAMHeader=fdopen(handle,"r+b");
  JAMLastRead = 0;
  if (UseLastread)
  {
    strcpy(JAMFileName,JAMpath);  strcat(JAMFileName,".UJL");
    handle = open(JAMFileName, O_RDWR|O_BINARY|O_DENYWRITE);
    if (handle!=-1)
    {
      read(handle,&JAMLastRead,sizeof(JAMLastRead));
      close(handle);
      SeekToLastRead=1;
    }
    else
    {
       MSGBaseFile = fopen(JAMFileName,"w+b");
       fwrite(&JAMLastRead,sizeof(JAMLastRead),1,MSGBaseFile);
       fclose(MSGBaseFile);
    }
  }

  strcpy(JAMFileName,JAMpath);  strcat(JAMFileName,".JDT");
  handle = open(JAMFileName, O_RDWR|O_BINARY|O_DENYWRITE);
  if (handle==-1)
  {
    fclose(JAMIndex);
    fclose(JAMHeader);
    AccessDenied(JAMFileName);
    return(0);
  }
  MSGBaseFile=fdopen(handle,"rb");

       if (debug)
       {
         sprintf(LogString,"Total letters: %5d", MaxMessage);
	 DebugLog(LogString);
         smart_debug=2;
       }

  fread(&JAMHdr,sizeof(JAMHdr),1,JAMHeader);
  fread(&JAMIdx,sizeof(JAMIdx),1,JAMIndex);
  while (!feof(JAMIndex) && !BreakFlag)
  {
    if (UseLastread && SeekToLastRead)
    {
      if (JAMIdx.HdrLoc!=0xFFFFFFFF && JAMIdx.MsgToCrc!=0xFFFFFFFF)
      {
        fseek(JAMHeader,JAMIdx.HdrLoc,SEEK_SET);
        fread(&JAMMsgHdr,sizeof(JAMMsgHdr),1,JAMHeader);
	if (JAMMsgHdr.MsgNum>JAMLastRead) SeekToLastRead=0;
      }
    }
   if (JAMIdx.HdrLoc!=0xFFFFFFFF && JAMIdx.MsgToCrc!=0xFFFFFFFF && !SeekToLastRead)
   {
    JAMLastRead = JAMMsgHdr.MsgNum;
    JAMMsgHdr.TextLen=0;
    fseek(JAMHeader,JAMIdx.HdrLoc,SEEK_SET);
    fread(&JAMMsgHdr,sizeof(JAMMsgHdr),1,JAMHeader);
    if (stricmp(JAMMsgHdr.Signature,"JAM")!=0) {JAMIdx.HdrLoc=0xFFFFFFFF; continue;}
//    fread(&JAMSubBuffer,JAMMsgHdr.SubFieldLen,1,JAMHeader);
      ZeroMsgData(MsgData);
           s=0; JAMStrIn=0;
           if (debug)
           {
              sprintf(LogString,"Letter #%d,  size: %ld",CurrentMessage, (unsigned long)JAMMsgHdr.TextLen);
              DebugLog(LogString);
           }
       do
       {
	 fread(&JAMPid,sizeof(JAMPid),1,JAMHeader);
	 fread(&JAMStrLength,sizeof(JAMStrLength),1,JAMHeader);
	 if ((JAMStrLength+JAMStrIn+8)>(JAMMsgHdr.SubFieldLen)) JAMStrLength=JAMMsgHdr.SubFieldLen-JAMStrIn-8;
	 s=JAMStrLength;
	 do // ᫨   240 ᨬ
	 {
	   memset(JAMStr,0,sizeof(JAMStr));
	   if (s>240) {fread(JAMStr,240,1,JAMHeader);s-=240;}
	   else {fread(JAMStr,s,1,JAMHeader);s=0;}
	 } while (s>0 && !feof(JAMHeader));
	 JAMStrIn+=JAMStrLength+8;
	 if (JAMPid == 0)
	 {
	  s=0;
	  while (s<strlen(JAMStr) && JAMStr[s]!='@')
	  {
		 MsgData.AddrFrom[s]=JAMStr[s];
		 s++;
	  }
	  MsgData.AddrFrom[s]='\0';
	 }
	 else
	 if (JAMPid == 1)
	 {
	  s=0;
	  while (s<strlen(JAMStr) && JAMStr[s]!='@')
	  {
		 MsgData.AddrTo[s]=JAMStr[s];
		 s++;
	  }
	  MsgData.AddrTo[s]='\0';
	 }
	 else
	 if (JAMPid == 2) strcpy(MsgData.From    , JAMStr);
	 else
	 if (JAMPid == 3) strcpy(MsgData.To      , JAMStr);
	 else
	 if (JAMPid == 4)
	 {
	    FindWord(JAMStr,1);
	    s=0;
	    while (s<strlen(FindingWord) && FindingWord[s]!='@')
	    {
		 MsgData.AddrFrom[s]=FindingWord[s];
		 s++;
	    }
	    MsgData.AddrFrom[s]='\0';
	    FindWord(JAMStr,2);
		 strncpy(MsgData.MSGID, FindingWord,8);
	    MsgData.MSGID[8]='\0';
            if (debug)
            {
               smart_debug = 0;
               sprintf(LogString, "MSGID: %s", MsgData.MSGID);
               DebugLog(LogString);
               smart_debug = 1;
            }
	 }
	 else
	 if (JAMPid == 5)
	 {
	    FindWord(JAMStr,1);
	    s=0;
	    while (s<strlen(FindingWord) && FindingWord[s]!='@')
	    {
		 MsgData.AddrTo[s]=FindingWord[s];
		 s++;
	    }
	    MsgData.AddrTo[s]='\0';
	 }
	 else
	 if (JAMPid == 6) strcpy(MsgData.Subj    , JAMStr);
       } while (JAMStrIn<JAMMsgHdr.SubFieldLen && !feof(JAMHeader));
    UnixToDT(JAMMsgHdr.DateWritten,dt,tm);
    sprintf(MsgData.DateTime,"%02d %s %4d  %02d:%02d:%02d\0",dt.da_day,Month[dt.da_mon-1],dt.da_year,
							tm.ti_hour, tm.ti_min, tm.ti_sec);
    if (ScanMessage((unsigned long)JAMMsgHdr.TextLen,JAMMsgHdr.TextOfs,OutUUEpath1,MsgData,BName) || DeleteEchoNow)
    {
     if (DeleteMessages)
     {
       JAMHdr.ActiveMsgs--;
       JAMHdr.ModCounter++;
       JAMMsgHdr.Attr1=0x81000000;
       fseek(JAMHeader,0L,SEEK_SET);
       fwrite(&JAMHdr,sizeof(JAMHdr),1,JAMHeader);
       fseek(JAMHeader,JAMIdx.HdrLoc,SEEK_SET);
       fwrite(&JAMMsgHdr,sizeof(JAMMsgHdr),1,JAMHeader);
       JAMIdx.MsgToCrc=(long)0xFFFFFFFF;
       JAMIdx.HdrLoc=(long)0xFFFFFFFF;
       fseek(JAMIndex,(CurrentMessage-1)*sizeof(JAMIdx),SEEK_SET);
       fwrite(&JAMIdx,sizeof(JAMIdx),1,JAMIndex);
       fseek(JAMIndex,(CurrentMessage)*sizeof(JAMIdx),SEEK_SET);
     }
    }
   }
   if (VisibleOutput)
   {
           Progress++;
           if (Progress>=ProgressStep) ProgressBar(Progress,ProgressStep,CurrentMessage,oLastProgress);

           Percent++;
           if (Percent>=PercentLetterStep) PercentBar(Percent,PercentLetterStep,CurrentMessage);
   }
           CurrentMessage++;
   fread(&JAMIdx,sizeof(JAMIdx),1,JAMIndex);
#ifdef __WIN32__
		  PeekConsoleInput(
					 hStdin,      /* input buffer handle    */
					 irInBuf,     /* buffer to read into    */
					 128,         /* size of read buffer    */
					 &cNumRead);  /* number of records read */

		  if (cNumRead)
		  {
 		    ReadConsoleInput(hStdin,irInBuf,128,&cNumRead);

		    for (i = 0; i < cNumRead; i++)
			 if (irInBuf[i].EventType==KEY_EVENT)
          {
             //KeyProcessing(irInBuf[i].Event.KeyEvent);
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==27 ||
                 irInBuf[i].Event.KeyEvent.wVirtualKeyCode==67) BreakFlag=1;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==9) BreakFlag=2;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==32) BreakFlag=3;
          }
		  }
#else
   if (kbhit())
   {
     BreakC=getch();
     if (BreakC==27) BreakFlag=1;
     if (BreakC==9)  BreakFlag=2;
     if (BreakC==32) BreakFlag=3;
   }
#endif
  }
    fclose(MSGBaseFile);
    fclose(JAMHeader);
    fclose(JAMIndex);

    strcpy(JAMFileName,JAMpath);  strcat(JAMFileName,".UJL");
    MSGBaseFile = fopen(JAMFileName,"w+b");
    fwrite(&JAMLastRead,sizeof(JAMLastRead),1,MSGBaseFile);
    fclose(MSGBaseFile);

	 color(7,0); gotoxy(41,wherey());
	 if (!BreakFlag)
	 {
		if (VisibleOutput)
		{
		cprintf("                               ");
		gotoxy(5,wherey()); color(LIGHTGREEN,0); cprintf("");
                }
	 }
	 else
	 {
	 color(15,0);
	 if (VisibleOutput) cprintf("            Skipped            ");
	 if (BreakFlag)
	 {
		if (BreakFlag==3) BreakFlag=0;
		sprintf(LogString,"Scanning of %s was skipped from %d of %d messages",BName,CurrentMessage-1,MaxMessage);
		AddLog(LogString);
	 }
    }
  smart_debug = 0;
  return (0);
}

void FidoMsgProcessing(char *BName, char *FidoMsgpath, char *OutUUEpath1)
{
   int FidoMsgFile;
   FidoMsg FidoMsgHeader;
   char FMPath[80];
   int CurrentMessage=0, End_of_files, LastRead;
   int LastReadNumber;
   struct ffblk FidoMsgF;
   long readbt;
   MsgDataBase MsgData = {"\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0"};
#ifdef __WIN32__
	 DWORD cNumRead,i;
	 INPUT_RECORD irInBuf[128];
#endif
   char d1;
   MakeMSGFile=NOMSG;
   if (VisibleOutput)
   {
     textcolor(7);  cprintf("\r\n      Searching in ");
     textcolor(GREEN);  cprintf("%s",BName);clreol();
   }
   if (UseLastread)
   {
     LastReadNumber = 0;
     sprintf(FMPath,"%slastread.uux",FidoMsgpath);
     LastRead=open(FMPath,O_RDONLY|O_BINARY|O_DENYWRITE);
     if (LastRead!=-1)
     {
       read(LastRead,&LastReadNumber,sizeof(LastReadNumber));
       close(LastRead);
     }
     else
     {
       MSGBaseFile = fopen(FMPath,"w+b");
       fwrite(&LastReadNumber,sizeof(LastReadNumber),1,MSGBaseFile);
       fclose(MSGBaseFile);
     }
   }
   strcpy(FMPath,FidoMsgpath);
   strcat(FMPath,"*.msg");
   End_of_files = findfirst(FMPath,&FidoMsgF,0);
   textcolor(15); gotoxy(47,wherey()); if (VisibleOutput) cprintf("Processed...");
   while (!End_of_files && !BreakFlag)
   {
     sprintf(FMPath,"%s%s",FidoMsgpath,FidoMsgF.ff_name);
     if (UseLastread) sscanf(FidoMsgF.ff_name,"%d.msg",&LastRead);
     if (!UseLastread || (LastRead>LastReadNumber))
     {
       FidoMsgFile = open(FMPath,O_RDONLY|O_BINARY|O_DENYWRITE);
       if (FidoMsgFile == -1)
       {
       	 sprintf(LogString,"! %s Access Denied",FMPath);
	 AddLog(LogString);
       }
       else
       if (FidoMsgFile)
     {
       read(FidoMsgFile,&FidoMsgHeader,sizeof(FidoMsgHeader));
       readbt=filelength(FidoMsgFile)-sizeof(FidoMsgHeader);
	   MSGBaseFile = fdopen(FidoMsgFile,"rb");
           ZeroMsgData(MsgData);
           strncpy(MsgData.From, FidoMsgHeader.FromUserName,35); MsgData.From[35]='\0';
           strncpy(MsgData.To  , FidoMsgHeader.ToUserName,35);   MsgData.To[35]='\0';
           strncpy(MsgData.Subj, FidoMsgHeader.Subject,71);      MsgData.Subj[71]='\0';
           strncpy(MsgData.DateTime, FidoMsgHeader.DateTime,22); MsgData.DateTime[22]='\0';

           if (debug)
           {
              sprintf(LogString,"Letter #%d,  size: %ld", CurrentMessage+1, readbt);
              DebugLog(LogString);
           }

       if ((ScanMessage(readbt,sizeof(FidoMsgHeader),OutUUEpath1,MsgData,BName) || DeleteEchoNow) &&
		       DeleteMessages && (KillTransit || (FidoMsgHeader.Attribute & 0x0020)!=0x0020))
		       {
			 fclose(MSGBaseFile);
			 if (remove(FMPath)==-1)
			 {
			    sprintf(LogString,"%s Remove Access Denied",FMPath);
			    AddLog(LogString);
			 }
		       }
		       else fclose(MSGBaseFile);
       CurrentMessage++;
       gotoxy(72,wherey()); if (VisibleOutput) cprintf("%5d",CurrentMessage);
     }
     }
	  End_of_files = findnext(&FidoMsgF);
#ifdef __WIN32__
		  PeekConsoleInput(
					 hStdin,      /* input buffer handle    */
					 irInBuf,     /* buffer to read into    */
					 128,         /* size of read buffer    */
					 &cNumRead);  /* number of records read */

		  if (cNumRead)
		  {
 		    ReadConsoleInput(hStdin,irInBuf,128,&cNumRead);

		    for (i = 0; i < cNumRead; i++)
			 if (irInBuf[i].EventType==KEY_EVENT)
          {
             //KeyProcessing(irInBuf[i].Event.KeyEvent);
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==27 ||
                 irInBuf[i].Event.KeyEvent.wVirtualKeyCode==67) BreakFlag=1;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==9) BreakFlag=2;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==32) BreakFlag=3;
          }
		  }
#else
     if (kbhit())
     {
       BreakC=getch();
       if (BreakC==27) BreakFlag=1;
       if (BreakC==9)  BreakFlag=2;
       if (BreakC==32) BreakFlag=3;
     }
#endif

   }
   if (CurrentMessage==0) gotoxy(1,wherey()-1);
   else
   {
    textcolor(7); gotoxy(72,wherey()); if (VisibleOutput)cprintf("%5d",CurrentMessage);
    color(7,0); gotoxy(41,wherey());
    if (!BreakFlag)
    {
      if (VisibleOutput){
      cprintf("                               ");
      gotoxy(5,wherey()); color(LIGHTGREEN,0); cprintf("");}
    }
    else
    {
	 color(15,0);
	 if (VisibleOutput) cprintf("            Skipped            ");
	 if (BreakFlag)
	 {
	   if (BreakFlag==3) BreakFlag=0;
		sprintf(LogString,"Scanning of %s was skipped from %d message",BName,CurrentMessage);
	   AddLog(LogString);
	 }
    }
   }
  smart_debug = 0;
}

int SquishProcessing(char *BName, char *Squishpath, char *OutUUEpath1)
{
   FILE /*SQUISHdFile,*/ *SQUISHiFile, *newSQUISHiFile;
   char SquishFileName[60];
   SqBaseType SquishBase;
   SqFrameHdrType SquishHdr, NearHdr;
   SqMsgHdrType SquishMsgHdr;
   SqIdxType SquishIndex;
   int CurrentMessage=1, MaxMessage, Changed=0, handle, SeekToLastRead=0, LastRead;
   long SeekPos;
   MsgDataBase MsgData = {"\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0"};
   double PercentLetterStep, ProgressStep, Percent, Progress;
   int    oLastProgress=41;
   char d1;

   MakeMSGFile=NOMSG;
   if (VisibleOutput)
   {
     textcolor(7);  cprintf("\r\n      Searching in ");
     textcolor(GREEN);  cprintf("%s",BName);clreol();
   }
   if (PauseTime) CheckFastEchoBusyFlag();

   strcpy(SquishFileName, Squishpath); strcat(SquishFileName,".SQI");
   handle=open(SquishFileName, O_RDWR | O_BINARY  | O_DENYWRITE);
   if (handle==-1)
   {
     fclose(MSGBaseFile);
     AccessDenied(SquishFileName);
     return(0);
   }
   SQUISHiFile=fdopen(handle,"r+b");

   LastRead = 0;
   if (UseLastread)
   {
     strcpy(SquishFileName, Squishpath); strcat(SquishFileName,".USL");
     handle=open(SquishFileName, O_RDWR | O_BINARY | O_DENYWRITE);
     if (handle!=-1)
     {
       read(handle,&LastRead,sizeof(LastRead));
       close(handle);
       SeekToLastRead=1;
     }
     else
     {
       MSGBaseFile = fopen(SquishFileName,"w+b");
       fwrite(&LastRead,sizeof(LastRead),1,MSGBaseFile);
       fclose(MSGBaseFile);
     }
   }


   strcpy(SquishFileName, Squishpath); strcat(SquishFileName,".SQD");
   handle=open(SquishFileName, O_RDWR | O_BINARY  | O_DENYWRITE);
   if (handle==-1)
   {
     fclose(SQUISHiFile);
     AccessDenied(SquishFileName);
     return(0);
   }

   MSGBaseFile=fdopen(handle,"r+b");
   fread(&SquishBase,sizeof(SquishBase),1,MSGBaseFile);

   if (SquishBase.NumMsg==0)
   {
      gotoxy(1,wherey()-1);
      fclose(SQUISHiFile);
      fclose(MSGBaseFile);
      return(0);
   }
   MaxMessage=SquishBase.NumMsg;

   if (VisibleOutput)
   {
     gotoxy(41,wherey());
     color(15,1);
     cprintf("                     ");
   }
       PercentLetterStep = MaxMessage/100.0;
       ProgressStep = MaxMessage/42.0;
       Percent = Progress = 0;

   if (VisibleOutput)
   {
	// 뢮 ଠ樨  ⢥ ᥬ  
       color(7,0); gotoxy(72,wherey()); cprintf("%5d", MaxMessage);
   }
       if (debug)
       {
         sprintf(LogString,"Total letters: %5d", MaxMessage);
	 DebugLog(LogString);
         smart_debug=2;
       }
   strcpy(SquishFileName, Squishpath); strcat(SquishFileName,".$$i");
   newSQUISHiFile=fopen(SquishFileName,"w+b");
   fread(&SquishIndex, sizeof(SquishIndex), 1, SQUISHiFile);
   while (!feof(SQUISHiFile))
   {
     fseek(MSGBaseFile,SquishIndex.Ofs,SEEK_SET);
     fread(&SquishHdr,sizeof(SquishHdr),1,MSGBaseFile);
     if (UseLastread && SeekToLastRead)
     {
      if (SquishHdr.FrameType==SqFrameMsg)
      {
       if (LastRead<SquishIndex.UMsgId) SeekToLastRead=0;
       else CurrentMessage++;
      }
     }
     if (!SeekToLastRead)
     {
     LastRead = CurrentMessage;
     fread(&SquishMsgHdr,sizeof(SquishMsgHdr),1,MSGBaseFile);
     ZeroMsgData(MsgData);
     strcpy(MsgData.From, SquishMsgHdr.MsgFrom); MsgData.From[35]='\0';
     strcpy(MsgData.To  , SquishMsgHdr.MsgTo);   MsgData.To[35]='\0';
     strcpy(MsgData.Subj, SquishMsgHdr.Subj); MsgData.Subj[71]='\0';
     strcpy(MsgData.DateTime, SquishMsgHdr.AzDate); MsgData.DateTime[22]='\0';
     if (SquishHdr.FrameType==SqFrameMsg)
     {
       LastRead = SquishIndex.UMsgId;
       if (debug)
       {
         sprintf(LogString,"Letter #%d,  size: %ld", CurrentMessage, (long)SquishHdr.MsgLength-(long)sizeof(SquishMsgHdr));
         DebugLog(LogString);
       }
       if ((ScanMessage((long)SquishHdr.MsgLength-(long)sizeof(SquishMsgHdr),SquishIndex.Ofs+sizeof(SquishHdr)+sizeof(SquishMsgHdr),OutUUEpath1,MsgData,BName) || DeleteEchoNow) &&
	   DeleteMessages)
       {
	SquishBase.NumMsg--;
	SquishBase.HighMsg--;
	Changed=1;

	if(SquishHdr.PrevFrame != 0)
	{
	fseek(MSGBaseFile, SquishHdr.PrevFrame, SEEK_SET);
	fread(&NearHdr, sizeof(NearHdr), 1, MSGBaseFile);
	NearHdr.NextFrame = SquishHdr.NextFrame;
	fseek(MSGBaseFile, SquishHdr.PrevFrame, SEEK_SET);
	fwrite(&NearHdr, sizeof(NearHdr), 1, MSGBaseFile);
	}

	if (SquishHdr.NextFrame != 0)
	{
	fseek(MSGBaseFile, SquishHdr.NextFrame, SEEK_SET);
	fread(&NearHdr, sizeof(NearHdr), 1, MSGBaseFile);
	NearHdr.PrevFrame = SquishHdr.PrevFrame;
	fseek(MSGBaseFile, SquishHdr.NextFrame, SEEK_SET);
	fwrite(&NearHdr, sizeof(NearHdr), 1, MSGBaseFile);
	}
	SquishHdr.FrameType = SqFrameFree;
	SquishHdr.PrevFrame = SquishBase.LastFree;
	SquishHdr.NextFrame = 0x00000000;
	SquishBase.LastFree = SquishIndex.Ofs;
	if (SquishBase.FirstFree == 0x00000000 && SquishBase.LastFree == 0)
	    SquishBase.FirstFree = SquishIndex.Ofs;
	else
	{
	    fseek(MSGBaseFile, SquishHdr.PrevFrame, SEEK_SET);
	    fread(&NearHdr, sizeof(NearHdr), 1, MSGBaseFile);
	    NearHdr.NextFrame = SquishIndex.Ofs;
	    fseek(MSGBaseFile, SquishHdr.PrevFrame, SEEK_SET);
	    fwrite(&NearHdr, sizeof(NearHdr), 1, MSGBaseFile);
	}
	fseek(MSGBaseFile,SquishIndex.Ofs,SEEK_SET);
	fwrite(&SquishHdr,sizeof(SquishHdr),1,MSGBaseFile);
       }
       else fwrite(&SquishIndex, sizeof(SquishIndex), 1, newSQUISHiFile);

        if (VisibleOutput)
        {
           Progress++;
           if (Progress>=ProgressStep) ProgressBar(Progress,ProgressStep,CurrentMessage,oLastProgress);
           Percent++;
           if (Percent>=PercentLetterStep) PercentBar(Percent,PercentLetterStep,CurrentMessage);
        }
        CurrentMessage++;
     }
     }
     fread(&SquishIndex, sizeof(SquishIndex), 1, SQUISHiFile);
   }
   fclose(SQUISHiFile);
   fclose(newSQUISHiFile);
   if (Changed)
   {
     strcpy(SquishFileName, Squishpath); strcat(SquishFileName,".sqi");
     strcpy(LogString, Squishpath); strcat(LogString,".$$i");
     remove(SquishFileName);
     rename(LogString,SquishFileName);
     fseek(MSGBaseFile,0L,SEEK_SET);
     fwrite(&SquishBase,sizeof(SquishBase),1,MSGBaseFile);
   } else
   {
     strcpy(LogString, Squishpath); strcat(LogString,".$$i");
     remove(LogString);
   }
   fclose(MSGBaseFile);

//   if (UseLastread)
//   {
       strcpy(SquishFileName, Squishpath); strcat(SquishFileName,".USL");
       MSGBaseFile = fopen(SquishFileName,"w+b");
       fwrite(&LastRead,sizeof(LastRead),1,MSGBaseFile);
       fclose(MSGBaseFile);
//   }

   if (VisibleOutput)
   {
     color(7,0); gotoxy(41,wherey()); cprintf("                               ");
     gotoxy(5,wherey()); color(LIGHTGREEN,0); cprintf("");
   }
   smart_debug = 0;
   return (0);
}

void FileProcessing(char *FileDefined, char *OutUUEpath1, char *A1, char *S1, char *FakeArea, int Hud=0)
{
   long CurrentPosition, LF, endoffile;
   int FileD, d;
   char BName[60], PathtoFile[60];
   struct date dt;
   struct time tm;
   struct ffblk UserFile;
#ifdef __WIN32__
	 DWORD cNumRead, i;
	 INPUT_RECORD irInBuf[128];
#endif

   MsgDataBase MsgData = {"\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0"};
   MakeMSGFile=0;
   strcpy(PathtoFile,FileDefined);
   d=strlen(PathtoFile)-1;
   while(PathtoFile[d]!='\\' && d>=0) {PathtoFile[d]='\0';d--;}
   endoffile = findfirst(FileDefined,&UserFile,0);
  while (!endoffile && !BreakFlag)
  {
   textcolor(7);  cprintf("\r\n      Searching in ");
   textcolor(GREEN);  cprintf("%s",UserFile.ff_name);clreol();
   strcpy(FileDefined,PathtoFile);
   strcat(FileDefined,UserFile.ff_name);
   FileD = open(FileDefined, O_RDONLY|O_TEXT|O_DENYWRITE);
   if (FileD==-1)
   {
      AccessDenied(FileDefined);
   }
   else
   {
   LF = filelength(FileD);
   if (LF==0)
   {
     gotoxy(1,wherey()-1);
     close(FileD);
     return;
   }
   textcolor(15); gotoxy(47,wherey()); cprintf("Processing...");
   color(7,0); gotoxy(63,wherey()); cprintf("%10ld bytes",LF);
   MSGBaseFile=fdopen(FileD,"rt");
	   strcpy(MsgData.FullFileName,"\0");   sprintf(MsgData.From,"%s\0",S1);
	   sprintf(MsgData.To,"%s\0",S1);       sprintf(MsgData.Subj,"UUE from %s\0",FileDefined);
	   sprintf(MsgData.AddrFrom,"%s\0",A1); strcpy(MsgData.AddrTo,"\0");
	   strcpy(MsgData.DateTime,"\0");       strcpy(MsgData.UUECoder,"\0");
	   strcpy(MsgData.MSGID,"\0");
   getdate(&dt);
   gettime(&tm);
   sprintf(MsgData.DateTime,"%02d %s %02d  %02d:%02d:%02d\0",dt.da_day,Month[dt.da_mon-1],dt.da_year,
							tm.ti_hour, tm.ti_min, tm.ti_sec);
   strcpy(BName,FakeArea);
   ScanMessage(LF,0L,OutUUEpath1,MsgData,BName,Hud,0);
   fclose(MSGBaseFile);
   color(7,0); gotoxy(41,wherey()); cprintf("                                      ");
   gotoxy(5,wherey()); color(LIGHTGREEN,0); cprintf("");
   }
   endoffile = findnext(&UserFile);
#ifdef __WIN32__
		  PeekConsoleInput(
					 hStdin,      /* input buffer handle    */
					 irInBuf,     /* buffer to read into    */
					 128,         /* size of read buffer    */
					 &cNumRead);  /* number of records read */

		  if (cNumRead)
		  {
 		    ReadConsoleInput(hStdin,irInBuf,128,&cNumRead);

		    for (i = 0; i < cNumRead; i++)
			 if (irInBuf[i].EventType==KEY_EVENT)
          {
             //KeyProcessing(irInBuf[i].Event.KeyEvent);
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==27 ||
                 irInBuf[i].Event.KeyEvent.wVirtualKeyCode==67) BreakFlag=1;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==9) BreakFlag=2;
          }
		  }
#else
   if (kbhit())
   {
     BreakC=getch();
     if (BreakC==27) BreakFlag=1;
     if (BreakC==9)  BreakFlag=2;
   }
#endif
  }
}


void PktProcessing(char *PKTPath, char *OutUUEpath1)
{
  FILE *NewPKT;
  PKTHDR PktHdr;
  PKTMSG PktMsg;
  SPKT SPkt;
  int handle, PKTSearch, PKTPid, y, x, Ability, Changes, DelChanges, NULLBytes;
  char PKTFileName[60], c, Echo[60], NewPKTName[60];
  ffblk pkts;
  long PKTSize, MSGSize=0, TempSize;
  fpos_t CurrentPosition, LastPosition, LP=0;
  MsgDataBase MsgData = {"\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0", "\0"};
  double PercentLetterStep, ProgressStep, Percent, Progress;
  int    oLastProgress=41;
  char d1;
#ifdef __WIN32__
	 DWORD cNumRead, i;
	 INPUT_RECORD irInBuf[128];
#endif

  MakeMSGFile=NOMSG;
  LastSlesh(PKTPath,1);
  strcpy(PKTFileName,PKTPath);
  strcat(PKTFileName,"*.pkt");

  PKTSearch = findfirst(PKTFileName,&pkts,0);

  while (!PKTSearch)
  {
   if (VisibleOutput)
   {
    textcolor(7);
    cprintf("\r\n      Searching in ");
    textcolor(GREEN);
    cprintf("%s",pkts.ff_name);clreol();
    gotoxy(41,wherey()); color(15,1); cprintf("                     ");
   }
    strcpy(PKTFileName,PKTPath); strcat(PKTFileName,pkts.ff_name);
    handle=open(PKTFileName, O_RDONLY | O_BINARY | O_DENYWRITE);
    if (handle==-1) AccessDenied(PKTFileName);
    else
    {

    PKTSize=filelength(handle);
    MSGBaseFile = fdopen(handle,"rb");

    PercentLetterStep = PKTSize/100.0;
    ProgressStep = PKTSize/42.0;
    Percent = Progress = LP = 0;
    if (VisibleOutput)
    {
      color(7,0); gotoxy(72,wherey());
      if (PKTSize>99999) {TempSize=PKTSize/1000;  cprintf("%5ldK",TempSize);}
      else cprintf("%5d", PKTSize);
    }
    if (debug)
    {
       sprintf(LogString,"Scanning %s (%ld bytes)", PKTFileName, PKTSize);
       DebugLog(LogString);
       smart_debug = 2;
    }
    if (PKTSize)
    {
       if (PKTDelete)
       {
	  strcpy(NewPKTName,PKTPath); strcat(NewPKTName,"~uux_pkt.$$$");
	  NewPKT = fopen(NewPKTName,"w+b");
       }
       Changes=0;DelChanges=0;
       strcpy(MsgData.FullFileName,"\0");   strcpy(MsgData.From,"\0");
       strcpy(MsgData.To,"\0");             strcpy(MsgData.Subj,"\0");
       strcpy(MsgData.AddrFrom,"\0");       strcpy(MsgData.AddrTo,"\0");
       strcpy(MsgData.DateTime,"\0");       strcpy(MsgData.UUECoder,"\0");
       strcpy(MsgData.MSGID,"\0");

       fread(&PktHdr,sizeof(PktHdr),1,MSGBaseFile);
       fread(&PktMsg,sizeof(PktMsg),1,MSGBaseFile);
       if (PKTDelete) fwrite(&PktHdr,sizeof(PktHdr),1,NewPKT);
       while (!feof(MSGBaseFile) && !(BreakFlag && !PKTDelete))
       {
	 fread(MsgData.DateTime,20,1,MSGBaseFile);MsgData.DateTime[20]='\0';
	 PKTPid = 0; x=0;
	 do
	 {
	   do
	   {
	     fread(&c,1,1,MSGBaseFile);
	     if (PKTPid==0 && x<35) MsgData.To[x]=c;
	     if (PKTPid==1 && x<35) MsgData.From[x]=c;
		  if (PKTPid==2 && x<72) MsgData.Subj[x]=c;
	     x++;
	   }
	   while (c);
	   PKTPid++; x=0;
	 } while (PKTPid<3);
	 MsgData.To[35]='\0'; MsgData.From[35]='\0'; MsgData.Subj[72]='\0';
	 fgetpos(MSGBaseFile, &CurrentPosition);
	 Ability=1; MSGSize=0;
	 do
	 {
	   for(y=0;y<16640;y++) Letter[y]=0x7F;
	   fread(Letter,16640,1,MSGBaseFile);
	   if (MSGSize<16640) while (Letter[x]>32 && x<55 && Letter[x]) Echo[x]=Letter[x++];
	   Letter[16640]='\0';
	   MSGSize+=strlen(Letter);
	 } while (strlen(Letter)==16640 && !feof(MSGBaseFile));
	 while (Letter[MSGSize]==0) MSGSize++;
	 Echo[x]='\0';Echo[4]='\0';
	 Ability=0;
	 if (stricmp(Echo,"AREA")==0)
	   for(Ability=5;Ability<x;Ability++) Echo[Ability-5]=Echo[Ability];
	 Echo[Ability-5]='\0';
	 if (!Echo[0]) strcpy(Echo,"NETMAIL");
         if (debug)
         {
           sprintf(LogString,"Current Position: %ld, Letter size: %ld", CurrentPosition, MSGSize);
           DebugLog(LogString);
         }
	 if (!(ScanMessage(MSGSize,CurrentPosition,OutUUEpath1,MsgData,Echo) &&
	     PKTDelete))
	 {
	  if(PKTDelete)
	  {
	    fwrite(&PktMsg,sizeof(PktMsg),1,NewPKT);
	    fwrite(MsgData.DateTime,20,1,NewPKT);
	    fwrite(MsgData.To,strlen(MsgData.To)+1,1,NewPKT);
	    fwrite(MsgData.From,strlen(MsgData.From)+1,1,NewPKT);
	    fwrite(MsgData.Subj,strlen(MsgData.Subj)+1,1,NewPKT);
	    fsetpos(MSGBaseFile,&CurrentPosition);
	    TempSize=MSGSize;
	    do
	    {
	       for(y=0;y<16640;y++) Letter[y]=0x7F;
	       if (TempSize>16640) y=16640; else y=TempSize;
	       fread(Letter,y,1,MSGBaseFile);
	       fwrite(Letter,y,1,NewPKT);
	       TempSize-=y;
	    } while (TempSize);
	    Changes=1;
	  }
	 }
	 else DelChanges=1;
	 LastPosition=CurrentPosition+MSGSize;
	 if (VisibleOutput)
   	 {
           Progress=Progress+LastPosition-LP;
           if (Progress>=ProgressStep) ProgressBar(Progress,ProgressStep,LastPosition,oLastProgress);
           Percent=Percent+LastPosition-LP;
           if (Percent>=PercentLetterStep) PercentBar(Percent,PercentLetterStep,LastPosition);
         }
         LP = LastPosition;
	 fsetpos(MSGBaseFile, &LastPosition);
	 fread(&PktMsg,sizeof(PktMsg),1,MSGBaseFile);
#ifdef __WIN32__
		  PeekConsoleInput(
					 hStdin,      /* input buffer handle    */
					 irInBuf,     /* buffer to read into    */
					 128,         /* size of read buffer    */
					 &cNumRead);  /* number of records read */

	  if (cNumRead && !PKTDelete)
	  {
 	    ReadConsoleInput(hStdin,irInBuf,128,&cNumRead);

	    for (i = 0; i < cNumRead; i++)
	    if (irInBuf[i].EventType==KEY_EVENT)
          {
             //KeyProcessing(irInBuf[i].Event.KeyEvent);
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==27 ||
                 irInBuf[i].Event.KeyEvent.wVirtualKeyCode==67) BreakFlag=1;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==9) BreakFlag=2;
             if (irInBuf[i].Event.KeyEvent.wVirtualKeyCode==32) BreakFlag=3;
          }
	  }
#else
	 if (kbhit() && !PKTDelete)
	 {
	   BreakC=getch();
	   if (BreakC==27) BreakFlag=1;
	   if (BreakC==9)  BreakFlag=2;
	   if (BreakC==32) BreakFlag=3;
	 }
#endif

       }
       fclose(MSGBaseFile);
       if (PKTDelete)fclose(NewPKT);
       if (Changes && DelChanges && PKTDelete)
       {
	 remove(PKTFileName);
	 rename(NewPKTName,PKTFileName);
       }
       else
       if (!Changes && DelChanges && PKTDelete)
       {
	 remove(PKTFileName);
	 remove(NewPKTName);
       }
       else
       if (PKTDelete) remove (NewPKTName);
       color(7,0); gotoxy(41,wherey());
       if (!BreakFlag)
       {
 	 if (VisibleOutput)
         {
	   cprintf("                               ");
	   gotoxy(5,wherey()); color(LIGHTGREEN,0); cprintf("");
         }
       }
       else
       {
	 color(15,0);
	 if (VisibleOutput) cprintf("            Skipped            ");
	 if (BreakFlag==3) BreakFlag=0;
       }
    }
    else
    {
      gotoxy(1,wherey()-1);
      fclose(MSGBaseFile);
    }
    }
    PKTSearch=findnext(&pkts);
  }
  smart_debug = 0;
}
