{**********************************************}
{*                                            *}
{*     TimeZone processing utilities v1.00    *}
{*                                            *}
{*  This is the part of the "Utilities pack"  *}
{*                                            *}
{*           Copyright (c) 1999 by            *}
{*  Alexander S. Tokareff, 2:5077/27@fidonet  *}
{*                                            *}
{**********************************************}
{$Q-}
{$IFDEF VIRTUALPASCAL}
{$Delphi+,J+}
{$ENDIF VIRTUALPASCAL}
Unit TZUtils;
Interface
Const
 TZIdentifier : string[3] = 'EST';
 TZHours      : integer = 5;
 TZMinutes    : integer = 0;
 TZSeconds    : integer = 0;
 TZDST        : string[3] = 'EDT';
 TZsm         : integer = 4;
 TZsw         : integer = 1;
 TZsd         : integer = 0;
 TZst         : longint = 3600;
 TZem         : integer = 10;
 TZew         : integer = -1;
 TZed         : integer = 0;
 TZet         : longint = 7200;
 TZshift      : integer = 3600;

 function ParseTZ( tz : string ) : boolean;

 function TZOffset( time : longint ) : longint; { seconds }
 function TZOffsetMin( time : longint ) : integer; { minutes }
 function TZOffsetHour( time : longint ) : integer; { hours }

 function TZOffsetNow : longint; { seconds, now }
 function TZOffsetMinNow : integer; { minutes, now }
 function TZOffsetHourNow : integer; { hours, now }

 function UTCTimeNow : longint; { current unix time in UTC }

Implementation
Uses
{$IFNDEF MSDOS}
 DateUtils,
{$ELSE}
 DateUtil,
{$ENDIF MSDOS} StrUtils;

 function ParseTZ( tz : string ) : boolean;
 var
  _tz, s1 : string;
  i : integer;
  iden, dst : string[3];
  h, m, s, sm, sw, sd, st, em, ew, ed, et, shift : longint;
 begin
  iden := ''; dst := '';
  h := 0; m := 0; s := 0; sm := 0; sw := 0; sd := 0; st := 0;
  em := 0; ew := 0; ed := 0; et := 0; shift := 0;
  ParseTZ := false;

  if ( tz = '' ) then exit;

  _tz := Upper( tz );

  if ( length( _tz ) = 3 ) then
  begin
   TZIdentifier := _tz;
   TZDST := '';
   TZHours := 0;
   TZMinutes := 0;
   TZSeconds := 0;
   TZsm := 0;
   TZsw := 0;
   TZsd := 0;
   TZst := 0;
   TZem := 0;
   TZew := 0;
   TZed := 0;
   TZet := 0;
   TZshift := 0;
   ParseTZ := true;
   exit;
  end;

  iden := copy( _tz, 1, 3 );
  delete( _tz, 1, 3 );
  i := 2;

  if ( _tz[1] = '+' ) then h := 1
  else if ( _tz[1] = '-' ) then h := -1
  else i := 1;
  s1 := '';

  while ( _tz[i] in ['0'..'9'] ) do
  begin
   s1 := s1 + _tz[i];
   inc( i );
  end;

  h := h * Str2Int( s1 );
  delete( _tz, 1, i - 1 );

  if ( _tz[1] = ':' ) then { hours }
  begin
   delete( _tz, 1, 1 );
   s1 := ''; i := 1;

   while ( _tz[i] in ['0'..'9'] ) do
   begin
    s1 := s1 + _tz[i];
    inc( i );
   end;

   m := Str2Int( s1 );
   delete( _tz, 1, i - 1 );

   if ( _tz[1] = ':' ) then { minutes }
   begin
    delete( _tz, 1, 1 );
    s1 := ''; i := 1;
    while ( _tz[i] in ['0'..'9'] ) do
    begin
     s1 := s1 + _tz[i];
     inc( i );
    end;
    s := Str2Int( s1 );
    delete( _tz, 1, i - 1 );
   end;
  end;

  if ( length( _tz ) > 0 ) then dst := copy( _tz, 1, 3 );
  delete( _tz, 1, 3 );

  if ( length( _tz ) = 0 ) then
  begin
   TZIdentifier := iden;
   TZDST := dst;
   TZHours := h;
   TZMinutes := m;
   TZSeconds := s;
   ParseTZ := true;
   exit;
  end;

  _tz := StripAll( _tz, ' ' );
  _tz := Replace( _tz, ';', ',' );
  _tz := Replace( _tz, ',', ' ' );
  if ( Words( _tz ) <> 9 ) then exit;

  sm := Str2Int( GetWords( _tz, 1, 1 ) );
  if ( ( sm < 1 ) or ( sm > 12 ) ) then exit;

  sw := Str2Int( GetWords( _tz, 2, 1 ) );
  if ( ( sw < -4 ) or ( sw > 4 ) ) then exit;

  sd := Str2Int( GetWords( _tz, 3, 1 ) );
  if ( ( sw <> 0 ) and ( ( sd < 0 ) or ( sd > 6 ) ) ) then exit
  else if ( ( sw = 0 ) and ( ( sd < 1 ) or ( sd > 31 ) ) ) then exit;

  st := Str2Int( GetWords( _tz, 4, 1 ) );
  if ( ( st < 0 ) or ( st > 82800 ) ) then exit;

  em := Str2Int( GetWords( _tz, 5, 1 ) );
  if ( ( em < 1 ) or ( em > 12 ) ) then exit;

  ew := Str2Int( GetWords( _tz, 6, 1 ) );
  if ( ( ew < -4 ) or ( ew > 4 ) ) then exit;

  ed := Str2Int( GetWords( _tz, 7, 1 ) );
  if ( ( ew <> 0 ) and ( ( ed < 0 ) or ( ed > 6 ) ) ) then exit
  else if ( ( ew = 0 ) and ( ( ed < 1 ) or ( ed > 31 ) ) ) then exit;

  et := Str2Int( GetWords( _tz, 8, 1 ) );
  if ( ( et < 0 ) or ( et > 82800 ) ) then exit;

  shift := Str2Int( GetWords( _tz, 9, 1 ) );
  if ( ( shift < 0 ) or ( shift > 82800 ) ) then exit;

  TZIdentifier := iden;
  TZDST := dst;
  TZHours := h;
  TZMinutes := m;
  TZSeconds := s;
  TZsm := sm;
  TZsw := sw;
  TZsd := sd;
  TZst := st;
  TZem := em;
  TZew := ew;
  TZed := ed;
  TZet := et;
  TZshift := shift;
  ParseTZ := true;
 end;

 function CalcDST( year : integer; at_begin : boolean ) : longint;
 var
  m, w, d, i, count : integer;
  s : longint;
 begin

  if ( at_begin ) then
  begin
   m := TZsm;
   w := TZsw;
   d := TZsd;
  end
  else
  begin
   m := TZem;
   w := TZew;
   d := TZed;
  end;

  if ( w <> 0 ) then
  begin
   count := 0;
   if ( w > 0 ) then
   begin
    i := 0;
    while ( count <> w ) do
    begin
     inc( i );
     if ( DayOfWeek( i, m, year ) = d ) then inc( count );
    end;
    d := i;
   end
   else
   begin
    i := MonthLen[m] + 1;
    if ( ( LeapYear( year ) ) and ( m = 2 ) ) then inc( i );
    while ( count <> abs( w ) ) do
    begin
     dec( i );
     if ( DayOfWeek( i, m, year ) = d ) then inc( count );
    end;
    d := i;
   end;
  end;

  CalcDST := YearSeconds( d, m, year ) + TZst;
 end;

 function TZOffset( time : longint ) : longint;
 var
  dummy, day, month, year, hour, min, sec : integer;
  stime, etime, off : longint;
 begin
  Unix2DateExt( time, day, month, year, dummy, hour, min, sec );
  stime := CalcDST( year, true );
  etime := CalcDST( year, false );
  time := YearSeconds( day, month, year ) + ( hour * 3600 ) + ( min * 60 ) + sec;
  off := ( TZHours * 3600 ) + ( TZMinutes * 60 ) + TZSeconds;
  if ( ( time >= stime ) and ( time < etime ) ) then off := off - TZshift;
  TZOffset := off;
 end;

 function TZOffsetMin( time : longint ) : integer;
 begin
  TZOffsetMin := ( TZOffset( time ) div 60 );
 end;

 function TZOffsetHour( time : longint ) : integer;
 begin
  TZOffsetHour := ( TZOffset( time ) div 3600 );
 end;

 function TZOffsetNow : longint;
 begin
  TZOffsetNow := TZOffset( TimeNow );
 end;

 function TZOffsetMinNow : integer;
 begin
  TZOffsetMinNow := ( TZOffsetNow div 60 );
 end;

 function TZOffsetHourNow : integer;
 begin
  TZOffsetHourNow := ( TZOffsetNow div 3600 );
 end;

 function UTCTimeNow : longint;
 begin
  UTCTimeNow := TimeNow + TZOffsetNow;
 end;

End.

