{***************************************************************************}
{*                                                                         *}
{*                        ࢨ  ணࠬ.                    *}
{*                                                                         *}
{*     Copyright (c) 1999 by Konstantin Kubatkin, 2:468/13@Fidonet         *}
{*                                                                         *}
{***************************************************************************}
Unit Tools;

Interface
Uses TextColl;

Const
  ErrorID: String[15] = ' Error ';

(* -= 猪 稭 =- *)
{  訡 蠥  ᨬ쭮 祭}
Function GetError(Value: Integer): String;

{   RunTime 訡 㧭  ப 祭 }
Function RTGetError(Value: Word): String;

{ 頥 㭨 ப  8 ᨬ }
Function UniqueID: String;

{ ॢ  ᥫ  ᨬ }
Function XStr(L: LongInt): String;

{ ॢ  ᨬ  ᫠ }
Function XVal(S: String): LongInt;
Function _Val(S: String; Var I: LongInt): Boolean;

(* -=   ⠬ =- *)
{砥 ⥪饥 ६  }
Procedure GetDateTime(Var Year, Month, Day, DayOfWeek, Hour, Minute, Second, MSec: Word);

{ 頥 TZ ( ᥪ㭤) }
Function GetTZ: LongInt;

{ 頥 浪    , 뢠 ᮪ }
Function DayInYear: Integer;

{ ॢ ᮢ᪮ ६  ଠ Unix }
Function DateDosToUnix(TZ: LongInt): LongInt;

(* -=   p =- *)
{  ஡ ᯥ।  ᧠ }
Function RemoveSpaces(S: String): String;

{ १ ப   -   ᫥ ࢮ ஡ }
Procedure SplitString(Line: String; Var Str1, Str2: String);

{$IfDef MSDOS}
{ pp ᨬ  p孨 pp }
Function  UpCase(C : Char) : Char;

{ pp ᨬ   pp }
Function  LowCase(C : Char) : Char;
{$EndIf}

{ pp p  p孨 pp }
Function UpCaseStr(Str: String): String;

{ pp p   pp }
Function LowCaseStr(Str: String): String;

(* -=   䠩  ppﬨ =- *)

{  \   ப }
Function AddSlash(dName: String): String;

{  \   ப }
Function DelSlash(dName: String): String;

{ p頥 0, ᫨ 䠩 ,   訡 }
{    ᯮ짮 *                         }
Function FileExist(Const fName: String): Word;

{ p뢠 䠩. p頥 0, ᫨ ᯥ譮,   訡 }
Function FileRename(const sName, dName: String): Word;

{  䠩. p頥 0, ᫨ ᯥ譮,   訡 }
Function FileCreate(const fName: String): Word;

{  䠩. p頥 0, ᫨ ᯥ譮,   訡 }
Function FileErase(const fName: String): Word;

{ p頥  䠩  -1 ᫨ 訡 }
Function FileLength(const fName: String): LongInt;

{ p Source 䠩  Dest. p頥 0, ᫨ ᪮஢ ᯥ譮 }
{ 1 - ᫨ 訡 }
Function FileCopy(sName, dName: String): Word;

{ p Source 䠩  Dest. p頥 0, ᫨ ᪮஢ ᯥ譮 }
{ 1 - ᫨ 訡 }
Function FileMove(sName, dName: String): LongInt;

{ p頥 0, ᫨ 䠩     Hidden }
Function ExistNoHidden(const fName: String): Boolean;

{ p頥 0, ᫨ pp  }
Function ExistDir(dName: String): Boolean;

{  ४ਨ DirName   ४ﬨ }
Function CrDir(DirName: String): Word;

{ 祭 ᯨ᪠  ⠫  ⠫ }
Procedure GetDirList(DirName: String; DirList: PTextCollection);

(* -=   ⥬ ᫥ =- *)

{ ॢ Number  Integer  Hex  頥 ࠧ }
{   ப  N ᨬ }
Function Int2Hex(Number: Longint; N: Byte ): String;

{ Return hexadecimal equivalent of Pointer }
Function Ptr2Hex(p: Pointer ): String;

{ ॢ N  Integer  Hex  頥 ࠧ   ப }
Function Dec2Hex(N: Word): String;

{ ॢ N  Integer   ⥬ ᫥ c ᭮ Base }
Procedure X2Hex(Base, N: Word; Var Ts: String);

{$IfDef MSDOS}
{ 몫砥  }
Procedure ShowCursor;

{ 砥  }
Procedure HideCursor;
{$EndIf}

Implementation
{$IfDef VirtualPascal}
Uses Strings, Dos, Objects, VPSysLow;
{$EndIf}
{$IfDef MSDOS}
Uses Strings, Dos, Objects;
{$EndIf}

Const
  NonVLabel = ReadOnly + Hidden + SysFile + Directory + Archive;

{$IfDef VirtualPascal}
Function GetError(Value: Integer): String;
Var
  Temp: PChar;
  Buffer: Array[0..1023] of Char;
  Blank: Boolean;
  C: Char;
  I,J,MsgLen: Longint;
Begin
  Temp:= SysGetSystemError(Value, Buffer, SizeOf(Buffer), MsgLen);
  { Remove all embedded linefeeds, carriage returns and extra blanks }
  I:= 0; J:= 0; Blank:= False;
  While MsgLen > 0 Do
    Begin
      Dec(MsgLen);
      C:= Buffer[I];
      Inc(I);
      If C In [' ', #10, #13] Then Blank:= True
      Else
        Begin
          If Blank Then
            Begin Buffer[J]:= ' '; Inc(J); Blank:= False End;
          Buffer[J]:= C;
          Inc(J)
        End
    End;
  Buffer[J]:= #0;
  GetError:= StrPas(Buffer)
End;
{$EndIf}
{$IfDef MSDOS}
{$I ERROR.INC}
{$EndIf}

{$I RTERROR.INC}

Function UniqueID: String;
Var
  S    : String;
  J, B : Byte;
  C    : Char;
Begin
  Randomize; S:= '';
  For J:= 1 to 8 do
    Begin
      B:= Random(16);
      If B in [0..9] Then S:= S + Chr(Ord('0')+B)
        Else S:= S + Chr(Ord('a')+(B-10))
    End;
 UniqueID:= S
End;

Function XStr(L: LongInt): String;
Var
  Temp: String;
Begin
  Temp:= ''; Str(L, Temp); XStr:= Temp
End;

Function XVal(S: String): LongInt;
Var
{$IfDef VirtualPascal}
  I, Zed: LongInt;
{$EndIf}
{$IfDef MSDOS}
  I, Zed: Integer;
{$EndIf}
Begin
  Val(S, I, Zed); If Zed > 0 Then I:= -1; XVal:= I
End;

Function _Val(S: String; Var I: LongInt): Boolean;
Var
{$IfDef VirtualPascal}
  Code: LongInt;
{$EndIf}
{$IfDef MSDOS}
  Code: Integer;
{$EndIf}
Begin
  Val(S, I, Code ); _Val:= (Code = 0)
End;

Procedure GetDateTime(Var Year,Month,Day,DayOfWeek,Hour,Minute,Second,MSec: Word);
{$IfDef VirtualPascal}
Var
  Y, M, D, DOW, H, Min, S, MS: PLongInt;
Begin
  New(Y); New(M); New(D); New(DOW); New(H); New(Min); New(S); New(MS);
  SysGetDateTime(Y, M, D, DOW, H, Min, S, MS);
  Year:= Word(Y^); Month:= Word(M^); Day:= Word(D^); DayOfWeek:= Word(DOW^);
  Hour:= Word(H^); Minute:= Word(Min^); Second:= Word(S^); MSec:= Word(MS^);
  Dispose(Y); Dispose(M); Dispose(D); Dispose(DOW);
  Dispose(H); Dispose(Min); Dispose(S); Dispose(MS)
{$EndIf}
{$IfDef MSDOS}
Begin
  GetDate(Year, Month, Day, DayOfWeek); GetTime(Hour, Minute, Second, MSec)
{$EndIf}
End;

Function GetTZ: LongInt;
Var
  Str, Str1: String;
  sm,sw,sd,st,em,ew,ed,et,shift: LongInt;
  cy,cm,cd,cw,ch,cmin,cs,cms: Word;
  stime, etime, ctime: LongInt;
  I: LongInt;
  TZ: LongInt;
Begin
  { 樠㥬 ६ }
  GetTZ:= 0; TZ:= 0;
  { 뢠 ६ TZ }
  Str:= UpCaseStr(GetEnv('TZ'));
  { ᫨ TZ  ।,  ᯮ㥬 㬮砭 }
  If Str = '' Then Str:= 'EST5EDT,4,1,0,3600,10,-1,0,7200,3600';
  Delete(Str, 1, 3);
  { 뢠 砫쭮 祭 TZ }
  If Pos(',', Str) = 0 Then Begin Str1:= Str; Str:= '' End
  Else
    Begin
      Str1:= Copy(Str, 1, Pos(',', Str)-1);
      Delete(Str, 1, Pos(',', Str))
    End;
  {   ⠪: TZ=EET-2 }
  While not _Val(Str1[Length(Str1)], I) Do Str1[0]:= Chr(Ord(Str1[0]) - 1);
  { ᫨ 砫쭮 祭 㪧  ⠬  ᥪ㭤 }
  If Pos(':', Str1) > 0 Then
    Begin
      If not _Val(Copy(Str1, 1, Pos(':', Str1)-1), I) Then I:= 5;
      Delete(Str1, 1, Pos(':', Str1)); TZ:= I*3600;
      { ᫨ 㪠  }
      If Pos(':', Str1) > 0 Then
        Begin
          If not _Val(Copy(Str1, 1, Pos(':', Str1)-1), I) Then I:= 0;
          Delete(Str1, 1, Pos(':', Str1));
          If Abs(TZ) = TZ Then TZ:= TZ + I*60 Else TZ:= TZ - I*60;
          { ᫨  㪠  ᥪ㭤 }
          If Str1 <> '' Then
            Begin
              If not _Val(Str1, I) Then I:= 0;
              If Abs(TZ) = TZ Then TZ:= TZ + I Else TZ:= TZ - I
            End
        End
      { ᫨  ᥪ㭤 }
      Else
        Begin
          If not _Val(Str1, I) Then I:= 0;
          If Abs(TZ) = TZ Then TZ:= TZ + I*60 Else TZ:= TZ - I*60
        End
    End
  { ᫨    ᥪ㭤 }
  Else
    Begin
      If not _Val(Str1, I) Then I:= 5;
      TZ:= I*3600
    End;
  GetTZ:= TZ;
  { ᫨  㪠 ᫮ 室  ⭥ ६ }
  If Str <> '' Then
    Begin
      { 뢠 ६ 室 }
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), sm) Then sm:= 4;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), sw) Then sw:= 1;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), sd) Then sd:= 0;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), st) Then st:= 3600;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), em) Then em:= 10;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), ew) Then ew:= -1;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), ed) Then ed:= 0;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Copy(Str, 1, Pos(',', Str)-1), et) Then et:= 7200;
      Delete(Str, 1, Pos(',', Str));
      If not _Val(Str, shift) Then shift:= 3600;
      { 砥 ⥪饥 ६ }
      GetDateTime(cy,cm,cd,cw,ch,cmin,cs,cms);
      { 뢠 ६ 砫 DST }
      If sw <> 0 Then
        Begin
          If Abs(sw) = sw Then I:= 7*sw-7 Else I:= 28+7*sw;
          If sd = 0 Then sd:= I + 7 Else sd:= I + sd;
        End;
      stime:= 0;
      stime:= ((sm-1)*30+(Byte(sm>1)+Byte(sm>3)+Byte(sm>5)+Byte(sm>7)+Byte(sm>8)+
      Byte(sm>10)+sd-Byte(sm>2)*2+Byte((cy/400=(cy div 400)) or ((cy/4=(cy div 4)) and ((cy mod 100)>0)))))*86400+st;
      { 뢠 ६  DST }
      If ew <> 0 Then
        Begin
          If Abs(ew) = ew Then I:= 7*ew-7 Else I:= 28+7*ew;
          If ed = 0 Then ed:= I + 7 Else ed:= I + ed;
        End;
      etime:= 0;
      etime:= ((em-1)*30+(Byte(em>1)+Byte(em>3)+Byte(em>5)+Byte(em>7)+Byte(em>8)+
      Byte(em>10)+ed-Byte(em>2)*2+Byte((cy/400=(cy div 400)) or ((cy/4=(cy div 4)) and ((cy mod 100)>0)))))*86400+et;
      { 뢠 ⥪饥 - ᥪ㭤 }
      ctime:= 0;
      ctime:= ((cm-1)*30+(Byte(cm>1)+Byte(cm>3)+Byte(cm>5)+Byte(cm>7)+Byte(cm>8)+
      Byte(cm>10)+cd-Byte(cm>2)*2+Byte((cy/400=(cy div 400)) or ((cy/4=(cy div 4)) and ((cy mod 100)>0)))))*86400+ch
      *3600+cmin*60+cs;
      { 뢠 TZ }
      If (ctime > stime) and (ctime < etime) Then
        If Abs(TZ) = TZ Then TZ:= TZ + shift
          Else TZ:= TZ - shift
    End;
  GetTZ:= TZ
End;

Function DayInYear: Integer;
Var
  Year,Month,Day,DayOfWeek,Hour,Minute,Second,MSecond: Word;
Begin
  DayInYear:= -1;
  GetDateTime(Year,Month,Day,DayOfWeek,Hour,Minute,Second,MSecond);
  DayInYear:= (Month-1)*30+
  (Byte(Month>1)+Byte(Month>3)+Byte(Month>5)+Byte(Month>7)+Byte(Month>8)+
   Byte(Month>10)+Day-Byte(Month>2)*2+
   Byte((Year/400=(Year div 400)) or ((Year/4=(Year div 4)) and ((Year mod 100)>0))))
End;

Function DateDosToUnix(TZ: LongInt): LongInt;
Var
  Year,Month,Day,DayOfWeek,Hour,Minute,Second,MSecond: Word;
Begin
  DateDosToUnix:= -1;
  GetDateTime(Year,Month,Day,DayOfWeek,Hour,Minute,Second,MSecond);
  DateDosToUnix:=(((Year-1970)*365+((Year-1969) div 4)-((Year-1969) div 400)+((Month-1)*30+Byte(Month>1)+
  Byte(Month>3)+Byte(Month>5)+Byte(Month>7)+Byte(Month>8)+Byte(Month>10)+
  Day-Byte(Month>2)*2+Byte((Year/400=(Year div 400))or((Year/4=(Year div 4))and((Year mod 100)>0))))-1))*
  86400+(Hour*3600+Minute*60+Second)+(TZ)
End;

Function RemoveSpaces(S: String): String;
Begin
  While (S[1] = ' ') and (Length(S) > 0) Do Delete(S, 1, 1);
{  While (S[Length(S)] = ' ') and (Length(S) > 0) Do S[0]:= Chr(Ord(S[0]) - 1);}
  While (S[Length(S)] = ' ') and (Length(S) > 0) Do Dec(S[0]);
  RemoveSpaces:= S
End;

Procedure SplitString(Line: String; Var Str1, Str2: String);
Begin
  Str1:= RemoveSpaces(Copy(Line, 1, Pos(' ', Line)));
  Delete(Line, 1, Pos(' ', Line)); Str2:= RemoveSpaces(Line)
End;

{$IfDef MSDOS}
Function UpCase; assembler;
Asm
  mov   al,&C
  cmp   al,'a'
  jb    @@ok
  cmp   al,'z'
  jbe   @@lo
  cmp   al,''
  jb    @@ok
  cmp   al,''
  jbe   @@lo
  cmp   al,''
  jb    @@ok
  cmp   al,''
  ja    @@ok
  sub   al,80-32
@@lo: sub     al,20h
@@ok:
End;

Function LowCase; assembler;
Asm
  mov   al,&C
  cmp   al,'A'
  jb    @@ok
  cmp   al,'Z'
  jbe   @@up
  cmp   al,''
  jb    @@ok
  cmp   al,''
  jbe   @@up
  cmp   al,''
  jb    @@ok
  cmp   al,''
  ja    @@ok
  add   al,80-32
@@up: add     al,20h
@@ok:
End;
{$EndIf}

Function UpCaseStr(Str: String): String;
{$IfDef VirtualPascal}
Var
  NameStr: PChar;
Begin
  GetMem(NameStr, Length(Str)+1); StrPCopy(NameStr, Str);
  UpCaseStr:= StrPas(SysUpperCase(NameStr));
  FreeMem(NameStr, Length(Str)+1)
{$EndIf}
{$IfDef MSDOS}
Var
  I: Integer;
Begin
  UpCaseStr[0]:= Str[0];
  For I:= 1 To Length(Str) Do UpCaseStr[I]:= UpCase(Str[I])
{$EndIf}
End;

Function LowCaseStr(Str: String): String;
{$IfDef VirtualPascal}
Var
  NameStr: PChar;
Begin
  GetMem(NameStr, Length(Str)+1); StrPCopy(NameStr, Str);
  LowCaseStr:= StrPas(SysLowerCase(NameStr));
  FreeMem(NameStr, Length(Str)+1)
{$EndIf}
{$IfDef MSDOS}
Var
  I: Integer;
Begin
  LowCaseStr[0]:= Str[0];
  For I:= 1 To Length(Str) Do LowCaseStr[I]:= LowCase(Str[I])
{$EndIf}
End;

Function AddSlash(dName: String): String;
Begin
  If dName[Length(dName)] <> '\'
    Then AddSlash:= dName + '\' Else AddSlash:= dName
End;

Function DelSlash(dName: String): String;
Begin
  If dName[Length(dName)] = '\' Then Delete(dName, Length(dName), 1);
  DelSlash:= dName
End;

Function FileExist(Const fName: String): Word;
Var
  DirInfo: SearchRec;
Begin
  FindFirst(fName, AnyFile, DirInfo); FileExist:= DosError;
{$IfDef VirtualPascal} FindClose(DirInfo) {$EndIf}
End;

Function FileRename(Const sName, dName: String): Word;
Var
  FH: File;
Begin
  Assign(FH, sName); {$I-} Rename(FH, dName); {$I+}
  FileRename:= IOResult
End;

Function FileCreate(const fName: String): Word;
Var
  FH: File;
Begin
  Assign(FH, fName); {$I-} ReWrite(FH); {$I+}
  If IOResult = 0  Then Close(FH); FileCreate:= IOResult
End;

Function FileErase(const fName: String): Word;
Var
  FH: File;
Begin
  Assign(FH, fName); { SetFAttr(FH, Archive);}
  {$I-} Erase(FH); {$I+} FileErase:= IOResult
End;

Function FileLength(const fName: String): LongInt;
Var
  FH: File;
  I : Longint;
Begin
  I:= FileMode; FileMode:= $40;
  Assign(FH, fName); {$I-} Reset(FH, 1); {$I+} FileMode:= I;
  If IOResult <> 0 Then FileLength:= -1 Else FileLength:= FileSize(FH);
  Close(FH)
End;

{$IfDef VirtualPascal}
Function FileCopy(sName, dName: String): Word;
Var
  sNameStr : PChar;
  dNameStr : PChar;
Begin
  FileCopy:= 1;
  GetMem(sNameStr, Length(sName)+1); StrPCopy(sNameStr, sName);
  GetMem(dNameStr, Length(dName)+1); StrPCopy(dNameStr, dName);
  If SysFileCopy(sNameStr, dNameStr, False) Then FileCopy:= 0;
  FreeMem(sNameStr, Length(sName)+1); FreeMem(dNameStr, Length(dName)+1)
End;
{$EndIf}
{$IfDef MSDOS}
Function FileCopy(sName, dName: String): Word;
Var
  FromF, ToF : File;
  NumRead    : Integer;
  NumWritten : Integer;
  Time       : LongInt;
  Buf        : Pointer;
  Block      : Word;
Begin
  FileCopy:= 1;
  Assign(FromF, sName); {$I-} Reset(FromF, 1); {$I+}
  If IOResult <> 0 Then Begin FileCopy:= IOResult; Close(FromF); Exit End;
  Assign(ToF, dName); {$I-} ReWrite(ToF, 1); {$I+}
  If IOResult <> 0 Then Begin FileCopy:= IOResult; Close(ToF); Exit End;
  Block:= MaxAvail; GetMem(Buf, Block);
  Repeat
    BlockRead(FromF, Buf^, Block, NumRead);
    BlockWrite(ToF, Buf^, NumRead, NumWritten);
    If NumWritten <> NumRead Then
      Begin
        FileCopy:= 1; Close(FromF); Close(ToF); FileErase(dName); Exit
      End
  Until NumRead = 0;
  GetFTime(FromF,Time); SetFTime(ToF,Time);
  FreeMem (Buf, Block); Close (ToF); Close(FromF);
  FileCopy:= 0;
End;
{$EndIf}

{$IfDef VirtualPascal}
Function FileMove(sName, dName: String): LongInt;
Var
  sNameStr : PChar;
  dNameStr : PChar;
Begin
  GetMem(sNameStr, Length(sName)+1); StrPCopy(sNameStr, sName);
  GetMem(dNameStr, Length(dName)+1); StrPCopy(dNameStr, dName);
  FileMove:= SysFileMove(sNameStr, dNameStr);
  FreeMem(sNameStr, Length(sName)+1); FreeMem(dNameStr, Length(dName)+1)
End;
{$EndIf}
{$IfDef MSDOS}
Function FileMove(sName, dName: String): LongInt;
Var
  F: File;
Begin
  Assign(F, sName); {$I-} Rename(F, dName); {$I+} Close(F);
  FileMove:= IOResult
End;
{$EndIf}

Function ExistNoHidden(const fName: String): Boolean;
Var
  DirInfo: SearchRec;
Begin
  FindFirst(fName, AnyFile, DirInfo);
  If DosError = 0 Then ExistNoHidden:= (DirInfo.Attr and Hidden = 0)
    Else ExistNoHidden:= False;
{$IfDef VirtualPascal} FindClose(DirInfo) {$EndIf}
End;

Function ExistDir(dName: String): Boolean;
Var
  DirInfo: SearchRec;
Begin
  dName:= DelSlash(dName); FindFirst(dName, Directory, DirInfo);
  ExistDir:= DosError = 0;
{$IfDef VirtualPascal} FindClose(DirInfo) {$EndIf}
End;

Function CrDir(DirName: String): Word;
Var
  Temp: String;
Begin
  DirName:= DelSlash(DirName); Temp:= DirName; CrDir:= 0;
  While not ExistDir(Temp) Do
    Begin
      {$I-} MkDir(Temp); {$I+}
      If IOResult = 3 Then
        Repeat
          While Temp[Length(Temp)] <> '\' Do Temp[0]:= Chr(Ord(Temp[0]) - 1);
          Temp[0]:= Chr(Ord(Temp[0]) - 1);
          {$I-} MkDir(Temp) {$I+}
        Until IOResult = 0
      Else CrDir:= IOResult;
      Temp:= DirName
    End
End;

Procedure GetDirList(DirName: String; DirList: PTextCollection);
{$IfDef VirtualPascal}
Var
  DirInfo: TOSSearchRec;
  PS     : PString;
  P      : PChar;
  rc     : LongInt;
Begin
  If DirList = Nil Then Exit; DirName:= DelSlash(DirName);
  PS:= NewStr(DirName); If PS <> Nil Then DirList^.Insert(PS);
  P:= StrPCopy(P, DirName+'\*');
  rc:= SysFindFirst(P, $10 + $1000, DirInfo, False);
  While rc = 0 Do
    Begin
      If (DirInfo.Name <> '.') and (DirInfo.Name <> '..') Then
        GetDirList(DirName+'\'+DirInfo.Name, DirList);
      rc:= SysFindNext(DirInfo, False)
    End;
  rc:= SysFindClose(DirInfo)
End;
{$EndIf}
{$IfDef MSDOS}
Var
  DirInfo: SearchRec;
  PS     : PString;
Begin
  If DirList = Nil Then Exit; DirName:= DelSlash(DirName);
  PS:= NewStr(DirName); If PS <> Nil Then DirList^.Insert(PS);
  FindFirst(DirName+'\*.*' , NonVLabel, DirInfo);
  While DosError = 0 Do
    Begin
      If (DirInfo.Name[1] <> '.') and ((DirInfo.Attr And Directory) = Directory) Then
        GetDirList(DirName+'\'+DirInfo.Name, DirList);
      FindNext(DirInfo)
    End
End;
{$EndIf}

Function Int2Hex(Number: Longint; N: Byte ): String;
Const
  HexDigit: Array[0..$f] of char = '0123456789ABCDEF';
Var
  S: String;
  I: Integer;
Begin
  S[0]:= Chr(N);
  For I:= N DownTo 1 Do
    Begin
      S[I]:= HexDigit[Number and $F];
      Number:= Number shr 4
    End;
  Int2Hex:= S
End;

{ Return hexadecimal equivalent of Pointer }
Function Ptr2Hex(p : Pointer ): String;
Begin
  Ptr2Hex:= Int2Hex(Word(p), 8)
End;

Function Dec2Hex(N: Word): String;
Var
  S: String[10];
  D: byte;
Begin
  If N = 0 Then S:= '0'
  Else Begin
    S:= '';
    While N <> 0 do Begin
      d:= n and $F; n:= n SHR 4;
      If d < 10 Then s:= chr(d+48)+s Else s:= chr(d+55)+s
    End
  End;
  Dec2Hex:= s
End;

Procedure X2Hex(Base, N: Word; Var Ts: String);
Var
  Rest: Integer;
Begin
  Rest:= N mod Base; N:= N div Base;
  Case Rest of
    00..09: Ts := XStr(Rest) + Ts;
    10..31: Ts := Chr(55+Rest) + Ts;
  End;
  If N <> 0 then X2Hex(Base, N, Ts)
End;

{$IfDef MSDOS}
Procedure ShowCursor; assembler;
Asm
  mov AH,1
  mov CH,20
  mov CL,0
  Int 10
End;

Procedure HideCursor; assembler;
Asm
  mov AH,1
  mov CH,6
  mov CL,7
  Int 10
End;
{$EndIf}

End.

