unit TextColl; { Text Collection }

interface

uses Objects;

type
  PTextCollection = ^TTextCollection;
  TTextCollection = object(TCollection)
    procedure FreeItem(Item: Pointer); virtual;
    function GetItem(var S: TStream): Pointer; virtual;
    procedure PutItem(var S: TStream; Item: Pointer); virtual;
    function SearchStr(const Str: String; var Index: Integer): Boolean;
  end;

implementation

type
  PTextBuffer = ^TTextBuffer;
  TTextBuffer = array[0..256] of Char;

procedure TTextCollection.FreeItem(Item: Pointer);
begin
  DisposeStr(Item);
end;

function TTextCollection.GetItem(var S: TStream): Pointer;
begin
  GetItem := S.ReadStr;
end;

procedure TTextCollection.PutItem(var S: TStream; Item: Pointer);
begin
  S.WriteStr(Item);
end;

function TTextCollection.SearchStr(const Str: String; var Index: Integer): Boolean;

  function Match(Item: Pointer): Boolean; far;
  begin
    Match := Pos(Str, PString(Item)^) <> 0;
  end;

var
  P: Pointer;
begin
  P := FirstThat(@Match);
  SearchStr := P <> nil;
  if P <> nil then Index := IndexOf(P)
  else Index := -1;
end;

end.
