{**********************************************}
{*                                            *}
{*          String utilities v1.20            *}
{*                                            *}
{*  This is the part of the "Utilities pack"  *}
{*                                            *}
{*       Copyright (c) 1995-1999 by           *}
{*  Alexander S. Tokareff, 2:5077/27@fidonet  *}
{*                                            *}
{* MatchStr prototype is (c) Vadim Rumyantsev *}
{*                                            *}
{**********************************************}
{$Q-}
{$IFDEF VIRTUALPASCAL}
{$Delphi+,J+}
{$ENDIF VIRTUALPASCAL}
{$IFDEF MSDOS}
{$N+}
{$ENDIF MSDOS}
Unit StrUtils;
Interface
{$IFDEF VIRTUALPASCAL}
//Uses Use32;
{$ENDIF}
Const
 cp_NoChange    = 0;
 cp_DOS866      = 1;
 cp_UnixKOI8R   = 2;
 cp_Win1251     = 3;
 cp_ISO8859_5   = 4;
 cp_Macintosh   = 5;

Const
 CurrentCP : byte = 1;

 function IsSpace( ch : char ) : boolean;
 function IsNumeric( ch : char ) : boolean;
 function IsAlphabetic( ch : char ) : boolean;
 function IsAlphaNum( ch : char ) : boolean;
 function IsAlphaRus( ch : char ) : boolean;

 function UpCaseChar( ch : char ) : char;
 function LoCaseChar( ch : char ) : char;

 function CopyPos( s : string; from, too : integer ) : string;
 function Copies( ch : char; num : byte ) : string;
 function First( s : string; num : byte ) : string;
 function Last( s : string; num : byte ) : string;
 function PadLeft( s : string; num : byte; ch : char ) : string;
 function PadCenter( s : string; num : byte; ch : char ) : string;
 function PadRight( s : string; num : byte; ch : char ) : string;
 function OverType( s, s1 : string; ps : byte ) : string;

 function Upper( s : string ) : string;
 function Lower( s : string ) : string;
 function Mixed( s : string ) : string;

 function StripLead( s : string; ch : char ) : string;
 function StripAll( s : string; ch : char ) : string;
 function StripTrail( s : string; ch : char ) : string;
 function StripBoth( s : string; ch : char ) : string;

 function Replace( s, what, too : string ) : string;

 function Words( s : string ) : integer;
 function GetWordBeg( s : string; wrd : integer ) : integer;
 function GetWordEnd( s : string; wrd : integer ) : integer;
 function PosIsWord( s : string; ps : integer ) : integer;
 function GetWords( s : string; start, num : integer ) : string;

 function Str2Int( s : string ) : integer;
 function Str2Long( s : string ) : longint;
 function Int2Str( int : longint ) : string;
 function Int2Hex( int : longint ) : string;
 function Int2Oct( int : longint ) : string;
 function Int232( int : longint ) : string;
 function Comp2Str( cmp : comp; inum, flnum : integer ) : string;

 procedure FormatStr( var res : string; const format : string; var params );
 function Format( const fmt : string; var params ) : string;

 function MatchStr( s, pat : string ) : boolean;

Implementation
Uses Strings;

 function IsSpace( ch : char ) : boolean;
 begin
  IsSpace := ( ( ch = #9 ) or ( ch = #10 ) or ( ch = #13 ) or ( ch = #32 ) );
 end;

 function IsNumeric( ch : char ) : boolean;
 begin
  IsNumeric := ( ( byte( ch ) >= $30 ) and ( byte( ch ) <= $39 ) );
 end;

 function IsAlphabetic( ch : char ) : boolean;
 begin
  IsAlphabetic := ( ( ( byte( ch ) >= $41 ) and ( byte( ch ) <= $5a ) ) or
                    ( ( byte( ch ) >= $61 ) and ( byte( ch ) <= $7a ) ) or
                    ( IsAlphaRus( ch ) ) );
 end;

 function IsAlphaNum( ch : char ) : boolean;
 begin
  IsAlphaNum := ( ( IsNumeric( ch ) ) or ( IsAlphabetic( ch ) ) );
 end;

 function IsAlphaRus( ch : char ) : boolean;
 begin
  IsAlphaRus := ( byte( ch ) > 127 );
 end;

 function UpCaseChar( ch : char ) : char;
 begin
  if ( ( byte( ch ) >= $61 ) and ( byte( ch ) <= $7a ) ) then
   UpCaseChar := char( byte( ch ) - $20 )
  else if ( CurrentCP = cp_DOS866 ) then
  begin
   if ( ( byte( ch ) >= $a0 ) and ( byte( ch ) <= $af ) ) then
    UpCaseChar := char( byte( ch ) - $20 )
   else if ( ( byte( ch ) >= $e0 ) and ( byte( ch ) <= $ef ) ) then
    UpCaseChar := char( byte( ch ) - $50 )
   else if ( ( ch = '' ) or ( ch = '' ) or ( ch = '' ) or ( ch = '' ) ) then
    UpCaseChar := char( byte( ch ) - 1 )
   else UpCaseChar := ch;
  end
  else if ( CurrentCP = cp_UnixKOI8R ) then
  begin
   if ( ( byte( ch ) >= $c0 ) and ( byte( ch ) <= $df ) ) then
    UpCaseChar := char( byte( ch ) + $20 )
   else if ( byte( ch ) = $a3 ) then UpCaseChar := #$b3
   else if ( byte( ch ) = $98 ) then UpCaseChar := #$99
   else if ( byte( ch ) = $9b ) then UpCaseChar := #$93
   else if ( byte( ch ) = $97 ) then UpCaseChar := #$9f
   else UpCaseChar := ch;
  end
  else if ( CurrentCP = cp_Win1251 ) then
  begin
   if ( ( byte( ch ) >= $a0 ) and ( byte( ch ) <= $ff ) ) then
    UpCaseChar := char( byte( ch ) - $20 )
   else if ( byte( ch ) = $b8 ) then UpCaseChar := #$a8
   else UpCaseChar := ch;
  end
  else if ( CurrentCP = cp_ISO8859_5 ) then
  begin
   if ( ( byte( ch ) >= $d0 ) and ( byte( ch ) <= $ef ) ) then
    UpCaseChar := char( byte( ch ) - $20 )
   else if ( byte( ch ) = $f1 ) then UpCaseChar := #$a2
   else UpCaseChar := ch;
  end
  else if ( CurrentCP = cp_Macintosh ) then
  begin
   if ( ( byte( ch ) >= $e0 ) and ( byte( ch ) <= $fe ) ) then
    UpCaseChar := char( byte( ch ) - $60 )
   else if ( byte( ch ) = $df ) then UpCaseChar := #$9f
   else if ( byte( ch ) = $de ) then UpCaseChar := #$dd
   else UpCaseChar := ch;
  end
  else UpCaseChar := ch;
 end;

 function LoCaseChar( ch : char ) : char;
 begin
  if ( ( byte( ch ) > $40 ) and ( byte( ch ) < $5b ) ) then
   LoCaseChar := char( byte( ch ) + $20 )
  else if ( CurrentCP = cp_DOS866 ) then
  begin
   if ( ( byte( ch ) > $7f ) and ( byte( ch ) < $90 ) ) then
    LoCaseChar := char( byte( ch ) + $20 )
   else if ( ( byte( ch ) > $8f ) and ( byte( ch ) < $9f ) ) then
    LoCaseChar := char( byte( ch ) + $50 )
   else if ( ( ch = '' ) or ( ch = '' ) or ( ch = '' ) or ( ch = '' ) ) then
    LoCaseChar := char( byte( ch ) + 1 )
   else LoCaseChar := ch;
  end
  else if ( CurrentCP = cp_UnixKOI8R ) then
  begin
   if ( ( byte( ch ) >= $a0 ) and ( byte( ch ) <= $ff ) ) then
    LoCaseChar := char( byte( ch ) - $20 )
   else if ( byte( ch ) = $a3 ) then LoCaseChar := #$b3
   else if ( byte( ch ) = $98 ) then LoCaseChar := #$99
   else if ( byte( ch ) = $9b ) then LoCaseChar := #$93
   else if ( byte( ch ) = $97 ) then LoCaseChar := #$9f
   else LoCaseChar := ch;
  end
  else if ( CurrentCP = cp_Win1251 ) then
  begin
   if ( ( byte( ch ) >= $c0 ) and ( byte( ch ) <= $df ) ) then
    LoCaseChar := char( byte( ch ) - $20 )
   else if ( byte( ch ) = $a8 ) then LoCaseChar := #$b8
   else LoCaseChar := ch;
  end
  else if ( CurrentCP = cp_ISO8859_5 ) then
  begin
   if ( ( byte( ch ) >= $b0 ) and ( byte( ch ) <= $cf ) ) then
    LoCaseChar := char( byte( ch ) + $20 )
   else if ( byte( ch ) = $a2 ) then LoCaseChar := #$f1
   else LoCaseChar := ch;
  end
  else if ( CurrentCP = cp_Macintosh ) then
  begin
   if ( ( byte( ch ) >= $80 ) and ( byte( ch ) <= $9e ) ) then
    LoCaseChar := char( byte( ch ) + $60 )
   else if ( byte( ch ) = $9f ) then LoCaseChar := #$df
   else if ( byte( ch ) = $dd ) then LoCaseChar := #$de
   else LoCaseChar := ch;
  end
  else LoCaseChar := char( byte( ch ) + $20 );
 end;

 function CopyPos( s : string; from, too : integer ) : string;
 begin
  CopyPos := copy( s, from, ( too - from ) + 1 );
 end;

 function Copies( ch : char; num : byte ) : string;
 var
  i : integer;
  res : string;
 begin
  res := '';
  for i := 1 to num do res := res + ch;
  Copies := res;
 end;

 function First( s : string; num : byte ) : string;
 begin
  First := copy( s, 1, num );
 end;

 function Last( s : string; num : byte ) : string;
 begin
  if ( num > length( s ) ) then Last := s
  else Last := copy( s, ( length( s ) - num ) + 1, num );
 end;

 function PadLeft( s : string; num : byte; ch : char ) : string;
 var
  cnt : byte;
 begin
  cnt := num - length( s );
  if ( cnt > 0 ) then PadLeft := s + Copies( ch, cnt )
  else PadLeft := s;
 end;

 function PadCenter( s : string; num : byte; ch : char ) : string;
 var
  cnt : byte;
  odd : boolean;
 begin
  cnt := num - length( s );
  odd := ( ( cnt mod 2 ) = 0 );
  if ( ( cnt > 0 ) and odd ) then
   PadCenter := Copies( ch, cnt div 2 ) + s + Copies( ch, cnt div 2 )
  else if ( ( cnt > 0 ) and not odd ) then
   PadCenter := Copies( ch, cnt div 2 + 1 ) + s + Copies( ch, cnt div 2 )
  else PadCenter := s;
 end;

 function PadRight( s : string; num : byte; ch : char ) : string;
 var
  cnt : byte;
 begin
  cnt := num - length( s );
  if ( cnt > 0 ) then PadRight := Copies( ch, cnt ) + s
  else PadRight := s;
 end;

 function OverType( s, s1 : string; ps : byte ) : string;
 var
  i, j, en : integer;
 begin
  j := 0;
  if ( ( ps >= 1 ) and ( ps <= length( s ) ) ) then
  begin
   if ( ( ps + length( s1 ) ) >= length( s ) ) then en := length( s )
   else en := ( ps + length( s1 ) ) - 1;
   for i := ps to en do
   begin
    inc( j );
    s[i] := s1[j];
   end;
  end;
  OverType := s;
 end;

 function Upper( s : string ) : string;
 var
  i : integer;
 begin
  for i := 1 to length( s ) do s[i] := UpCaseChar( s[i] );
  Upper := s;
 end;

 function Lower( s : string ) : string;
 var
  i : integer;
 begin
  for i := 1 to length( s ) do s[i] := LoCaseChar( s[i] );
  Lower := s;
 end;

 function Mixed( s : string ) : string;
 var
  wrd, ps : integer;
 begin
  if ( Words( s ) = 0 ) then Exit;
  s := Lower( s );
  for wrd := 1 to Words( s ) do
  begin
   ps := GetWordBeg( s, wrd );
   s[ps] := UpCaseChar( s[ps] );
  end;
  Mixed := s;
 end;

 function StripLead( s : string; ch : char ) : string;
 var
  i : integer;
 begin
  i := 1;
  while ( s[i] = ch ) do inc( i );
  StripLead := copy( s, i, ( length( s ) - i ) + 1 );
 end;

 function StripAll( s : string; ch : char ) : string;
 var
  i : integer;
  res : string;
 begin
  res := '';
  for i := 1 to length( s ) do if ( s[i] <> ch ) then res := res + s[i];
  StripAll := res;
 end;

 function StripTrail( s : string; ch : char ) : string;
 var
  i : integer;
 begin
  i := length( s );
  while ( s[i] = ch ) do dec( i );
  StripTrail := copy( s, 1, i );
 end;

 function StripBoth( s : string; ch : char ) : string;
 begin
  StripBoth := StripLead( StripTrail( s, ch ), ch );
 end;

 function Replace( s, what, too : string ) : string;
 var
  i, lw, lt : integer;
 begin
  Replace := s;
  if ( ( s = '' ) or ( what = '' ) ) then Exit;
  lw := length( what ); lt := length( too );
  i := pos( what, s );
  while ( i <> 0 ) do
  begin
   Delete( s, i, lw );
   Insert( too, s, i );
   i := pos( what, s );
  end;
  Replace := s;
 end;

 function Words( s : string ) : integer;
 var
  i, wrd : integer;
  one_word : boolean;
 begin
  s := StripBoth( s, ' ' );
  if ( length( s ) = 0 ) then begin Words := 0; Exit; end;
  wrd := 1; one_word := true;
  for i := 1 to length( s ) do
  begin
   if ( ( not IsSpace( s[i] ) ) and ( not one_word ) ) then
   begin
    inc( wrd );
    one_word := true;
   end
   else if ( IsSpace( s[i] ) ) then one_word := false;
  end;
  Words := wrd;
 end;

 function GetWordBeg( s : string; wrd : integer ) : integer;
 var
  i, w, len : integer;
  was_space : boolean;
 begin
  GetWordBeg := 0;
  i := 0; w := 0; was_space := false; len := length( s );
  if ( wrd > Words( s ) ) then Exit;
  if ( not IsSpace( s[1] ) ) then w := 1;
  if ( ( wrd = 1 ) and ( w = 1 ) ) then
  begin
   GetWordBeg := 1;
   Exit;
  end;
  while ( w < wrd ) do
  begin
   inc( i );
   if ( IsSpace( s[i] ) and ( not was_space ) ) then
   begin
    inc( w );
    was_space := true;
   end
   else if ( not IsSpace( s[i] ) ) then was_space := false;
   if ( i = len ) then break;
  end;
  while ( IsSpace( s[i] ) ) do inc( i );
  GetWordBeg := i;
 end;

 function GetWordEnd( s : string; wrd : integer ) : integer;
 var
  i, len : integer;
 begin
  GetWordEnd := 0;
  i := GetWordBeg( s, wrd );
  if ( i = 0 ) then Exit;
  len := length( s );
  if ( i >= len ) then begin GetWordEnd := len; Exit; end;
  while ( not IsSpace( s[i] ) ) do
  begin
   inc( i );
   if ( i = len ) then
   begin
    if ( IsSpace( s[i] ) ) then GetWordEnd := i - 1
    else GetWordEnd := i;
    Exit;
   end;
  end;
  GetWordEnd := i - 1;
 end;

 function PosIsWord( s : string; ps : integer ) : integer;
 var
  i, begword, endword : integer;
 begin
  PosIsWord := 0;
  if ( ps > length( s ) ) then Exit;
  if ( IsSpace( s[ps] ) ) then Exit;
  for i := 1 to Words( s ) do
  begin
   begword := GetWordBeg( s, i );
   endword := GetWordEnd( s, i );
   if ( ( begword <= ps ) and ( ps <= endword ) ) then break;
  end;
  PosIsWord := i;
 end;

 function GetWords( s : string; start, num : integer ) : string;
 var
  begword, endword : integer;
 begin
  GetWords := '';
  if ( ( start + num ) - 1 > Words( s ) ) then Exit;
  begword := GetWordBeg( s, start );
  endword := GetWordEnd( s, ( start + num ) - 1 );
  if ( ( begword = 0 ) or ( endword = 0 ) or ( endword < begword ) ) then Exit;
  GetWords := CopyPos( s, begword, endword );
 end;

 function Str2Int( s : string ) : integer;
 var
{$IFDEF VirtualPascal}
  res, code : longint;
{$ELSE}
  res, code : integer;
{$ENDIF}
 begin
  Val( s, res, code );
  Str2Int := res;
 end;

 function Str2Long( s : string ) : longint;
 var
{$IFDEF VirtualPascal}
  res, code : longint;
{$ELSE}
  res : longint;
  code : integer;
{$ENDIF}
 begin
  Val( s, res, code );
  Str2Long := res;
 end;

 function Int2Str( int : longint ) : string;
 var
  s : string;
 begin
  Str( int, s );
  Int2Str := s;
 end;

 function Int2Hex( int : longint ) : string;
 const
  Digits : array[0..15] of char = '0123456789ABCDEF';
 var
  s : string;
 begin
  if ( int = 0 ) then
  begin
   Int2Hex := '0';
   exit;
  end;
  s := '';
  while ( int <> 0 ) do
  begin
   s := Digits[int and $0f] + s;
   int := int shr 4;
  end;
  Int2Hex := s;
 end;

 function Int2Oct( int : longint ) : string;
 const
  Digits : array[0..7] of char = '01234567';
 var
  s : string;
 begin
  if ( int = 0 ) then
  begin
   Int2Oct := '0';
   exit;
  end;
  s := '';
  while ( int <> 0 ) do
  begin
   s := Digits[int and 7] + s;
   int := int shr 3;
  end;
  Int2Oct := s;
 end;

 function Int232( int : longint ) : string;
 const
  Digits : array[0..31] of char = '0123456789ABCDEFGHIJKLMNOPQRSTUV';
 var
  s : string;
 begin
  if ( int = 0 ) then
  begin
   Int232 := '0';
   exit;
  end;
  s := '';
  while ( int <> 0 ) do
  begin
   s := Digits[int and $1f] + s;
   int := int shr 5;
  end;
  Int232 := s;
 end;

 function Comp2Str( cmp : comp; inum, flnum : integer ) : string;
 var
  s : string;
 begin
  str( cmp : inum : flnum, s );
  Comp2Str := StripBoth( s, ' ' );
 end;

 procedure FormatStr( var res : string; const format : string; var params );
 type
  TLongArray = array[0..0] of longint;
  PString = ^string;
 var
  reslen, fmtindex : byte;

   procedure HandleParameter( i : longint );
   var
    justify, wth, prec : byte;
    print_sign : boolean;
    typ, fill : char;
    s : string;
   begin
    while ( fmtindex <= length( format ) ) do
    begin
     while ( format[fmtindex] <> '%' ) and ( fmtindex <= length( format ) ) do
     begin
      res[reslen + 1] := format[fmtindex];
      inc( reslen );
      inc( fmtindex );
     end;
     if ( ( fmtindex < length( format ) ) and ( format[fmtindex] = '%' ) ) then
     begin
      fill := ' ';
      justify := 0;
      wth := 0;
      prec := 0;
      print_sign := false;
      inc( fmtindex );
      if ( format[fmtindex] = '0' ) then fill := '0';
      if ( format[fmtindex] = '+' ) then
      begin
       print_sign := true;
       inc( fmtindex );
      end;
      if ( format[fmtindex] = '-' ) then
      begin
       justify := 1;
       inc( fmtindex );
      end;
      if ( format[fmtindex] = '=' ) then
      begin
       justify := 2;
       inc( fmtindex );
      end;
      while ( ( fmtindex <= length( format ) ) and ( format[fmtindex] >= '0' ) and ( format[fmtindex] <= '9' ) ) do
      begin
       wth := wth * 10;
       wth := wth + ord( format[fmtindex] ) - $30;
       inc( fmtindex );
      end;
      if ( ( fmtindex <= length( format ) ) and ( format[fmtindex] = '#' ) ) then
      begin
       inc( fmtindex );
       HandleParameter( wth );
      end;
      if ( fmtindex <= length( format ) ) then
      begin
       typ := format[fmtindex];
       case ( typ ) of
        '%' : begin
               s := '%';
               inc( fmtindex );
               move( s[1], res[reslen + 1], 1 );
               inc( reslen, length( s ) );
               continue;
              end;
        'c' : s := char( TLongArray( params )[i] );
        's' : s := PString( TLongArray( params )[i] )^;
        'S' : s := StrPas( PChar( TLongArray( params )[i] ) );
        'o' : s := Int2Oct( TLongArray( params )[i] );
        'd' : begin
               s := Int2Str( TLongArray( params )[i] );
               if ( ( print_sign ) and ( TLongArray( params )[i] > 0 ) ) then s := '+' + s;
              end;
        'x' : s := Lower( Int2Hex( TLongArray( params )[i] ) );
        'X' : s := Int2Hex( TLongArray( params )[i] );
        'v' : s := Lower( Int232( TLongArray( params )[i] ) );
        'V' : s := Int232( TLongArray( params )[i] );
       end;
       inc( fmtindex );
       if ( wth > 0 ) then
       begin
        case ( justify ) of
         0 : begin
              if ( wth > length( s ) ) then s := PadRight( s, wth, fill )
              else s := CopyPos( s, ( length( s ) - wth ) + 1, length( s ) );
             end;
         1 : begin
              if ( wth > length( s ) ) then s := PadLeft( s, wth, fill )
              else s := copy( s, 1, wth );
             end;
         2 : begin
              if ( wth > length( s ) ) then s := PadCenter( s, wth, fill );
             end;
        end;
       end;
       move( s[1], res[reslen + 1], length( s ) );
       inc( reslen, length( s ) );
       inc( i );
      end;
     end;
    end;
   end;

 begin
  reslen := 0;
  fmtindex := 1;
  HandleParameter( 0 );
 {$IFDEF MSDOS}
  res[0] := chr( reslen );
 {$ELSE}
  SetLength( res, reslen );
 {$ENDIF MSDOS}
 end;

 function Format( const fmt : string; var params ) : string;
 var
  s : string;
 begin
  s := '';
  FormatStr( s, fmt, params );
  Format := s;
 end;

 function MatchStr( s, pat : string ) : boolean;

  function MatchChar( spos, ppos : byte ) : boolean;
  begin
   if ( ppos > length( pat ) ) then MatchChar := spos > length( s )
   else if ( spos > length( s ) ) then MatchChar := ( pat[ppos] = '*' ) and MatchChar( spos, ppos + 1 )
   else if ( pat[ppos] = '*' ) then
   begin
    MatchChar := false;
    for spos := length( s ) + 1 downto spos do
     if ( MatchChar( spos, ppos + 1 ) ) then
     begin
      MatchChar := true;
      break;
     end;
   end
   else MatchChar := ( ( ( pat[ppos] = '?' ) or ( pat[ppos] = s[spos] ) ) and ( MatchChar( spos + 1, ppos + 1 ) ) );
  end;

 begin
  MatchStr := MatchChar( 1, 1 );
 end;

End.

