{***************************************************************************}
{*                                                                         *}
{*                       p  PKT 䠩.                    *}
{*                                                                         *}
{*       p 1.1, ⥯p p ⨯ ⮢ 2+  fsc-0039      *}
{*         p 1.2, ⥯p p  2+  fsc-0048         *}
{*     p 1.3, ⥯p   2.2  fsc-0045 ⮦ p     *}
{*                                                                         *}
{*    Copyright (c) 1996, 1997 by Alexander Tokareff, 2:5077/27@Fidonet    *}
{*                                                                         *}
{***************************************************************************}
Unit Pkts;
Interface
Uses Objects;
Const
 Fill8 : array[1..8] of byte = ( 0,0,0,0,0,0,0,0 );

 { TPktHeader error flags }

 hdrOk          = 0;
 hdrNotMemory   = 1;
 hdrUnknownType = 2;
 hdrDamaged     = 3;
 hdrNilOriginal = 4;
 hdrCannotRead  = 5;
 hdrCannotWrite = 6;

 { TPktMsg error flags }

 msgOk          = 0;
 msgNotMemory   = 1;
 msgUnknownType = 2;
 msgDamaged     = 3;
 msgLogicalEnd  = 4;
 msgNilOriginal = 5;
 msgCannotRead  = 6;
 msgCannotWrite = 7;

Const
 HeaderError : integer = hdrOk;
 MessageError : integer = msgOk;
 StripKludges : boolean = false;
 Kludges2Strip : array[1..10] of string[20] = ( '', '', '', '', '',
                                               '', '', '', '', '' );

 procedure ResetHdrError;
 procedure ResetMsgError;

Type
 String8 = array[1..8] of char;
 TDateTime = array[1..20] of char;
 String36 = array[1..36] of char;
 String72 = array[1..72] of char;
 HdrType = ( StoneAge, Type2plus, Type2_2 );

Type
 PPktParent = ^TPktParent;
 TPktParent = object( TObject )
  procedure Store( var S : TStream ); virtual;
 end;

 PPktHeader = ^TPktHeader;
 TPktHeader = object( TPktParent )
  OrigNode, DestNode, Year, Month, Day, Hour, Minute, Second, Baud, Version,
  OrigNet, DestNet : integer;
  ProdCodeL, RevLevelMaj : byte;
  Password : String8;
  QOrigZone, QDestZone : integer;
  AuxNet : integer;
  CapWordValid : word;
  ProdCodeH, RevLevelMin : byte;
  CapWord : word;
  OrigZone, DestZone : integer;
  OrigPoint, DestPoint : integer;
  ProductData : longint;
  OrigDomain, DestDomain : String8;
  HeaderType : HdrType;

  constructor Init( var S : TStream );
  constructor Create( AOrigNode, ADestNode, AYear, AMonth, ADay, AHour,
                     AMinute, ASecond, ABaud, AOrigNet, ADestNet,
                     AOrigZone, ADestZone, AOrigPoint, ADestPoint : integer;
                     APassword : String );
  constructor CopyFrom( AHdr : PPktHeader );
  destructor Done; virtual;

  function GetProdCode : word;
    { Hi( GetProdCode ) = ProdCodeH, Lo( GetProdCode ) = ProdCodeL }
  function GetRevisionLevel : word;
    { Hi( GetRevisionLevel ) = RevLevelMaj, Lo( GetRevisionLevel ) = RevLevelMin }

  procedure Store( var S : TStream ); virtual;
 end;

 PPktMsg = ^TPktMsg;
 TPktMsg = object( TPktParent )
  OrigNode, DestNode, OrigNet, DestNet, Attr, Cost : integer;
  Date : TDateTime;
  Too  : String36;
  From : String36;
  Subject : String72;
  TextMsg : PChar;
  ReplaceRussianH : boolean;

  constructor Init( var S : TStream );
  constructor Create( AOrigNode, ADestNode, AOrigNet, ADestNet, AAttr : integer;
                     ADate, AToo, AFrom, ASubject : string;
                     ATextMsg : PChar );
  destructor Done; virtual;

  function GetTextLen : longint;

  function SetTextMsg( var ATextMsg : PChar ) : boolean;

  procedure Store( var S : TStream ); virtual;
 private
  TextLen : word;
 end;

 PNulMsg = ^TNulMsg;
 TNulMsg = object( TPktParent )
  procedure Store( var S : TStream ); virtual;
 end;

 PPktCollection = ^TPktCollection;
 TPktCollection = object( TCollection )
  constructor Init( var S : TStream );
  constructor Create( AMsg : PPktMsg );
  constructor CopyFrom( AMsgs : PPktCollection );
  destructor Done; virtual;

  procedure Store( var S : TStream );
 end;

 PPacket = ^TPacket;
 TPacket = object( TPktParent )
  Header : PPktHeader;
  Messages : PPktCollection;
  EndMsg : PNulMsg;

  constructor Init( var S : TStream );
  constructor Create( var AHeader : PPktHeader; AMsgs : PPktCollection );
  destructor Done; virtual;

  procedure InsertMsg( Msg : PPktMsg );

  procedure Store( var S : TStream ); virtual;
 end;

Implementation
Uses Strings, StrnTTT5;

 function StrDel( S : PChar; i, l : word ) : PChar;
 var
  temp : PChar;
 begin
  temp := StrNew( S );
  if ( i + l ) >= StrLen( temp ) then
   temp[i] := #0
  else
  begin
   Move( temp[i + l], temp[i], StrLen( S ) - l - i );
   temp[StrLen( S ) - l] := #0;
  end;
  StrDel := temp;
 end;

 procedure TPktParent.Store;
 begin
 end;

 constructor TPktHeader.Init;
 var
  data : array[0..57] of byte;
  ver, bd : integer;
  cw, cwv : word;
  str : string[8];
 begin
  FillChar( OrigNode, 78, 0 );
  S.Seek( 0 );
  if ( S.GetSize < 58 ) then begin HeaderError := hdrDamaged; Fail; end;
  S.Read( data, 58 );
  if ( S.Status <> stOk ) then begin HeaderError := hdrCannotRead; Fail; end;
  Move( data[16], bd, 2 );
  Move( data[18], ver, 2 );
  Move( data[40], cwv, 2 );
  cwv := Swap( cwv );
  Move( data[44], cw, 2 );
  if ( ver <> 2 ) then begin HeaderError := hdrUnknownType; Fail; end;
  if ( bd = 2 ) then
   HeaderType := Type2_2
  else if ( ( cw <> cwv ) or ( cw = 0 ) or ( ( cw and $01 ) <> $01 ) )  then
   HeaderType := StoneAge
  else
   HeaderType := Type2plus;
  case HeaderType of
   Type2_2 : begin
              Baud := 2; Version := 2;
              Move( data[0], OrigNode, 4 );
              Move( data[4], OrigPoint, 4 );
              Move( data[20], OrigNet, 4 );
              ProdCodeL := data[24]; RevLevelMaj := data[25];
              Move( data[26], Password, 8 );
              Move( data[34], OrigZone, 4 );
              Move( data[38], OrigDomain, 8 );
              Move( data[46], DestDomain, 8 );
              Move( data[54], ProductData, 4 );
             end;
   StoneAge : begin
               Move( data[0], OrigNode, 34 );
              end;
   Type2plus : begin
                Move( data[0], OrigNode, 58 );
                CapWordValid := cwv;
                if ( ( OrigPoint <> 0 ) and ( OrigNet = -1 ) ) then
                 OrigNet := AuxNet;
                if ( ( OrigZone = 0 ) and ( QOrigZone <> 0 ) ) then
                 OrigZone := QOrigZone;
                if ( ( DestZone = 0 ) and ( QDestZone <> 0 ) ) then
                 DestZone := QDestZone;
                QOrigZone := OrigZone; QDestZone := DestZone;
                AuxNet := 0;
               end;
   end;
 end;

 constructor TPktHeader.Create;
 begin
  OrigNode := AOrigNode; DestNode := ADestNode; OrigNet := AOrigNet;
  DestNet := ADestNet; Year := AYear; Month := AMonth; Day := ADay;
  Hour := AHour; Minute := AMinute; Second := ASecond; Baud := ABaud;
  OrigZone := AOrigZone; DestZone := ADestZone;
  QOrigZone := AOrigZone; QDestZone := ADestZone;
  CapWord := $0100; CapWordValid := $0100;
  OrigPoint := AOrigPoint; DestPoint := ADestPoint;
  Version := $0002; ProdCodeL := $00; RevLevelMaj := $01;
  ProdCodeH := $00; RevLevelMin := $00;
  ProductData := $544B5058; AuxNet := $0000;
  if ( APassword = '' ) then
   FillChar( Password, 8, #0 )
  else
   Move( APassword[1], Password, 8 );
 end;

 constructor TPktHeader.CopyFrom;
 begin
  if ( AHdr = nil ) then begin HeaderError := hdrNilOriginal; Fail; end;
  OrigNode := AHdr^.OrigNode; DestNode := AHdr^.DestNode; OrigNet := AHdr^.OrigNet;
  DestNet := AHdr^.DestNet; Year := AHdr^.Year; Month := AHdr^.Month; Day := AHdr^.Day;
  Hour := AHdr^.Hour; Minute := AHdr^.Minute; Second := AHdr^.Second; Baud := AHdr^.Baud;
  OrigZone := AHdr^.OrigZone; DestZone := AHdr^.DestZone;
  QOrigZone := AHdr^.QOrigZone; QDestZone := AHdr^.QDestZone;
  CapWord := $0100; CapWordValid := $0100;
  OrigPoint := AHdr^.OrigPoint; DestPoint := AHdr^.DestPoint;
  Version := $0002; ProdCodeL := AHdr^.ProdCodeL;
  RevLevelMaj := AHdr^.RevLevelMaj; ProdCodeH := AHdr^.ProdCodeH;
  RevLevelMin := AHdr^.RevLevelMin;
  ProductData := $544b5058; AuxNet := $0000;
  Password := AHdr^.Password;
 end;

 destructor TPktHeader.Done;
 begin
  inherited Done;
 end;

 function TPktHeader.GetProdCode;
 type
  WordRec = record
   Lo, Hi : byte;
  end;
 var
  w : word;
 begin
  WordRec( w ).Hi := ProdCodeH;
  WordRec( w ).Lo := ProdCodeL;
  GetProdCode := w;
 end;

 function TPktHeader.GetRevisionLevel;
 type
  WordRec = record
   Lo, Hi : byte;
  end;
 var
  w : word;
 begin
  WordRec( w ).Hi := RevLevelMaj;
  WordRec( w ).Lo := RevLevelMin;
  GetRevisionLevel := w;
 end;

 procedure TPktHeader.Store;
 begin
  CapWordValid := $0100;
  CapWord := $0001;
  with S do
  begin
   Seek( 0 );
   if ( S.Status <> stOk ) then begin HeaderError := hdrCannotWrite; Exit; end;
   Truncate;
   if ( S.Status <> stOk ) then begin HeaderError := hdrCannotWrite; Exit; end;
   Write( OrigNode, 58 );
   if ( S.Status <> stOk ) then
    HeaderError := hdrCannotWrite;
  end;
 end;

 constructor TPktMsg.Init;
 var
  w, i : word;
  c : char;
  beginpos, endpos, l, sz : longint;
  data : array[1..72] of char;
  temp : PChar;
 begin
  ReplaceRussianH := false;
  FillChar( Too, 36, #0 );
  FillChar( From, 36, #0 );
  FillChar( Subject, 72, #0 ); { 堫, ⨬ }
  sz := S.GetSize;
  if ( sz = 0 ) then begin MessageError := msgDamaged; Fail; end;
  with S do
  begin
   Read( w, 2 );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotRead; Fail; end;
   if ( w = 0 ) then
   begin
    MessageError := msgLogicalEnd;
    Fail; { $0000    -- ਧ  . : ) }
   end;
   if ( w <> 2 ) then
   begin
    MessageError := msgUnknownType;
    Fail; {  砫 ᠣ   2 }
   end;
   beginpos := GetPos;
   if ( ( sz - beginpos ) < 36 ) then
   begin
    MessageError := msgDamaged;
    Fail; { ᫨誮 쪠 ᠣ }
   end;
   Read( OrigNode, 32 );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotRead; Fail; end;
   beginpos := GetPos;
   l := sz - beginpos;
   if ( l >= 36 ) then  { ⠥ y᮪   Too }
    Read( data[1], 36 )
   else
    Read( data[1], l );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotRead; Fail; end;
   i := 1;
   while ( ( data[i] <> #0 ) and ( i < 36 ) ) do { ᪨ y Too }
   begin
    Too[i] := data[i];
    inc( i );
   end;
   inc( beginpos, i );
   Seek( beginpos );
   l := sz - beginpos;
   if ( l >= 36 ) then  { ⠥ y᮪   From }
    Read( data[1], 36 )
   else
    Read( data[1], l );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotRead; Fail; end;
   i := 1;
   while ( ( data[i] <> #0 ) and ( i < 36 ) ) do { ᪨ y From }
   begin
    From[i] := data[i];
    inc( i );
   end;
   inc( beginpos, i );
   Seek( beginpos );
   l := sz - beginpos;
   if ( l >= 72 ) then  { ⠥ y᮪   Subject }
    Read( data[1], 72 )
   else
    Read( data[1], l );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotRead; Fail; end;
   i := 1;
   while ( ( data[i] <> #0 ) and ( i < 72 ) ) do { ᪨ y From }
   begin
    Subject[i] := data[i];
    inc( i );
   end;
   inc( beginpos, i );
   Seek( beginpos );
   c := #255;
   while ( ( c <> #0 ) and ( Status = 0 ) and ( GetPos < sz ) ) do
    Read( c, 1 );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotRead; Fail; end;
   if ( GetPos = sz ) then begin MessageError := msgDamaged; Fail; end;
   endpos := GetPos;
   TextLen := endpos - beginpos;
   Seek( beginpos );
   if ( TextLen > MemAvail ) then
   begin
    MessageError := msgNotMemory; {   墠⨫ }
    Fail;
   end;
   GetMem( temp, TextLen );
   Read( temp^, TextLen );
   TextMsg := StrNew( temp );
   FreeMem( temp, TextLen );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotRead; Fail; end;
  end;
 end;

 constructor TPktMsg.Create;
 var
  str : string;
 begin
  OrigNode := AOrigNode; DestNode := ADestNode; OrigNet := AOrigNet;
  DestNet := ADestNet; Attr := AAttr;
  FillChar( Date, 20, #0 );
  FillChar( Too, 36, #0 );
  FillChar( From, 36, #0 );
  FillChar( Subject, 72, #0 );
  Move( ADate[1], Date, 19 );
  str := Strip( 'R', #0, Copy( AToo, 1, 35 ) );
  Move( str[1], Too[1], Length( str ) );
  str := Strip( 'R', #0, Copy( AFrom, 1, 35 ) );
  Move( str[1], From[1], Length( str ) );
  str := Strip( 'R', #0, Copy( ASubject, 1, 71 ) );
  Move( str[1], Subject[1], Length( str ) );
  TextLen := StrLen( ATextMsg ) + 1;
  if ( TextLen > MemAvail ) then
  begin
   MessageError := msgNotMemory; {   墠⨫ }
   Fail;
  end;
  TextMsg := StrNew( ATextMsg );
  ReplaceRussianH := false;
 end;

 destructor TPktMsg.Done;
 begin
  if ( TextMsg <> nil ) then StrDispose( TextMsg );
  inherited Done;
 end;

 function TPktMsg.GetTextLen;
 begin
  GetTextLen := TextLen;
 end;

 function TPktMsg.SetTextMsg;
 begin
  SetTextMsg := false;
  if ( ATextMsg = nil ) then begin MessageError := msgNilOriginal; Exit; end;
  if ( TextMsg <> nil ) then StrDispose( TextMsg );
  TextLen := StrLen( ATextMsg ) + 1;
  if ( TextLen > MemAvail ) then
  begin
   MessageError := msgNotMemory; {   墠⨫ }
   Exit;
  end;
  TextMsg := StrNew( ATextMsg );
  SetTextMsg := true;
 end;

 procedure TPktMsg.Store;
 var
  w : word;
  i : longint;
  fromname, toname : string[36];
  subj : string[72];
  begstr, endstr, tmp, strup : PChar;
  pc, strp : array[0..150] of char;
 begin
  if ( ReplaceRussianH ) then
   for i := 0 to TextLen do
    if ( TextMsg[i] = #$8D ) then
     TextMsg[i] := #$48;
  if ( StripKludges ) then
  begin
   i := 1;
   FillChar( pc, 150, #0 );
   FillChar( strp, 150, #0 );
   while ( Kludges2Strip[i] <> '' ) do
   begin
    StrPCopy( strp, #1 + Kludges2Strip[i] );
    strup := StrNew( TextMsg );
    StrUpper( strup );
    begstr := StrPos( strup, strp );
    while ( begstr <> nil ) do
    begin
     endstr := StrPos( begstr, #13 );
     if ( endstr <> nil ) then
      tmp := StrDel( TextMsg, longint( begstr - strup ),
                        longint( endstr - begstr ) + 1 );
     StrDispose( TextMsg );
     TextMsg := StrNew( tmp );
     StrDispose( tmp );
     StrDispose( strup );
     strup := StrNew( TextMsg );
     StrUpper( strup );
     begstr := StrPos( strup, strp );
    end;
    StrDispose( strup );
    Inc( i );
   end;
  end;
  fromname[0] := #36;
  Move( From, fromname[1], 36 );
  toname[0] := #36;
  Move( Too, toname[1], 36 );
  subj[0] := #72;
  Move( Subject, subj[1], 72 );
  fromname := Strip( 'R', #0, fromname ) + #0;
  toname := Strip( 'R', #0, toname ) + #0;
  subj := Strip( 'R', #0, subj ) + #0;
  with S do
  begin
   w := $0002;
   Write( w, 2 );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotWrite; Exit; end;
   Write( OrigNode, 32 );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotWrite; Exit; end;
   Write( toname[1], Ord( toname[0] ) );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotWrite; Exit; end;
   Write( fromname[1], Ord( fromname[0] ) );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotWrite; Exit; end;
   Write( subj[1], Ord( subj[0] ) );
   if ( S.Status <> stOk ) then begin MessageError := msgCannotWrite; Exit; end;
   if ( TextMsg = nil ) then begin MessageError := msgCannotWrite; Exit; end;
   Write( TextMsg^, StrLen( TextMsg ) + 1 );
   if ( S.Status <> stOk ) then
    MessageError := msgCannotWrite;
  end;
 end;

 procedure TNulMsg.Store;
 var
   nul : word;
 begin
  nul := $0000;
  S.Write( nul, 2 );
 end;

 constructor TPktCollection.Init;
 var
  msg : PPktMsg;
 begin
  inherited Init( 10, 10 );
  msg := New( PPktMsg, Init( S ) );
  while ( msg <> nil ) do
  begin
   if ( msg <> nil ) then Insert( msg );
   msg := New( PPktMsg, Init( S ) );
  end;
 end;

 constructor TPktCollection.Create;
 begin
  inherited Init( 10, 3 );
  if ( AMsg <> nil ) then Insert( AMsg );
 end;

 constructor TPktCollection.CopyFrom;

  procedure CopyMsg( P : pointer );
  begin
   Self.Insert( PPktMsg( P ) );
  end;

 begin
  inherited Init( AMsgs^.Count, 3 );
  if ( AMsgs <> nil ) then
   AMsgs^.ForEach( @CopyMsg );
 end;

 destructor TPktCollection.Done;
 begin
  inherited Done;
 end;

 procedure TPktCollection.Store;

  procedure StoreItem( P : pointer ); far;
  begin
   PPktMsg( P )^.Store( S );
  end;

 begin
  ForEach( @StoreItem );
 end;

 constructor TPacket.Init;
 begin
  inherited Init;
  Header := New( PPktHeader, Init( S ) );
  if ( Header = nil ) then Fail;
  Messages := New( PPktCollection, Init( S ) );
  EndMsg := New( PNulMsg, Init );
 end;

 constructor TPacket.Create;
 begin
  inherited Init;
  if ( AHeader <> nil ) then Header := New( PPktHeader, CopyFrom( AHeader ) );
  if ( AMsgs <> nil ) then Messages := New( PPktCollection, CopyFrom( AMsgs ) );
  EndMsg := New( PNulMsg, Init );
 end;

 destructor TPacket.Done;
 begin
  if ( Header <> nil ) then Dispose( Header, Done );
  if ( Messages <> nil ) then Dispose( Messages, Done );
  if ( EndMsg <> nil ) then Dispose( EndMsg, Done );
  inherited Done;
 end;

 procedure TPacket.InsertMsg;
 begin
  if ( Msg <> nil ) then
   Messages^.Insert( Msg );
 end;

 procedure TPacket.Store;
 begin
  Header^.Store( S );
  Messages^.Store( S );
  EndMsg^.Store( S );
 end;

 procedure ResetHdrError;
 begin
  HeaderError := hdrOk;
 end;

 procedure ResetMsgError;
 begin
  MessageError := msgOk;
 end;

End.
