{***************************************************************************}
{*                                                                         *}
{*                           䠩.                     *}
{*                                                                         *}
{*       Copyright (c) 1999 by Konstantin Kubatkin, 2:468/13@Fidonet       *}
{*       Copyright (c) 1995 by basil v. vorontsov, 5020/487@Fidonet        *}
{*                                                                         *}
{***************************************************************************}
{$IfDef VirtualPascal}
{&Use32-}
{$EndIf}
Unit LogMgr;

Interface
Uses Objects, TextColl;

Const
  MonthNum: Array [1..12] of String[3]=('Jan','Feb','Mar','Apr','May','Jun',
                                        'Jul','Aug','Sep','Oct','Nov','Dec');

{ ᠭ ୮   ଠ The Brake! 718.a8    }
{   ᫥  :                    }
{ 0,1,2,3,4 - ⥫쭮 ᮡ (UnixTime, LongInt)   }
{ 5,6 -   ଠ樥  ᨨ (BrkBinSesionInfo) }
{ 7 - 祣                                             }
{ 254 -  ᨨ ୮  (byte)               }

{   ଠ樨  ᨨ  ୮  }
Type
  BrkBinSessionHeader = Record
    UnixTime: LongInt;        { p ᮡ                             }
    RecType : Byte            { ⨯ : 0-Answer, 1-Dial, 2-Terminal, }
                              { 3-Bbs, 4-External, 5-In, 6-Out,           }
                              { 7-砫/ ࠡ ,            }
                              { 254- ᨨ ୮            }
  End;

{   ଠ樥  ᨨ  ୮  }
Type
  BrkBinSessionInfo = Record
    Zone, Net, Node, Point: Word;
    sType: Byte;           { ⨯ ᨨ: 0-FTS, 1-WAZOO, 2-EMSI              }
    Protocol: Byte;        { ⮪: 0-ZModem, 1-ZedZap, 2-DirZap, 3-Hydra }
    Crc: Byte;             { CRC: 16  32                                  }
    Elapsed: LongInt;      { த⥫쭮 ᨨ, ᥪ㭤               }
    netSend, netRecv,      { ᫠/祭 ⬥                     }
    xmSend,  xmRecv,       { ᫠/祭 બ                     }
    filesSend, filesRecv: LongInt; { ᫠/祭 䠩               }
    Domain: Array [0..16] of Char  {                              }
  End;

{ TLog error flags }
Const
  logOk          = 0;
  logCannotOpen  = 1;
  logCannotClose = 2;
  logCannotRead  = 3;
  logCannotWrite = 4;

Const
  LogError: Integer = logOk;

Type
  PLog = ^TLog;
  TLog = Object(TObject)
    LogName   : String;
    LogLevel  : String;
    LogTitle  : String;
    LogFile   : Text;
    LogBuffer : LongInt;
    Buf       : PTextCollection;
    { 樠  䠩   nLog, ஢ ஢ lLog }
    {  ⠢ tLog  ஬ bLog. ᫨ bLog >1,     }
    {  १  ࠧ஬  bLog ப                         }
    Constructor Init(nLog, lLog, tLog: String; bLog: LongInt);
    { ᢮  }
    Destructor  Done; virtual;
    { 뢮   ᮮ饭 Message, ᫨ ⠣ Tag  ᯨ᪥ 㯭}
    Procedure LogMsg(Tag: Char; Message: String);
  End;

Type
  PBinBrkLog = ^TBinBrkLog;
  TBinBrkLog = Object(TObject)
    LogName   : String;
    LogFile   : File;
    TZ        : LongInt;
    SesHdr    : BrkBinSessionHeader;
    SesInfo   : BrkBinSessionInfo;
    ReadByte  : LongInt;
    WriteByte : LongInt;
    CurPos    : LongInt;
    { 樠  䠩   nLog, TZ = nTZ }
    Constructor Init(nLog: String; nTZ: LongInt);
    { ᢮  }
    Destructor  Done; virtual;
    { 뢮   ᮮ饭 Message, ᫨ ⠣ Tag  ᯨ᪥ 㯭}
    Procedure ReadHeader;
    Procedure WriteHeader;
    Procedure ReadInfo;
    Procedure WriteInfo;
  End;

Implementation
Uses Tools;

Var
  I: LongInt;

Constructor TLog.Init;
Begin
  LogError:= logOk;
  LogName:= nLog; LogLevel:= lLog; LogTitle:= tLog; LogBuffer:= bLog;
  Assign(LogFile, LogName); {$I-} Reset(LogFile); {$I+}
  If IOResult = 0 Then
    Begin
      {$I-} Close(LogFile); {$I+}
      If IOResult <> 0 Then Begin LogError:= logCannotClose; Fail End
    End
  Else
    Begin
      {$I-} ReWrite(LogFile); {$I+}
      If IOResult <> 0 Then Begin LogError:= logCannotOpen; Fail End;
      {$I-} Close(LogFile); {$I+}
      If IOResult <> 0 Then Begin LogError:= logCannotClose; Fail End;
    End;
  If (LogBuffer > 1) and (LogBuffer*256 > MaxAvail) Then
    Buf:= New(PTextCollection, Init(LogBuffer, 0))
  Else LogBuffer:= 0
End;

Procedure TLog.LogMsg(Tag: Char; Message: String);
Var
  Temp: String;
  Year,Month,Day,DayOfWeek,Hour,Minute,Second,MSecond: Word;
Begin
  LogError:= logOk; Temp:= '';
  If Pos(Tag, LogLevel) > 0 Then
    Begin
      { ⠢ ப     }
      Temp:= Tag + ' ';
      GetDateTime(Year,Month,Day,DayOfWeek,Hour,Minute,Second,MSecond);
      If Day in [0..9] Then Temp:= Temp + '0' + XStr(Day) + ' '
                       Else Temp:= Temp + XStr(Day) + ' ';
      Temp:= Temp + MonthNum[Month] + ' '+XStr(Year)+' ';
      If Hour in [0..9] Then Temp:= Temp + '0' + XStr(Hour) + ':'
                        Else Temp:= Temp + XStr(Hour) + ':';
      If Minute in [0..9] Then Temp:= Temp + '0' + XStr(Minute) + ':'
                          Else Temp:= Temp + XStr(Minute) + ':';
      If Second in [0..9] Then Temp:= Temp + '0' + XStr(Second)
                          Else Temp:= Temp + XStr(Second);
      If LogTitle = '' Then Temp:= Temp + ' ' + Message
                       Else Temp:= Temp + ' ' + LogTitle + ' ' + Message;
      { 뢠   }
      {$I-} Append(LogFile); {$I+}
      If IOResult <> 0 Then Begin LogError:= logCannotOpen; Exit End;
      { ᫨ ࠧ襭  }
      If LogBuffer > 1 Then
        Begin
          Buf^.Insert(NewStr(Temp));
          { ᫨  㦥     ᪨뢠   }
          If Buf^.Count = LogBuffer Then
            Begin
              I:= 0;
              While I < Buf^.Count Do
                Begin
                  {$I-} WriteLn(LogFile, PString(Buf^.At(I))^); {$I+}
                  If IOResult <> 0 Then Begin LogError:= logCannotWrite; Exit End;
                  Inc(I)
                End;
              Buf^.FreeAll
            End
        End
      { ᤨ   }
      Else
        Begin
          {$I-} WriteLn(LogFile, Temp); {$I+}
          If IOResult <> 0 Then Begin LogError:= logCannotWrite; Exit End
        End
    End;
  {$I-} Close(LogFile); {$I+}
  If IOResult <> 0 Then Begin LogError:= logCannotClose; Exit End
End;

Destructor TLog.Done;
Begin
  LogError:= logOk;
  {$I-} Append(LogFile); {$I+}
  If IOResult <> 0 Then
    Begin
      If LogBuffer > 1 Then Dispose(Buf, Done);
      Inherited Done;
      LogError:= logCannotOpen; Exit
    End;
  If LogBuffer > 1 Then
    Begin
      I:= 0;
      While I < Buf^.Count Do
        Begin
          {$I-} WriteLn(LogFile, PString(Buf^.At(I))^); {$I+}
          If IOResult <> 0 Then
            Begin
              Dispose(Buf, Done);
              Inherited Done;
              LogError:= logCannotWrite; Exit
            End;
          Inc(I)
        End;
      Dispose(Buf, Done)
    End;
  {$I-} WriteLn(LogFile); {$I+}
  If IOResult <> 0 Then
    Begin
      If LogBuffer > 1 Then Dispose(Buf, Done);
      Inherited Done;
      LogError:= logCannotWrite; Exit
    End;
  {$I-} Close(LogFile); {$I+}
  If IOResult <> 0 Then
    Begin
      If LogBuffer > 1 Then Dispose(Buf, Done);
      Inherited Done;
      LogError:= logCannotClose; Exit
    End;
  Inherited Done;
End;

Constructor TBinBrkLog.Init;
Var
  I: Byte;
Begin
  LogName:= nLog; TZ:= nTZ; ReadByte:= 0; WriteByte:= 0; CurPos:= 0;
  FillChar(SesHdr, SizeOf(SesHdr), 0); FillChar(SesInfo, SizeOf(SesInfo), 0);
  If FileExist(LogName) <> 0 Then
    Begin
      Assign(LogFile, LogName); ReWrite(LogFile, 1);
      SesHdr.UnixTime:= DateDosToUnix(TZ);
      SesHdr.RecType:= 254; I:= 1;
      BlockWrite(LogFile, SesHdr, SizeOf(SesHdr));
      BlockWrite(LogFile, I, SizeOf(I)); Close(LogFile);
      WriteByte:= SizeOf(SesHdr) + SizeOf(I)
    End
  Else 
    Begin
      Assign(LogFile, LogName); Reset(LogFile, 1);
      WriteByte:= FileSize(LogFile); Close(LogFile)
    End
End;

Procedure TBinBrkLog.ReadHeader;
Begin
  FillChar(SesHdr, SizeOf(SesHdr), 0);
  Assign(LogFile, LogName); Reset(LogFile, 1); Seek(LogFile, WriteByte);
  BlockRead(LogFile, SesHdr, SizeOf(SesHdr)); Close(LogFile);
  ReadByte:= ReadByte + SizeOf(SesHdr)
End;

Procedure TBinBrkLog.WriteHeader;
Begin
  Assign(LogFile, LogName); Reset(LogFile, 1); Seek(LogFile, WriteByte);
  BlockWrite(LogFile, SesHdr, SizeOf(SesHdr)); Close(LogFile);
  WriteByte:= WriteByte + SizeOf(SesHdr); FillChar(SesHdr, SizeOf(SesHdr), 0)
End;

Procedure TBinBrkLog.ReadInfo;
Begin
  FillChar(SesInfo, SizeOf(SesInfo), 0);
  Assign(LogFile, LogName); Reset(LogFile, 1); Seek(LogFile, WriteByte);
  BlockRead(LogFile, SesInfo, SizeOf(SesInfo)); Close(LogFile);
  ReadByte:= ReadByte + SizeOf(SesInfo)
End;

Procedure TBinBrkLog.WriteInfo;
Begin
  Assign(LogFile, LogName); Reset(LogFile, 1); Seek(LogFile, WriteByte);
  BlockWrite(LogFile, SesInfo, SizeOf(SesInfo)); Close(LogFile);
  WriteByte:= WriteByte + SizeOf(SesInfo); FillChar(SesInfo, SizeOf(SesInfo), 0)
End;

Destructor TBinBrkLog.Done;
Begin
  Inherited Done;
End;

End.

