{***************************************************************************}
{*                                                                         *}
{*                         FTN ᨨ                        *}
{*                                                                         *}
{*        Copyright (c) 1996-97 by Cat Kubatkin, 2:468/13@Fidonet          *}
{*                                                                         *}
{***************************************************************************}
{$DEFINE DEBUG}
{$I PLATFORM.DEF}
{$D  FTN ᨨ  }
{$IfDef OS2}
{$DEFINE LongName}
{$EndIf}
{$IfDef WIN32}
{$DEFINE LongName}
{$EndIf}

Program LanFix;
Uses
{$IfDef VirtualPascal}
{$IfDef OS2}
  Os2Def, Os2Base,
{$EndIf}
  CfgMgr, LogMgr, FidoMgr, FreqMgr, TextColl, Tools, Dos, Objects,
  Pkts, Strings, VPUtils, Crt, VpSysLow, TZUtils;
{$EndIf}
{$IfDef MSDOS}
  CfgMgr, LogMgr, FidoMgr, FreqMgr, TextColl, Tools, Dos, Objects,
  Pkts, Strings, TZUtils;
{$EndIf}

{ 䠩  ⮩ 樨 }
Const
  CompileDate = {$I COMP.INC};

{  ᨨ }
Const
{$IfDef OS2}   Copyright = 'LanFix/OS2 2.0.1'; {$EndIf}
{$IfDef Win32} Copyright = 'LanFix/W32 2.0.1'; {$EndIf}
{$IfDef MSDOS} Copyright = 'LanFix/DOS 2.0.1'; {$EndIf}

{   㬮砭 }
Const
  DefDomain: String[7] = 'Fidonet';

{ ப  ᮧ  䠩 }
Const
  BusyStr: String[16] = 'LanFix busy flag';

{ ᠭ ⨯   ᪠  ᪥ }
Type
  PMaskRec = ^TMaskRec;
  TMaskRec = Record
    FileN : String;
    Arg   : String;
    Exec  : Boolean
  End;

{ ᠭ ⨯ ᯨ᪠ ᪠  ᪥ }
Type
  PMaskCollection = ^TMaskCollection;
  TMaskCollection = Object(TCollection)
    Procedure FreeItem(Item: Pointer); Virtual;
  End;

{ ᠭ ⨯   ᠭ  }
Type
  PPointRec = ^TPointRec;
  TPointRec = Record
    Addr      : String[30];
    FIn, FOut, Box, Flag : String
  End;

{ ᠭ ⨯ ᯨ᪠  }
Type
  PPointCollection = ^TPointCollection;
  TPointCollection = Object(TCollection)
    Procedure FreeItem(Item: Pointer); Virtual;
  End;

{ ८। 室  訡 }
Var
  SaveExit: Pointer;

{ ᠭ ᯨ᪠  }
Var
  Domain      : PDomainCollection;
  TempDomain  : PDomainRec;

{ ᠭ ᯨ᪠ ᪠  ᪥ }
Var
  Mask        : PMaskCollection;
  TempMask    : PMaskRec;
  TempTime    : LongInt;
  TempFileName: String;

{ ᠭ ᯨ᪠  }
Var
  Point       : PPointCollection;
  TempRec     : PPointRec;

{ ᠭ ᯨ᪠  ᮧ ࠯⮢  ४ }
Var
  Rep         : PTextCollection;

{ ᠭ ᯨ᪠ 䠩, ਠ祭  *.?lo 䠩 }
Var
  LoArray     : PTextCollection;

{ ᠭ 䨣樮 䠩 }
Var
  Cfg      : PCfg;
  CfgFile  : String;

{ ᠭ ६  ࠡ   }
Var
  Log         : PLog;
  BLog        : PBinBrkLog;
  LogFile     : String;
  LogLevel    : String;
  LogBuf      : LongInt;
  BinLog      : String;

{ ᠭ  ६ }
Var
  MainAddr    : String;
  ParamAddr   : String;
  WorkDir     : String;
  CtlFile     : String;
  MainIn      : String;
  ConfLName   : String;
  NoDelete    : Boolean;
  DelNotFound : Boolean;
  FBox        : Boolean;

{ ᠭ ६  ࠡ  ⡠㭤 }
Var
  BinkRoot    : String;
  LongBinkRoot: String;
  BoxRoot     : String;
  LongBoxRoot : String;
  BinkName    : String;
  LongBinkName: String;
  TBoxName    : String;
  LongBoxName : String;
  TLongBoxName: String;
  BsySemName  : String;
  EnableFBox  : Boolean;

{ ᠭ ६  ࠡ  䫠 }
Var
  MainFlag    : String;
  PBFlag      : String;
  RescanFlag  : String;
  NetFlag     : String;
  TossFlag    : String;
  TicFlag     : String;
  TempFlag    : String;
  SemRoot     : String;
  EnableFlag  : Boolean;
  FlagRescan  : Boolean;

{ ᠭ ६  ࠡ  ४ }
Var
  FrqPwd      : String;
  DirFrq      : String;
  Alias       : String;
  EnableFreq  : Boolean;
  EnableAlias : Boolean;
  Freq        : PFreq;

{ ᠭ ᯮ⥫ ६ }
Var
  F           : Text;
  DirInfo     : SearchRec;
  Temp        : String;
  Temp1       : String;
  PS          : PString;
  CurItem     : Integer;
  I           : Integer;
  InSize      : LongInt;
  OutSize     : LongInt;
  TZ          : LongInt;
  rc          : LongInt;
  Wait        : Boolean;

{$IfDef VirtualPascal}
{$IfDef OS2}
Var
  Prio        : String;
  Delta       : String;
  PClass      : ULong;
{$EndIf}
Var
  Mut         : tSemHandle;
  bMut        : tSemHandle;
  Bus         : array[1..4] of Char;
{$EndIf}

{ ᢮    ᪠  ᪥ }
Procedure TMaskCollection.FreeItem(Item: Pointer);
Begin
  Dispose(PMaskRec(Item))
End;

{ ᢮     }
Procedure TPointCollection.FreeItem(Item: Pointer);
Begin
  Dispose(PPointRec(Item))
End;

{ ᪠  ࠡ  ணࠬ }
Procedure Help;
Begin
  WriteLn(' Usage: LanFix [-c<Path to .ctl file>] [-w] [address for session]');
  ExitProc:= SaveExit; Halt(0)
End;

{ 뢮  p    p SS  ⠣ Tag }
{ ᫨ Cod <> 0  Halt(Cod) }
Procedure Error(Tag: Char; SS: String; Cod: Integer);
Var
  rc: LongInt;
Begin
  { 뢥 ப  ࠭   -䠩 }
  If Pos(Tag, LogLevel) > 0 Then
    Begin
      WriteLn(SS);
      If LogFile <> ErrorID Then Log^.LogMsg(Tag, SS)
    End;
  { ᫨ ந襫 맮 ᫥ 訡 }
  If Cod <> 0 Then
    Begin
      { 塞 ६  䫠 }
      rc:= FileErase(TempFlag);

      {  bsy 䫠 }
      {$IfDef MsDos}
      Error('@', 'Remove busy flag '+BinkName+'.bsy', 0);
      rc:= FileErase(BinkName+'.bsy');
      Error('&', 'Erase file '+BinkName+'.bsy. rc = '+XStr(rc), 0);
      If rc <> 0 Then Error('?', GetError(rc), 0);
      {$EndIf}
      {$IfDef LongName}
      If SemRoot <> ErrorID Then
        Begin
          Error('@', 'Remove busy flag '+BsySemName, 0);
          SemCloseMutex(bMut)
        End
      Else
        Begin
          If BinkRoot <> ErrorID Then
            Begin
              Error('@', 'Remove busy flag '+BinkName+'.bsy', 0);
              rc:= FileErase(BinkName+'.bsy');
              Error('&', 'Erase file '+BinkName+'.bsy. rc = '+XStr(rc), 0);
              If rc <> 0 Then Error('?', GetError(rc), 0)
            End;
          If LongBinkRoot <> ErrorID Then
            Begin
              Error('@', 'Remove busy flag '+LongBinkName+'.Busy', 0);
              rc:= FileErase(LongBinkName+'.Busy');
              Error('&', 'Erase file '+LongBinkName+'.Busy. rc = '+XStr(rc), 0);
              If rc <> 0 Then Error('?', GetError(rc), 0)
            End
        End;
      {$EndIf}

      {     砭 ࠡ }
      Error('+','end, ' + Copyright, 0);
      BLog^.SesHdr.UnixTime:= DateDosToUnix(BLog^.TZ); BLog^.SesHdr.RecType:= 7;
      BLog^.WriteHeader;
{$IfDef VirtualPascal}
      WriteLn('Close semaphor \SEM32\Fido\LanFix\lanfix.run.');
      SemCloseMutex(Mut);
{$EndIf}
      { ᢮   ᪨ ᨢ }
      If Log <> nil Then Dispose(Log, Done);
      If BLog <> nil Then Dispose(BLog, Done);
      If Cfg <> nil Then Dispose(Cfg, Done);
      If Domain <> nil Then Dispose(Domain, Done);
      If Mask <> nil Then Dispose(Mask, Done);
      If Point <> nil Then Dispose(Point, Done);
      If Freq <> nil Then Dispose(Freq, Done);
      If Rep <> nil Then Dispose(Rep, Done);
      If LoArray <> nil Then Dispose(LoArray, Done);
      { 祭   室   Cod }
      ShowCursor; ExitProc:= SaveExit; Halt(Cod)
    End
End;

Procedure MyExit;
{$IfDef VirtualPascal}
Var
  FileName: String;
  LineNo  : LongInt;
Begin
  If ExitCode <> 0 Then
    Begin
      Error('!', 'A run-time error #'+XStr(ExitCode)+' occured while running '+Copyright, 0);
      Error('!', 'Possible cause: '+RTGetError(ExitCode), 0);
      If GetLocationInfo(ErrorAddr, FileName, LineNo) <> nil Then
        Error('!', 'Fault address: '+Ptr2Hex(ErrorAddr)+' ('+FileName+'#'+XStr(LineNo-1)+')', 0);
      ExitCode:= 0; ErrorAddr:= nil;
      Error('!', 'Please mail to author.', 13)
    End
{$EndIf}
{$IfDef MSDOS}
Begin
  If ErrorAddr <> nil Then
    Begin
      Error('!', 'A run-time error #'+XStr(ExitCode)+' occured while running '+Copyright, 0);
      Error('!', 'Possible cause: '+RTGetError(ExitCode), 0);
      Error('!', 'Fault address: '+Ptr2Hex(ErrorAddr), 0);
      ExitCode:= 0; ErrorAddr:= nil;
      Error('!', 'Please mail to author.', 13)
    End
{$EndIf}
End;

{ PKT}
Function GenPkt(PktName: String): Boolean;
Const
  Month: Array [1..12] of String[3]=('Jan','Feb','Mar','Apr','May','Jun',
                                     'Jul','Aug','Sep','Oct','Nov','Dec');

Var
  Pkt      : PPacket;
  PktMsg   : PPktMsg;
  PktText  : PPktCollection;
  PktHeader: PPktHeader;
  FN       : PDosStream;
  sAType, dAType: AddrType;
{$IfDef VirtualPascal}
  Y,M,D,DOW: LongInt;
  H,Mi,S,S100: LongInt;
  TextBuffer: Array[1..$ffff] of Char;
{$Else}
  Y,M,D,DOW: Word;
  H,Mi,S,S100: Word;
  TextBuffer: Array[1..$fff] of Char;
{$EndIf VirtualPascal}
  I: Integer;
  CurrentPosition: LongInt;
  TextRep  : PChar;
  Temp: String;

Procedure PutString(TempStr: String);
Var J: LongInt;
Begin
  For J:= 1 to Length(TempStr) Do
    Begin TextBuffer[CurrentPosition]:= TempStr[J]; Inc(CurrentPosition) End;
End;

Begin
  CurrentPosition:= 1; FillChar(TextBuffer, SizeOf(TextBuffer), #0);

  If not SplitAddr(MainAddr, sAType) Then Exit;
  If not SplitAddr(PPointRec(Point^.At(CurItem))^.Addr, dAType) Then Exit;

  GetDate(Y, M, D, DOW); GetTime(H, Mi, S, S100);

  PktHeader:= New(PPktHeader);
  PktHeader^.Create(XVal(sAType.Node),
                    XVal(dAType.Node),
                    Y, M, D, H, Mi, S,
                    9600,
                    XVal(sAType.Net),
                    XVal(dAType.Net),
                    XVal(sAType.Zone),
                    XVal(dAType.Zone),
                    XVal(sAType.Point),
                    XVal(dAType.Point),
                    '');

  { ⮢ ⥪ }
  PutString(#01+'MSGID: '+MainAddr+' '+UniqueID+#13);
  PutString(#01+'INTL '+dAType.Zone+':'+dAType.Net+'/'+dAType.Node+' '+sAType.Zone+':'+sAType.Net+'/'+sAType.Node+#13);
  If sAType.Point <> '0' Then PutString(#01+'FMPT '+sAType.Point+#13);
  If dAType.Point <> '0' Then PutString(#01+'TOPT '+dAType.Point+#13);
  PutString(#13+' File               Status'+#13);
  PutString('----------------------------------------------------'+#13);

  I:= 0;
  While I < Rep^.Count Do Begin PutString(PString(Rep^.At(I))^); Inc(I) End;
  PutString(#13+'--- '+Copyright+#13);
  GetMem(TextRep, SizeOf(TextBuffer));
  Move(TextBuffer, TextRep^, SizeOf(TextBuffer));

  { ⮢  }
  If D in [0..9] Then Temp:= '0' + XStr(D) + ' ' Else Temp:= XStr(D) + ' ';
  Temp:= Temp + Month[M] + ' ';
  Temp:= Temp + Copy(XStr(Y), 3, 2) + '  ';
  If H in [0..9] Then Temp:= Temp + '0' + XStr(H) + ':'
    Else Temp:= Temp + XStr(H) + ':';
  If Mi in [0..9] Then Temp:= Temp + '0' + XStr(Mi) + ':'
    Else Temp:= Temp + XStr(Mi) + ':';
  If S in [0..9] Then Temp:= Temp + '0' + XStr(S)
    Else Temp:= Temp + XStr(S) + #0;

  PktMsg:= New(PPktMsg);
  PktMsg^.Create(XVal(sAType.Node),
                 XVal(dAType.Node),
                 XVal(sAType.Net),
                 XVal(dAType.Net),
                 0,
                 Temp,
                 'Sysop'+#0,
                 Copyright,
                 'Freq report'+#0,
                 TextRep);

  PktText:= New(PPktCollection); PktText^.Create(PktMsg);
  Pkt:= New(PPacket); Pkt^.Create(PktHeader, PktText);
  FN:= New(PDosStream, Init(PktName, stCreate)); Pkt^.Store(FN^);

  FreeMem(TextRep, SizeOf(TextBuffer))
End;

Procedure FidoFileCopy(sName, dName, IO: String; Mode: Byte);
Var
{$IfDef VirtualPascal}
  D, N, E    : String;
  D1, N1, E1 : String;
{$Else}
  D, D1      : DirStr;
  N, N1      : NameStr;
  E, E1      : ExtStr;
{$EndIf}
  rc         : LongInt;
Begin
  FSplit(sName, D, N, E); FSplit(dName, D1, N1, E1);
  { pp 䠩  ⢮ }
  While FileExist(dName) = 0 Do
     Begin
       E:= UpCaseStr(E);
       If E = '' Then E:= '.1';
       If E[4]= 'Z' Then dName:= D1+UniqueID+E1
         Else
           Begin
             If E[4]= '9' Then E[4]:= 'A' Else E[4]:= Succ (E[4]);
             dName:= D1+N1+E
           End
     End;
  If Mode = 0 Then Error(':','Copy ' +sName+' to '+dName, 0)
    Else Error(':','Move ' +sName+' to '+dName, 0);
  rc:= FileCopy(sName, dName);
  Error('&','Copy file '+sName+' to '+dName+'. rc = '+XStr(rc), 0);
  If rc = 0 Then
    Begin
      If IO = 'IN' Then
        If GetType(sName)='MAIL' Then BLog^.SesInfo.netRecv:=BLog^.SesInfo.netRecv+FileLength(sName)
        Else If GetType(sName)='XMAIL' Then BLog^.SesInfo.xmRecv:=BLog^.SesInfo.xmRecv+FileLength(sName)
             Else BLog^.SesInfo.filesRecv:= BLog^.SesInfo.filesRecv+FileLength(sName)
      Else
        If GetType(sName)='MAIL' Then BLog^.SesInfo.netSend:=BLog^.SesInfo.netSend+FileLength(sName)
        Else If GetType(sName)='XMAIL' Then BLog^.SesInfo.xmSend:=BLog^.SesInfo.xmSend+FileLength(sName)
             Else BLog^.SesInfo.filesSend:= BLog^.SesInfo.filesSend+FileLength(sName);
      If Mode <> 0 Then
        Begin
          rc:= FileErase(sName);
          Error('&','Erase file '+sName+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End
    End
End;

{ p  䠩  pp. }
Procedure CopyDir(FromPath, ToPath, IO: String);
Var
  DirInfo: SearchRec;
Begin
  FindFirst(FromPath+'*.*', (AnyFile and not VolumeID and not Directory), DirInfo);
  { ஢ઠ  稥 䠩  ४ਨ }
  If DosError = 0 Then
    If FBox Then Error('#','Processing FileBox '+DelSlash(FromPath), 0)
      Else Error('#','Processing directory '+DelSlash(FromPath), 0);
  { ᫨ ,  ६頥 }
  While DosError = 0 Do
    Begin
      FidoFileCopy(FromPath+DirInfo.Name, ToPath+DirInfo.Name, IO, 1);
      FlagRescan:= True; FindNext(DirInfo)
    End;
{$IfDef VirtualPascal} FindClose(DirInfo) {$EndIf}
End;

{ p뢠 *.?lo 䠩 }
Procedure ProcessLo(FromPath, ToPath: String);
Var
  FH  : Text;
  D   : DirStr;
  N   : NameStr;
  E   : ExtStr;
  rc  : LongInt;
  I   : Integer;
  PTemp    : PString;
  Temp     : String;
  Copy     : Boolean;
  Move     : Boolean;
  Trunc    : Boolean;
Begin
  { ⥭ 誨   }
  If not ReadLoFile(FromPath, LoArray) Then
    Begin Error('?', 'Error open '+FromPath, 0); Exit End;
  { p⪠ 誨   }
  I:= 0;
  While I < LoArray^.Count Do
    Begin
      { 樠 ६ }
      Move:= False; Copy:= False; Trunc:= False;
      { ⠥  뫪  誨 }
      PTemp:= LoArray^.At(I); Temp:= PTemp^;
      { ।塞,  㦭   䠩 }
      { ᫨   ᪮஢,  ⮬ 㤠 }
      If Temp[1] = '^' Then
        Begin
          Delete(Temp, 1, 1); FSplit(Temp, D, N, E);
          Copy:= True; Move:= True
        End
      Else
        { ᫨   ᪮஢,  ⮬ 㫨 }
        If Temp[1] = '#' Then
          Begin
            Delete(Temp, 1, 1); FSplit(Temp, D, N, E);
            {    㫨,  㤠? ࠬ Delete  䨣 }
            If NoDelete Then Trunc:= True Else Move:= True;
            Copy:= True
          End
        Else
          { ᫨   ய }
          If Temp[1] = '~' Then Begin Inc(I); Continue End
          {  -  ᪮஢ }
          Else
            Begin
              FSplit(Temp, D, N, E);
              Copy:= True
            End;
      { ᫨ 䠩  , 㤠  ⠢ }
      {   ࠬ  䨣 RemoveNotFound }
      If FileExist(Temp) <> 0 Then
        If DelNotFound Then
          Begin
            LoArray^.Delete(PTemp);
            Error('?', 'File '+Temp+' not found. Remove.', 0);
            Continue
          End
        Else
          Begin
            Error('?', 'File '+Temp+' not found. Skip.', 0);
            Inc(I); Continue
          End;
      { ᫨ 䠩  ᪮஢ }
      If Copy Then
        Begin
          { 㥬 䠩 }
          FidoFileCopy(Temp, ToPath+N+E, 'OUT', 0);
          {  ᫨   㦭  㤠 }
          If Move Then
            Begin
              rc:= FileErase(Temp);
              Error('&','Erase file '+Temp+'. rc = '+XStr(rc), 0);
              If rc <> 0 Then Error('?', GetError(rc), 0);
            End
          Else
            {  䠩  㫨 }
            If Trunc Then
              Begin
                rc:= FileCreate(Temp);
                Error('&', 'Truncate file '+Temp+'. rc = '+XStr(rc), 0);
                If rc <> 0 Then Error('?', GetError(rc), 0)
              End;
          { 塞   樨, 뢥訢 䫠  ᪠ }
          LoArray^.Delete(PTemp); FlagRescan:= True
        End
    End;
  { ᫨  誥  ⠫ 뫪 }
  If LoArray^.Count > 0 Then
    If not WriteLoFile(FromPath, LoArray) Then Error('?', 'Error write '+FromPath, 0)
       Else Error(':', 'Write file '+FromPath, 0)
  Else
    Begin
      rc:= FileErase(FromPath);
      Error('&','Erase file '+FromPath+'. rc = '+XStr(rc), 0);
      If rc <> 0 Then Error('?', GetError(rc), 0)
    End
End;

{ p⪠ 䠩 }
Procedure CopyFileBox(FromPath, ToPath: String);
Var
  DirInfo: SearchRec;
  Temp   : String;
Begin
  FromPath:= AddSlash(FromPath);
  Temp:= FromPath + 'tobesend.$$$';
  { ஢ઠ  tobesend.$$$. ᫨ ,  ࠡ뢠   .?lo }
  If FileExist(Temp) = 0 Then
    Begin
      Error('#','Processing '+Temp, 0);
      ProcessLo(Temp, ToPath)
    End;
  { ࠡ뢠 ᠬ 䠩 }
  FBox:= True; CopyDir(FromPath, ToPath, 'OUT'); FBox:= False;
  { 塞 䠩  ஢મ,      㤠 ? }
  FindFirst(FromPath+'*.*', (AnyFile and not VolumeID and not Directory), DirInfo);
  If DosError <> 0 Then
    Begin
      FromPath:= DelSlash(FromPath);
      {$I-} RmDir(FromPath); {$I+}
      Error('&','Erase directory '+FromPath+'. rc = '+XStr(IOResult), 0);
      If IOResult <> 0 Then Error('?', GetError(IOResult), 0)
    End;
{$IfDef VirtualPascal} FindClose(DirInfo) {$EndIf}
End;

{ p⪠ ᪮ ⡠㭤 }
Procedure ProcessBinkOut(FromPath, ToPath: String);
Var
  sName : String;
  dName : String;
  rc    : LongInt;
Begin
  {   뫠 }
  sName:= FromPath+'.iut'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.cut'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.dut'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.out'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.nut'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.hut'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  {  襪 }
  sName:= FromPath+'.ilo';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.clo';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.dlo';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.flo';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.nlo';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.hlo';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0);
      ProcessLo(sName, ToPath)
    End;

  {  䠩 pᮢ }
  sName:= FromPath+'.req'; dName:= ToPath+'files.req';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End
End;

{ p⪠   ⡠㭤 }
Procedure ProcessLongBinkOut(FromPath, ToPath: String);
Var
  sName : String;
  dName : String;
  rc    : LongInt;
Begin
  {   뫠 }
  sName:= FromPath+'.Immediate.Mail'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.Crash.Mail'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.Direct.Mail'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.Normal.Mail'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  sName:= FromPath+'.Hold.Mail'; dName:= ToPath + UniqueID + '.pkt';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End;

  {  襪 }
  sName:= FromPath+'.Immediate.List';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.Crash.List';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.Direct.List';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.Normal.List';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  sName:= FromPath+'.Hold.List';
  If FileExist(sName) = 0 Then
    Begin
      Error('#','Processing ' + sName, 0); ProcessLo(sName, ToPath)
    End;

  {  䠩 pᮢ }
  sName:= FromPath+'.Request'; dName:= ToPath+'files.req';
  If FileExist(sName) = 0 Then
    Begin
      Error(':','Move ' +sName+' to '+dName, 0);
      FidoFileCopy(sName, dName, 'OUT', 1)
    End
End;

{ p⪠ p }
Procedure ProcessFrq;
Var
  FH     : Text;
  FH1    : Text;
  Buf    : Array [1..255] of Char;
  Temp   : String;
  Temp1  : String;
  FrqName: String;
  ListFrq: String;
  Password: String;
  RealName: String;
  FI     : String;
  I      : Word;
  rc     : LongInt;

{ ᨬ १ ࠡ⪨ ४    ४ }
Procedure InsToRep(Line: String);
Var
  Temp : String;
  I    : Integer;
Begin
  Temp:= ' '+RealName;
  For I:= 1 To (20 - (Length(RealName)+1)) Do Temp:= Temp+' ';
  Temp:= Temp+Line;
  If Temp[Length(Temp)] <> #13 Then Temp:= Temp + #13;
  PS:= NewStr(Temp); Rep^.Insert(PS)
End;

{ 㥬 䠩,   ࠡ⪥ ४ }
Procedure CopyReqFile(sName, dName: String);
Var
  D : DirStr;
  N : NameStr;
  E : ExtStr;
Begin
  FSplit(sName, D, N, E); RealName:= N+E;
  Error(':','Copy ' +sName+' to '+dName+RealName, 0);
  FidoFileCopy(sName, dName+RealName, 'OUT', 0)
{
  Error('&','Copy file '+sName+' to '+dName+RealName+'.rc = '+XStr(rc), 0);
  If rc <> 0 Then
    Begin InsToRep('File not found.'); Error('?', GetError(rc), 0) End
  Else
    Begin InsToRep('Send'); SesInfo.filesSend:= SesInfo.filesSend + FileLength(sName) End
}
End;

Begin
  { 樠 ६ }
  FrqName:= '0'; Password:= '0'; Temp:= '0';
  ListFrq:= PPointRec(Point^.At(CurItem))^.FOut+'files.req';
  FI:= PPointRec(Point^.At(CurItem))^.FIn;

  { 뢠 䠩 }
  Assign(FH, ListFrq); {$I-} Reset(FH); {$I+}
  If IOResult <> 0 Then Begin Error('?', GetError(IOResult), 0); Exit End;

  SetTextBuf(FH, Buf, SizeOf(Buf));
  While not EOF(FH) Do
    Begin
      ReadLn(FH, Temp);
      { pᨭ p p  :  䠩  -  p }
      If Pos('!', Temp) > 0 Then
        Begin
          FrqName:= UpCaseStr(RemoveSpaces(Copy(Temp,1 ,Pos('!', Temp)-1)));
          Password:= RemoveSpaces(Copy(Temp,Pos('!', Temp)+1,Length(Temp)))
        End
      Else FrqName:= UpCaseStr(RemoveSpaces(Temp));
      If FrqName = '' Then Continue Else RealName:= FrqName;

      { p    }
      If (Pos(':\', FrqName) = 2) Then
        If Password <> FrqPwd Then InsToRep('Password error')
        Else
          Begin CopyReqFile(FrqName, FI); Continue End;

      {  p ᮢ }
      If EnableAlias Then
        Begin
          Temp:= Freq^.FindInAlias(FrqName);
          If Temp <> ErrorID Then
            Begin
              { ᫨ ᯨ᮪ 䠩 }
              If Pos('@', Temp) = 1 Then
                Begin
                  Assign(FH1, Temp); {$I-} Reset(FH1); {$I+}
                  If IOResult <> 0 Then Begin Error('?', GetError(IOResult), 0); Continue End;
                  SetTextBuf(FH1, Buf, SizeOf(Buf));
                  While not EOF(FH1) Do
                    Begin
                      ReadLn(FH1, Temp1);
                      CopyReqFile(RemoveSpaces(Temp1), FI)
                    End;
                  Close(FH1)
                End
              Else
                Begin CopyReqFile(Temp, FI); Continue End;
            End
        End;

      {  p p }
      Temp:= Freq^.FindInFreq(FrqName, Password);
      If Temp = 'PError' Then InsToRep('Password error')
      Else
        If Temp <> ErrorID Then CopyReqFile(Temp, FI)
          Else InsToRep('File not found.')
    End;
  Close(FH);

{$IfDef VirtualPascal}
  If GenPkt(FI+UniqueID+'.pkt')
    Then Error('#', 'Create freq report '+FI+UniqueID+'.pkt', 0)
    Else Error('#', 'Error create freq report '+FI+UniqueID+'.pkt', 0);
{$EndIf}

  rc:= FileErase(ListFrq);
  Error('&','Erase file '+ListFrq+'.rc = '+XStr(rc), 0);
  If rc <> 0 Then Error('?', GetError(rc), 0)
End;

{   }
Procedure Session;
Var
  DirInfo: SearchRec;
  aType  : AddrType;
  Addr   : String;
  FIn    : String;
  FOut   : String;
  Box    : String;
  Flag   : String;
  Temp   : String;
  rc     : LongInt;
  pTemp  : PChar;
  Hour,Minute,Second,Sec100: Word;
  DT     : DateTime;
  T      : LongInt;
  T1     : LongInt;
  I      : Byte;
  BinF   : File;
Begin
  Addr:= PPointRec(Point^.At(CurItem))^.Addr;
  FIn:=  PPointRec(Point^.At(CurItem))^.FIn;
  FOut:= PPointRec(Point^.At(CurItem))^.FOut;
  Box:=  PPointRec(Point^.At(CurItem))^.Box;
  Flag:= PPointRec(Point^.At(CurItem))^.Flag;

  Error('#','Session with '+Addr, 0);
  InSize:= 0; OutSize:= 0;
  GetTime(Hour, Minute, Second, Sec100);
  DT.Hour:= Hour; DT.Min:= Minute; DT.Sec:= Second; PackTime(DT, T);

  { ᫥ Bink style  }
  { BinkName  - standart BinkName }
  { LBinkName - long style BinkName }
  { TBoxName  - T-Mail style filebox }
  { LBoxName  - Brake! style filebox }
  { TLBoxName - T-Mail style long filebox }
  BinkName:= GetBinkName(Addr, Domain);
  If BinkName = ErrorID Then
    Begin Error('!', 'Error in address '+Addr, 0); Exit End;
  BinkName:= BinkRoot + BinkName;
  TBoxName:= BoxRoot + GetTBoxName(Addr);
{$IfDef LongName}
  Temp:= GetLongName(Addr);
  LongBinkName:= LongBinkRoot + Temp;
  LongBoxName:= LongBoxRoot + Temp;
  BsySemName:= SemRoot + Temp;
  TLongBoxName:= LongBoxRoot + GetTLongBoxName(Addr);
{$EndIf}

  { ஢ઠ     }
{$IfDef MsDos}
  { ᫨ ୥ ⠫   ,  ᮧ  }
  Temp:= BinkName;
  While Temp[Length(Temp)] <> '\' Do Temp[0]:= Chr(Ord(Temp[0]) - 1);
  If not ExistDir(Temp) Then
    Begin
      Error('@', 'Create dir '+Temp, 0); rc:= CrDir(Temp);
      Error('&', 'Create dir '+Temp+'. rc = '+XStr(rc), 0);
      If rc <> 0 Then Error('?', GetError(rc), 0)
    End;
    Error('@', 'Create busy flag '+BinkName+'.bsy', 0);
    If not CreateBinkBusy(BinkName,'.bsy',BusyStr) Then
      Begin Error('?','System '+Addr+' is busy', 0); Exit End;
{$EndIf}
{$IfDef LongName}
  If SemRoot <> ErrorID Then
    Begin
      Error('@', 'Create busy flag '+BsySemName, 0);
      GetMem(pTemp, Length(BsySemName)+1); StrPCopy(pTemp, BsySemName);
      bMut:= SemCreateMutex(pTemp, True, False);
      FreeMem(pTemp, Length(BsySemName)+1);
      If bMut = -1 Then Begin Error('?','System '+Addr+' is busy', 0); Exit End
    End
  Else
    Begin
      If BinkRoot <> ErrorID Then
        Begin
          { ᫨ ୥ ⠫   ,  ᮧ  }
          Temp:= BinkName;
          While Temp[Length(Temp)] <> '\' Do Temp[0]:= Chr(Ord(Temp[0]) - 1);
          If not ExistDir(Temp) Then
            Begin
              Error('@', 'Create dir '+Temp, 0); rc:= CrDir(Temp);
              Error('&', 'Create dir '+Temp+'. rc = '+XStr(rc), 0);
              If rc <> 0 Then Error('?', GetError(rc), 0)
            End;
          Error('@', 'Create busy flag '+BinkName+'.bsy', 0);
          If not CreateBinkBusy(TempFlag, BinkName+'.bsy') Then
            Begin Error('?','System '+Addr+' is busy', 0); Exit End
        End;
      If LongBinkRoot <> ErrorID Then
        Begin
          Error('@', 'Create busy flag '+LongBinkName+'.Busy', 0);
          If not CreateBinkBusy(TempFlag, LongBinkName+'.Busy') Then
            Begin Error('?','System '+Addr+' is busy', 0); Exit End
        End
    End;
{$EndIf}

  { 室  }
  Error(':',' Incoming session', 0);

  If not ExistDir(FOut) Then Error('?','Path FileOut for '+Addr+' not exist', 0)
  Else
    If FileExist(FOut+PBFlag) <> 0 Then
      Begin
        {  室 ० }
        {  *.?ut }
        FindFirst(FOut+'*.?ut', AnyFile, DirInfo);
        While DosError = 0 Do
          Begin
            Temp:= MainIn+UniqueID+'.pkt';
            Error(':','Move ' +DirInfo.Name+' to '+Temp, 0);
            FidoFileCopy(DirInfo.Name, Temp, 'IN', 1);
            FindNext(DirInfo)
          End;
{$IfDef VirtualPascal} FindClose(DirInfo); {$EndIf}

        {  *.?lo }
        FindFirst(FOut + '*.?lo', AnyFile, DirInfo);
        While DosError = 0 Do
          Begin
            Error('@','Found '+DirInfo.Name+'. Deleted.', 0);
            rc:= FileErase(FOut + DirInfo.Name);
            Error('&','Erase file '+DirInfo.Name+'. rc = '+XStr(rc), 0);
            If rc <> 0 Then Error('?', GetError(rc), 0);
            FindNext(DirInfo)
          End;
{$IfDef VirtualPascal} FindClose(DirInfo); {$EndIf}

        { ᫨ ४ ࠧ襭   䠩  ᯨ᪮ 䠩 }
        If EnableFreq and (FileExist(FOut + 'files.req') = 0) Then
          Begin
            Error('#','Processing request list '+FOut+'files.req', 0);
            ProcessFrq
          End;

        CopyDir(FOut, MainIn, 'IN')
      End;
  { 室  }
  Error(':',' Outgoing session', 0);

  If not ExistDir(FIn) Then Error('?','Path FileIn for '+Addr+' not exist', 0)
  Else
    If FileExist(FIn + PBFlag) <> 0 Then
      Begin
        { ࠡ뢠 Bink OutBound }
        If BinkRoot <> ErrorID Then ProcessBinkOut(BinkName, FIn);
        If LongBinkRoot <> ErrorID Then ProcessLongBinkOut(LongBinkName, FIn);

        { ࠡ뢠  䠩 }
        If ExistDir(Box) Then
          Begin FBox:= True; CopyDir(Box, FIn, 'OUT'); FBox:= False End;

        { ࠡ뢠 䠩 }
        If BoxRoot <> ErrorID Then
          Begin
            {  T-Mail style filebox }
            {   宫 䠩 }
            If ExistDir(TBoxName) Then CopyFileBox(TBoxName, FIn);
            {  宫 䠩 }
            If ExistDir(TBoxName+'H') Then CopyFileBox(TBoxName+'H', FIn)
          End;
        If LongBoxRoot <> ErrorID Then
          Begin
            {  Brake! style filebox }
            {  Immediate 䠩 }
            If ExistDir(LongBoxName + '.Immediate') Then
              CopyFileBox(LongBoxName + '.Immediate', FIn);
            {  Crash 䠩 }
            If ExistDir(LongBoxName + '.Crash') Then
              CopyFileBox(LongBoxName + '.Crash', FIn);
            {  Direct 䠩 }
            If ExistDir(LongBoxName + '.Direct') Then
              CopyFileBox(LongBoxName + '.Direct', FIn);
            {  Normal 䠩 }
            If ExistDir(LongBoxName + '.Normal') Then
              CopyFileBox(LongBoxName + '.Normal', FIn);
            {  Hold 䠩 }
            If ExistDir(LongBoxName + '.Hold') Then
              CopyFileBox(LongBoxName + '.Hold', FIn);
            {  T-Mail style long filebox }
            {   宫 䠩 }
            If ExistDir(TLongBoxName) Then CopyFileBox(TLongBoxName, FIn);
            {  宫 䠩 }
            If ExistDir(TLongBoxName+'.H') Then CopyFileBox(TLongBoxName+'.H', FIn)
          End
      End;

  { 뢥訢 䫠   }
  If ExistDir(Flag) Then
    Begin
      { ᫨  p ⬥,  ᮧ 䫠 }
      If ExistPkt(FIn) and (NetFlag <> ErrorID) Then
        Begin
          Error('@','Create flag '+NetFlag, 0);
          rc:= FileCreate(Flag + NetFlag);
          Error('&','Create file '+NetFlag+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End;
      { ᫨ 뫨 p ,  ᮧ 䫠 }
      If ExistArc(FIn) and (TossFlag <> ErrorID) Then
        Begin
          Error('@','Create flag '+TossFlag, 0);
          rc:= FileCreate(Flag + TossFlag);
          Error('&','Create file '+TossFlag+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End;
      { ᫨ 뫨 p 䠩,  ᮧ 䫠 }
      If ExistTic(FIn) and (TicFlag <> ErrorID) Then
        Begin
          Error('@','Create flag '+TicFlag, 0);
          rc:= FileCreate(Flag + TicFlag);
          Error('&','Create file '+TicFlag+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End
    End;

  {  bsy 䫠 }
{$IfDef MsDos}
  Error('@', 'Remove busy flag '+BinkName+'.bsy', 0);
  rc:= FileErase(BinkName+'.bsy');
  Error('&', 'Erase file '+BinkName+'.bsy. rc = '+XStr(rc), 0);
  If rc <> 0 Then Error('?', GetError(rc), 0);
{$EndIf}
{$IfDef LongName}
  If SemRoot <> ErrorID Then
    Begin
      Error('@', 'Remove busy flag '+BsySemName, 0);
      SemCloseMutex(bMut)
    End
  Else
    Begin
      If BinkRoot <> ErrorID Then
        Begin
          Error('@', 'Remove busy flag '+BinkName+'.bsy', 0);
          rc:= FileErase(BinkName+'.bsy');
          Error('&', 'Erase file '+BinkName+'.bsy. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End;
      If LongBinkRoot <> ErrorID Then
        Begin
          Error('@', 'Remove busy flag '+LongBinkName+'.Busy', 0);
          rc:= FileErase(LongBinkName+'.Busy');
          Error('&', 'Erase file '+LongBinkName+'.Busy. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End
    End;
{$EndIf}

  InSize:= BLog^.SesInfo.netRecv + BLog^.SesInfo.xmRecv + BLog^.SesInfo.filesRecv;
  OutSize:= BLog^.SesInfo.netSend + BLog^.SesInfo.xmSend + BLog^.SesInfo.filesSend;
  Error('#', 'Send/Receive: '+XStr(OutSize)+'/'+XStr(InSize)+ ' bytes.', 0);

  {     }
  If (BinLog <> ErrorID) and ((InSize <> 0) or (OutSize <> 0)) Then
    Begin
      { 樠   ୮  }
      BLog^.SesHdr.UnixTime:= DateDosToUnix(BLog^.TZ); BLog^.SesHdr.RecType:= 6;
      SplitAddr(Addr, aType);
      BLog^.SesInfo.Zone:= Word(XVal(aType.Zone));
      BLog^.SesInfo.Net:= Word(XVal(aType.Net));
      BLog^.SesInfo.Node:= Word(XVal(aType.Node));
      BLog^.SesInfo.Point:= Word(XVal(aType.Point));
      BLog^.SesInfo.sType:= 0;
      BLog^.SesInfo.Protocol:= 0;
      BLog^.SesInfo.Crc:= 32;
      { 쪮 ६   }
      GetTime(Hour, Minute, Second, Sec100);
      DT.Hour:= Hour; DT.Min:= Minute; DT.Sec:= Second; PackTime(DT, T1);
      T:= T1-T; UnpackTime(T, DT);
      BLog^.SesInfo.Elapsed:= DT.Hour*3600+DT.Min*60+DT.Sec;
      For I:= 1 To Length(aType.Domain) Do
        BLog^.SesInfo.Domain[I-1]:= aType.Domain[I];
      { ᠬ  }
      BLog^.WriteHeader; BLog^.WriteInfo
    End
End;

(* -= H砫 pp =- *)

Begin
  { 樠 ६ }
  ParamAddr:= '0'; LogFile:= ErrorID; LogLevel:= '+!?#&:@';
  BinkRoot:= ErrorID; LongBinkRoot:= ErrorID; Wait:= False;
  BoxRoot:= ErrorID; LongBoxRoot:= ErrorID; FBox:= False;

  { pp塞 室  RunTime Error }
  SaveExit:= ExitProc; ExitProc:= @MyExit;

  { 몫砥   뢮 ⠢ }
  HideCursor;
  WriteLn(Copyright,': Fido <-> Lan Support');
  WriteLn('Copyright (c) 1999 by Konstantin Kubatkin (2:468/13@FidoNet)');
  WriteLn('Compiled on ',CompileDate,'. All rights reserved.');
  WriteLn;

  { 塞 ࠡ ४ = ४ਨ ᪠ }
  WorkDir:= ParamStr(0);
  While WorkDir[Length(WorkDir)] <> '\' Do WorkDir[0]:= Chr(Ord(WorkDir[0]) - 1);
  CfgFile:= WorkDir + 'lanfix.ctl';

  { p⪠  p }
  If (ParamStr(1) = '/?') or (ParamStr(1) = '?') Then Help;
  For I:= 1 To ParamCount Do
    If Pos('-C', UpCaseStr(ParamStr(I))) = 1 Then
      CfgFile:= Copy(ParamStr(I), 3, Length(ParamStr(I)) - 2)
    Else
      If UpCaseStr(ParamStr(I)) = '-W' Then Wait:= True
        Else ParamAddr:= ParamStr(I);

{$IfDef VirtualPascal}
  { ஢塞 稥 㣮  }
  WriteLn('Create semaphor \SEM32\Fido\LanFix\lanfix.run.');
  Bus[1]:= '|'; Bus[2]:= '/'; Bus[3]:= '-'; Bus[4]:= '\'; I:= 1;
  Repeat
    Mut:= SemCreateMutex('Fido\LanFix\lanfix.run', True, False);
    If Mut = -1 Then
      Begin
       Write('Ahother copy LanFix is active.');
       If not Wait Then
         Begin WriteLn; ShowCursor; ExitProc:= SaveExit; Halt(1) End;
       Write(' ',Bus[I]); GoToXY(1, WhereY); SysCtrlSleep(3000);
       If I = 4 Then I:= 1 Else Inc(I)
      End
  Until Mut <> -1;
  { 頥 ࠭   }
  GoToXY(1, WhereY); ClrEol;
{$EndIf}

  { ⥭ 䨣 }
  Cfg:= New(PCfg, Init(CfgFile));
  If (Cfg = nil) or (CfgError <> cfgOk) Then
    Begin
      WriteLn('Error read config file ',CfgFile);
      ExitProc:= SaveExit; Halt(13)
    End;

  {  ६  䫠 }
  TempFlag:= WorkDir+'bsy.tmp';
  If FileExist(TempFlag) = 0 Then FileErase(TempFlag);
  {$I-}
  Assign(F, TempFlag); ReWrite(F); WriteLn(F, BusyStr); Close(F);
  {$I+}
  If IOResult <> 0 Then
    Begin
      WriteLn('Error create ',TempFlag); ExitProc:= SaveExit; Halt(13)
    End;

  {   }
  LogFile:= Cfg^.GetValue('Log');
  { ⠫  }
  LogLevel:= Cfg^.GetValue('LogLevel');
  If LogLevel = ErrorID Then LogLevel:= '+!?#&:@';
  { ࠧ   ( ப) }
  If not _Val(Cfg^.GetValue('LogBuffer'), LogBuf) Then LogBuf:= 0;
  { 樠 -䠩 }
  If LogFile <> ErrorID Then Log:= New(PLog, Init(LogFile, LogLevel, 'LFIX', LogBuf));
  If (Log = nil) or (LogError <> logOk) Then
    Begin
      Error('?','Error open '+LogFile+' file. Log disabled.',0);
      LogFile:= ErrorID
    End;

  { ⥭   ୮  }
  BinLog:= Cfg^.GetValue('BinLog');
  { ⠥ TZ }
  If not _Val(Cfg^.GetValue('TZ'), TZ) Then
    Begin ParseTZ(GetEnv('TZ')); TZ:= TZOffsetNow End;
  If BinLog <> ErrorID Then BLog:= New(PBinBrkLog, Init(BinLog, TZ));
  If BLog = nil Then
    Begin
      Error('?','Error open '+BinLog+' file. Binary log disabled.',0);
      BinLog:= ErrorID
    End;

  {   砫 ࠡ   }
  Error('+', 'begin, '+Copyright, 0);
  {   砫 ࠡ    }
  BLog^.SesHdr.UnixTime:= DateDosToUnix(BLog^.TZ); BLog^.SesHdr.RecType:= 7;
  BLog^.WriteHeader;

{$IfDef VirtualPascal}
{$IfDef OS2}
  { ⠭ ਮ     }
  Delta:= Cfg^.GetValue('Delta');
  If (Delta = ErrorID) or (XVal(Delta) > 31) or (XVal(Delta) < -31) Then Delta:= '0';
  Prio:= Cfg^.GetValue('Priority');
  If Prio = 'IdleTime' Then PClass:= prtyc_IdleTime
  Else If Prio = 'Regular' Then PClass:= prtyc_Regular
       Else If Prio = 'ForeGroundServer' Then PClass:= prtyc_ForeGroundServer
            Else If Prio = 'TimeCritical' Then PClass:= prtyc_TimeCritical
                 Else Begin Prio:= 'Regular'; PClass:= prtyc_Regular End;
  rc:= DosSetPriority(prtys_Thread, PClass, XVal(Delta), 0);
  Error('&','Set priority '+Prio+', delta '+Delta+'. rc = '+XStr(rc), 0);
{$EndIf}
{$EndIf}

  { ⥭ 䨣樨 }
  MainAddr:= Cfg^.GetValue('Address');
  If MainAddr = ErrorID Then Error('!','Not found parameter Address in '+CfgFile+' file.', 13);
  If (Pos(':', MainAddr) = 0) and (Pos('/', MainAddr) = 0) and ((Pos('#', MainAddr) = 0) or (Pos('@', MainAddr) = 0)) Then
    Error('!','Parameter Address is not 5D Fido address.', 13);

  { Inbound }
  MainIn:= Cfg^.GetValue('Inbound');
  If MainIn = ErrorID Then
    Error('!','Not found parameter Inbound in '+CfgFile, 13)
  Else If not ExistDir(MainIn) Then Error('!','Path '+MainIn+' not exist', 13);
  MainIn:= AddSlash(MainIn);

  { BinkOutbound Root }
  BinkRoot:= Cfg^.GetValue('OutboundRoot');
  If BinkRoot <> ErrorID Then
    Begin
      If not ExistDir(BinkRoot) Then Error('!','Path '+BinkRoot+' not exist', 13);
      BinkRoot:= AddSlash(BinkRoot)
    End;

  { FileBox }
  BoxRoot:= Cfg^.GetValue('FileBox');
  If BoxRoot <> ErrorID Then
    Begin
      If not ExistDir(BoxRoot) Then Error('!','Path '+BoxRoot+' not exist', 13);
      BoxRoot:= AddSlash(BoxRoot)
    End;

  { ⠥ ⠫,   ᮧ 䫠 }
  MainFlag:= Cfg^.GetValue('Flag');
  If MainFlag <> ErrorID Then
    Begin
      If not ExistDir(MainFlag) Then Error('!','Path '+MainFlag+' not exist', 13);
      MainFlag:= AddSlash(MainFlag)
    End;

  { ⥭ 䨣樨  }
  If Cfg^.FindFirstParam('Domain') Then
    Begin
      Domain:= New(PDomainCollection, Init(1, 1));
      Repeat
        { 樠 ६ }
        TempDomain:= New(PDomainRec);
        TempDomain^.Domain:= '0'; TempDomain^.Outbound:= '0';
        TempDomain^.MainZone:= '0'; TempDomain^.Zones:= '0';

        {  ᥩ }
        Temp:= UpCaseStr(Cfg^.GetCurrentParam);
        While Temp <> 'ENDDOMAIN' Do
          Begin
            { ⠥   }
            If Temp = 'DOMAIN' Then
              TempDomain^.Domain:= Cfg^.GetCurrentValue
            Else
              { ⠥ ७  }
              If Temp = 'OUTBOUND' Then
                TempDomain^.Outbound:= Cfg^.GetCurrentValue
              Else
                { ⠥    }
                If Temp = 'MAINZONE' Then
                  TempDomain^.MainZone:= Cfg^.GetCurrentValue
                Else
                  { ⠥   }
                  If Temp = 'ZONES' Then
                    TempDomain^.Zones:= Cfg^.GetCurrentValue;
            { 饬 ᫥饥 祭 }
            Temp:= UpCaseStr(Cfg^.GetNextParam)
          End;
        { ᨬ   }
        Domain^.Insert(TempDomain)
      {    ᠭ  }
      Until not Cfg^.FindNextParam
    End;

{$IfDef LongName}
  { LongBSO }
  LongBinkRoot:= Cfg^.GetValue('LongOutboundRoot');
  If LongBinkRoot <> ErrorID Then
    Begin
      If not ExistDir(LongBinkRoot) Then Error('!','Path '+LongBinkRoot+' not exist', 13);
      LongBinkRoot:= AddSlash(LongBinkRoot)
    End;

  { LongBox }
  LongBoxRoot:= Cfg^.GetValue('LongFileBox');
  If LongBoxRoot <> ErrorID Then
    Begin
      If not ExistDir(LongBoxRoot) Then Error('!','Path '+LongBoxRoot+' not exist', 13);
      LongBoxRoot:= AddSlash(LongBoxRoot)
    End;

  { ।塞 প ᥬ஢ }
  SemRoot:= Cfg^.GetValue('BsySemaPath');
  If SemRoot <> ErrorId Then
    Begin
      If Pos('\SEM32\', UpCaseStr(SemRoot)) <> 1 Then
        Error('!','Path '+SemRoot+' is not semaphore', 13);
      Delete(SemRoot, 1, 7);
      SemRoot:= AddSlash(SemRoot)
    End;
{$EndIf}

  { ⠥ ਧ 㤠/㫥 䠩 }
  NoDelete:= Cfg^.FindFirstParam('Delete');

  { ⠥ ਧ 㤠  뫮 }
  DelNotFound:= Cfg^.FindFirstParam('RemoveNotFound');

  { ⠥ ஫  ⥢ ४ }
  FrqPwd:= Cfg^.GetValue('FreqPass');

  { ⠥ প ४ }
  Freq:= New(PFreq,Init(Cfg^.GetValue('FreqDir'),Cfg^.GetValue('FreqAlias')));
  If FreqError <> freqOk Then Error('!','Error init freq. Freq disabled.', 0);
  If AliasError <> aliasOk Then Error('!','Error init alias. Alias disabled.', 0);

  { ⠥ 䫠   }
  PBFlag:= Cfg^.GetValue('PointBusyFlag');

  { ⠥ 䫠  ᪠஢ ।  }
  RescanFlag:= Cfg^.GetValue('Rescan');

  { ⠥ 䫠  ⬥ }
  NetFlag:= Cfg^.GetValue('Net_Flag');

  { ⠥ 䫠  બ }
  TossFlag:= Cfg^.GetValue('Arc_Flag');

  { ⠥ 䫠  ⨪ }
  TicFlag:= Cfg^.GetValue('Tic_Flag');

  { ⥭ ᪠  ᪥ }
  If Cfg^.FindFirstParam('Mask') Then
    Begin
      Mask:= New(PMaskCollection, Init(3, 1));
      Repeat
        TempMask:= New(PMaskRec);
        Temp:= UpCaseStr(Cfg^.GetCurrentValue);
        TempMask^.FileN:= Copy(Temp, 1, Pos(' ', Temp)-1);
        Delete(Temp, 1, Pos(' ', Temp)); Temp:= RemoveSpaces(Temp);
        If Pos('EXEC', Temp) = 1 Then TempMask^.Exec:= True
                                 Else TempMask^.Exec:= False;
        Delete(Temp, 1, Pos(' ', Temp));
        TempMask^.Arg:= RemoveSpaces(Temp);
        Mask^.Insert(TempMask)
      Until not Cfg^.FindNextParam
    End;

  { ⥭ 䨣樨 ⮢ }
  If Cfg^.FindFirstParam('Node') Then
    Begin
      Point:= New(PPointCollection, Init(13, 3));
      Repeat
        TempRec:= New(PPointRec);
        TempRec^.Addr:= ErrorID; TempRec^.FIn:= ErrorID;
        TempRec^.FOut:= ErrorID; TempRec^.Box:= ErrorID;
        TempRec^.Flag:= ErrorID;

        Temp:= UpCaseStr(Cfg^.GetCurrentParam);
        While Temp <> 'ENDNODE' Do
          Begin
            If Temp = 'NODE' Then
{              TempRec^.Addr:= CopyAddr(MainAddr, Cfg^.GetCurrentValue)}
              TempRec^.Addr:= ExpandAddr(MainAddr, Cfg^.GetCurrentValue, Domain)
            Else
              If Temp = 'FILEIN' Then
                TempRec^.FIn:= AddSlash(Cfg^.GetCurrentValue)
              Else
                If Temp = 'FILEOUT' Then
                  TempRec^.FOut:= AddSlash(Cfg^.GetCurrentValue)
                Else
                  If Temp = 'PFILEBOX' Then
                    TempRec^.Box:= AddSlash(Cfg^.GetCurrentValue)
                  Else
                    If Temp = 'POINTFLAG' Then
                      TempRec^.Flag:= AddSlash(Cfg^.GetCurrentValue);
            Temp:= UpCaseStr(Cfg^.GetNextParam)
          End;
        Point^.Insert(TempRec)
      Until not Cfg^.FindNextParam
    End;

  { 樠 樨 ४-९ }
  Rep:= New(PTextCollection, Init(1, 1));

  { ⢥  }
  { ᫨  䨣   }
  If Point <> nil Then
    Begin
      CurItem:= 0;
      If ParamAddr <> '0' Then
        Begin
          { ᫨  pp  p, p    p }
{          ParamAddr:= CopyAddr(MainAddr, ParamAddr);}
          ParamAddr:= ExpandAddr(MainAddr, ParamAddr, Domain);
          While CurItem < Point^.Count Do
            Begin
              If PPointRec(Point^.At(CurItem))^.Addr = ParamAddr Then
                Begin
                  Session; Break
                End
              Else Inc(CurItem)
            End
          End
      Else
        While CurItem < Point^.Count Do
          Begin
            If PPointRec(Point^.At(CurItem))^.Addr = ErrorID Then Continue;
            Session; Inc(CurItem)
          End
    End;

  { ࠡ⪠ ᪠  ᪥ }
  If Mask <> nil Then
    Begin
      CurItem:= 0;
      While CurItem < Mask^.Count Do
        Begin
          If FileExist(MainIn+PMaskRec(Mask^.At(CurItem))^.FileN) = 0 Then
            Begin
              If PMaskRec(Mask^.At(CurItem))^.Exec Then
                Begin
                  FindFirst(MainIn+PMaskRec(Mask^.At(CurItem))^.FileN,AnyFile,DirInfo);
                  TempFileName:= DirInfo.Name; TempTime:= DirInfo.Time;
                  While DosError = 0 Do
                    Begin
                      FindNext(DirInfo);
                      If DirInfo.Time > TempTime Then
                        Begin
                          TempFileName:= DirInfo.Name;
                          TempTime:= DirInfo.Time
                        End
                    End;
{$IfDef VirtualPascal}
                  FindClose(DirInfo);
{$EndIf}
                  Error('@', 'Exec '+PMaskRec(Mask^.At(CurItem))^.Arg+' '+MainIn+TempFileName, 0);
                  Exec(GetEnv('COMSPEC'), '/C '+PMaskRec(Mask^.At(CurItem))^.Arg+' '+MainIn+TempFileName);
                  Error('&', 'Exec '+PMaskRec(Mask^.At(CurItem))^.Arg+' '+MainIn+TempFileName+'. rc = '+XStr(DosExitCode), 0);
                  If DosError <> 0 Then Error('!', GetError(DosExitCode), 0)
                End
              Else
                Begin
                  Error('@','Create flag '+PMaskRec(Mask^.At(CurItem))^.Arg, 0);
                  rc:= FileCreate(MainFlag+PMaskRec(Mask^.At(CurItem))^.Arg);
                  Error('&','Create file '+PMaskRec(Mask^.At(CurItem))^.Arg+'. rc = '+XStr(rc), 0);
                  If rc <> 0 Then Error('?', GetError(rc), 0)
                End
            End;
          Inc(CurItem)
        End;
      Dispose(Mask, Done)
    End;

  { ᫨ ࠧ襭 ࠡ  䫠 }
  If EnableFlag Then
    Begin
      { ᫨  p ⬥,  ᮧ 䫠 }
      If ExistPkt(MainIn) and (NetFlag <> ErrorID) Then
        Begin
          Error('@','Create flag '+NetFlag, 0);
          rc:= FileCreate(MainFlag+NetFlag);
          Error('&','Create file '+NetFlag+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End;
      { ᫨ 뫨 p ,  ᮧ 䫠 }
      If ExistArc(MainIn) and (TossFlag <> ErrorID) Then
        Begin
          Error('@','Create flag '+TossFlag, 0);
          rc:= FileCreate(MainFlag+TossFlag);
          Error('&','Create file '+TossFlag+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End;
      { ᫨ 뫨 p 䠩,  ᮧ 䫠 }
      If ExistTic(MainIn) and (TicFlag <> ErrorID) Then
        Begin
          Error('@','Create flag '+TicFlag, 0);
          rc:= FileCreate(MainFlag+TicFlag);
          Error('&','Create file '+TicFlag+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End;
      { ᫨  p᪠p p }
      If FlagRescan and (RescanFlag <> ErrorID) Then
        Begin
          Error('@','Create flag '+RescanFlag, 0);
          rc:= FileCreate(MainFlag+RescanFlag);
          Error('&','Create file '+RescanFlag+'. rc = '+XStr(rc), 0);
          If rc <> 0 Then Error('?', GetError(rc), 0)
        End
    End;

  { 塞 ६  䫠 }
  rc:= FileErase(TempFlag);

  Error('+', 'end, ' + Copyright, 0);
  BLog^.SesHdr.UnixTime:= DateDosToUnix(BLog^.TZ); BLog^.SesHdr.RecType:= 7;
  BLog^.WriteHeader;
{$IfDef VirtualPascal}
  WriteLn('Close semaphor \SEM32\Fido\LanFix\lanfix.run.');
  SemCloseMutex(Mut);
{$EndIf}

  { ᢮   権  室 }
  If Log <> nil Then Dispose(Log, Done);
  If BLog <> nil Then Dispose(BLog, Done);
  If Cfg <> nil Then Dispose(Cfg, Done);
  If Domain <> nil Then Dispose(Domain, Done);
  If Mask <> nil Then Dispose(Mask, Done);
  If Point <> nil Then Dispose(Point, Done);
  If Freq <> nil Then Dispose(Freq, Done);
  If Rep <> nil Then Dispose(Rep, Done);
  If LoArray <> nil Then Dispose(LoArray, Done);
  ShowCursor; ExitProc:= SaveExit
End.
