{***************************************************************************}
{*                                                                         *}
{*                        Freq support library.                            *}
{*                                                                         *}
{*     Copyright (c) 1999 by Konstantin Kubatkin, 2:468/13@Fidonet         *}
{*                                                                         *}
{***************************************************************************}
{$IfDef VirtualPascal}
{&Use32-}
{$EndIf}
Unit FreqMgr;

Interface
Uses Objects, TextColl;

{ TFreq error flags }
Const
  freqOk           = 0;
  freqCannotOpen   = 1;
  freqCannotRead   = 2;
  freqCannotWrite  = 3;
  freqErrPass      = 4;

  aliasOk          = 0;
  aliasCannotOpen  = 1;
  aliasCannotRead  = 2;
  aliasCannotWrite = 3;

Const
  FreqError: Integer  = freqOk;
  AliasError: Integer = aliasOk;

Type
  PFreqRec = ^TFreqRec;
  TFreqRec = Record
    DirName  : String;
    Password : String
  End;

Type
  PAliasRec = ^TAliasRec;
  TAliasRec = Record
    AliasName : String;
    FileName  : String
  End;

Type
  PFreqCollection = ^TFreqCollection;
  TFreqCollection = Object(TCollection)
    Procedure FreeItem(Item: Pointer); Virtual;
  End;

Type
  PAliasCollection=^TAliasCollection;
  TAliasCollection=Object(TCollection)
    Procedure FreeItem(Item:pointer); Virtual;
  End;

Type
  PFreq = ^TFreq;
  TFreq = Object(TObject)
    FreqName   : String;
    AliasName  : String;
    FreqFile   : Text;
    AliasFile  : Text;
    FreqArray  : PFreqCollection;
    AliasArray : PAliasCollection;
    { 樠㥬 }
    Constructor Init(fName, aName: String);
    { pp, - 䠩   }
    Function FindinAlias(aName: String): String;
    { pp, - 䠩  ४ }
    Function FindInFreq(fName, Pass: String): String;
    { 뢮  ࠭   }
    Procedure WriteAll;
    { ᢮  }
    Destructor Done; virtual;
  End;

Implementation
Uses Dos, Tools;

Procedure TFreqCollection.FreeItem(Item: Pointer);
Begin
  Dispose(PFreqRec(Item))
End;

Procedure TAliasCollection.FreeItem(Item: Pointer);
Begin
  Dispose(PAliasRec(Item))
End;

Constructor TFreq.Init;
Var
  nAlias  : String;
  nFile   : String;
  nDir    : String;
  Pass    : String;
  Temp    : String;
  TempStr : String;
  I       : LongInt;
  J       : LongInt;
  tFreq   : PFreqRec;
  tAlias  : PAliasRec;
  Dir     : PTextCollection;
  Buf     : Array [1..255] of Char;
Begin
  AliasName:= aName; FreqName:= fName;
  { ⥭ 䠩 ᮢ }
  If AliasName <> '' Then
    Begin
      Assign(AliasFile, AliasName); {$R-} Reset(AliasFile); {$R+}
      If IOResult = 0 Then
        Begin
          SetTextBuf(AliasFile, Buf, SizeOf(Buf));
          AliasArray:= New(PAliasCollection, Init(3, 1));
          While not EOF(AliasFile) Do
            Begin
              nAlias:= ''; nFile:= ''; I:= 0; J:= 0;
              Readln(AliasFile, nAlias);
              {  ਥ }
              If Pos(';', nAlias) > 0 Then
                Delete(nAlias,Pos(';',nAlias),Length(nAlias)-Pos(';',nAlias)+1);
              nAlias:= RemoveSpaces(nAlias);
              { ᫨  ப - 室 }
              If nAlias = '' Then Continue;
              { ᫨ ଠ GPMail,  ਢ   "alias file" }
              If Pos('FREQALIAS',UpCaseStr(nAlias)) = 1 Then Delete(nAlias,1,9);
              { ᫨ ଠ Brake!,  ਢ   "alias file" }
              If Pos('ALIAS',UpCaseStr(nAlias)) = 1 Then Delete(nAlias,1,5);
              { ᫨ ଠ T-Mail,  ਢ   "alias file" }
              If nAlias[1] = '@' Then Delete(nAlias,1,1);
              nAlias:= RemoveSpaces(nAlias);
              { ᫨ ⮫쪮  ᫮ - 室 }
              I:= Pos(' ', nAlias); If I = 0 Then Continue;
              { 砥    䠩,   ᮮ⢥ }
              nFile:= RemoveSpaces(Copy(nAlias, I, Length(nAlias) - I + 1));
              Delete(nAlias,I,Length(nAlias)-I+1); nAlias:= RemoveSpaces(nAlias);
              { ᫨   ᯮ ६ 㦥 }
              For I:= 1 To Length(nFile) Do If nFile[I] = '%' Then Inc(J);
              If J > 1 Then
                Begin
                  I:= Pos('%', nFile);
                  Temp:= Copy(nFile, 1, I - 1); Delete(nFile, 1, I);
                  I:= Pos('%', nFile);
                  TempStr:= Copy(nFile, 1, I - 1); Delete(nFile, 1, I);
                  If GetEnv(TempStr) = '' Then Continue
                    Else nFile:= Temp + GetEnv(TempStr) + nFile
                End;
              tAlias:= New(PAliasRec);
              tAlias^.AliasName:= nAlias;
              tAlias^.FileName:= nFile;
              AliasArray^.Insert(tAlias)
            End;
          Close(AliasFile)
        End
      Else AliasError:= aliasCannotRead
    End
  Else AliasError:= aliasCannotOpen;
  { ⥭ 䠩 ४਩  ४ }
  If FreqName <> '' Then
    Begin
      Assign(FreqFile, FreqName); {$R-} Reset(FreqFile); {$R+}
      If IOResult = 0 Then
        Begin
          SetTextBuf(FreqFile, Buf, SizeOf(Buf));
          FreqArray:= New(PFreqCollection, Init(3, 1));
          While not EOF(FreqFile) Do
            Begin
              nDir:= ''; Pass:= '';
              Readln(FreqFile, nDir);
              {  ਥ }
              If Pos(';', nDir) > 0 Then
                Delete(nDir,Pos(';',nDir),Length(nDir)-Pos(';',nDir)+1);
              nDir:= RemoveSpaces(nDir);
              { ᫨  ப - 室  ᫥騩 横 }
              If nDir = '' Then Continue;
              { ᫨ 㪠 ஫ }
              I:= Pos(' !', nDir);
              If I > 0 Then
                Begin
                  Pass:= RemoveSpaces(Copy(nDir,I+2,Length(nDir)-I));
                  nDir:= RemoveSpaces(Copy(nDir, 1, I-1))
                End;
              I:= Pos(' |', nDir);
              If I > 0 Then
                Begin
                  Pass:= RemoveSpaces(Copy(nDir,I+2,Length(nDir)-I));
                  nDir:= RemoveSpaces(Copy(nDir, 1, I-1))
                End;
              { ᫨   ᯮ ६ 㦥 }
              For I:= 1 To Length(nDir) Do If nDir[I] = '%' Then Inc(J);
              If J > 1 Then
                Begin
                  I:= Pos('%', nDir);
                  Temp:= Copy(nDir, 1, I - 1); Delete(nDir, 1, I);
                  I:= Pos('%', nDir);
                  TempStr:= Copy(nDir, 1, I - 1); Delete(nDir, 1, I);
                  If GetEnv(TempStr) = '' Then Continue
                    Else nDir:= Temp + GetEnv(TempStr) + nDir
                End;
              { ᫨ ॢ ४਩ }
              If (Pos('TREE', UpCaseStr(nDir))=1) or (Pos('FREQTREE', UpCaseStr(nDir))=1) Then
                Begin
                  nDir:= RemoveSpaces(Copy(nDir,Pos(' ',nDir)+1,Length(nDir)-Pos(' ',nDir)));
                  nDir:= RemoveSpaces(nDir);
                  Dir:= New(PTextCollection, Init(3, 1));
                  GetDirList(nDir, Dir);
                  I:= 0;
                  While I < Dir^.Count Do
                    Begin
                      { ᥭ   }
                      tFreq:= New(PFreqRec);
                      tFreq^.DirName:= AddSlash(PString(Dir^.At(I))^);
                      tFreq^.Password:= Pass;
                      FreqArray^.Insert(tFreq);
                      Inc(I)
                    End;
                  Dispose(Dir, Done)
                 End
              Else
                Begin
                  If nDir[1] = '@' Then Continue;
                  If Pos('FREQDIR',UpCaseStr(nDir)) = 1 Then Delete(nDir,1,8);
                  If Pos('PATH',UpCaseStr(nDir)) = 1 Then Delete(nDir,1,4);
                  nDir:= RemoveSpaces(nDir);
                  { ᥭ   }
                  tFreq:= New(PFreqRec);
                  tFreq^.DirName:= AddSlash(nDir);
                  tFreq^.Password:= Pass;
                  FreqArray^.Insert(tFreq)
                End
            End;
          Close(FreqFile)
        End
      Else freqError:= aliasCannotRead
    End
  Else FreqError:= freqCannotOpen
End;

Function TFreq.FindInAlias(aName: String): String;
Var
  Temp    : String;
  PredFile: String;
  Dir     : DirStr;
  Dir1    : DirStr;
  Name    : NameStr;
  Ext     : ExtStr;
  PredExt : LongInt;
  I       : LongInt;
  DirInfo : SearchRec;
Begin
  FindInAlias:= ErrorID; I:= 0; PredFile:= ''; PredExt:= 0;
  If AliasArray^.Count = 0 Then Exit;
  While I < AliasArray^.Count Do
    Begin
      If UpCaseStr(PAliasRec(AliasArray^.At(I))^.AliasName) = UpCaseStr(aName) Then
        Begin Temp:= PAliasRec(AliasArray^.At(I))^.FileName; Break End;
      Inc(I)
    End;
  { ᫨   䠩 ᯮ 䨪 T-Mail }
  If Pos('SMALLEST', UpCaseStr(Temp)) = 1 Then
    Begin
      Delete(Temp, 1, 8); Temp:= RemoveSpaces(Temp);
      FSplit(Temp, Dir, Name, Ext);
      FindFirst(Temp, AnyFile, DirInfo);
      While DosError = 0 do
        Begin
          If PredExt = 0 Then
            Begin PredFile:= DirInfo.Name; PredExt:= DirInfo.Size End;
          If DirInfo.Size < PredExt Then
            Begin
              PredFile:= DirInfo.Name; PredExt:= DirInfo.Size
            End;
          FindNext(DirInfo)
        End;
{$IfDef VirtualPascal}
      FindClose(DirInfo);
{$EndIf VirtualPascal}
      Temp:= Dir + PredFile
    End;
  If Pos('LARGEST', UpCaseStr(Temp)) = 1 Then
    Begin
      Delete(Temp, 1, 7); Temp:= RemoveSpaces(Temp);
      FSplit(Temp, Dir, Name, Ext);
      FindFirst(Temp, AnyFile, DirInfo);
      While DosError = 0 do
        Begin
          If PredExt = 0 Then
            Begin PredFile:= DirInfo.Name; PredExt:= DirInfo.Size End;
          If DirInfo.Size > PredExt Then
            Begin
              PredFile:= DirInfo.Name; PredExt:= DirInfo.Size
            End;
          FindNext(DirInfo)
        End;
{$IfDef VirtualPascal}
      FindClose(DirInfo);
{$EndIf VirtualPascal}
      Temp:= Dir + PredFile
    End;
  If Pos('OLDEST', UpCaseStr(Temp)) = 1 Then
    Begin
      Delete(Temp, 1, 6); Temp:= RemoveSpaces(Temp);
      FSplit(Temp, Dir, Name, Ext);
      FindFirst(Temp, AnyFile, DirInfo);
      While DosError = 0 do
        Begin
          If PredExt = 0 Then
            Begin PredFile:= DirInfo.Name; PredExt:= DirInfo.Time End;
          If DirInfo.Time < PredExt Then
            Begin
              PredFile:= DirInfo.Name; PredExt:= DirInfo.Time
            End;
          FindNext(DirInfo)
        End;
{$IfDef VirtualPascal}
      FindClose(DirInfo);
{$EndIf VirtualPascal}
      Temp:= Dir + PredFile
    End;
  If Pos('LATEST', UpCaseStr(Temp)) = 1 Then
    Begin
      Delete(Temp, 1, 6); Temp:= RemoveSpaces(Temp);
      FSplit(Temp, Dir, Name, Ext);
      FindFirst(Temp, AnyFile, DirInfo);
      While DosError = 0 do
        Begin
          If PredExt = 0 Then
            Begin PredFile:= DirInfo.Name; PredExt:= DirInfo.Time End;
          If DirInfo.Time > PredExt Then
            Begin
              PredFile:= DirInfo.Name; PredExt:= DirInfo.Time
            End;
          FindNext(DirInfo)
        End;
{$IfDef VirtualPascal}
      FindClose(DirInfo);
{$EndIf VirtualPascal}
      Temp:= Dir + PredFile
    End;
  FSplit(Temp, Dir, Name, Ext);
  If Ext = '.999' Then
    Begin
      FindFirst(Dir+Name+'.*', AnyFile, DirInfo);
      While DosError = 0 do
        Begin
          FSplit(DirInfo.Name, Dir1, Name, Ext); Delete(Ext,1,1);
          If XVal(Ext) > PredExt Then
            Begin
              PredFile:= DirInfo.Name;
              PredExt:= XVal(Ext)
            End;
          FindNext(DirInfo)
        End;
{$IfDef VirtualPascal}
      FindClose(DirInfo);
{$EndIf VirtualPascal}
      Temp:= Dir + PredFile
    End;
  FindInAlias:= Temp
End;

Function TFreq.FindInFreq;
Var
  I       : Integer;
  DirInfo : SearchRec;
Begin
  fName:= UpCaseStr(fName); FindInFreq:= ErrorID;
  I:= 0; If FreqArray^.Count = 0 Then Exit;
  While I < FreqArray^.Count Do
    Begin
      FindFirst(PFreqRec(FreqArray^.At(I))^.DirName+fName, AnyFile, DirInfo);
      If DosError = 0 Then
        Begin
          If PFreqRec(FreqArray^.At(I))^.Password = Pass Then
            Begin
              FindInFreq:= PFreqRec(FreqArray^.At(I))^.DirName+DirInfo.Name;
              Exit
            End
          Else Begin FreqError:= freqErrPass; Exit End;
          FindNext(DirInfo)
        End;
      Inc(I);
{$IfDef VirtualPascal}
      FindClose(DirInfo)
{$EndIf VirtualPascal}
    End
End;

Procedure TFreq.WriteAll;
Var
  I: LongInt;
Begin
  I:= 0;
  WriteLn('Alias: ');
  While I < AliasArray^.Count Do
    Begin
      WriteLn(' ',PAliasRec(AliasArray^.At(I))^.AliasName,' ',PAliasRec(AliasArray^.At(I))^.FileName);
      Inc(I)
    End;
  I:= 0;
  WriteLn('Freq Dir: ');
  While I < FreqArray^.Count Do
    Begin
      WriteLn(' ',PFreqRec(FreqArray^.At(I))^.DirName,' ',PFreqRec(FreqArray^.At(I))^.Password);
      Inc(I)
    End;
End;

Destructor TFreq.Done;
Begin
  If FreqArray <> nil Then Dispose(FreqArray, Done);
  If AliasArray <> nil Then Dispose(AliasArray, Done);
  Inherited Done;
End;

End.
