{***************************************************************************}
{*                                                                         *}
{*                     ࢨ  FIDO ணࠬ.                  *}
{*                                                                         *}
{*           Copyright (c) 1997 by Cat Kubatkin, 2:468/13@Fidonet          *}
{*                                                                         *}
{***************************************************************************}
{$IfDef VirtualPascal}
{&Use32-}
{$EndIf}
Unit FidoMgr;

Interface
Uses Objects, TextColl;

{ ப  ᮮ饭  訡 }
Const
  ErrorID: String[15] = ' Error ';

{   㬮砭 }
Const
  DefDomain: String[7] = 'Fidonet';

Type
  String8 = array[1..8] of char;

{ ᠭ ⨯    }
Type
  PDomainRec = ^TDomainRec;
  TDomainRec = Record
    Domain   : String;
    Outbound : String;
    MainZone : String;
    Zones    : String
  End;

{ ᠭ ⨯ ᯨ᪠  }
Type
  PDomainCollection = ^TDomainCollection;
  TDomainCollection = Object(TCollection)
    Procedure FreeItem(Item: Pointer); Virtual;
  End;

{   ᮬ }
Type
  AddrType = Record
    Zone,Net,Node,Point,Domain: String
  End;

(* -=   ⬥, 宬  䠩堬 =- *)

{  ⨯ 䠩: MAIL, XMAIL, FILE }
Function GetType(fName: String): String;

{ ᫨  Path  '*.tic'    Hidden,
   頥 True,  - Flase}
Function ExistTic(Path: String): Boolean;

{ ᫨  Path  *.pkt    Hidden,
   頥 True,  - Flase}
Function ExistPkt(Path: String): Boolean;

{ ᫨  Path  ArcMail    Hidden,
   頥 True,  - Flase}
Function ExistArc(Path: String): Boolean;

(* -=   pᠬ =- *)

{    ⠢騥  }
{      zone:net/node.point@domain  }
{ domain#zone:net/node.point.   ⥩  㫨 }
Function SplitAddr(FAddr: String; Var Addr: AddrType): Boolean;

{ p 騥   sAddr  dAddr
  ..  sAddr = 2:468/13@Fidonet, dAddr = .1
  CopyAddr p 2:468/13.1@Fidonet,
   sAddr = 2:, dAddr = .1 CopyAddr p 2:0/0.1@0 }
Function CopyAddr(sAddr, dAddr: String): String;

Function ExpandAddr(sAddr, dAddr: String; aDomain: PDomainCollection): String;

(* -= 㭪樨 祭  ⠫  䠩 =- *)

{   *.?lo, *.bsy, *.?ut  ଠ Bink  প domain
  Addr - ,  ண  ᫨.
       ⡠㭤.
  ਬ,  Addr=2:468/13.36@Fidonet
  GetBinkName ୥ 01d4000d.pnt\00000024 }
Function GetBinkName(Addr: String; Domain: PDomainCollection): String;

{   *.?lo, *.bsy, *.?ut  ଠ LongName  প domain
  ਬ,  Addr = 2:468/13.36@Fidonet
  GetLongName ୥ Fidonet.2.468.13.36 }
Function GetLongName(Addr: String): String;

{ 頥  䠩  ⨫ T-Mail   Addr }
{  ᫥ 㪢 ७ }
Function GetTBoxName(Addr: String): String;

{ 頥  䠩  ⨫ Long T-Mail   Addr
  ਬ,  Addr = 2:468/13.36@Fidonet
  GetTLongName ୥ 2.468.13.36 }
Function GetTLongBoxName(Addr: String): String;

{  ४⭮ ᮧ busy.  -   2:463/68 }
{$IfDef VirtualPascal}
Function CreateBinkBusy(sName, dName: String): Boolean;
{$Else}
Function CreateBinkBusy(BinkName, Busy, Str: String): Boolean;
{$EndIf VirtualPascal}

{  bsy 䫠   Addr  ⨫ T-Mail   Line }
{  ⠫ Path }
Function CreateFDBusy(Addr, Path: String; Line: Char): Boolean;

(* -=   OutBound' =- *)

{ 뢠 ᮤন 誨   Lo }
Function ReadLoFile(Path: String; Var Lo: PTextCollection): Boolean;

{ 뢠 ᮤন 誨   Lo }
Function WriteLoFile(Path: String; Lo: PTextCollection): Boolean;

Implementation
Uses
{$IfDef VirtualPascal}
{$IfDef OS2}
  Os2Def, Os2Base,
{$EndIf}
  Dos, Tools, Crc32, Strings, VPSysLow;
{$EndIf}
{$IfDef MsDos}
  Dos, Tools, Crc32, Strings;
{$EndIf}

{ ᢮     }
Procedure TDomainCollection.FreeItem(Item: Pointer);
Begin
  Dispose(PDomainRec(Item))
End;

Function GetType(fName: String): String;
Var
  D: DirStr;
  N: NameStr;
  E: ExtStr;
Begin
  GetType:= 'FILE';
  FSplit(fName, D, N, E); E:= UpCaseStr(E);
  If (E = '.PKT') or (E = '.MAIL') or (Pos('UT', E) = 3) Then
    Begin GetType:= 'MAIL'; Exit End;
  If (Pos('MO',E)=2) or (Pos('TU',E)=2) or (Pos('WE',E)=2) or (Pos('TH',E)=2) or (Pos('FR',E)=2) or
     (Pos('SA',E)=2) or (Pos('SU',E)=2) Then
    GetType:= 'XMAIL'
End;

Function ExistTic(Path: String): Boolean;
Begin
  ExistTic:= ExistNoHidden(AddSlash(Path)+'*.tic')
End;

Function ExistPkt(Path: String): Boolean;
Begin
  ExistPkt:= ExistNoHidden(AddSlash(Path)+'*.pkt')
End;

Function ExistArc(Path: String): Boolean;
Var
  Temp: Boolean;
Begin
  Path:= AddSlash(Path);
  Temp:= ExistNoHidden(Path+'*.mo?');
  ExistArc:= Temp; If Temp Then Exit;
  Temp:= ExistNoHidden(Path+'*.tu?');
  ExistArc:= Temp; If Temp Then Exit;
  Temp:= ExistNoHidden(Path+'*.we?');
  ExistArc:= Temp; If Temp Then Exit;
  Temp:= ExistNoHidden(Path+'*.th?');
  ExistArc:= Temp; If Temp Then Exit;
  Temp:= ExistNoHidden(Path+'*.fr?');
  ExistArc:= Temp; If Temp Then Exit;
  Temp:= ExistNoHidden(Path+'*.sa?');
  ExistArc:= Temp; If Temp Then Exit;
  Temp:= ExistNoHidden(Path+'*.su?');
  ExistArc:= Temp; If Temp Then Exit
End;

Function SplitAddr(FAddr: String; Var Addr: AddrType): Boolean;
Var
  pZ : Byte;
  pN : Byte;
  pP : Byte;
  pD : Byte;
  pD1: Byte;
Begin
  { 樠㥬 ६ }
  SplitAddr:= False;
  pZ:=  Pos(':',FAddr); pN:=  Pos('/',FAddr); pP:=  Pos('.',FAddr);
  pD:=  Pos('@',FAddr); pD1:= Pos('#',FAddr);
  With Addr Do
    Begin
      Zone:= ''; Net:= ''; Node:= ''; Point:= ''; Domain:= ''
    End;
  { ᫨ 㪠  ,  室 }
  If (pD1 > 0) and (pD > 0) Then Exit;
  { 뤥塞  }
  If pD > 0 Then
    Begin
      Addr.Domain:= Copy(FAddr, pD + 1, Length(FAddr) - pD);
      Delete(FAddr, pD, Length(FAddr))
    End;
  If pD1 > 0 Then
    Begin Addr.Domain:= Copy(FAddr, 1, pD1 - 1); Delete(FAddr, 1 , pD1) End;
  {   }
  pZ:=  Pos(':',FAddr); pN:=  Pos('/',FAddr); pP:=  Pos('.',FAddr);
  If pZ > 0 Then
    Begin
      If ((pN > 0) and (pZ > pN)) or ((pP > 0) and (pZ > pP)) Then Exit;
      Addr.Zone:= Copy(FAddr, 1, pZ - 1); Delete(FAddr, 1, pZ);
      If pN = 0 Then Begin Addr.Net:= FAddr; FAddr:= '' End
    End;
  {   }
  pN:=  Pos('/',FAddr); pP:=  Pos('.',FAddr);
  If pN > 0 Then
    Begin
      If (pP > 0) and (pN > Pp) Then Exit;
      Addr.Net:= Copy(FAddr, 1, pN - 1); Delete(FAddr, 1, pN)
    End;
  {     }
  pP:=  Pos('.',FAddr);
  If pP = 0 Then Addr.Node:= FAddr
  Else
    Begin
      Addr.Node:= Copy(FAddr, 1, pP - 1); Delete(FAddr, 1, pP);
      Addr.Point:= FAddr
    End;
  SplitAddr:= True
End;

Function CopyAddr(sAddr, dAddr: String): String;
Var
  sAType, dAType: AddrType;
  Temp: String;
Begin
  CopyAddr:= ErrorID; Temp:= '';
  If not SplitAddr(sAddr, sAType) Then Exit;
  If not SplitAddr(dAddr, dAType) Then Exit;
  With dAType Do
    Begin
      If Zone = '' Then Temp:= sAType.Zone + ':'
        Else Temp:= Zone + ':';
      If Net = '' Then Temp:= Temp + sAType.Net + '/'
        Else Temp:= Temp + Net + '/';
      If Node = '' Then Temp:= Temp + sAType.Node + '.'
        Else Temp:= Temp + Node + '.';
      If Point = '' Then Temp:= Temp + sAType.Point + '@'
        Else Temp:= Temp + Point + '@';
      If Domain = '' Then Temp:= Temp + sAType.Domain
        Else Temp:= Temp + Domain
    End;
  CopyAddr:= Temp
End;

Function ExpandAddr(sAddr, dAddr: String; aDomain: PDomainCollection): String;
Var
  sAType, dAType: AddrType;
  Temp: String;
  I: LongInt;
Begin
  ExpandAddr:= ErrorID; Temp:= '';
  If not SplitAddr(sAddr, sAType) Then Exit;
  If not SplitAddr(dAddr, dAType) Then Exit;
  With dAType Do
    Begin
      If (Zone = '') and (Domain = '') Then
        Begin Zone:= sAType.Zone; Domain:= sAType.Domain End;
      If (Zone = '') and (Domain <> '') Then
        If Domain = sAType.Domain Then Zone:= sAType.Zone
        Else
          Begin
            I:= 0;
            While I < aDomain^.Count Do
              Begin
                Temp:= PDomainRec(aDomain^.At(I))^.Zones;
                If UpCaseStr(PDomainRec(aDomain^.At(I))^.Domain) = UpCaseStr(Domain) Then
                  If Pos(',', Temp) <> 0 Then Zone:= Copy(Temp, 1, Pos(',', Temp)-1)
                    Else Zone:= Temp;
                Inc(I)
              End
          End;
      If (Zone <> '') and (Domain = '') Then
        If Zone = sAType.Zone Then Domain:= sAType.Domain
        Else
          Begin
            I:= 0;
            While I < aDomain^.Count Do
              Begin
                If Pos(Zone, PDomainRec(aDomain^.At(I))^.Zones) <> 0 Then
                  Domain:= PDomainRec(aDomain^.At(I))^.Domain;
                Inc(I)
              End
          End;
      If Net = '' Then Net:= sAType.Net;
      If Node = '' Then Node:= sAType.Node;
      If Point = '' Then Point:= '0';
      ExpandAddr:= Zone+':'+Net+'/'+Node+'.'+Point+'@'+Domain
    End
End;

Function GetBinkName(Addr: String; Domain: PDomainCollection): String;
Var
  AType    : AddrType;
  Temp     : String;
  TempPath : String;
  MZone    : String;
  I        : LongInt;
Begin
  Temp:= '0'; TempPath:= '0'; MZone:= '0'; GetBinkName:= ErrorID;
  If not SplitAddr(Addr, AType) Then Exit;
  If (AType.Domain='0') or (AType.Zone='0') or (AType.Net='0') or (AType.Node='0') Then Exit;
  If Pos('.ORG', UpCaseStr(AType.Domain)) > 0 Then
    Delete(AType.Domain, Pos('.ORG', UpCaseStr(AType.Domain)), 4);
  If Domain <> nil Then
    Begin
      I:= 0;
      While I < Domain^.Count Do
        Begin
          If UpCaseStr(PDomainRec(Domain^.At(I))^.Domain) = UpCaseStr(AType.Domain) Then
            Begin
              Temp:= PDomainRec(Domain^.At(I))^.Outbound;
              MZone:= PDomainRec(Domain^.At(I))^.MainZone;
              Break
            End;
          Inc(I)
        End
    End;
  If Temp = '0' Then Temp:= AType.Domain;
  If AType.Zone <> MZone Then
    Begin
      TempPath:= Dec2Hex(XVal(AType.Zone));
      While Length(TempPath) < 3 Do TempPath:= '0' + TempPath;
      Temp:= AddSlash(Temp + '.' + TempPath)
    End
  Else Temp:= AddSlash(Temp);
  TempPath:= '';
  TempPath:= Dec2Hex(XVal(AType.Net));
  While Length(TempPath) < 4 Do TempPath:= '0' + TempPath;
  Temp:= Temp + TempPath;
  TempPath:= '';
  TempPath:= Dec2Hex(XVal(AType.Node));
  While Length(TempPath) < 4 Do TempPath:= '0' + TempPath;
  Temp:= Temp + TempPath;
  TempPath:= '';
  If AType.Point <> '0' Then
    Begin
      TempPath:= Dec2Hex(XVal(AType.Point));
      While Length(TempPath) < 8 Do TempPath:= '0' + TempPath;
      Temp:= Temp + '.Pnt\'+TempPath
    End;
  GetBinkName:= Temp
End;

Function GetLongName(Addr: String): String;
Var
  AType: AddrType;
Begin
  GetLongName:= ErrorID;
  If not SplitAddr(Addr, AType) Then Exit;
  If (AType.Domain='0') or (AType.Zone='0') or (AType.Net='0') or (AType.Node='0') Then Exit;
  With AType Do
    GetLongName:= Domain+'.'+Zone+'.'+Net+'.'+Node+'.'+Point
End;

Function GetTBoxName(Addr: String): String;
Var
  AType: AddrType;
  Z1, N1, No1, P1: String;
Begin
  GetTBoxName:= ErrorID;
  If not SplitAddr(Addr, AType) Then Exit;
  If (AType.Zone='0') or (AType.Net='0') or (AType.Node='0') Then Exit;
  Z1:= ''; N1:= ''; No1:= ''; P1:= '';
  X2Hex(32,XVal(AType.Zone),Z1); While Length(Z1) < 2 Do Z1:= '0' + Z1;
  X2Hex(32,XVal(AType.Net),N1); While Length(N1) < 3 Do N1:= '0' + N1;
  X2Hex(32,XVal(AType.Node),No1); While Length(No1) < 3 Do No1:= '0' + No1;
  X2Hex(32,XVal(AType.Point),P1); While Length(P1) < 2 Do P1:= '0' + P1;
  GetTBoxName:= Z1 + N1 + No1 + '.' + P1
End;

Function GetTLongBoxName(Addr: String): String;
Var
  AType: AddrType;
Begin
  GetTLongBoxName:= ErrorID;
  If not SplitAddr(Addr, AType) Then Exit;
  If (AType.Zone='0') or (AType.Net='0') or (AType.Node='0') Then Exit;
  With AType Do
    GetTLongBoxName:= Zone+'.'+Net+'.'+Node+'.'+Point
End;

{$IfDef VirtualPascal}
Function CreateBinkBusy(sName, dName: String): Boolean;
Var
  sNameStr : PChar;
  dNameStr : PChar;
Begin
  GetMem(sNameStr, Length(sName)+1); StrPCopy(sNameStr, sName);
  GetMem(dNameStr, Length(dName)+1); StrPCopy(dNameStr, dName);
//  CreateBinkBusy:= DosCopy(sNameStr, dNameStr, $00000000) = 0;
  CreateBinkBusy:= SysFileCopy(sNameStr, dNameStr, False);
  FreeMem(sNameStr, Length(sName)+1); FreeMem(dNameStr, Length(dName)+1)
End;
{$Else}
Function CreateBinkBusy(BinkName, Busy, Str: String): Boolean;
Var
  F: Text;
Begin
  CreateBinkBusy:= False;
  Assign(F, BinkName+'.t$p'); ReWrite(F); WriteLn(F, Str); Close(F);
  {$I-} Rename(F, BinkName+Busy); {$I+}
  If IOResult = 0 Then CreateBinkBusy:= True Else Erase(F)
End;
{$EndIf VirtualPascal}

Function CreateFDBusy(Addr, Path: String; Line: Char): Boolean;
Var
  Temp  : String;
  Temp1 : String;
  Busy  : String[3];
  AType : AddrType;
  F     : File;
Begin
  CreateFDBusy:= False;
  Busy:= '.~0'+Line;
  If not SplitAddr(Addr, AType) Then Exit;
  If (AType.Zone='0') or (AType.Net='0') or (AType.Node='0') Then Exit;
  With AType Do
    If Point = '0' Then Temp:= Zone+':'+Net+'/'+Node
      Else Temp:= Zone+':'+Net+'/'+Node+'.'+Point;
  Temp1:= CalcCRC32(Temp); Temp1:= AddSlash(Path)+Temp1;
  Assign(F, Temp1+'.t$p'); ReWrite(F); Close(F);
  {$I-} Rename(F, Temp1+Busy); {$I+}
  If IOResult = 0 Then CreateFDBusy:= True Else Erase(F)
End;

Function ReadLoFile(Path: String; Var Lo: PTextCollection): Boolean;
Var
  FH   : Text;
  Temp : String;
  PTemp: PString;
Begin
  ReadLoFile:= False;
  { ⨥ 䠩 }
  Assign(FH, Path); {$I-} Reset(FH); {$I+}
  If IOResult <> 0 Then Exit;
  If Lo = nil Then Lo:= New(PTextCollection, Init(3, 3));
  If Lo^.Count <> 0 Then Lo^.FreeAll;
  { ⥭ 誨   }
  While not EOF(FH) Do
    Begin
      ReadLn(FH, Temp); PTemp:= NewStr(Temp);
      If PTemp <> Nil Then Lo^.Insert(PTemp)
    End;
  Close(FH); ReadLoFile:= True
End;

Function WriteLoFile(Path: String; Lo: PTextCollection): Boolean;
Var
  FH   : Text;
  I    : LongInt;
Begin
  WriteLoFile:= False;
  If (Lo = nil) or (Lo^.Count = 0) Then Exit;
  { ⨥ 䠩 }
  Assign(FH, Path); {$I-} ReWrite(FH); {$I+}
  If IOResult <> 0 Then Exit;
  I:= 0;
  While I < Lo^.Count Do
    Begin
      WriteLn(FH, PString(Lo^.At(I))^); Inc(I)
    End;
  Close(FH); WriteLoFile:= True
End;

End.

