{**********************************************}
{*                                            *}
{*      Date management utilities v1.00       *}
{*                                            *}
{*  This is the part of the "Utilities pack"  *}
{*                                            *}
{*           Copyright (c) 1999 by            *}
{*  Alexander S. Tokareff, 2:5077/27@fidonet  *}
{*                                            *}
{**********************************************}
{$R-,Q-}
{$IFDEF VIRTUALPASCAL}
{$Delphi+,J+}
{$ENDIF VIRTUALPASCAL}

{$IFDEF BORLANDPASCAL}
Unit DateUtil;
{$ELSE}
Unit DateUtils;
{$ENDIF BORLANDPASCAL}
Interface
Uses Dos;
Const
 MonthLen : array[1..12] of byte =
  { Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec }
  ( 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 );

 MonthDays : array[0..1] of array[1..12] of integer = (
 { Jan Feb Mar Apr May  Jun  Jul  Aug  Sep  Oct  Nov  Dec }
  ( 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 ),
 { Jan Feb Mar Apr May  Jun  Jul  Aug  Sep  Oct  Nov  Dec }
  ( 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335 ) );

 MonthSeconds : array[0..1] of array[1..12] of longint = (
 { Jan Feb      Mar      Apr      May       Jun       Jul       Aug       Sep       Oct       Nov       Dec }
  ( 0, 2678400, 5097600, 7776000, 10368000, 13046400, 15638400, 18316800, 20995200, 23587200, 26265600, 28857600 ),
 { Jan Feb      Mar      Apr      May       Jun       Jul       Aug       Sep       Oct       Nov       Dec }
  ( 0, 2678400, 5184000, 7862400, 10454400, 13132800, 15724800, 18403200, 21081600, 23673600, 26352000, 28944000 ) );

 function Date2Unix( dt : DateTime ) : longint;
 procedure Unix2Date( utime : longint; var dt : DateTime );

 function Date2UnixExt( day, month, year, hour, minute, second : integer ) : longint;
 procedure Unix2DateExt( utime : longint; var day, month, year, dow, hour, minute, second : integer );

 function DosTime2UnixTime( dostime : longint ) : longint;
 function UnixTime2DosTime( unixtime : longint ) : longint;

 function TimeNow : longint;

 function LeapYear( year : integer ) : boolean;

 function DayOfWeek( day, month, year : integer ) : byte;

 function YearSeconds( day, month, year : integer ) : longint;

Implementation

 function Date2Unix( dt : DateTime ) : longint;
 var
  res : longint;
  i, t : integer;
 begin
  res := ( dt.Year - 1970 ) * 365 + ( dt.Year - 1969 ) div 4;
  t := 0;
  for i := 1 to dt.Month - 1 do t := t + MonthLen[i];
  if ( ( LeapYear( dt.Year ) ) and ( dt.Month > 2 ) ) then inc( t );
  res := res + t + ( dt.Day - 1 );
  res := res * 24 + dt.Hour;
  res := res * 60 + dt.Min;
  res := res * 60 + dt.Sec;
  Date2Unix := res;
 end;

 procedure Unix2Date( utime : longint; var dt : DateTime );
 var
  i, t, y, d, dy : longint;
 begin
  i := 0; y := 0; d := 0; dy := 0;
  t := utime;
  dt.Sec := t mod 60; t := t div 60;
  dt.Min := t mod 60; t := t div 60;
  dt.Hour := t mod 24; t := t div 24;
  i := t; y := 1970; d := 0;
  while ( i > 365 ) do
  begin
   if ( LeapYear( y ) ) then dy := 366 else dy := 365;
   dec( i, dy );
   inc( d, dy );
   inc( y );
  end;
  if ( LeapYear( y ) ) then MonthLen[2] := 29;
  dt.Year := y;
  d := t - d + 1;
  i := 1; dy := 0; y := d;
  while ( y > 0 ) do
  begin
   dec( y, MonthLen[i] );
   inc( dy, MonthLen[i] );
   inc( i );
  end;
  dt.Month := i - 1;
  dec( dy, MonthLen[i - 1] );
  dt.Day := d - dy;
 end;

 function Date2UnixExt( day, month, year, hour, minute, second : integer ) : longint;
 var
  dt : DateTime;
 begin
  dt.Day := day; dt.Month := month; dt.Year := year;
  dt.Hour := hour; dt.Min := minute; dt.Sec := second;
  Date2UnixExt := Date2Unix( dt );
 end;

 procedure Unix2DateExt( utime : longint; var day, month, year, dow, hour, minute, second : integer );
 var
  dt : DateTime;
 begin
  Unix2Date( utime, dt );
  year := dt.Year;
  month := dt.Month;
  day := dt.Day;
  dow := DayOfWeek( day, month, year );
  hour := dt.Hour;
  minute := dt.Min;
  second := dt.Sec;
 end;

 function DosTime2UnixTime( dostime : longint ) : longint;
 var
  dt : DateTime;
 begin
  UnpackTime( dostime, dt );
  DosTime2UnixTime := Date2Unix( dt );
 end;

 function UnixTime2DosTime( unixtime : longint ) : longint;
 var
  dt : DateTime;
  dostime : longint;
 begin
  Unix2Date( unixtime, dt );
  PackTime( dt, dostime );
  UnixTime2DosTime := dostime;
 end;

 function TimeNow : longint;
 var
  dt : DateTime;
 {$IFDEF BORLANDPASCAL}
  day, month, year, dow, hour, minute, second, msec : word;
 {$ELSE}
  day, month, year, dow, hour, minute, second, msec : longint;
 {$ENDIF BORLANDPASCAL}
 begin
  GetDate( year, month, day, dow );
  GetTime( hour, minute, second, msec );
  dt.Day := day; dt.Month := month; dt.Year := year;
  dt.Hour := hour; dt.Min := minute; dt.Sec := second;
  TimeNow := Date2Unix( dt );
 end;

 function LeapYear( year : integer ) : boolean;
 begin
  LeapYear := ( ( ( ( year mod 4 ) = 0 ) and not ( ( year mod 100 ) = 0 ) ) or ( ( year mod 400 ) = 0 ) );
 end;

 function DayOfWeek( day, month, year : integer ) : byte;
 var
  y1, y2 : integer;
 begin
  if ( month < 3 ) then
  begin
   month := month + 10;
   year := year - 1;
  end
  else month := month - 2;
  y1 := year div 100;
  y2 := year mod 100;
  DayOfWeek := ( ( ( day + trunc( 2.6 * month - 0.1 ) + y2 + y2 div 4 + y1 div 4 - 2 * y1 + 49 ) mod 7 ) + 1 ) - 1;
 end;

 function YearSeconds( day, month, year : integer ) : longint;
 begin
  YearSeconds := MonthSeconds[byte( LeapYear( year ) )][month] + ( ( day - 1 ) * 86400 );
 end;

End.

