{***************************************************************************}
{*                                                                         *}
{*                 ⥭ 䨣樮 䠩.                *}
{*                                                                         *}
{*       Copyright (c) 1999 by Konstantin Kubatkin, 2:468/13@Fidonet       *}
{*       Copyright (c) 1995 by basil v. vorontsov, 5020/487@Fidonet        *}
{*                                                                         *}
{***************************************************************************}
Unit CfgMgr;

Interface
Uses Objects, TextColl;

Const
  ErrorID: String[15] = ' Error ';

{ TCfg error flags }
Const
  cfgOk          = 0;
  cfgCannotOpen  = 1;
  cfgCannotClose = 2;
  cfgCannotRead  = 3;
  cfgCannotWrite = 4;

Const
  CfgError: Integer = cfgOk;

{ ᯮ짮   ६ 㦥 }
Const
  UseEnv: Boolean = True;

Type
  PParamRec = ^TParamRec;
  TParamRec = Record
    CfgLine    : LongInt;
    ParamName  : String;
    ParamValue : String
  End;

Type
  PParamCollection = ^TParamCollection;
  TParamCollection = Object(TCollection)
    Procedure FreeItem(Item: Pointer); Virtual;
  End;

Type
  PCfg = ^TCfg;
  TCfg = Object(TObject)
    CfgName    : String;
    CfgFile    : Text;
    CurrentRec : LongInt;
    Param      : String;
    Value      : String;
    CfgArray   : PTextCollection;
    ParamArray : PParamCollection;
    { 樠 cfg 䠩   nCfg }
    { ᠬ cfg 頥  CfgArray         }
    { ࠬ   祭  ParamArray  }
    Constructor Init(nCfg: String);
    {  ⥪騩 ࠬ }
    Function GetCurrentParam: String;
    {  ᫥騩 ࠬ }
    Function GetNextParam: String;
    { ஢,    ⠪ ࠬ AParam }
    Function FindFirstParam(AParam: String): Boolean;
    { ஢,     ࠬ AParam}
    Function FindNextParam: Boolean;
    {  祭 ⥪饣 ࠬ }
    Function GetCurrentValue: String;
    {  ࢮ 祭 ࠬ AParam }
    Function GetValue(AParam: String): String;
    {  ᫥饥 祭 AParam }
    Function GetNextValue: String;
    { 뢠 䨣   }
    Procedure WriteCfg;
    { ᢮  }
    Destructor  Done; virtual;
  End;

Implementation
Uses Tools, Dos;

Procedure TParamCollection.FreeItem(Item: Pointer);
Begin
  Dispose(PParamRec(Item))
End;

Constructor TCfg.Init;
Var
  Str    : String;
  Temp   : String;
  TempStr: String;
  Buf    : Array [1..256] of Char;
  TempRec: PParamRec;
  I      : LongInt;
  J      : LongInt;
Begin
  { 樠㥬 ६ }
  CfgError:= cfgOk; CfgName:= nCfg;
  { 뢠 䨣 }
  Assign(CfgFile, CfgName); {$I-} Reset(CfgFile); {$I+}
  If IOResult <> 0 Then Begin CfgError:= cfgCannotOpen; Fail End;
  SetTextBuf(CfgFile, Buf, SizeOf(Buf));
  { 樠㥬 樨 }
  CfgArray:= New(PTextCollection, Init(1, 1));
  ParamArray:= New(PParamCollection, Init(1, 1));
  { ࠡ뢠 䨣 }
  While not EOF(CfgFile) Do
    Begin
      {$I-} ReadLn(CfgFile, Str); {$I+}
      If IOResult <> 0 Then Begin cfgError:= cfgCannotRead; Fail End;
      CfgArray^.Insert(NewStr(Str));
      { ࠡ뢠 ப  । 뤥 ࠬ   祭 }
      {  ਥ }
      If Pos(';', Str) > 0 Then
        Delete(Str, Pos(';', Str), Length(Str)-Pos(';', Str) + 1);
      Str:= RemoveSpaces(Str);
      { ᫨  ப - 室  ᫥騩 横 }
      If Str = '' Then Continue;
      {  ᨬ ⠡樨 }
      For I:= 1 To Length(Str) Do If Str[I] = #9 Then Str[I]:= ' ';
      {  ⮣, ⮡  뫮  ⨯: Address=2:468/28.33 }
      If Pos('=', Str) > 0 Then Str[Pos('=',Str)]:= ' ';
      { ᫨  ࠬ,  祭 }
      If Pos(' ', Str) = 0 Then Begin Param:= Str; Value:= '' End
        Else
          Begin
            SplitString(Str, Param, Value);
            {᫨  祭 ᯮ ६ 㦥}
            If UseEnv Then
              Begin
                J:= 0;
                For I:= 1 To Length(Value) Do
                  If Value[I] = '%' Then Inc(J);
                If J > 1 Then
                  Begin
                    Temp:= Copy(Value, 1, Pos('%', Value)-1);
                    Delete(Value, 1, Pos('%', Value));
                    TempStr:= Copy(Value, 1, Pos('%', Value)-1);
                    Delete(Value, 1, Pos('%', Value));
                    If GetEnv(TempStr) = '' Then Value:= ErrorID
                      Else Value:= Temp + GetEnv(TempStr) + Value
                  End
              End
          End;
      TempRec:= New(PParamRec);
      TempRec^.CfgLine:= CfgArray^.Count;
      TempRec^.ParamName:= Param;
      TempRec^.ParamValue:= Value;
      ParamArray^.Insert(TempRec)
    End;
  { 뢠 䨣 }
  {$I-} Close(CfgFile); {$I+}
  If IOResult <> 0 Then Begin cfgError:= cfgCannotClose; Fail End;
  CurrentRec:= 0; Param:= ''; Value:= ''
End;

Function TCfg.GetCurrentParam: String;
Begin
  GetCurrentParam:= ' Error '; If ParamArray^.Count= 0 Then Exit;
  GetCurrentParam:= PParamRec(ParamArray^.At(CurrentRec))^.ParamName
End;

Function TCfg.GetNextParam;
Begin
  GetNextParam:= ' Error '; Inc(CurrentRec);
  If (ParamArray^.Count = 0) or ((CurrentRec) > ParamArray^.Count) Then Exit;
  GetNextParam:= PParamRec(ParamArray^.At(CurrentRec))^.ParamName
End;

Function TCfg.FindFirstParam(AParam: String): Boolean;
Begin
  FindFirstParam:= False; If ParamArray^.Count = 0 Then Exit;
  CurrentRec:= 0; Param:= AParam;
  While CurrentRec < ParamArray^.Count Do
    Begin
      If UpCaseStr(Param) = UpCaseStr(PParamRec(ParamArray^.At(CurrentRec))^.ParamName) Then
        Begin
          FindFirstParam:= True;
          Break
        End;
      Inc(CurrentRec)
    End
End;

Function TCfg.FindNextParam: Boolean;
Begin
  FindNextParam:= False; Inc(CurrentRec);
  If (ParamArray^.Count = 0) or ((CurrentRec) > ParamArray^.Count) Then Exit;
  While CurrentRec < ParamArray^.Count Do
    Begin
      If UpCaseStr(Param) = UpCaseStr(PParamRec(ParamArray^.At(CurrentRec))^.ParamName) Then
        Begin
          FindNextParam:= True;
          Break
        End;
      Inc(CurrentRec)
    End
End;

Function TCfg.GetCurrentValue: String;
Begin
  GetCurrentValue:= ' Error '; If ParamArray^.Count = 0 Then Exit;
  GetCurrentValue:= PParamRec(ParamArray^.At(CurrentRec))^.ParamValue
End;

Function TCfg.GetValue(AParam: String): String;
Begin
  GetValue:= ' Error '; If ParamArray^.Count = 0 Then Exit;
  CurrentRec:= 0; Param:= AParam;
  While CurrentRec < ParamArray^.Count Do
    Begin
      If UpCaseStr(Param) = UpCaseStr(PParamRec(ParamArray^.At(CurrentRec))^.ParamName) Then
        Begin
          GetValue:= PParamRec(ParamArray^.At(CurrentRec))^.ParamValue;
          Break
        End;
      Inc(CurrentRec)
    End
End;

Function TCfg.GetNextValue: String;
Begin
  GetNextValue:= ' Error '; Inc(CurrentRec);
  If (ParamArray^.Count = 0) or ((CurrentRec) > ParamArray^.Count) Then Exit;
  While CurrentRec < ParamArray^.Count Do
    Begin
      If UpCaseStr(Param) = UpCaseStr(PParamRec(ParamArray^.At(CurrentRec))^.ParamName) Then
        Begin
          GetNextValue:= PParamRec(ParamArray^.At(CurrentRec))^.ParamValue;
          Break
        End;
      Inc(CurrentRec)
    End
End;

Procedure TCfg.WriteCfg;
Var
  I: LongInt;
Begin
  CfgError:= cfgOk; I:= 0;
  If (CfgArray = nil) or (CfgArray^.Count = 0) Then Exit;
  {$I-} ReWrite(CfgFile); {$I+}
  If IOResult <> 0 Then Begin CfgError:= cfgCannotOpen; Exit End;
  While I < CfgArray^.Count Do
    Begin
      {$I-} WriteLn(CfgFile, PString(CfgArray^.At(I))^); {$I+}
      If IOResult <> 0 Then Begin CfgError:= cfgCannotWrite; Exit End;
      Inc(I)
    End;
  {$I-} Close(CfgFile); {$I+}
  If IOResult <> 0 Then Begin CfgError:= cfgCannotClose; Exit End
End;

Destructor TCfg.Done;
Begin
  CfgError:= cfgOk;
  If CfgArray <> nil Then Dispose(CfgArray, Done);
  If ParamArray <> nil Then Dispose(ParamArray, Done);
  Inherited Done;
End;

End.
