{***************************************************************************}
{*                                                                         *}
{*                    ࠡ  娢.                       *}
{*                                                                         *}
{*       Copyright (c) 1999 by Konstantin Kubatkin, 2:468/13@Fidonet       *}
{*                                                                         *}
{***************************************************************************}
Unit ArcMgr;

Interface
Uses Objects, CfgMgr;

{ ப  ᮮ饭  訡 }
Const
  ErrorID: String[15] = ' Error ';

{ TArc error flags }
Const
  arcOk          = 0;
  arcCannotOpen  = 1;
  arcCannotClose = 2;
  arcCannotRead  = 3;
  arcCannotWrite = 4;
  arcNoComspec   = 5;
  arcNotFound    = 6;

Const
  ArcError: Integer = arcOk;


{ ᠭ ⨯   娢 }
Type
  PArcRec = ^TArcRec;
  TArcRec = Record
    Archiver  : String;
    Extension : String;
    Ident     : String;
    Add       : String;
    Extract   : String;
    View      : String;
  End;

{ ᠭ ⨯ ᯨ᪠ 娢஢ }
Type
  PArcCollection = ^TArcCollection;
  TArcCollection = Object(TCollection)
    Procedure FreeItem(Item: Pointer); Virtual;
  End;

Type
  PArc = ^TArc;
  TArc = Object(TObject)
    ArcName    : String;
    ArcFile    : Text;
    OS         : String;
    CurrentRec : LongInt;
    ArcCfg     : PCfg;
    ArcArray   : PArcCollection;
    Comspec    : String;
    Archiver   : String;
    ArchiveName: String;
    FileName   : String;
    PathName   : String;
    ExecLine   : String;
    ClearScr   : Boolean;
    ClearErr   : Boolean;
    OSError    : LongInt;
    ArcError   : LongInt;
    { 樠 compress.cfg 䠩   nArc  }
    {  樮 OS                              }
    { OS2 - OS/2, DOS - DOS, W32 - Win32, NIX - *NIX  }
    Constructor Init(nArc: String; nOS: String);
    { 㧭, 祬  䠩 fName }
    Function GetArcType(fName: String): String;
    {  Extension  娢 aName }
    Function GetArcExtension(aName: String): String;
    {  Ident  娢 aName }
    Function GetArcIdent(aName: String): String;
    {  Add  娢 aName }
    Function GetArcAdd(aName: String): String;
    {  Extract  娢 aName }
    Function GetArcExtract(aName: String): String;
    {  View  娢 aName }
    Function GetArcView(aName: String): String;
    { 㥬 䠩 FileName  娢 ArchiveName 娢஬ Archiver }
    Procedure Add;
    {   娢 ArchiveName 䠩 FileName   PathName }
    { 娢஬ Archiver }
    Procedure Extract;
    { ᬮਬ ᮤন 娢 }
    Procedure View;
    { 뢮  ࠭  娢 }
    Procedure WriteArc;
    { ᢮  }
    Destructor  Done; virtual;
  End;

Implementation
Uses Tools, Dos;

{ ᢮    娢 }
Procedure TArcCollection.FreeItem(Item: Pointer);
Begin
  Dispose(PArcRec(Item))
End;

Constructor TArc.Init;
Var
  Temp   : String;
  Temp1  : String;
  Temp2  : String;
  TempArc: PArcRec;
Begin
  { 樠㥬 ६ }
  ArcError:= arcOk; ArcName:= nArc; OS:= nOS; UseEnv:= False;
  ClearScr:= False; ClearErr:= False; OSError:= 0; ArcError:= 0;
  ExecLine:= '';
  { 뢠 compress.cfg }
  ArcCfg:= New(PCfg, Init(ArcName));
  If (ArcCfg = nil) or (CfgError <> cfgOk) Then
    Begin ArcError:= arcCannotOpen; Fail End;
  Comspec:= GetEnv('COMSPEC');
  If Comspec = '' Then
    Begin ArcError:= arcNoComspec; Fail End;
  { 樠㥬 ᨢ 娢஢ }
  ArcArray:= New(PArcCollection, Init(1, 1));
  { ࠡ뢠 祭 १ }
  If ArcCfg^.FindFirstParam('Archiver') Then
    Repeat
      { 樠 ६ }
      TempArc:= New(PArcRec);
      TempArc^.Archiver:= ErrorID; TempArc^.Extension:= ErrorID;
      TempArc^.Ident:= ErrorID; TempArc^.Add:= ErrorID;
      TempArc^.Extract:= ErrorID; TempArc^.View:= ErrorID;
      {  ᥩ }
      Temp:= UpCaseStr(ArcCfg^.GetCurrentParam);
      While (Temp <> 'END') and (UpCaseStr(ArcCfg^.GetCurrentValue) <> 'ARCHIVER') Do
        Begin
          { ⠥  娢 }
          If Temp = 'ARCHIVER' Then
            TempArc^.Archiver:= ArcCfg^.GetCurrentValue
          Else
            { ⠥  ७  㬮砭 }
            If Temp = 'EXTENSION' Then
              TempArc^.Extension:= ArcCfg^.GetCurrentValue
            Else
              { ⠥  ᨣ }
              If Temp = 'IDENT' Then
                TempArc^.Ident:= ArcCfg^.GetCurrentValue
              Else
                { ⠥  娢 }
                If Temp = UpCaseStr(OS) Then
                  Begin
                    Temp1:= ArcCfg^.GetCurrentValue;
                    Temp2:= RemoveSpaces(Copy(Temp1, 1, Pos(' ', Temp1)));
                    Delete(Temp1, 1, Pos(' ', Temp1)); Temp1:= RemoveSpaces(Temp1);
                    If UpCaseStr(Temp2) = 'ADD' Then
                      TempArc^.Add:= Temp1
                    Else
                      If UpCaseStr(Temp2) = 'EXTRACT' Then
                        TempArc^.Extract:= Temp1
                      Else
                        If UpCaseStr(Temp2) = 'VIEW' Then
                          TempArc^.View:= Temp1
                  End
                Else
                  { ⠥  娢  㬮砭 }
                  If Temp = 'ADD' Then
                    TempArc^.Add:= ArcCfg^.GetCurrentValue
                  Else
                    If Temp = 'EXTRACT' Then
                      TempArc^.Extract:= ArcCfg^.GetCurrentValue
                     Else
                       If Temp = 'VIEW' Then
                         TempArc^.View:= ArcCfg^.GetCurrentValue;
          { 饬 ᫥饥 祭 }
          Temp:= UpCaseStr(ArcCfg^.GetNextParam)
        End;
      { ᨬ   }
      ArcArray^.Insert(TempArc)
    {    ᠭ 娢஢ }
    Until not ArcCfg^.FindNextParam;
  { ᢮  }
  Dispose(ArcCfg, Done)
End;

Function TArc.GetArcType(fName: String): String;
Var
  Offset : String;
  Code   : String;
  Temp   : String;
  FH     : PDosStream;
  Buf    : Array [1..10] of Byte;
  I      : LongInt;
  J      : LongInt;
  Len    : Word;
  TempArc: PArcRec;
Begin
  GetArcType:= ErrorID; If ArcArray^.Count = 0 Then Exit; I:= 0;
  While I < ArcArray^.Count Do
    Begin
      { 뢠  娢  樨 }
      TempArc:= ArcArray^.At(I);
      Offset:= Copy(TempArc^.Ident, 1, Pos(',', TempArc^.Ident)-1);
      Code:= Copy(TempArc^.Ident, Pos(',', TempArc^.Ident)+1, Length(TempArc^.Ident));
      Len:= (Length(Code) div 2);
      { 뢠 娢  ⥭ }
      FH:= New(PDosStream, Init(fName, stOpenRead));
      If (FH^.Status <> stOk ) Then Exit;
      { ।  㦭  }
      If Pos('-', Offset) = 0 Then FH^.Seek(XVal(Offset))
        Else FH^.Seek(FH^.GetSize + XVal(Offset) + 1);
      { 뢠 䨪 }
      FH^.Read(Buf, Len); FH^.Done;
      { 㥬 ⨯ 娢 }
      Temp:= '';
      For J:= 1 To Len Do
        Begin
          If Length(Dec2Hex(Buf[J])) = 1 Then Temp:= Temp + '0' + Dec2Hex(Buf[J])
            Else Temp:= Temp + Dec2Hex(Buf[J])
        End;
      { ᫨  ⥪騩 ⨯ 娢 }
      If UpCaseStr(Temp) = UpCaseStr(Code) Then
        Begin GetArcType:= TempArc^.Archiver; Exit End;
      Inc(I)
    End
End;

Function TArc.GetArcExtension(aName: String): String;
Var
  I: LongInt;
Begin
  GetArcExtension:= ErrorID; I:= 0;
  If (ArcArray = nil) or (ArcArray^.Count = 0) Then Exit;
  While I < ArcArray^.Count Do
    Begin
      If UpCaseStr(PArcRec(ArcArray^.At(I))^.Archiver) = UpCaseStr(aName) Then
        GetArcExtension:= PArcRec(ArcArray^.At(I))^.Extension;
      Inc(I)
    End
End;

Function TArc.GetArcIdent(aName: String): String;
Var
  I: LongInt;
Begin
  GetArcIdent:= ErrorID; I:= 0;
  If (ArcArray = nil) or (ArcArray^.Count = 0) Then Exit;
  While I < ArcArray^.Count Do
    Begin
      If UpCaseStr(PArcRec(ArcArray^.At(I))^.Archiver) = UpCaseStr(aName) Then
        GetArcIdent:= PArcRec(ArcArray^.At(I))^.Ident;
      Inc(I)
    End
End;

Function TArc.GetArcAdd(aName: String): String;
Var
  I: LongInt;
Begin
  GetArcAdd:= ErrorID; I:= 0;
  If (ArcArray = nil) or (ArcArray^.Count = 0) Then Exit;
  While I < ArcArray^.Count Do
    Begin
      If UpCaseStr(PArcRec(ArcArray^.At(I))^.Archiver) = UpCaseStr(aName) Then
        GetArcAdd:= PArcRec(ArcArray^.At(I))^.Add;
      Inc(I)
    End
End;

Function TArc.GetArcExtract(aName: String): String;
Var
  I: LongInt;
Begin
  GetArcExtract:= ErrorID; I:= 0;
  If (ArcArray = nil) or (ArcArray^.Count = 0) Then Exit;
  While I < ArcArray^.Count Do
    Begin
      If UpCaseStr(PArcRec(ArcArray^.At(I))^.Archiver) = UpCaseStr(aName) Then
        GetArcExtract:= PArcRec(ArcArray^.At(I))^.Extract;
      Inc(I)
    End
End;

Function TArc.GetArcView(aName: String): String;
Var
  I: LongInt;
Begin
  GetArcView:= ErrorID; I:= 0;
  If (ArcArray = nil) or (ArcArray^.Count = 0) Then Exit;
  While I < ArcArray^.Count Do
    Begin
      If UpCaseStr(PArcRec(ArcArray^.At(I))^.Archiver) = UpCaseStr(aName) Then
        GetArcView:= PArcRec(ArcArray^.At(I))^.View;
      Inc(I)
    End
End;

Procedure TArc.Add;
Var
  Temp: String;
Begin
  OSError:= 0; ArcError:= 0;
  { ᬮ,   }
  ExecLine:= GetArcAdd(Archiver);
  { ᫨  ᠭ  compress.cfg }
  If ExecLine = ErrorID Then
    Begin ArcError:= arcNotFound; Exit End;
  { ࠡ뢠  %a, %p, %f }
  Temp:= UpCaseStr(ExecLine);
  If Pos('%A', Temp) > 0 Then
    Begin
      Insert(ArchiveName, ExecLine, Pos('%A', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%A', Temp), 2)
    End;
  If Pos('%P', Temp) > 0 Then
    Begin
      Insert(PathName, ExecLine, Pos('%P', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%P', Temp), 2)
    End;
  If Pos('%F', Temp) > 0 Then
    Begin
      Insert(FileName, ExecLine, Pos('%F', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%F', Temp), 2)
    End;
  { ।    ᯮ }
  If ClearScr Then ExecLine:= ExecLine + ' 1>nul';
  If ClearErr Then ExecLine:= ExecLine + ' 2>nul';
  Exec(Comspec, ' /C ' + ExecLine);
  { 砥  訡 }
  OSError:= DosError; ArcError:= DosExitCode
End;

Procedure TArc.Extract;
Var
  Temp: String;
Begin
  OSError:= 0; ArcError:= 0;
  { ⠢  ᪠ }
  ExecLine:= GetArcExtract(Archiver);
  { ࠡ뢠  %a, %p, %f }
  Temp:= UpCaseStr(ExecLine);
  If Pos('%A', Temp) > 0 Then
    Begin
      Insert(ArchiveName, ExecLine, Pos('%A', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%A', Temp), 2)
    End;
  If Pos('%P', Temp) > 0 Then
    Begin
      Insert(PathName, ExecLine, Pos('%P', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%P', Temp), 2)
    End;
  If Pos('%F', Temp) > 0 Then
    Begin
      Insert(FileName, ExecLine, Pos('%F', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%F', Temp), 2)
    End;
  { ।    ᯮ }
  If ClearScr Then ExecLine:= ExecLine + ' 1>nul';
  If ClearErr Then ExecLine:= ExecLine + ' 2>nul';
  Exec(Comspec, ' /C ' + ExecLine);
  { 砥  訡 }
  OSError:= DosError; ArcError:= DosExitCode
End;

Procedure TArc.View;
Var
  Temp: String;
Begin
  OSError:= 0; ArcError:= 0;
  { ᬮ,   }
  ExecLine:= GetArcView(Archiver);
  { ᫨  ᠭ  compress.cfg }
  If ExecLine = ErrorID Then
    Begin ArcError:= arcNotFound; Exit End;
  { ࠡ뢠  %a, %p, %f }
  Temp:= UpCaseStr(ExecLine);
  If Pos('%A', Temp) > 0 Then
    Begin
      Insert(ArchiveName, ExecLine, Pos('%A', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%A', Temp), 2)
    End;
  If Pos('%P', Temp) > 0 Then
    Begin
      Insert(PathName, ExecLine, Pos('%P', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%P', Temp), 2)
    End;
  If Pos('%F', Temp) > 0 Then
    Begin
      Insert(FileName, ExecLine, Pos('%F', Temp));
      Temp:= UpCaseStr(ExecLine); Delete(ExecLine, Pos('%F', Temp), 2)
    End;
  { ।    ᯮ }
  If ClearScr Then ExecLine:= ExecLine + ' 1>nul';
  If ClearErr Then ExecLine:= ExecLine + ' 2>nul';
  Exec(Comspec, ' /C ' + ExecLine);
  { 砥  訡 }
  OSError:= DosError; ArcError:= DosExitCode
End;

Procedure TArc.WriteArc;
Var
  I: LongInt;
Begin
  I:= 0;
  While I < ArcArray^.Count Do
    Begin
      WriteLn('Archiver   : ',PArcRec(ArcArray^.At(I))^.Archiver);
      WriteLn('  Extension: ',PArcRec(ArcArray^.At(I))^.Extension);
      WriteLn('  Ident    : ',PArcRec(ArcArray^.At(I))^.Ident);
      WriteLn('  Add      : ',PArcRec(ArcArray^.At(I))^.Add);
      WriteLn('  Extract  : ',PArcRec(ArcArray^.At(I))^.Extract);
      WriteLn('  View     : ',PArcRec(ArcArray^.At(I))^.View);
      ReadLn;
      Inc(I)
    End
End;

Destructor TArc.Done;
Begin
  ArcError:= arcOk;
  If ArcArray <> nil Then Dispose(ArcArray, Done);
  Inherited Done;
End;

End.
