(* Copyright (C) 1997-2000  Michail A.Baikov (2:5020/1305@Fidonet.Org)
   All rights reserved.

   Read LICENSE in distribution archive for more information.

   For contact mail us baikov@mosfilm.ru
*)

{$IFDEF VIRTUALPASCAL}
{$B-,D+,F+,H-,I-,J-,L+,P-,Q-,R-,S-,T-,V+,W-,X+,Z-}
{&AlignCode+,AlignData-,AlignRec-,Asm+,Delphi-,Frame+,G5+,LocInfo+,Open32-}
{&Optimise+,OrgName-,SmartLink+,Speed+,Use32-,ZD+}
{$M 65535,1048576}
{$ENDIF}

unit global;

interface

uses windows,objects,dos,types;

type

PStrings = ^TStrings;
TStrings = object(TCollection)
 procedure FreeItem(Item: Pointer); virtual;
end;

SendType        = (Kill,Cut,NoKill);

feclink = record
Address:NewAddress;
Status:Char;
end;

nstring         =string;

felistffx       = record {felist.ffx}
area                      :string[45];
description               :string;
end;

announceffx     = record {announce.ffx}
area                     :char;
path                     :string;
from                     :addrtype;
groups                   :string[40];
password                 :string[8];
destination              :addrtype;
end;

newareagroupffx = record {newareag.ffx}
address                  :addrtype;
group                    :char;
path                     :string;
flags                    :string;
links                    :array [1..255] of addrtype;   {links.ffx}
end;


linksffx        = record {links.ffx}
address                 :addrtype;
sysopname               :string[36];
password                :string[8];
flags                   :string;
groups                  :string[26];
route                   :char;
end;

fileechosffx    = record
area                    :string[36];
path                    :string;
flags                   :string;
description             :string[60];
group                   :string[26];
links                   :array [1..512] of feclink;
end;

configffx       = record
fastfixid               :word;
address                 :array [1..40] of addrtype;
getfileiddiz            :array [1..20] of nstring;
putfilesbbs             :array [1..20] of nstring;
addfiles                :array [1..10] of string[80];
Inbound                 :String;
Netmail_In              :String;
Netmail_Out             :String;
Outbound                :String;
Outtics                 :String;
BadDirectory            :String;
DupeDirectory           :String;
TempDirectory           :String;
LogDirectory            :String;
FileEchoDirectory       :String;
AnnounceDirectory       :String;
Pluginsdirectory        :String;
TemplateDirectory       :String;
BadLog                  :String;
NewFechoLog             :String;

MailerMode              :String;
AddComment              :String;
AnnounceCheck           :String;
FormatBBS               :String;
LogChars                :String;
Backup                  :Boolean;
ForceDesc               :Boolean;
DupeFilesbbs            :boolean;
MOverride               :boolean;
MaskSupport             :Boolean;
LongNames               :Boolean;

MaxWaitFile             :Longint;
MaxFreeOutbound,
MaxFreeFileecho,
MaxFreeWork             :Longint;

DupeLimit               :Longint;
CutMessages             :Word;

MainZone                :Word;
Ignores                 :byte;
StartFilesbbs           :byte;
DupeCheck               :Byte;
Margin                  :Word;

DefaultRoute            :Char;

crcid                   :string[8];
end;

var

                Parameter              :Integer;
                NextParam              :Integer;
                cfg,cfg2,cfg3          :Text;

                posit                  :Word;
                flog                   :Text;
                error                  :Integer;
                rs,rs1,rs2             :Searchrec;

                lastmsgid:string;
                num:longint;

                tfl                    :word; {- p 䠩}

                UpdateConfig     :Boolean;

const
  fRead     = 1;
  fAppend   = 2;
  frewrite  = 3;

const

     Ok                         = 00000;
     LowSendSecurity            = 00001;
     LowReceiveSecurity         = 00002;
     CreateFechoError           = 00004;
     OriginIsUnknown            = 00008;
     FromIsUnknown              = 00016;
     Filenotfound               = 00032;
     BadSize                    = 00064;
     DestinationIsNotForUs      = 00128;
     DupeLink                   = 00256;
     ReplaceError               = 00512;
     BadCrc                     = 01024;
     BadPassword                = 02048;
     UnknownFecho               = 04096;
     NoLink                     = 08192;
     UnknownLink                = 16384;

     UnknownArchive             = 32768;
     FileReadError              = 65535;

{$IFDEF WIN32}
const version='FastFIX/W32 v1.00 alpha 13';

const sversion=$A1D0;

const rights='Copyright (C) 1997-2000 by Michail A.Baikov (2:5020/1305)';
{$ENDIF}

{$IFDEF OS2}

const version='FastFIX/2 v1.00 alpha 13';

const sversion=$A1D0;

const rights='Copyright (C) 1997-2000 by Michail A.Baikov (2:5020/1305)';

{$ENDIF}

type

RTic          = record
{H 䠩}
                Area             :PString;
{ᠭ 䠩}
                AreaDesc         :PString;
{p ⥬,  p 䠩  y饭  䠩y}
                Origin           :NewPAddr;
{p ⥬,  p  ⥬ y稫 䠩}
                From             :NewPAddr;
{ 䠩}
                File_            :PString;
{ 䠩}
                Size             :Longint;
{p⪮ ᠭ}
                Desc             :PString;
{ ᠭ}
                LDesc            :PCollection;
{p     p祭 TIC-䠩}
                Destination      :NewPAddr;
{Path}
                Path             :PCollection;
{Seen-by}
                Seenby           :PCollection;
{᪠  堭 REPLACE}
                Replaces         :PString;
{CRC-32 䠩}
                Crc              :String;
{p}
                Password         :PString;
{ ᮧ tic-䠩}
                Created          :PString;
end;

RTossUpdateScreen = record
        NameTic         :PString;
        TotalSize       :Longint;
        CurrentSize     :Longint;
        CurrentTic      :Longint;
        TotalTics       :Longint;
        TotalFiles      :Longint;
        SpeedTics       :Longint;
        SpeedFiles      :Longint;
        TotalTime       :Longint;
        ExtTotalTime    :Longint;
        Tic             :RTic;
        SendMessage     :PString;
        Reserved        :Longint;

        NormalFiles     :Longint;
        DuplicateFiles  :Longint;
        TransitFiles    :Longint;
        PasstroughFiles :Longint;
        BadFiles        :Longint;
        CarbonNotify    :Longint;
        TotalExport     :Longint;

        h,m,s,h2,m2,s2  :Word;  //Time
        eh_,em_,es_,eh,em,es,eh2,em2,es2 :Word;  //External Time
        Update          :Boolean;
end;

RTossOutbound = record
        SystemPath      :PString;
        Outbound        :PString;
        Outtics         :PString;
        Netmail_In      :PString;
        Netmail_Out     :PString;
        From            :NewPAddr;
        mainzone        :word;
        tempdirectory   :PString;
        ffx4            :linksffx;
        typeofsend      :char;
        Data            :PString;
        Reserved        :PString;
end;

RIdentification = record
        TextVersion     :PString;
        WordVersion     :Word;
        Minversion      :Word;
        MaxVersion      :Word;
        UID             :Word;
        Copyright       :PString;
end;


var Handle_:array [0..255] of THandle;
    RID                    :RIdentification;

type

ConfigRec       = record
                { pp}
                Inbound                 :PString;
                Netmail_In              :PString;
                Netmail_Out             :PString;
                Outbound                :PString;
                Outtics                 :PString;
                BadDirectory            :PString;
                DupeDirectory           :PString;
                TempDirectory           :PString;
                LogDirectory            :PString;
                FileEchoDirectory       :PString;
                SystemPath              :PString;
                AnnounceDirectory       :PString;
                Pluginsdirectory        :PString;
                TemplateDirectory       :PString;
                BadLog                  :PString;
                NewFechoLog             :PString;


                SystemAddress           :PCollection;
                Uplinks                 :PCollection;
                AddFiles                :PStrings;
                GetFileiddiz            :PStrings;
                PutFilesbbs             :PStrings;
                FileFixName             :PCollection;
                FileechoDesc            :PCollection;
                Announce                :PCollection;
                NewAreaGroup            :PCollection;
                Nodeslist               :PCollection;
                Fileechos               :PCollection;
                Archive                 :PCollection;
                FileHatch               :PCollection;
                Forwards                :PCollection;

                MailerMode              :PString;
                AddComment              :PString;
                AnnounceCheck           :PString;
                FormatBBS               :PString;
                LogChars                :String;
                Backup                  :Boolean;
                ForceDesc               :Boolean;
                DupeFilesbbs            :boolean;
                MOverride               :boolean;
                MaskSupport             :Boolean;
                LongNames               :Boolean;

                MaxWaitFile             :Longint;
                MaxFreeOutbound,
                MaxFreeFileecho,
                MaxFreeWork             :Longint;
                {᫨ 0, y  }
                DupeLimit               :Longint;
                CutMessages             :Word;

                MainZone                :Word;
                Ignores                 :byte;
                StartFilesbbs           :byte;
                DupeCheck               :Byte;
                Margin                  :Word;

                DefaultNodeFlags        :PString;
                ParamLine               :PString;
                DefaultRoute            :Char;
                CoreHandle              :THandle;
end;

skconfigrec     = record
                MessageBasePath         :PString;
                TypeOfBase              :String[2];
                NumMessage              :Longint;
                FromName                :PString;
                FromAddress             :PString;
                ToAddress               :PString;
                ToName                  :PString;
                Subject                 :PString;
                Attributes              :PString;
                AddTearline             :boolean;
                AddOrigin               :boolean;
                MainZone                :Word;
                Body                    :PStrings;
end;


type _coreplugin=procedure (const p:pointer;const config:configrec);
     _corepostskmhld=function (const sk:skconfigrec):byte;
     _corereadskmhld=function (var sk:skconfigrec):byte;
     _coredisposeskmhl=procedure (var sk:skconfigrec);

     _tossplugin=procedure(const p:pointer;const config:configrec;var UpdateRec:RTossUpdateScreen);
     _out_getdirectory=function(var out:RTossOutbound):string;
     _out_addtoqueue=procedure (var out:RTossOutbound);
     _out_purge=function (var out:RTossOutbound):boolean;
     _id=function:ridentification;
     _x=function (filename:string;var key:string):boolean;
     _init=procedure (P:Pointer);

var
    beforework:_coreplugin;
    beforetoss:_coreplugin;
    aftertoss:_coreplugin;
    beforescan:_coreplugin;
    afterscan:_coreplugin;
    beforeannounce:_coreplugin;
    afterannounce:_coreplugin;
    beforepurge:_coreplugin;
    afterpurge:_coreplugin;
    afterwork:_coreplugin;

    readmessage: _corereadskmhld;
    readheader:_corereadskmhld;
    postmessage:_corepostskmhld;
    disposemessage:_coredisposeskmhl;
    killmessage:_corepostskmhld;

    toss_beforetoss:_tossplugin;
    toss_updatescreen:_tossplugin;
    toss_beforetic:_tossplugin;
    toss_aftertic:_tossplugin;

    out_getdirectory:_out_getdirectory;
    out_addtoqueue:_out_addtoqueue;
    out_purge:_out_purge;
    id:_id;
    x:_x;
    init:_init;

type

xreadconfig  = function (var PConfigStr:PCollection;var Config:ConfigRec):boolean;
xparseconfig = procedure (const PConfigStr:PCollection;var Config:ConfigRec);
xdisposeconfig = procedure (var Config:ConfigRec);

type

PConfig = ^TConfig;
TConfig = object(TObject)
        Str:PString;
        ConfFile:PString;
constructor Init(astr,aconffile:string);
destructor Done;virtual;
end;



var             readconfig              :xreadconfig;
                parseconfig             :xparseconfig;
                disposeconfig           :xdisposeconfig;
                PConfigStr              :PCollection;
                CurrentConfigFile       :PString;
                GlobalConfig            :ConfigRec;
                ffx                     :Configffx;
                ffx1                    :felistffx;
                ffx2                    :announceffx;
                ffx3                    :newareagroupffx;
                ffx4                    :linksffx;
                ffx5                    :fileechosffx;


implementation


procedure TStrings.FreeItem(Item: Pointer);
 begin
  DisposeStr(Item);
 end;

constructor TConfig.Init(astr,aconffile:string);
begin
inherited init;
str:=nil;
conffile:=nil;
if astr<>'' then str:=newstr(astr);
if aconffile<>'' then conffile:=newstr(aconffile);
end;

destructor TConfig.Done;
begin
disposestr(conffile);
disposestr(str);
inherited done
end;

begin
lastmsgid:='';
CurrentConfigFile:=nil;
end.


