Attribute VB_Name = "modBlatDLL"
'
' Sample Visual Basic source for calling Blat.dll
'
' Harri Pesonen 2002-12-05
'

Public Type StringArray
    STRINGS(0 To 99) As String
End Type

Public Type BigString
  ch(32800) As Byte
End Type

Private Declare Function Blat Lib "blat.dll" (ByVal argc&, ByRef argv As StringArray) As Long
Private Declare Sub SetPrintFunc Lib "blat.dll" (ByVal func&)

Private SMTPMessages$

Public Function FnPtr(ByVal lp As Long) As Long
    FnPtr = lp
End Function

Private Sub TrimCrLf(Text$)
    Do While Len(Text)
        Select Case Right(Text, 1)
        Case vbCr, vbLf
            Text = Left(Text, Len(Text) - 1)
        Case Else
            Exit Sub
        End Select
    Loop
End Sub

Private Sub PrintBlat(ByRef Text As BigString)
    Dim s$
    On Error Resume Next
    Dim i&
    Do
        If Text.ch(i) = 0 Then
            Exit Do
        End If
        s = s & Chr$(Text.ch(i))
        i = i + 1
    Loop
    s = Replace(s, vbLf, vbCrLf)
    TrimCrLf s
    If Len(s) Then
        If Len(SMTPMessages) Then
            SMTPMessages = SMTPMessages + vbCrLf
        End If
        SMTPMessages = SMTPMessages + s
    End If
End Sub

Public Function SendSMTP(SMTP_Server$, MailFrom$, From$, Addresses$, Subject$, Body$, Attachments As Collection, RecipientType$, Messages$) As Boolean
    On Error Resume Next
    SMTPMessages = ""
    ChDrive App.Path
    ChDir App.Path
    Err.Clear
    SetPrintFunc FnPtr(AddressOf PrintBlat)
    If Err Then
        MsgBox "Can't load BLAT.DLL"
        Exit Function
    End If
    Dim argv As StringArray
    argv.STRINGS(0) = "blat.dll"
    argv.STRINGS(1) = "-"
    argv.STRINGS(2) = "-server"
    argv.STRINGS(3) = SMTP_Server
    argv.STRINGS(4) = "-mailfrom"
    argv.STRINGS(5) = MailFrom
    If Len(Addresses) Then
        argv.STRINGS(6) = "-" + RecipientType
        argv.STRINGS(7) = Addresses
    Else
        Messages = "No recipients."
        Exit Function
    End If
    argv.STRINGS(8) = "-s"
    argv.STRINGS(9) = Subject
    argv.STRINGS(10) = "-body"
    argv.STRINGS(11) = Body
    argv.STRINGS(12) = "-from"
    argv.STRINGS(13) = From
    argv.STRINGS(14) = "-mime" ' "-html" '"-enriched" '"-mime"
    argv.STRINGS(15) = "-binary"
    Dim argc&
    argc = 16
    Dim FileName$
    Dim i&
    For i = 1 To Attachments.Count
        FileName = Attachments.Item(i)
        argv.STRINGS(argc) = "-attach"
        argv.STRINGS(argc + 1) = FileName
        argc = argc + 2
    Next
    Dim ret&
    Err.Clear
    ret = Blat(argc, argv)
    If ret Or Err Then
        Messages = SMTPMessages + vbCrLf + "Sending e-mail via SMTP (BLAT.DLL) failed: " + CStr(ret)
        Exit Function
    End If
    SendSMTP = True
    Messages = SMTPMessages
End Function

Public Sub Main()
    Dim Attachments As New Collection
    Attachments.Add App.Path + "\blatdll.bas"
    Dim Messages$
    If Not SendSMTP("mail.surfnet.fi", "fuerte@sci.fi", "Harri Pesonen <fuerte@sci.fi>", "fuerte@sci.fi", "This is a test ", "Test body ", Attachments, "To", Messages) Then
        MsgBox Messages
    End If
End Sub
