*
* FOXTEST.PRG
*
* Visual FoxPro 3.0 Test Program
*

***[ WSC32 Declarations for Visual FoxPro 3.0]***
#define COM1   0
#define COM2   1
#define COM3   2
#define COM4   3
#define COM5   4
#define COM6   5
#define COM7   6
#define COM8   7
#define COM9   8
#define COM10  9
#define COM11 10
#define COM12 11
#define COM13 12
#define COM14 13
#define COM15 14
* Parity Codes
#define NoParity 0
#define OddParity  1
#define EvenParity 2
#define MarkParity 3
#define SpaceParity 4
* Stop Bit Codes
#define OneStopBit  0
#define TwoStopBits 2
* Word Length Codes
#define WordLength5  5
#define WordLength6  6
#define WordLength7  7
#define WordLength8  8
* return codes
#define WSC_NO_DATA   -100
#define WSC_RANGE     -101
#define WSC_ABORTED   -102
#define WSC_WIN32ERR  -103
#define WSC_EXPIRED   -104
#define IE_BADID      -1
#define IE_OPEN       -2
#define IE_NOPEN      -3
#define IE_MEMORY     -4
#define IE_DEFAULT    -5
#define IE_HARDWARE   -10
#define IE_BYTESIZE   -11
#define IE_BAUDRATE   -12
* baud codes
#define Baud110    0
#define Baud300    1
#define Baud1200   2
#define Baud2400   3
#define Baud4800   4
#define Baud9600   5
#define Baud19200  6
#define Baud38400  7
#define Baud57600  8
#define Baud115200 9
* SioGetError masks
#define WSC_RXOVER   1
#define WSC_OVERRUN  2
#define WSC_PARITY   4
#define WSC_FRAME    8
#define WSC_BREAK    16
#define WSC_TXFULL   256
* WSC Functions
DECLARE INTEGER SioBaud;
   in WSC32.DLL INTEGER Port, INTEGER BaudCode
DECLARE INTEGER SioCTS;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioDCD;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioDebug;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioDone;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioDSR;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioDTR;
   in WSC32.DLL INTEGER Port, INTEGER Cmd
DECLARE INTEGER SioFlow;
   in WSC32.DLL INTEGER Port, INTEGER Cmd
DECLARE INTEGER SioInfo;
   in WSC32.DLL INTEGER Cmd
DECLARE INTEGER SioGetc;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioParms;
   in WSC32.DLL INTEGER Port,INTEGER P1,INTEGER P2,INTEGER P3
DECLARE INTEGER SioPutc;
   in WSC32.DLL INTEGER Port, INTEGER TheChar
DECLARE INTEGER SioRead;
   in WSC32.DLL INTEGER Port, INTEGER Reg
DECLARE INTEGER SioReset;
   in WSC32.DLL INTEGER Port, INTEGER RxBufSize, INTEGER TxBufSize
DECLARE INTEGER SioRI;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioRTS;
   in WSC32.DLL INTEGER Port, INTEGER Cmd
DECLARE INTEGER SioRxClear;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER SioRxQue;
   in WSC32.DLL INTEGER Port
DECLARE INTEGER  SioStatus;
    in WSC32.DLL INTEGER  Port, INTEGER  Cmd
DECLARE INTEGER  SioTxClear;
    in WSC32.DLL INTEGER  Port
DECLARE INTEGER  SioTxQue;
    in WSC32.DLL INTEGER  Port
DECLARE INTEGER  SioUnGetc;
    in WSC32.DLL INTEGER  Port, INTEGER  TheChar
DECLARE INTEGER  SioWinError;
    in WSC32.DLL @STRING Buffer INTEGER  Size
***[ End of WSC32 Declarations ]***

Port = COM2

CR = CHR(13)
LF = CHR(10)

?? "Transmitting AT to modem connected to COM2" + CR + LF
?? "Expecting OK back" + CR + LF

* reset port
Code = SioReset(Port,512,256)
if Code < 0
  ? "Error: SioReset returns ", Code
  Return
endif
Code = SioBaud(Port,Baud19200)
* set DTR and RTS
Code = SioDTR(Port,Asc("S"))
Code = SioRTS(Port,Asc("S"))
* transmit "AT" to modem
Code = SioPutc(Port,13)
Code = Delay(0.25)
Code = SioPutc(Port,13)
Code = Delay(0.25)
Code = SioPutc(Port,Asc("A"))
Code = Delay(0.25)
Code = SioPutc(Port,Asc("T"))
Code = Delay(0.25)
Code = SioPutc(Port,13)
* wait 3 seconds for response
MarkTime = Seconds() + 3.0
Do while Seconds() < MarkTime
  Code = SioGetc(Port)
  if Code = 13
    ?? CR
  endif
  if Code = 10
    ?? LF
  endif
  if Code >= 32
    ?? Chr(Code)
  endif
EndDo
?? CR + LF
Code = SioDone(Port)
return

* Delay Function ( waits <WaitSecs> )

Function Delay
Parameter WaitSecs
Private Counter
Private MarkTime
Counter = 0
MarkTime = Seconds() + WaitSecs
do while Seconds() < MarkTime
  Counter = Counter + 1
enddo
return Counter


 