/*
 * MultiMail offline mail reader
 * main, error

 Copyright (c) 1996 Kolossvary Tamas <thomas@vma.bme.hu>
 Copyright (c) 2001 William McBrine <wmcbrine@users.sourceforge.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "error.h"
#include "interfac.h"

#include <new.h>

Interface *ui = 0;
const chtype *ColorArray = 0;
ErrorType error;
mmail mm;
#ifdef PDCURSKLUDGE
int curs_start, curs_end;
#endif

void memError();
void fatalError(const char *description);

ErrorType::ErrorType()
{
	set_new_handler(memError);
	mygetcwd(origdir);
#ifdef __DJGPP__
	if (!getenv("TMP") && !getenv("DJGPP")) {
		const char *temp = getenv("TEMP");
		if (!temp)
			temp = origdir;
		newtmp = new char[strlen(temp) + 5];
		sprintf(newtmp, "TMP=%s", temp);
		putenv(newtmp);
	} else
		newtmp = 0;
#endif
}

ErrorType::~ErrorType()
{
#ifdef __DJGPP__
	delete[] newtmp;
#endif
	mychdir(origdir);
}

const char *ErrorType::getOrigDir()
{
	return origdir;
}

#if defined (SIGWINCH) && !defined (XCURSES) && !defined(NCURSES_SIGWINCH)
void sigwinchHandler(int sig)
{
	if (sig == SIGWINCH)
		ungetch(KEY_RESIZE);
	signal(SIGWINCH, sigwinchHandler);
}
#endif

void fatalError(const char *description)
{
	delete ui;
	fprintf(stderr, "\n\n%s\n\n", description);
	exit(EXIT_FAILURE);
}

void memError()
{
	fatalError("Out of memory");
}

int main(int argc, char **argv)
{
	ui = new Interface();
	ui->init();
	if (argc > 1)
		for (int i = 1; (i < argc) &&
			ui->fromCommandLine(argv[i]); i++);
	else
		ui->main();
	delete ui;
	return EXIT_SUCCESS;
}
