#include "gringo-init.h"


void window_Show( TWindow *win ) {
    assert( win != NULL );
    assert( win->object.type == TYPE_WINDOW );
    win->object.visible = TRUE;
    window_Paint(win);
}


void window_Hide( TWindow *win ) {
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  win->object.visible = FALSE;
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    window_Paint(win);
    gringo_repaint_all = 1;
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_hide( GTK_WIDGET(win->widget)  );
    #endif
  }
}
