#include "gringo-init.h"

void window_Paint( TWindow* win ) {
#ifdef USES_NCURSES
  TChainItem *item;
  TObject *child;
#endif  
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  if ( win->object.visible == FALSE ) return;
  if ( win->object.enabled == FALSE ) return;


  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_show( GTK_WIDGET(win->widget) );
    #endif
  } else
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // Draw Window
    werase(win->window);
    // Draw Shadow
    if ( win->shadow == TRUE ) {
      ncurses_draw_shadow( win->object.y - 1, win->object.x - 1, win->object.h + 1, win->object.w + 1 );
    }
    // Draw Frame
    if (win->trasparent == FALSE) {
      ncurses_fill_window( win->window, win->object.h, win->object.w, 0, 0, win->object.active ? win->back_color_active : win->back_color );
    }
    // Draw Border	
    if (win->border_width > 0 ) {
      wattrset( win->window, win->object.active? win->border_color_active : win->border_color );
      wborder( win->window, 0, 0, 0, 0, 0, 0, 0, 0 );
    }
    // Show Title Onto the Box Border
    if (win->title != NULL) {
      wmove   ( win->window, 0, 2 );
      wattrset( win->window, win->object.active? win->border_color_active : win->border_color );	
      waddstr ( win->window, "[ ");
      wattrset( win->window, win->object.active? win->title_color_active : win->title_color );	
      waddstr ( win->window, win->title);
      wattrset( win->window, win->object.active? win->border_color_active : win->border_color );	
      waddstr ( win->window, " ]");
    }
    // Show Any Widget
    item = win->widgets->head;
    while ( item != NULL ) {
      child = TOBJECT(item->data);
      if ( child->visible == TRUE ) object_Paint( child );
      item = item->next;
    }
    // Check if window is active
    if ( win == gringo_ActiveWindow ) {
      // Make sure there is an active widget
      // if this is the current window
      if ( win->activeChild == NULL ) window_ActivateFirstChild( win );
        // Repaint the active widget
        if ( win->activeChild != NULL ) {
        object_Paint( win->activeChild );
      }
    }    
    // Refresh window
    wnoutrefresh( win->window );
    refresh();
    #endif
  }
}
