#include "gringo-init.h"

void window_SetTitle(TWindow *win, char* newtitle) {
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );    
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    if ( win->title != NULL ) free(win->title);
    win->title = (char*) strdup(newtitle);
    window_Paint(win);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_window_set_title( GTK_WINDOW(win->widget), newtitle );
    #endif
  }
}

void window_Move(TWindow *win, int x, int y) {
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    mvwin( win->window, y, x );
    win->object.x = x;
    win->object.y = y;
    gringo_repaint_all = 1;
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_set_uposition( GTK_WIDGET(win), x * XFACTOR, y * YFACTOR );
    #endif
  }
}



void window_Resize(TObject *win, int w, int h) {
  assert( win != NULL );
  assert( win->type == TYPE_WINDOW );
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // NOP
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_set_usize( GTK_WIDGET(win), w * XFACTOR, h * YFACTOR );
    #endif
  }
}
