#include "gringo-init.h"

void window_Enable( TWindow *win ) {
// Activate the window
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  win->object.enabled = TRUE;
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // NOP
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_set_sensitive( GTK_WIDGET(win), TRUE );
    #endif
  }
}



void window_Disable( TWindow *win ) {
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  win->object.enabled = FALSE;  
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // NOP
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_set_sensitive( GTK_WIDGET(win), TRUE );
    #endif
  }
  window_Deactivate( win );
}
