#include "gringo-init.h"


void window_Destroy(TWindow *win) {
  TChainItem *item;
  assert( win != NULL );

  // Esegue l'evento OnClose
  if ( ((void*)(win->fOnClose)) != NULL ) {
    win->fOnClose();
  }

  // rimuove la finestra
  item = TOBJECT(win)->me;
  assert(item!=NULL);
  chain_remove(item);
  
  // controlla la finestra attiva
  if ( gringo_ActiveWindow == win ) gringo_ActiveWindow = NULL;

  // Clean all Widgets
  item = win->widgets->tail;
  while ( item != NULL ) {
    object_Destroy(item->data);
    item = win->widgets->tail;
  }

  // Remove Window resources
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    delwin( win->window );    
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_destroy(win->widget);
    #endif
  }

  free(win);
  gringo_repaint_all = 1;
  if (gringo_Windows->count==0) {
    //fprintf(stderr,"#libgringo (window_Destroy): no more windows exists !\n");
    //COMMENTED BY NEW gringo_Terminate(GRINGO_ERROR_NOMOREWINDOWS);
    gringo_Terminate(0);
  }
}


#ifdef USES_GTK
int window_Destroy_Gtk(GtkWidget *TargetWidget) {
  TWindow *win;
  TChainItem *item;
  // Sorry, i was unable to pass a pointer to the win structure
  // so i use this wrapper :-)
  assert( TargetWidget != NULL );
  gtk_grab_remove( TargetWidget );
  // Search the windows to destroy
  item = gringo_Windows->head;
  while( item != NULL ) {
    win = item->data;
    if ( win->widget == TargetWidget ) {
      window_Destroy( win );
      break;
    }
    item = item->next;
  } 
  return FALSE;
}
#endif
