#include "gringo-init.h"

#ifdef USES_NCURSES
void window_CursorLeft( TWindow *win ) {
  TObject* obj;
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  obj = win->activeChild;
  if ( obj == NULL ) return;
  if ( obj->type == TYPE_EDITBOX ) {
    if ( TEDIT(obj)->curpos > 0 ) {
      (TEDIT(obj)->curpos) --;
      edit_Paint( TEDIT(obj) );
    } else {
      beep();
    }
    wnoutrefresh( TEDIT(obj)->window );
  } else {
    window_ActivatePreviousChild(win);
  }
}


void window_CursorRight( TWindow *win ) {
  TObject* obj;
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  obj = win->activeChild;
  if ( obj == NULL ) return;
  if ( obj->type == TYPE_EDITBOX ) {
    // The OLD condition was "<=" !!!
    if ( (TEDIT(obj)->curpos) < strlen(TEDIT(obj)->text) ) {
      (TEDIT(obj)->curpos) ++ ;
      edit_Paint( TEDIT(obj) );
    } else {
      beep();
    }
    wnoutrefresh( TEDIT(obj)->window );
  } else {
    window_ActivateNextChild(win);
  }
}



void window_CursorHome( TWindow *win ) {
  TObject* obj;
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  obj = win->activeChild;
  if ( obj == NULL ) return;
  if ( obj->type == TYPE_EDITBOX ) {
    if ( TEDIT(obj)->curpos == 0 ) beep();
    TEDIT(obj)->curpos=0;
    edit_Paint( TEDIT(obj) );
  } else {
    window_ActivateFirstChild(win);
  }
}



void window_CursorEnd( TWindow *win ) {
  TObject* obj;
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  obj = win->activeChild;
  if ( obj == NULL ) return;
  if ( obj->type == TYPE_EDITBOX ) {
    if ( TEDIT(obj)->curpos == strlen( TEDIT(obj)->text ) ) {
      beep();
    } else {
      TEDIT(obj)->curpos = strlen( TEDIT(obj)->text );
      if ( TEDIT(obj)->curpos >= obj->w ) {
        TEDIT(obj)->curpos = obj->w-1;
        beep();
      }
      edit_Paint( TEDIT(obj) );
    }
  } else {
    window_ActivateLastChild(win);
    return;
  }
}



void window_CursorCanc( TWindow *win ) {
  TObject *obj;
  int i, l;
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  obj = win->activeChild;
  if (obj == NULL) return;
  if (obj->type != TYPE_EDITBOX ) return; 
  l = strlen( TEDIT(obj)->text );
  if ( TEDIT(obj)->curpos < l ) {
    TEDIT(obj)->text[l] = 0;
    for ( i=TEDIT(obj)->curpos; i<l; i++ ) {
      TEDIT(obj)->text[i] = TEDIT(obj)->text[i+1];
    }
    edit_Paint( TEDIT(obj) );
  } else {
    beep();
  }
}



int window_InsertChar( TWindow *win, char c ) {
  TObject *obj;
  int i, l;
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  obj = win->activeChild;
  if (obj == NULL) { beep() ; return 1; }
  if (obj->type != TYPE_EDITBOX ) return 1;
  l = strlen( TEDIT(obj)->text );
  if ( ( (TEDIT(obj)->curpos) <= l ) && ( l < ( obj->w) ) ) {
    for ( i=l; i>TEDIT(obj)->curpos; i-- ) {
      TEDIT(obj)->text[i] = TEDIT(obj)->text[i-1];
    }
    TEDIT(obj)->text[ TEDIT(obj)->curpos ] = c;
    TEDIT(obj)->text[l+1] = 0;
    TEDIT(obj)->curpos++;
    if ( TEDIT(obj)->curpos >= obj->w ) {
      TEDIT(obj)->curpos = obj->w-1;
    }
    edit_Paint( TEDIT(obj) );
    return 0;
  } else {
    beep();
  }
  return 1;
}
#endif
