#include "gringo-init.h"

TWindow* window_Create( int x, int y, int w, int h, char *title ) {
  TWindow *win = NULL;
  TChainItem *item = NULL;
  
  // Parameter Checking
  assert( x>=0 );
  assert( y>=0 );
  assert( w>=0 );
  assert( h>=0 );
    
  // Alloc Window Structure
  win = calloc( 1, sizeof( TWindow ) );
  assert( win != NULL );

  // Initialize Object
  win->object.name = NULL;
  win->object.type = TYPE_WINDOW;
  win->object.x = x;
  win->object.y = y;
  win->object.w = w;
  win->object.h = h;
  win->object.active  = FALSE;
  win->object.enabled = TRUE;
  win->object.visible = TRUE;
  win->object.parent  = NULL;
  win->object.me      = NULL;

  // Create Window's widgets chain
  win->widgets = chain_create();

  // Insert Into the Window List
  item = chain_append(gringo_Windows);
  item->data = win;
  win->object.me = item;
  
  // Set as the active window if no other is
  if ( gringo_ActiveWindow == NULL ) {
    gringo_ActiveWindow = win;
    win->object.active = TRUE;
  }

  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // Set ncurses window
    win->back_color = COLOR_PAIR( COLOR_GREY_WHITE );
    win->back_color_active = COLOR_PAIR( COLOR_GREY_WHITE );
    win->trasparent = FALSE;
    win->shadow     = TRUE;
    win->border_color = COLOR_PAIR( COLOR_BLACK_WHITE );
    win->border_color_active = A_BOLD | COLOR_PAIR( COLOR_GREY_WHITE );
    win->border_width = 1;
    win->title_color = COLOR_PAIR( COLOR_BLACK_WHITE );
    win->title_color_active = COLOR_PAIR( COLOR_RED_WHITE );    
    if (title!=NULL) win->title = (char*) strdup(title);
    win->fOnClose = NULL;
    // Clean child pointers
    win->activeChild = NULL;
    // Create the ncurses window
    win->window = newwin(h,w,y,x);
    assert( win->window != NULL );
    keypad (win->window, TRUE);
    scrollok (win->window, FALSE);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    // Create the Gtk window
    win->widget = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    if (title!=NULL) {
      gtk_window_set_title( GTK_WINDOW(win->widget), (char*)title );
    }
    gtk_widget_set_usize( GTK_WIDGET(win->widget), w * XFACTOR, h * YFACTOR );
    gtk_widget_set_uposition( GTK_WIDGET(win->widget), x * XFACTOR, y * YFACTOR );
    gtk_signal_connect_after( 
      GTK_OBJECT(win->widget),
      "delete_event",
      GTK_SIGNAL_FUNC( window_Destroy_Gtk ),
      win
    );
    win->fixed = gtk_fixed_new();
    gtk_container_add( GTK_CONTAINER(win->widget), win->fixed );
    gtk_widget_show(win->fixed);
    #endif
  }
  return win;
}
