#include "gringo-init.h"

#ifdef USES_NCURSES
void window_ActivateFirstChild( TWindow *win ) {
  TObject *child;
  TChainItem *item;
  item = win->widgets->head;
  while ( item != NULL ) {
    child = TOBJECT(item->data);
    if (
      ( child->enabled == TRUE ) &&
      ( child->visible == TRUE ) &&
      ( child->type    >= TYPE_SELECTABLE )
    ) {
      window_ActivateChild( win, child );
      return;
    }
    // Next Child if any
    item = item->next;
  }
}    


void window_ActivateNextChild( TWindow *win ) {
  TObject *child;
  TChainItem *item;
  if ( win->activeChild == NULL ) {
    window_ActivateFirstChild( win );
    return;
  }
  // Start from the active window
  item = TOBJECT(win->activeChild)->me->next;
  while ( item != NULL ) {
    child = TOBJECT(item->data);
    if (
      ( child->enabled == TRUE ) &&
      ( child->visible == TRUE ) &&
      ( child->type    >= TYPE_SELECTABLE )
    ) {
      window_ActivateChild( win, child );
      return;
    }
    // Next Child if any
    item = item->next;
  }
  // if EOF of the list try from the beginning
  window_ActivateFirstChild( win );
}


void window_ActivatePreviousChild( TWindow *win ) {
  TObject *child;
  TChainItem *item;
  if ( win->activeChild == NULL ) {
    window_ActivateLastChild( win );
    return;
  }
  // Start from the active window
  item = TOBJECT(win->activeChild)->me->prev;
  while ( item != NULL ) {
    child = TOBJECT(item->data);
    if (
      ( child->enabled == TRUE ) &&
      ( child->visible == TRUE ) &&
      ( child->type    >= TYPE_SELECTABLE )
    ) {
      window_ActivateChild( win, child );
      return;
    }
    // Next Child if any
    item = item->prev;
  }
  // if EOF of the list try from the beginning
  window_ActivateLastChild( win );
}


void window_ActivateLastChild( TWindow *win ) {
  TObject *child;
  TChainItem *item;
  item = win->widgets->tail;
  while ( item != NULL ) {
    child = TOBJECT(item->data);
    if (
      ( child->enabled == TRUE ) &&
      ( child->visible == TRUE ) &&
      ( child->type    >= TYPE_SELECTABLE )
    ) {
      window_ActivateChild( win, child );
      return;
    }
    // Next Child if any
    item = item->prev;
  }
}    


void window_ActivateChild( TWindow *win, TObject *obj) {
  if ( win->activeChild != NULL ) {
    TOBJECT(win->activeChild)->active = FALSE;
    object_Paint( win->activeChild );
  }
  obj->active = TRUE;
  win->activeChild = obj;
  object_Paint( obj );  
}
#endif