#include "gringo-init.h"

void window_Activate( TWindow *win ) {
// Activate the window
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // Disabilita finestra precedente
    if (gringo_ActiveWindow != NULL) {
      window_Deactivate(gringo_ActiveWindow);
    }
    // Rende attiva questa finestra e la visualizza
    gringo_ActiveWindow = win;
    win->object.active = TRUE;
    win->object.visible = TRUE;
    win->object.enabled = TRUE;
    window_Paint( win );
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_activate( GTK_WIDGET(win->widget)  );
    #endif
  }
}



void window_Deactivate( TWindow *win ) {
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  if ( win == gringo_ActiveWindow ) gringo_ActiveWindow = NULL;
  win->object.active = FALSE;
  window_Paint(win);
}
