#include "gringo-init.h"

void object_Paint( void *obj ) {
// object_Paint redirect the paint request to the specified object
// this is used when libgringo does not know with wich object is
// managing
  assert( obj != NULL );
  if ( TOBJECT(obj)->visible == FALSE ) {
    return;
  } else
  if ( TOBJECT(obj)->type == TYPE_LABEL ) { 
    label_Paint( TLABEL(obj) );
  } else
  if ( TOBJECT(obj)->type == TYPE_BUTTON ) { 
    button_Paint( TBUTTON(obj) );
  } else
  if ( TOBJECT(obj)->type == TYPE_EDITBOX ) { 
    edit_Paint( TEDIT(obj) );
  } else
  if ( TOBJECT(obj)->type == TYPE_CHECKBOX ) { 
    checkbox_Paint( TCHECKBOX(obj) );
  } else
  if ( TOBJECT(obj)->type == TYPE_LISTBOX ) { 
    listbox_Paint( TLISTBOX(obj) );
  } else
  if ( TOBJECT(obj)->type == TYPE_GRID ) { 
    grid_Paint( TGRID(obj) );
  } else {
    // If you forget to add an handler you will be fired ! :-)
    if (gringo_Mode == NCURSES_MODE ) {
      #ifdef USES_NCURSES
      fprintf(stderr,"#libgringo (object_paint): widget unknown %i\n", TOBJECT(obj)->type );
      #endif
    } else
    if (gringo_Mode == GTK_MODE ) {
      #ifdef USES_GTK
      g_print("#libgringo (object_paint): widget unknown %i\n", TOBJECT(obj)->type );
      #endif
    }
    gringo_Terminate(GRINGO_ERROR_NOPAINTMETHOD);
  }
}
