#include "gringo-init.h"

void object_Destroy( TObject* obj ) {
  TWindow *win;
  TChainItem *item;
  assert( obj != NULL );
  // Get the window who own the object
  win = obj->parent;
  assert( win != NULL );

  // cerca l'OGGETTO rimuovere  
  item = obj->me;
  // rimuove la finestra
  assert(item!=NULL);
  chain_remove(item);
  // controlla l'oggetto attivo
  if ( win->activeChild == obj ) win->activeChild = NULL;  
  
  // Remove window from the window list
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    switch ( obj->type ) {
      case TYPE_LABEL: 
      {
        delwin( TLABEL(obj)->window );
        break;
      }
    }
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    #endif
  }
  // Free Memory
  free(obj);
}
