#include "gringo-init.h"

// Simple utility to write things with ncurses

#ifdef USES_NCURSES

void ncurses_fill_window(WINDOW* win, int dy, int dx, int y, int x, chtype c ) {
// Fill a region of a ncurses window
  int i, j;
  wattrset ( win, c );
  for (i = y; i < y+dy; i++) {
    wmove ( win, i, x);
    for (j = 0; j < dx; j++) waddch ( win, ' ');
  }
}


void ncurses_clear_area(int y, int x, int dy, int dx, int c ) {
// Fill a region of the screen
  int i, j;
  attrset ( c );
  for (i = y; i < y+dy; i++) {
    move ( i, x);
    for (j = 0; j < dx; j++) addch ( ' ');
  }
}


void ncurses_clear_screen(void) {
// Clear the screen with the default color
  clear();
  ncurses_clear_area( 0, 0, LINES, COLS, COLOR_PAIR(COLOR_BACKGROUND) );
  refresh();
}


void ncurses_draw_box( int y, int x, int dy, int dx ) {
// Draw a box of a specified type
  int i;
  attrset ( A_BOLD | COLOR_PAIR(COLOR_WHITE) );
  // First Line
  move( y, x);
  addch (ACS_ULCORNER);
  for (i = 1; i < dx; i++) addch (ACS_HLINE);
  addch (ACS_URCORNER);
  // Borders
  for (i = y+1; i < y + dy; i++) {
    move (i,x);    addch ( ACS_VLINE);
    move (i,x+dx); addch ( ACS_VLINE);
  }
  // Last Line
  move( y + dy, x);
  addch ( ACS_LLCORNER);
  for (i = 1; i < dx; i++) addch ( ACS_HLINE);
  addch ( ACS_LRCORNER);
}


void ncurses_draw_shadow ( int y, int x, int dy, int dx ) {
// Draw a shadow around a box
  int i;
  if ( has_colors () ) {
    attrset ( A_NORMAL );
    move ( y + dy , x + 2);
    for (i = 0; i < dx-1; i++) addch ( 32);
    for (i = y + 2; i < y + dy ; i++) {
      move ( i, x + dx );
      addch ( 32 );
    }
  }
}

#endif
