#include "gringo-init.h"


void listbox_Paint( TListBox* obj ) {
#ifdef USES_NCURSES
  TItem *child;
  int count, i, l, max;
  int isActive;
#endif
  assert( obj != NULL );
  assert( obj->object.type == TYPE_LISTBOX );
  if ( obj->object.visible == FALSE ) return;
    
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    isActive = ( obj->object.active == TRUE ) &&( obj->object.enabled ==TRUE ) && ( obj->object.parent == gringo_ActiveWindow );
    // Draw
    werase(obj->window);
    ncurses_fill_window( obj->window, obj->object.h, obj->object.w, 0, 0, obj->object.active ? obj->back_color_active : obj->back_color );
    wmove(obj->window,0,0);
    // Draw Border	
    if (obj->border_width > 0 ) {
      wattrset( obj->window, obj->object.active ? obj->border_color_active : obj->border_color );
      wborder( obj->window, 0, 0, 0, 0, 0, 0, 0, 0 );
    }
    // Draw Child
    if ( obj->firstItem == NULL ) return;
    if ( obj->pageItem == NULL ) {
      obj->pageItem=obj->firstItem;
      obj->activeItem=obj->firstItem;
      obj->activeIndex = 0;
    }
    if ( obj->activeItem == NULL ) obj->activeItem=obj->pageItem;
    //
    child = obj->pageItem;
    max = obj->object.w - 2;
    for ( count=1; count < obj->object.h - 1; count++ ) {
      wmove(obj->window, count, 1 );
      //wattrset( obj->window, isActive && (child == obj->activeItem) ? obj->item_color_active : obj->item_color );
      if (isActive) {
        if (child == obj->activeItem) {
	  wattrset( obj->window, obj->item_color_active );
        } else {
	  wattrset( obj->window, obj->item_color );	
        }
      } else {
        if (child == obj->activeItem) {
	  wattrset( obj->window, obj->item_color_inactive );
        } else {
	  wattrset( obj->window, obj->item_color );	
        }
      }
      l = strlen(child->text);
      if ( l > max ) {
        for ( i=0; i<max; i++ ) waddch( obj->window, child->text[i] );
      } else {
        waddstr(obj->window, child->text);
        for ( i=l; i<max; i++ ) waddch( obj->window, ' ' );
      }
      child = child->next;
      if ( child == NULL ) break;
    }
    // Refresh window
    wnoutrefresh (obj->window);
    //wnoutrefresh( ((TWindow*)(obj->object.parent))->window );
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
}

