#include "gringo-init.h"


void listbox_AddItem( TListBox* obj, char *s ) {
#ifdef USES_NCURSES
  TItem *child;
#endif  
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    assert( obj != NULL );
    assert( obj->object.type == TYPE_LISTBOX );  
    child = calloc( 1, sizeof(TItem) );
    assert( child != NULL );
    child->text = strdup(s);
    // Insert Into the Window List
    if ( obj->firstItem == NULL ) {
      obj->firstItem = child;
      obj->lastItem = child;
    } else {
      obj->lastItem->next = child;
      child->prev = obj->lastItem;
      obj->lastItem = child;
    }
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    //gint CList::Append( gchar *text[] ) 
    // Declar an array of gchar* with 1 element
    gchar *append_text[1];
    append_text[0] = s;
    gtk_clist_append(  GTK_CLIST(obj->widget), append_text );
    #endif
  }
}



#ifdef USES_NCURSES
void listbox_ActivateNextItem( TListBox *obj ) {
  // Draw Child
  if ( obj->firstItem == NULL ) return;
  if ( obj->pageItem == NULL ) {
    obj->pageItem=obj->firstItem;
    obj->activeItem=obj->firstItem;
    obj->activeIndex = 0;
    return;
  }
  if ( obj->activeItem->next == NULL ) return;
  obj->activeItem = obj->activeItem->next;
  obj->activeIndex++;
  if (obj->activeIndex >= obj->object.h - 2 ) {
    obj->pageItem = obj->pageItem->next;
    obj->activeIndex--;
  }
  listbox_Paint(obj);
}
	      

void listbox_ActivatePreviousItem( TListBox *obj ) {
  // Draw Child
  if ( obj->firstItem == NULL ) return;
  if ( obj->pageItem == NULL ) {
    obj->pageItem=obj->firstItem;
    obj->activeItem=obj->firstItem;
    obj->activeIndex = 0;
    return;
  }
  if ( obj->activeItem->prev == NULL ) return;
  obj->activeItem = obj->activeItem->prev;
  obj->activeIndex--;
  if (obj->activeIndex < 0 ) {
    obj->pageItem = obj->pageItem->prev;
    obj->activeIndex = 0;
  }
  listbox_Paint(obj);
}



void listbox_ActivateNextPageItem( TListBox *obj ) {
  // Draw Child
  int count;
  if ( obj->firstItem == NULL ) return;
  if ( obj->pageItem == NULL ) {
    obj->pageItem=obj->firstItem;
    obj->activeItem=obj->firstItem;
    obj->activeIndex = 0;
    return;
  }
  count = obj->object.h - 2;
  while( (obj->activeItem->next) != NULL && (count>0) ) {
    obj->activeItem = obj->activeItem->next;
    count--;
  }
  obj->pageItem = obj->activeItem;
  obj->activeIndex=0;
  listbox_Paint(obj);
}
      


void listbox_ActivatePreviousPageItem( TListBox *obj ) {
  // Draw Child
  int count;
  if ( obj->firstItem == NULL ) return;
  if ( obj->pageItem == NULL ) {
    obj->pageItem=obj->firstItem;
    obj->activeItem=obj->firstItem;
    obj->activeIndex = 0;
    return;
  }
  count = obj->object.h - 2;
  while( (obj->activeItem->prev) != NULL && (count>0) ) {
    obj->activeItem = obj->activeItem->prev;
    count--;
  }
  obj->pageItem = obj->activeItem;
  obj->activeIndex=0;
  listbox_Paint(obj);
}

#endif	      
