#include "gringo-init.h"


#ifdef USES_GTK
/* GM */
static void list_selection(GtkWidget *clist,gint row,gint column,
			GdkEventButton *event,gpointer data) 
{
	TListBox *lbox = NULL;
	if (row>0) {
		assert(data);
		lbox =(TListBox*)data;
	    	assert(lbox);
	        fprintf(stderr,"#libgringo (list_selection): column = %d\n",column);
		lbox->activeIndex=row;
	}
	return;
}
#endif


TListBox* listbox_Create( TWindow* win, int x, int y, int w, int h ) {
  TListBox *obj = NULL;

  // Parameter Checking
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  assert( x>=0 );
  assert( y>=0 );
  assert( w>=0 );
  assert( h>=0 );
    
  // Alloc Window Structure
  obj = calloc( 1, sizeof( TListBox ) );
  assert( obj != NULL );

  // Initialize Object
  obj->object.name = NULL;
  obj->object.type = TYPE_LISTBOX;
  obj->object.x = x;
  obj->object.y = y;
  obj->object.w = w;
  obj->object.h = h;
  obj->object.active  = FALSE;
  obj->object.enabled = TRUE;
  obj->object.visible = TRUE;
  obj->object.parent = NULL;
  obj->object.me = NULL;

  // Add the object to the double-linked list of widgets of this window
  window_AttachObject( win, obj );
  obj->activeIndex= 0;

  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // Set ncurses window
    obj->back_color = COLOR_PAIR( COLOR_GREY_WHITE );
    obj->back_color_active = COLOR_PAIR( COLOR_GREY_WHITE );
    obj->border_color = A_BOLD | COLOR_PAIR( COLOR_BLACK_WHITE );
    obj->border_color_active = COLOR_PAIR( COLOR_BLACK_WHITE );
    obj->border_width = 1;
    obj->title_color = COLOR_PAIR( COLOR_BLACK_WHITE );
    obj->title_color_active = COLOR_PAIR( COLOR_RED_WHITE );    
    obj->title = NULL;
    obj->item_color_active = A_BOLD | COLOR_PAIR( COLOR_YELLOW_BLUE );
    obj->item_color_inactive = COLOR_PAIR( COLOR_BLACK_CYAN );
    obj->item_color = COLOR_PAIR( COLOR_BLACK_WHITE ); 
    // Clean child pointers
    obj->firstItem  = NULL;
    obj->lastItem   = NULL;
    obj->pageItem   = NULL;
    obj->activeItem = NULL;
    // Create the ncurses window
    obj->window = derwin(win->window, obj->object.h, obj->object.w, obj->object.y, obj->object.x);
    assert( obj->window != NULL );
    keypad (obj->window, TRUE);
    scrollok (obj->window, FALSE);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    // Create the Gtk window
    obj->widget = gtk_clist_new(1);
    assert(obj->widget);
    gtk_widget_set_usize( GTK_WIDGET(obj->widget), obj->object.w * XFACTOR, obj->object.h * YFACTOR );
    gtk_fixed_put( GTK_FIXED(win->fixed), obj->widget, x * XFACTOR, y * YFACTOR );
    // Settings
    gtk_clist_set_selection_mode( GTK_CLIST(obj->widget), GTK_SELECTION_BROWSE );
    gtk_clist_column_titles_passive( GTK_CLIST(obj->widget) );
    // Setta Outbox invece che inbox (non mi piace molto) :-(
    gtk_clist_set_shadow_type (GTK_CLIST(obj->widget), GTK_SHADOW_ETCHED_OUT);
    /*<GM> Selection callback */
    gtk_signal_connect(GTK_OBJECT(obj->widget), "select_row",
                            GTK_SIGNAL_FUNC(list_selection),
                            (gpointer)obj);
    /* </GM> */
    // Show
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
  return obj;
}


/* <GM>*/
char *listbox_GetValue( TListBox *obj ) {
	if (gringo_Mode == NCURSES_MODE ) {
		#ifdef USES_NCURSES
		assert(obj);
		if (obj->activeItem != NULL) {
		  return obj->activeItem->text;
		} else {
		  return "";
		}
		#endif
	} else if (gringo_Mode == GTK_MODE ) {		
		#ifdef USES_GTK
		gchar **text;
		gtk_clist_get_text(GTK_CLIST(obj->widget), obj->activeIndex, 0, text);
		return *text;
		#endif
	}
	return NULL;
}
/* </GM>*/
