#include "gringo-init.h"

void label_Paint( TLabel* obj ) {
  assert( obj != NULL );
  assert( obj->object.type == TYPE_LABEL );
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    if ( obj->object.visible == FALSE ) return;
    werase(obj->window);
    wmove(obj->window,0,0);
    wattrset( obj->window, obj->caption_color );	
    waddstr(obj->window, obj->caption);
    wnoutrefresh (obj->window);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
}
