#include "gringo-init.h"

void gringo_Terminate(int sig) {
// Unlock the signal handlers
// In case we are called thru' a signal exit directly
// otherwise let us set the flag to exit from gringo_Loop
// cycle of events

  // Deallocate Signals
  signal(SIGABRT, NULL );
  signal(SIGINT,  NULL );
  signal(SIGKILL, NULL );
  signal(SIGTERM, NULL );

  if ((sig>0)&&(sig!=2)) {
    gringo_Quit();
    if (gringo_Mode == NCURSES_MODE) {
      #ifdef USES_NCURSES
      beep();
      fprintf(stderr,"#libgringo (gringo_Terminate): quitted after getting signal %i \n", sig);
      #endif
    } else
    if (gringo_Mode == GTK_MODE) {
      #ifdef USES_GTK
      if (sig<80) g_print("#libgringo (gringo_Terminate): quitted after getting signal %i \n", sig);
      #endif
    }
    // Exit if different from CTRL+C
    exit(sig);
  }

  // Normal program termination
  if (gringo_Mode == NCURSES_MODE) {
    #ifdef USES_NCURSES
    gringo_main_loop = 1;	// Exit from the gringo_loop
    ncurses_clear_screen();	// Clear screen
    #endif
  }  
}
