#include "gringo-init.h"

// Destroy all the windows (and inner widgets)
// Then clean up ncurses and Gtk

int f_gringo_Quit = 0;

void gringo_Quit() {
  TChainItem *win;

  if (f_gringo_Quit == 1 ) return;
  
  // Clean all Windows !!!
  win = gringo_Windows->tail;
  while ( win != NULL ) {
    window_Destroy( win->data );
    win = gringo_Windows->tail;
  }
  // Close NCurses
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES

    intrflush(stdscr, TRUE);
    nocbreak();
    echo();
    nl();
    curs_set(2);
    flushinp();
    move(0,0);
    refresh();
    endwin();
    delscreen(gpTerm);

    #endif
  }
  
  // set the stopped flag
  f_gringo_Quit = 1;
}
