#include "gringo-init.h"

void gringo_Paint() {
// Paint all the visible windows
// then try to activate one if no-one was specified
  TChainItem *win;
#ifdef USES_NCURSES
  // we need to clear the whole screen
  if (gringo_Mode == NCURSES_MODE) {
    ncurses_clear_screen();
  }
#endif
  // Get first window
  win = gringo_Windows->head;
  // No Windows ?
  if ( win == NULL ) {
    // If you forget to add an handler you will be fired ! :-)
    fprintf(stderr,"#libgringo (gringo_Paint): no windows have been created\n");
    //gringo_Terminate(GRINGO_ERROR_NOWINDOWS);
    gringo_Terminate(0);
  }
  // Paint only visible windows
  while ( win != NULL ) {
    if ( TOBJECT(win->data)->visible == TRUE ) window_Paint( TWINDOW(win->data) );
    win = win->next;
  }  
  // Show the active Window if any
  // Otherwise try to find activate one
  if ( gringo_ActiveWindow == NULL )
    gringo_ActivateFirstWindow();
  else
    window_Show( gringo_ActiveWindow );
  // return
  gringo_repaint_all = 0;  
}
