#include "gringo-init.h"

int gringo_Loop() {
// This first paint all the visible window then start the event loop
// This loop end upon one of the following condition:
//   - call to gringo_Terminate
//   - users press ESC key in ncurses mode
//   - a signal occours (signal 99 is in object_Paint)
//   - there are no more enabled windows (signal 98 in window_Destroy)
#ifdef USES_NCURSES
  int c; 	// Keyboard input
  void *child;
#endif
  
  // Show all the visible windows
  gringo_Paint();

  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_main();
    #endif
  } else
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // Begin Event Processing
    c = 0;
    gringo_main_loop = 0;
    gringo_Paint();
    while ( gringo_main_loop == 0 ) {
      if ( gringo_repaint_all == 1 ) {
        gringo_Paint();
        //moved into gringo_Paint gringo_repaint_all = 0;
      }
      refresh();
      c = getch();
      switch ( c ) {
        case -1: continue;
        // ----------------------------------------- GLOBAL
        case CURS_ESC: { 
          if ( gringo_ActiveWindow != NULL ) {
            window_Close( gringo_ActiveWindow );
          } else {
  	    beep();
  	  }
          break; 
        }
        // ----------------------------------------- WINDOW
        case CURS_PGDN: {
          if ( gringo_ActiveWindow != NULL ) {
            if ( gringo_ActiveWindow->activeChild != NULL ) {
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_LISTBOX ) {
                listbox_ActivateNextPageItem( gringo_ActiveWindow->activeChild );
                break;
              } else
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_GRID ) {
                grid_ActivateNextPageItem( gringo_ActiveWindow->activeChild );
                break;
	      }
	    }
          }
          gringo_ActivateNextWindow();
          break;
        }	
        case CURS_PGUP: {
          if ( gringo_ActiveWindow != NULL ) {
            if ( gringo_ActiveWindow->activeChild != NULL ) {
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_LISTBOX ) {
                listbox_ActivatePreviousPageItem( gringo_ActiveWindow->activeChild );
                break;
              } else
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_GRID ) {
                grid_ActivatePreviousPageItem( gringo_ActiveWindow->activeChild );
                break;
              }
	    }
          }
          gringo_ActivatePreviousWindow();
          break;
        }
        // ----------------------------------------- WIDGETS
        case CURS_TAB: {
          window_ActivateNextChild( gringo_ActiveWindow );
          break ;
        }
        case CURS_DOWN: {
          if ( gringo_ActiveWindow != NULL ) {
            if ( gringo_ActiveWindow->activeChild != NULL ) {
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_LISTBOX ) {
                listbox_ActivateNextItem( gringo_ActiveWindow->activeChild );
                break;
              } else
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_GRID ) {
                grid_ActivateNextItem( gringo_ActiveWindow->activeChild );
                break;
	      }	    
	    }
          }
          window_ActivateNextChild( gringo_ActiveWindow );
          break ;
        }
        case CURS_UP: {
          if ( gringo_ActiveWindow != NULL ) {
            if ( gringo_ActiveWindow->activeChild != NULL ) {
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_LISTBOX ) {
                listbox_ActivatePreviousItem( gringo_ActiveWindow->activeChild );
                break;
              } else
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_GRID ) {
                grid_ActivatePreviousItem( gringo_ActiveWindow->activeChild );
                break;
	      }	    
	    }
          }
          window_ActivatePreviousChild( gringo_ActiveWindow );
          break;
        }
        case CURS_LEFT: {
          window_CursorLeft( gringo_ActiveWindow );
          break;
        }      
        case CURS_RIGHT: {
          window_CursorRight( gringo_ActiveWindow );
          break;
        }
        // ----------------------------------------- ADVANCED
        case CURS_HOME: {
          window_CursorHome( gringo_ActiveWindow );
          break;
        }
        case CURS_END: {
          window_CursorEnd( gringo_ActiveWindow );
          break;
        }
        case CURS_BACKSPACE: {
          if ( gringo_ActiveWindow != NULL ) {
            if ( gringo_ActiveWindow->activeChild != NULL ) {
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_EDITBOX ) {
                window_CursorLeft( gringo_ActiveWindow );
                window_CursorCanc( gringo_ActiveWindow );
	      }
	    }
          }
          break;
        }
        case CURS_DELETE: {
          window_CursorCanc( gringo_ActiveWindow );
          break;
        }
        case CURS_INS: {
          if ( gringo_ActiveWindow != NULL ) {
            if ( gringo_ActiveWindow->activeChild != NULL ) {
              if ( TOBJECT(gringo_ActiveWindow->activeChild)->type == TYPE_EDITBOX ) {
                if ( 0 == window_InsertChar( gringo_ActiveWindow, 32) ) {
                  window_CursorLeft( gringo_ActiveWindow );
	        }
              }
            }
          }
          break;
        }      
        // -----------------------------------------ACTIVATE
        case CURS_SPACE:
        case CURS_ENTER: {
          if ( (gringo_ActiveWindow != NULL) && (gringo_ActiveWindow->activeChild != NULL) ) {
            child = gringo_ActiveWindow->activeChild;
            if ( TOBJECT(child)->type == TYPE_BUTTON ) {
              if ( ((void*)( TBUTTON(child)->fOnClick)) != NULL ) {  
                TBUTTON(child)->status = 1;
                TBUTTON(child)->fOnClick();
              } else {
                beep();
	      }
              break;
	    } else
            if ( TOBJECT(child)->type == TYPE_CHECKBOX ) {
              TCHECKBOX(child)->status = abs( TCHECKBOX(child)->status - 1 );
              checkbox_Paint( TCHECKBOX(child) );
	      break;
	    } else
            if ( TOBJECT(child)->type == TYPE_GRID ) {
              if ( ((void*)( TGRID(child)->fOnClick)) != NULL ) {  
                TGRID(child)->fOnClick();
              } else {
                beep();
	      }
              break;
	    }	    
          }
        }      
        // ----------------------------------------- DEFAULT
        default: {
          if ( (c>=32) && (c<=122) ) {
            window_InsertChar( gringo_ActiveWindow, c );
          } else {
            beep();
          }
        }
      } // end of switch
    }  // end of while
    #endif
  }
  return 0;
}
