#ifndef _GRINGO_INIT_H
#define _GRINGO_INIT_H

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <badpenguin-ansi.h>
#include <badpenguin-chain.h>
#include <badpenguin-errors.h>
#include "gringo.h"

/* Modus Operandi */
#define UNKNOWN_MODE	0
#define NCURSES_MODE	1
#define GTK_MODE	2

#ifdef USES_NCURSES

// Additional colors
#define COLOR_BACKGROUND	10
#define COLOR_GREY_WHITE	11
#define COLOR_BLACK_WHITE	12
#define COLOR_RED_WHITE		13
#define COLOR_WHITE_BLUE	14
#define COLOR_YELLOW_BLUE  	15
#define COLOR_WHITE_RED		16
#define COLOR_BLACK_CYAN	17
#define COLOR_YELLOW_RED	18

// Ncurses getch Key definitions
#define CURS_TAB		9
#define CURS_ENTER		13
#define CURS_ESC		27
#define CURS_SPACE	 	32
#define CURS_UP			259
#define CURS_DOWN		258
#define CURS_LEFT		260
#define CURS_RIGHT		261
#define CURS_HOME		262
#define CURS_BACKSPACE		263
#define CURS_DELETE		330
#define CURS_INS		331
#define CURS_PGDN		338
#define CURS_PGUP		339
#define CURS_END		360
#endif

#ifdef USES_GTK
// 640x480 / 80x25
#define XFACTOR	8
#define YFACTOR	19
#endif


/* =========================== Externs =========================== */
extern TChain  *gringo_Windows;
extern TWindow *gringo_ActiveWindow;
extern int      gringo_Mode;
extern int gringo_main_loop;
extern int gringo_repaint_all;
extern int f_gringo_Quit;
#ifdef USES_NCURSES
extern SCREEN *gpTerm;
#endif

/* ========================= Functions =========================== */
void gringo_ActivateFirstWindow();
void gringo_ActivateNextWindow();
void gringo_ActivatePreviousWindow();
void gringo_ActivateLastWindow();
void gringo_Paint();

void object_Destroy( TObject *obj );
void object_Paint( void *obj );
void button_Paint( TButton* obj );
void checkbox_Paint( TCheckBox* obj );
void edit_Paint( TEdit* obj );
void label_Paint( TLabel* obj );

void window_AttachObject( TWindow *win, void *obj );
void window_Destroy(TWindow *win);
void window_Paint( TWindow* win );

void window_ActivateFirstChild( TWindow *win );
void window_ActivateNextChild( TWindow *win );
void window_ActivatePreviousChild( TWindow *win );
void window_ActivateLastChild( TWindow *win );
void window_ActivateChild( TWindow *win, TObject *obj );

void window_CursorLeft( TWindow *win );
void window_CursorRight( TWindow * win );
void window_CursorHome( TWindow *win );
void window_CursorEnd( TWindow *win );
void window_CursorCanc( TWindow *win );
int  window_InsertChar( TWindow *win, char c );
#ifdef USES_GTK
int window_Destroy_Gtk(GtkWidget *TargetWidget);
#endif

void listbox_Paint( TListBox* obj );
#ifdef USES_NCURSES
void listbox_ActivateNextItem( TListBox *obj );
void listbox_ActivatePreviousItem( TListBox *obj );
void listbox_ActivateNextPageItem( TListBox *obj );
void listbox_ActivatePreviousPageItem( TListBox *obj );
#endif
#ifdef USES_GTK
    #define CLIST_MAX_COLUMNS	20
#endif

void grid_Paint( TGrid* obj );
#ifdef USES_NCURSES
void grid_ActivateNextItem( TGrid *obj );
void grid_ActivatePreviousItem( TGrid *obj );
void grid_ActivateNextPageItem( TGrid *obj );
void grid_ActivatePreviousPageItem( TGrid *obj );
#endif

#ifdef USES_NCURSES
void ncurses_fill_window(WINDOW* win, int dy, int dx, int y, int x, chtype c );
void ncurses_clear_area(int y, int x, int dy, int dx, int c );
void ncurses_clear_screen(void);
void ncurses_draw_box( int y, int x, int dy, int dx );
void ncurses_draw_shadow ( int y, int x, int dy, int dx );
#endif

#endif
