#include "gringo-init.h"

TChain  *gringo_Windows = NULL;		// Window list
TWindow *gringo_ActiveWindow = NULL;	// Current Active WIndow
int gringo_Mode = UNKNOWN_MODE;		// Modus Operandi
int gringo_main_loop = 0;		// ncurses gringo_Loop flag
int gringo_repaint_all = 1;		// trigger a gringo_Paint if 1

#ifdef USES_NCURSES  
  SCREEN *gpTerm = NULL;
  FILE *outTerm = NULL;
  FILE *inTerm = NULL;
#endif

void gringo_Init(int *argc, char **argv[] ) {
  char *term;
  
  // Set Signals Handler
  signal(SIGABRT, gringo_Terminate );
  signal(SIGINT,  gringo_Terminate );
  signal(SIGKILL, gringo_Terminate );
  signal(SIGTERM, gringo_Terminate );

  // Check Terminal type
  term = getenv("TERM");
  printf("%s %s - @1998-2001 by Antonio Gallo (AGX) \n", PACKAGE, VERSION );
  
  // choose environment
  gringo_Mode = 0;
  if ( (argc!=NULL) && (*argc > 1) ) {
    if ( 0 == strcmp( (*argv)[1],"--force-ncurses")) {
      gringo_Mode = NCURSES_MODE;
      printf("- forcing uses of the ncurses backend\n");
    } else
    if ( 0 == strcmp( (*argv)[1],"--force-gtk")) {
      gringo_Mode = GTK_MODE;
      printf("- forcing uses of the gtk backend\n");
    }
  }
  if ( gringo_Mode == 0 ) {  
    if ( 0 == strncmp(term,"xterm",5)) {
      gringo_Mode = GTK_MODE;
      printf("- terminal is %s, using the gtk backend\n", term);
    } else
    if ( 0 == strncmp(term,"rxvt",4)) {
      gringo_Mode = GTK_MODE;
      printf("- terminal is %s, using the gtk backend\n", term);
    } else {
      gringo_Mode = NCURSES_MODE;
      printf("- terminal is %s, using the ncurses backend\n", term);
    }
  }
 
  // check if choosed env. is supported
  #ifndef USES_NCURSES
  if (gringo_Mode == NCURSES_MODE ) {
    printWARNING("- ncurses backend is not supported switching to GTK\n");
    normal_color();
    gringo_Mode = GTK_MODE;    
  }    
  #endif
  #ifndef USES_GTK
  if (gringo_Mode == GTK_MODE ) {
    printWARNING("- gtk backend is not supported switching to ncurses\n");
    normal_color();    
    gringo_Mode = NCURSES_MODE;
  }    
  #endif
  // check if at least something is supported
  #ifndef USES_NCURSES  
    #ifndef USES_GTK
    printWARNING("- no backend is supported ... check your Makefile and recompile libgringo!!!\n");
    normal_color();
    exit(ERROR_FORMAT);
    #endif
  #endif
  
  // Create Window's chain
  gringo_Windows = chain_create();
 
  // Run INIT
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    //initscr();

    outTerm = fopen( "/dev/tty", "w+" );
    if (outTerm==NULL) {
      outTerm = fopen( "/dev/console", "w+" );
      if (outTerm==NULL) {
        printWARNING("! unable to open /dev/tty and /dev/console for output \n");
        normal_color();
        exit(ERROR_IO);
      }
    }

    inTerm = fopen( "/dev/tty", "w+" );
    if (inTerm==NULL) {
      inTerm = fopen( "/dev/console", "w+" );
      if (inTerm==NULL) {
        printWARNING("! unable to open /dev/tty and /dev/console for input \n");
        normal_color();
        exit(ERROR_IO);
      }
    }

    gpTerm = newterm( term, outTerm, inTerm );
//    gpTerm = newterm( NULL, stdout, stdin );
    //set_term( gpTerm );
    
    cbreak();
    noecho();
    nonl();
    //NEW:
    intrflush(stdscr, FALSE);
    keypad(stdscr, TRUE);
    curs_set(0); // old value = 2
    refresh();
    
    if ( has_colors() ) {
      start_color();
      // Default colors
      init_pair(COLOR_BLACK,   COLOR_WHITE,   COLOR_BLACK);
      init_pair(COLOR_GREEN,   COLOR_GREEN,   COLOR_WHITE);    
      init_pair(COLOR_RED,     COLOR_RED,     COLOR_WHITE);
      init_pair(COLOR_CYAN,    COLOR_CYAN,    COLOR_WHITE);
      init_pair(COLOR_WHITE,   COLOR_WHITE,   COLOR_WHITE);
      init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_WHITE);
      init_pair(COLOR_BLUE,    COLOR_BLUE,    COLOR_WHITE);
      init_pair(COLOR_YELLOW,  COLOR_YELLOW,  COLOR_WHITE);
      // Advanced colors
      init_pair(COLOR_BACKGROUND,  COLOR_BLUE,   COLOR_BLUE  );
      init_pair(COLOR_GREY_WHITE,  COLOR_WHITE,  COLOR_WHITE );
      init_pair(COLOR_BLACK_WHITE, COLOR_BLACK,  COLOR_WHITE );	
      init_pair(COLOR_RED_WHITE,   COLOR_RED,    COLOR_WHITE );	
      init_pair(COLOR_WHITE_BLUE,  COLOR_WHITE,  COLOR_BLUE );
      init_pair(COLOR_YELLOW_BLUE, COLOR_YELLOW, COLOR_BLUE );	
      init_pair(COLOR_YELLOW_RED,  COLOR_YELLOW, COLOR_RED );
      init_pair(COLOR_BLACK_CYAN,  COLOR_BLACK, COLOR_CYAN );
    }
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_init( argc, argv );
    #endif
  }
  // set the flag started
  f_gringo_Quit = 0;
}
