#include "gringo-init.h"


void gringo_ActivateFirstWindow() {
// From the first window, try to find the first who is activable
  TChainItem *item;
  TWindow *win;
  item = gringo_Windows->head;
  while ( item != NULL ) {
    win = TWINDOW(item->data);  
    if (
      (win->object.visible==TRUE) &&
      (win->object.enabled==TRUE)
    ) {
      // activate then exit
      window_Activate( win );
      return;
    }
    // Next window
    item = item->next;
  }
  // No windows found
  fprintf(stderr,"#libgringo (activateFirstWindow): no more windows exists !\n");
  //give problems to gringosh: gringo_Terminate(GRINGO_ERROR_NOMOREWINDOWS);
  gringo_Terminate(0);
}



void gringo_ActivateNextWindow() {
  TChainItem *item;
  TWindow *win;
  // If there isn't an active window then try to get the first
  if ( gringo_ActiveWindow == NULL ) {
    gringo_ActivateFirstWindow();
    return;
  }
  item = TOBJECT(gringo_ActiveWindow)->me->next;
  while ( item != NULL ) {
    win = TWINDOW(item->data);  
    if (
      (win->object.visible==TRUE) &&
      (win->object.enabled==TRUE)
    ) {
      // activate then exit
      window_Activate( win );
      return;
    }
    // Next window
    item = item->next;
  }
  // if EOF of the list try from the beginning
  gringo_ActivateFirstWindow();
}



void gringo_ActivatePreviousWindow() {
  TWindow *win;
  TChainItem *item;
  // If there isn't an active window then try to get the first
  if ( gringo_ActiveWindow == NULL ) {
    gringo_ActivateLastWindow();
    return;
  }
  // Start from the active window
  item = TOBJECT(gringo_ActiveWindow)->me->prev;
  while ( item != NULL ) {
    win = TWINDOW(item->data);   
    if (
      (win->object.visible==TRUE) &&
      (win->object.enabled==TRUE)
    ) {
      // activate then exit
      window_Activate( win );
      return;
    }
    // Next window
    item = item->next;
  }
  // if EOF of the list try from the beginning
  gringo_ActivateLastWindow();
}



void gringo_ActivateLastWindow() {
// From the first window, try to find the first who is activable
  TWindow *win;
  TChainItem *item;
  item = gringo_Windows->tail;
  while ( item != NULL ) {
    win = TWINDOW(item->data);  
    if (
      (win->object.visible==TRUE) &&
      (win->object.enabled==TRUE)
    ) {
      // activate then exit
      window_Activate( win );
      return;
    }
    // Previous window
    item = item->prev;    
  }
  // No windows found
  fprintf(stderr,"#libgringo (activateLastWindow): gringo_ActivateLastWindow no more windows exists !\n");
  #ifdef USES_NCURSES
  beep();
  #endif  
  //NEW
  gringo_Terminate(0);
}
