#include "gringo-init.h"

void grid_Paint( TGrid* obj ) {
#ifdef USES_NCURSES
  TColumn *child;
  TItem *item;
  int i, l, max, j;
  int cmax, ci, xcol;
  int isActive;
#endif
    
  assert( obj != NULL );
  assert( obj->object.type == TYPE_GRID );
  if ( obj->object.visible == FALSE ) return;


  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  } else
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    isActive = ( obj->object.active == TRUE ) &&( obj->object.enabled ==TRUE ) && ( obj->object.parent == gringo_ActiveWindow );
    // Draw
    werase(obj->window);
    ncurses_fill_window( obj->window, obj->object.h, obj->object.w, 0, 0, obj->object.active ? obj->back_color_active : obj->back_color );
    wmove(obj->window,0,0);
    // Draw Border
    if (obj->border_width > 0 ) {
      wattrset( obj->window, obj->object.active ? obj->border_color_active : obj->border_color );
      wborder( obj->window, 0, 0, 0, 0, 0, 0, 0, 0 );
    }
    /* Draw Captions */
    wmove(obj->window,1,1);
    child = obj->firstCol;
    wattrset( obj->window, child->caption_color );
    cmax = (obj->object).w - 2;
    ci = 0;
    while ( (child!=NULL) && (ci<cmax) ) {
      max = child->width;
      l = 0;
      if (child->caption != NULL ) {
        l = strlen(child->caption);
        if (l>max) l=max;
      }    
      i=0;
      while ( i<max && ci<cmax ) {
        if (i<l) {
          waddch( obj->window, child->caption[i] );
        } else {
          waddch( obj->window, ' ' );
        }      
        ci++;
        i++;
      }
      if (ci<cmax) {
        waddch( obj->window, ' ' );
        ci++;
      }
      // next
      child = child->next;
    }
    /* Draw Subtitle */
    wmove(obj->window,2,1);
    child = (obj->firstCol);
    ci = 0;
    while ( (child!=NULL) && (ci<cmax) ) {
      max = child->width;
      l = 0;
      if (child->caption != NULL ) {
        l = strlen(child->caption);
        if (l>max) l=max;
      }    
      i=0;
      while ( i<max && ci<cmax ) {
        waddch( obj->window, ACS_HLINE );
        ci++;
        i++;
      }
      if (ci<cmax) {
        waddch( obj->window, ' ' );
        ci++;
      }
      // next
      child = child->next;
    }
    /* Draw Cells */
    child = obj->firstCol;
    xcol   = 1;
    while (child != NULL) {
      if ( child->firstItem == NULL ) break;
      if ( child->pageItem == NULL ) {
        child->pageItem=child->firstItem;
        child->activeItem=child->firstItem;
        child->activeIndex = 0;
      }
      if ( child->activeItem == NULL ) child->activeItem=child->pageItem;
      //
      item = child->pageItem;    
      for ( j=1; (j < child->height - 3)&&(item!=NULL) ; j++ ) {
        wmove(obj->window, 2+j, xcol );

// wattrset( obj->window, isActive && (item == child->activeItem) ? child->item_color_active : child->item_color );
        if (isActive) {
          if (item == child->activeItem) {
            wattrset( obj->window, child->item_color_active );
          } else {
	    wattrset( obj->window, child->item_color );	
          }
        } else {
          if (item == child->activeItem) {
	    wattrset( obj->window, child->item_color_inactive );
          } else {
	    wattrset( obj->window, child->item_color );	
          }
        }

        l = strlen(item->text);
        if ( l > child->width ) {
          for ( i=0; i<child->width; i++ ) waddch( obj->window, item->text[i] );
        } else {
          waddstr(obj->window, item->text);
          for ( i=l; i<child->width; i++ ) waddch( obj->window, ' ' );
        }
        item = item->next;
      }
      // Next col
      xcol = xcol + child->width + 1;
      child = child->next;
    }
    // Refresh window
    wnoutrefresh (obj->window);
    //wnoutrefresh( ((TWindow*)(obj->object.parent))->window );
    // Refresh window
    wnoutrefresh (obj->window);
    //wnoutrefresh( ((TWindow*)(obj->object.parent))->window );
    #endif
  }
}
