#include "gringo-init.h"

#ifdef USES_NCURSES
void grid_ActivateNextItem( TGrid *obj ) {
  TColumn *child;
  child = obj->firstCol;
  while ( child != NULL ) {
    if ( child->firstItem == NULL ) return;
    if ( child->pageItem == NULL ) {
      child->pageItem=child->firstItem;
      child->activeItem=child->firstItem;
      child->activeIndex = 0;
      return;
    }
    if ( child->activeItem->next == NULL ) return;
    child->activeItem = child->activeItem->next;
    child->activeIndex++;
    if (child->activeIndex >= child->height - 4 ) {
      child->pageItem = child->pageItem->next;
      child->activeIndex--;
    }
    // Next Child
    child=child->next;
  }
  grid_Paint(obj);    
}



void grid_ActivatePreviousItem( TGrid *obj ) {
  TColumn *child;
  child = obj->firstCol;
  while ( child != NULL ) {
    if ( child->firstItem == NULL ) return;
    if ( child->pageItem == NULL ) {
      child->pageItem=child->firstItem;
      child->activeItem=child->firstItem;
      child->activeIndex = 0;
      return;
    }
    if ( child->activeItem->prev == NULL ) return;
    child->activeItem = child->activeItem->prev;
    child->activeIndex--;
    if (child->activeIndex < 0 ) {
      child->pageItem = child->pageItem->prev;
      child->activeIndex = 0;
    }
    // Next Child
    child=child->next;
  }
  grid_Paint(obj);
}



void grid_ActivateNextPageItem( TGrid *obj ) {
  int count;
  TColumn *child;
  child = obj->firstCol;
  while ( child != NULL ) {
    if ( child->firstItem == NULL ) return;
    if ( child->pageItem == NULL ) {
      child->pageItem=child->firstItem;
      child->activeItem=child->firstItem;
      child->activeIndex = 0;
      return;
    }
    count = child->height - 4;
    while( (child->activeItem->next) != NULL && (count>0) ) {
      child->activeItem = child->activeItem->next;
      count--;
    }
    child->pageItem = child->activeItem;
    child->activeIndex=0;
    // Next Child
    child=child->next;
  }
  grid_Paint(obj);
}
      


void grid_ActivatePreviousPageItem( TGrid *obj ) {
  int count;
  TColumn *child;
  child = obj->firstCol;
  while ( child != NULL ) {
    if ( child->firstItem == NULL ) return;
    if ( child->pageItem == NULL ) {
      child->pageItem=child->firstItem;
      child->activeItem=child->firstItem;
      child->activeIndex = 0;
      return;
    }
    count = child->height - 4;
    while( (child->activeItem->prev) != NULL && (count>0) ) {
      child->activeItem = child->activeItem->prev;
      count--;
    }
    child->pageItem = child->activeItem;
    child->activeIndex=0;
    // Next Child
    child=child->next;
  }
  grid_Paint(obj);
}
#endif
