#include "gringo-init.h"

TGrid* grid_Create( TWindow* win, int x, int y, int w, int h ) {
  TGrid *obj = NULL;
#ifdef USES_GTK
  int i;
  gchar *notitles[CLIST_MAX_COLUMNS] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
  };
#endif

  // Parameter Checking
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  assert( x>=0 );
  assert( y>=0 );
  assert( w>=0 );
  assert( h>=0 );
    
  // Alloc Window Structure
  obj = calloc( 1, sizeof( TGrid ) );
  assert( obj != NULL );

  // Initialize Object
  obj->object.name = NULL;
  obj->object.type = TYPE_GRID;
  obj->object.x = x;
  obj->object.y = y;
  obj->object.w = w;
  obj->object.h = h;
  obj->object.active  = FALSE;
  obj->object.enabled = TRUE;
  obj->object.visible = TRUE;
  obj->object.parent = NULL;
  obj->object.me = NULL;

  // Add the object to the double-linked list of widgets of this window
  window_AttachObject( win, obj );

  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    obj->fOnClick = NULL;
    // Set ncurses window
    obj->back_color = COLOR_PAIR( COLOR_GREY_WHITE );
    obj->back_color_active = COLOR_PAIR( COLOR_GREY_WHITE );
    obj->border_color = A_BOLD | COLOR_PAIR( COLOR_BLACK_WHITE );
    obj->border_color_active = COLOR_PAIR( COLOR_BLACK_WHITE );
    obj->border_width = 1;  
    // Clean child pointers
    obj->firstCol  = NULL;
    obj->lastCol   = NULL;      
    // Create the ncurses window
    obj->window = derwin(win->window, obj->object.h, obj->object.w, obj->object.y, obj->object.x);
    assert( obj->window != NULL );
    keypad (obj->window, TRUE);
    scrollok (obj->window, FALSE);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    // We cannot dinamically add column, so we create a certain number of
    // default colums and make them invisible
    //obj->widget = gtk_clist_new(CLIST_MAX_COLUMNS);
    obj->widget = gtk_clist_new_with_titles ( CLIST_MAX_COLUMNS, notitles );
    assert(obj->widget);
    obj->columns = 0;
    gtk_widget_set_usize( GTK_WIDGET(obj->widget), obj->object.w * XFACTOR, obj->object.h * YFACTOR );
    gtk_fixed_put( GTK_FIXED(win->fixed), obj->widget, x * XFACTOR, y * YFACTOR );
    // Settings
    gtk_clist_set_selection_mode( GTK_CLIST(obj->widget), GTK_SELECTION_BROWSE );
    gtk_clist_column_titles_passive( GTK_CLIST(obj->widget) );
    // Setta Outbox invece che inbox (rilievo)
    gtk_clist_set_shadow_type (GTK_CLIST(obj->widget), GTK_SHADOW_ETCHED_IN );
    // Show
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    for ( i=0; i<CLIST_MAX_COLUMNS - 1 ; i++) {
      gtk_clist_set_column_visibility( GTK_CLIST(obj->widget), i, FALSE );
      //gtk_clist_set_column_width ( GTK_CLIST(obj->widget), i, 0 );
    }
    #endif
  }
  return obj;
}
