#include "gringo-init.h"

TColumn *grid_AddColumn( TGrid *obj, char *title, int w ) {
#ifdef USES_NCURSES
  TColumn *child;
#endif
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    assert( obj != NULL );
    assert( obj->object.type == TYPE_GRID );
    assert( w > 0 );
    //    
    child = calloc( 1, sizeof(TColumn) );
    assert( child != NULL );
    if ( title != NULL ) { child->caption = strdup(title); }
    child->width = w;
    child->height = obj->object.h;
    child->caption_color = COLOR_PAIR( COLOR_BLACK_WHITE );
    child->pageItem   = NULL;
    child->activeItem = NULL;
    child->activeIndex= 0;
    child->item_color_active = A_BOLD | COLOR_PAIR( COLOR_YELLOW_BLUE );
    child->item_color_inactive = COLOR_PAIR( COLOR_BLACK_CYAN );
    child->item_color = COLOR_PAIR( COLOR_BLACK_WHITE );  
    // Insert Into the Window List
    if ( obj->firstCol == NULL ) {
      obj->firstCol = child;
      obj->lastCol = child;
    } else {
      obj->lastCol->next = child;
      child->prev = obj->lastCol;
      obj->lastCol = child;
    }
    return child;
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_clist_set_column_visibility( GTK_CLIST(obj->widget), obj->columns, TRUE );
    gtk_clist_set_column_title ( GTK_CLIST(obj->widget), obj->columns, title );
    gtk_clist_set_column_width ( GTK_CLIST(obj->widget), obj->columns, w * XFACTOR );
    obj->columns++;
    return NULL;
    #endif
  }
  assert(0!=1);
  return NULL;
}


#ifdef USES_NCURSES
void column_AddText( TColumn* obj, char *s ) {
  TItem *child;
  assert( obj != NULL );
  assert( s != NULL ); 
  child = calloc( 1, sizeof(TItem) );
  assert( child != NULL );
  child->text = strdup(s);
  // Insert Into the Window List
  if ( obj->firstItem == NULL ) {
    obj->firstItem = child;
    obj->lastItem = child;
  } else {
    obj->lastItem->next = child;
    child->prev = obj->lastItem;
    obj->lastItem = child;
  }
}
#endif



void grid_AddText( TGrid *obj, ... ) {
  va_list AP;
  char *s;
  // NCURSES
#ifdef USES_NCURSES
  TColumn *col;
#endif  
  // GTK
  #ifdef USES_GTK
  int i;
  gchar *texts[CLIST_MAX_COLUMNS] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
  };
  #endif
  // go ...
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    va_start( AP, *obj );
    col = obj->firstCol;  
    while ( ( s = (char*)va_arg(AP,long)) != NULL ) {
      if (col==NULL) {
        fprintf(stderr,"#libgringo (grid_AddText): scartato '%s' per colonna nulla\n", s);
      } else {
        column_AddText( col, s );
        col = col->next;
      }
    }
    va_end( AP );
    // Add blank cells
    while ( col != NULL ) {
      column_AddText( col, "" );
      col = col->next;
    }
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    va_start( AP, *obj );
    i=0;
    while ( ( s = (char*)va_arg(AP,long)) != NULL ) {
      if (i<obj->columns) {
        texts[i] = s;
      }else{
        g_print("#libgringo (grid_AddText): scartato '%s' per colonna nulla\n", s);
      }
      i++;
    }
    gtk_clist_append ( GTK_CLIST(obj->widget), texts );
    va_end( AP );
    #endif
  }
}
