#include "gringo-init.h"

void edit_Paint( TEdit* obj ) {
#ifdef USES_NCURSES
  char c;
  int isActive;
#endif    
  assert( obj != NULL );
  assert( obj->object.type == TYPE_EDITBOX );
  if ( obj->object.visible == FALSE ) return;

  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    isActive = ( obj->object.active ==TRUE ) &&( obj->object.enabled ==TRUE ) && ( obj->object.parent == gringo_ActiveWindow );
    werase(obj->window);
    ncurses_fill_window( obj->window, obj->object.h, obj->object.w, 0, 0, isActive ? obj->back_color_active : obj->back_color );
    wmove(obj->window,0,0);
    wattrset( obj->window, isActive ? obj->text_color_active : obj->text_color );
    waddstr(obj->window, obj->text);
    // Highlight cursor
    if ( isActive == TRUE )  {
      c = obj->text[obj->curpos];
      if ( c == 0 ) c = 32;
      //wattrset( obj->window, A_REVERSE | A_BOLD | A_BLINK | COLOR_PAIR(COLOR_BLACK_CYAN) );
      //Changed the cursor color, the new seems look better
      wattrset( obj->window, A_BOLD | A_BLINK | COLOR_PAIR(COLOR_YELLOW_BLUE) );
      wmove(obj->window, 0, obj->curpos);
      waddch( obj->window, c );
    }
    wnoutrefresh (obj->window);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
}
