#include "gringo-init.h"

TEdit* edit_Create( TWindow* win, int x, int y, int w, char *text ) {
  TEdit *obj;
  // Check parameters
  assert( win != NULL );
  assert( win->object.type == TYPE_WINDOW );
  assert( x>=0 );
  assert( y>=0 );
  assert( w>=0 );
  assert( (w != 0) || (text != NULL) );
  // Create object
  obj = calloc( 1, sizeof(TEdit) );
  assert( obj != NULL );
  // Initialize basic object
  obj->object.name = NULL;
  obj->object.type = TYPE_EDITBOX;
  obj->object.x = x;
  obj->object.y = y;
  if (w==0) {
    obj->object.w=strlen(text); 
  } else {
    obj->object.w=w;
  }
  obj->object.h = 1;
  obj->object.active = FALSE;
  obj->object.enabled = TRUE;
  obj->object.visible = TRUE;
  obj->object.parent = NULL;
  // Add the object to the double-linked list of widgets of this window
  window_AttachObject( win, obj );
  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    // Set TLabel fields
    obj->text = (char*) calloc( (obj->object.w) + 2, sizeof(char) );
    if (text != NULL ) strncpy( obj->text, text, w );
    obj->text_color = COLOR_PAIR( COLOR_BLACK_CYAN );
    obj->text_color_active = A_BOLD | COLOR_PAIR( COLOR_YELLOW_RED );
    obj->back_color = COLOR_PAIR( COLOR_BLACK_CYAN );
    obj->back_color_active = COLOR_PAIR( COLOR_YELLOW_RED );
    // Now create the label
    obj->window = derwin(win->window, obj->object.h, obj->object.w, obj->object.y, obj->object.x);
    assert( obj->window != NULL );
    keypad (obj->window, TRUE);
    scrollok (obj->window, FALSE);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    if (w==0) w=strlen(text); 
    obj->widget = gtk_entry_new_with_max_length( w );
    assert(obj->widget);
    if (text!=NULL) gtk_entry_set_text( GTK_ENTRY(obj->widget), text );
    gtk_widget_set_usize( GTK_WIDGET(obj->widget), w * XFACTOR, 1 * YFACTOR );
    gtk_fixed_put( GTK_FIXED(win->fixed), obj->widget, x * XFACTOR, y * YFACTOR );
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
  return obj;
}
