#include "gringo-init.h"

void checkbox_Paint( TCheckBox* obj ) {
#ifdef USES_NCURSES
int isActive;
#endif
  assert( obj != NULL );
  assert( obj->object.type == TYPE_CHECKBOX );
  if ( obj->object.visible == FALSE ) return;
    if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    isActive = ( obj->object.active ==TRUE ) &&( obj->object.enabled ==TRUE ) && ( obj->object.parent == gringo_ActiveWindow );
    werase(obj->window);
    wmove(obj->window,0,0);
    if ( isActive ) {
      wattrset( obj->window, obj->caption_color_active );
    } else {
      wattrset( obj->window, obj->caption_color );
    }
    if ( obj->status == 0 ) {
      waddstr(obj->window, "[ ]");
    } else {
      waddstr(obj->window, "[X]");
    }
    // Print Text
    wattrset( obj->window, obj->caption_color );
    waddch(obj->window, ' ');
    waddstr(obj->window, obj->caption);
    wnoutrefresh (obj->window);
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    gtk_widget_show( GTK_WIDGET(obj->widget) );
    #endif
  }
}
