#include "gringo-init.h"

int checkbox_GetValue( TCheckBox *obj ) {
  assert( obj != NULL );
  assert( obj->object.type == TYPE_CHECKBOX );

  if (gringo_Mode == NCURSES_MODE ) {
    #ifdef USES_NCURSES
    return obj->status;
    #endif
  } else
  if (gringo_Mode == GTK_MODE ) {
    #ifdef USES_GTK
    return gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(obj->widget) );
    #endif
  }
  return 0;
}

